/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.Constants;
import dioscuri.config.ConfigController;
import dioscuri.config.Emulator;
import dioscuri.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;

public class CommandLineInterface {
    private static final Logger logger = Logger.getLogger(CommandLineInterface.class.getName());
    Emulator emuConfig;
    Options commandLineOptions;
    CommandLine commandLine;
    final boolean help;
    final boolean hide;
    final boolean visible;
    final boolean autorun;
    final boolean exit;
    final boolean autoshutdown;
    String configFilePath;

    public CommandLineInterface(String ... stringArray) throws Exception {
        Object object;
        Object object2;
        this.initOptions();
        this.parse(stringArray);
        this.help = this.commandLine.hasOption("?");
        this.exit = this.commandLine.hasOption("e");
        this.hide = this.commandLine.hasOption("h");
        this.visible = !this.hide;
        this.autorun = this.commandLine.hasOption("r");
        this.autoshutdown = this.commandLine.hasOption("s");
        if (this.commandLine.hasOption("?")) {
            object2 = new HelpFormatter();
            object2.printHelp("java -jar Dioscuri.jar [OPTIONS]\n", this.commandLineOptions);
            System.exit(0);
        }
        if (this.commandLine.hasOption("c")) {
            object2 = Utilities.resolvePathAsFile(this.commandLine.getOptionValue("c"));
            logger.log(Level.INFO, "using custom config file: " + object2);
            if (object2 == null || !((File)object2).exists()) {
                throw new IOException(" [cli] config file '" + ((File)object2).getName() + "' does not exist in folder '" + ((File)object2).getParentFile().getAbsolutePath() + "'");
            }
            this.configFilePath = ((File)object2).getAbsolutePath();
        } else {
            this.configFilePath = Constants.DEFAULT_CONFIG_XML;
        }
        this.loadConfigFile();
        boolean bl2 = false;
        if (this.commandLine.hasOption("f")) {
            object = Utilities.resolvePathAsFile(this.commandLine.getOptionValue("f"));
            logger.log(Level.INFO, " [cli] using custom floppy image: " + object);
            if (object == null || !((File)object).exists()) {
                throw new IOException(" [cli] floppy image '" + ((File)object).getName() + "' does not exist in folder '" + ((File)object).getParentFile().getAbsolutePath() + "'");
            }
            this.emuConfig.getArchitecture().getModules().getFdc().getFloppy().get(0).setImagefilepath(((File)object).getAbsolutePath());
            bl2 = true;
        }
        if (this.commandLine.hasOption("d")) {
            object = Utilities.resolvePathAsFile(this.commandLine.getOptionValue("d"));
            logger.log(Level.INFO, " [cli] using custom hard disk image: " + object);
            if (object == null || !((File)object).exists()) {
                throw new IOException(" [cli] floppy image '" + ((File)object).getName() + "' does not exist in folder '" + ((File)object).getParentFile().getAbsolutePath() + "'");
            }
            this.emuConfig.getArchitecture().getModules().getAta().getHarddiskdrive().get(0).setImagefilepath(((File)object).getAbsolutePath());
            bl2 = true;
        }
        if (this.commandLine.hasOption("a")) {
            object = this.commandLine.getOptionValue("a");
            if (!((String)object).matches("16|32")) {
                throw new UnrecognizedOptionException("illegal architecture value: " + (String)object);
            }
            int bl = Integer.valueOf((String)object);
            logger.log(Level.INFO, " [cli] setting cpu architecture to: " + bl + " bits");
            this.emuConfig.getArchitecture().getModules().getCpu().setCpu32Bit(bl == 32);
            bl2 = true;
        }
        if (this.commandLine.hasOption("b")) {
            object = this.commandLine.getOptionValue("b").toLowerCase();
            String string = "Floppy Drive";
            String string2 = "Hard Drive";
            boolean bl = true;
            String string3 = string2;
            if (((String)object).matches("floppy|harddisk")) {
                if (((String)object).equals("floppy")) {
                    bl = false;
                    string3 = string;
                }
            } else {
                throw new UnrecognizedOptionException("illegal boot value: " + string3);
            }
            logger.log(Level.INFO, " [cli] setting boot drive: " + (String)object);
            this.emuConfig.getArchitecture().getModules().getBios().get(0).getBootdrives().setBootdrive0(string3);
            if (bl) {
                this.emuConfig.getArchitecture().getModules().getAta().getHarddiskdrive().get(0).setEnabled(true);
            } else {
                this.emuConfig.getArchitecture().getModules().getFdc().getFloppy().get(0).setEnabled(true);
            }
            bl2 = true;
        }
        if (this.commandLine.hasOption("m")) {
            object = this.commandLine.getOptionValue("m").toLowerCase();
            if (!((String)object).matches("enabled|disabled")) {
                throw new UnrecognizedOptionException("illegal value: " + (String)object + ", expected 'enabled' or 'disabled'.");
            }
            boolean bl = ((String)object).equals("enabled");
            logger.log(Level.INFO, " [cli] mouse enabled? " + bl);
            this.emuConfig.getArchitecture().getModules().getMouse().setEnabled(bl);
            bl2 = true;
        }
        if (bl2) {
            Utilities.saveXML(this.emuConfig, this.configFilePath);
        }
    }

    private void loadConfigFile() throws Exception {
        File file = Utilities.resolvePathAsFile(this.configFilePath);
        this.emuConfig = ConfigController.loadFromXML(file);
    }

    private void initOptions() {
        this.commandLineOptions = new Options();
        this.commandLineOptions.addOption("?", "help", false, "print this message");
        this.commandLineOptions.addOption("h", "hide", false, "hides the GUI");
        this.commandLineOptions.addOption("r", "autorun", false, "emulator will directly start emulation process");
        this.commandLineOptions.addOption("e", "exit", false, "used for testing purposes, will cause Dioscuri to exit immediately");
        this.commandLineOptions.addOption("s", "autoshutdown", false, "emulator will shutdown automatically when emulation process is finished");
        Option option = new Option("c", "config", true, "loads a custom config xml file");
        option.setArgName("file");
        this.commandLineOptions.addOption(option);
        option = new Option("f", "floppy", true, "loads a custom floppy image");
        option.setArgName("file");
        this.commandLineOptions.addOption(option);
        option = new Option("d", "harddisk", true, "loads a custom hard disk image");
        option.setArgName("file");
        this.commandLineOptions.addOption(option);
        option = new Option("a", "architecture", true, "sets the cpu's architecture");
        option.setArgName("'16'|'32'");
        this.commandLineOptions.addOption(option);
        option = new Option("b", "boot", true, "sets the boot drive");
        option.setArgName("'floppy'|'harddisk'");
        this.commandLineOptions.addOption(option);
        option = new Option("m", "mouse", true, "enables or disables th mouse");
        option.setArgName("'enabled'|'disabled'");
        this.commandLineOptions.addOption(option);
    }

    private void parse(String[] stringArray) throws ParseException {
        PosixParser posixParser = new PosixParser();
        this.commandLine = posixParser.parse(this.commandLineOptions, stringArray);
    }
}

