/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.Constants;
import dioscuri.GUI;
import dioscuri.IO;
import dioscuri.Modules;
import dioscuri.config.ConfigController;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import dioscuri.exception.ModuleException;
import dioscuri.module.Module;
import dioscuri.module.ModuleATA;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleFDC;
import dioscuri.module.ModuleKeyboard;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMouse;
import dioscuri.module.ModulePIT;
import dioscuri.module.ModuleScreen;
import dioscuri.module.ModuleVideo;
import dioscuri.module.ata.ATA;
import dioscuri.module.ata.ATATranslationType;
import dioscuri.module.bios.BIOS;
import dioscuri.module.clock.Clock;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu32.AddressSpace;
import dioscuri.module.cpu32.DMAController;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.IOPortHandler;
import dioscuri.module.cpu32.LazyMemory;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.ModeSwitchException;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.SystemBIOS;
import dioscuri.module.cpu32.VGABIOS;
import dioscuri.module.dma.DMA;
import dioscuri.module.fdc.FDC;
import dioscuri.module.keyboard.Keyboard;
import dioscuri.module.memory.DynamicAllocationMemory;
import dioscuri.module.memory.Memory;
import dioscuri.module.motherboard.DeviceDummy;
import dioscuri.module.motherboard.Motherboard;
import dioscuri.module.mouse.Mouse;
import dioscuri.module.parallelport.ParallelPort;
import dioscuri.module.pic.PIC;
import dioscuri.module.pit.PIT;
import dioscuri.module.rtc.RTC;
import dioscuri.module.screen.Screen;
import dioscuri.module.serialport.SerialPort;
import dioscuri.module.video.Video;
import dioscuri.util.Utilities;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Emulator
implements Runnable {
    private Modules modules;
    private ArrayList<HardwareComponent> hwComponents;
    private IO io;
    private GUI gui;
    protected dioscuri.config.Emulator emuConfig;
    protected Emulator.Architecture.Modules moduleConfig;
    private boolean isAlive;
    private boolean coldStart;
    private boolean resetBusy;
    private boolean cpu32bit;
    private boolean dynamicMem;
    private static final Logger logger = Logger.getLogger(Emulator.class.getName());
    protected static final int CMD_START = 0;
    protected static final int CMD_STOP = 1;
    protected static final int CMD_RESET = 2;
    protected static final int CMD_DEBUG = 4;
    protected static final int CMD_LOGGING = 5;
    protected static final int CMD_OBSERVE = 6;
    protected static final int CMD_LOAD_MODULES = 7;
    protected static final int CMD_LOAD_DATA = 8;
    protected static final int CMD_LOGTOFILE = 9;
    protected static final int CMD_DEBUG_HELP = 3;
    protected static final int CMD_DEBUG_STEP = 16;
    protected static final int CMD_DEBUG_DUMP = 17;
    protected static final int CMD_DEBUG_ENTER = 18;
    protected static final int CMD_DEBUG_STOP = 19;
    protected static final int CMD_DEBUG_SHOWREG = 20;
    protected static final int CMD_DEBUG_MEM_DUMP = 21;
    protected static final int CMD_MISMATCH = 255;
    public static final int MODULE_FDC_TRANSFER_START = 0;
    public static final int MODULE_FDC_TRANSFER_STOP = 1;
    public static final int MODULE_ATA_HD1_TRANSFER_START = 2;
    public static final int MODULE_ATA_HD1_TRANSFER_STOP = 3;
    public static final int MODULE_KEYBOARD_NUMLOCK_ON = 4;
    public static final int MODULE_KEYBOARD_NUMLOCK_OFF = 5;
    public static final int MODULE_KEYBOARD_CAPSLOCK_ON = 6;
    public static final int MODULE_KEYBOARD_CAPSLOCK_OFF = 7;
    public static final int MODULE_KEYBOARD_SCROLLLOCK_ON = 8;
    public static final int MODULE_KEYBOARD_SCROLLLOCK_OFF = 9;

    public Emulator(GUI gUI) {
        this.gui = gUI;
        this.modules = null;
        this.hwComponents = new ArrayList();
        this.io = new IO();
        this.isAlive = true;
        this.coldStart = true;
        this.resetBusy = false;
        this.dynamicMem = false;
    }

    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (this.isAlive) {
            Object object;
            try {
                File file = new File(Utilities.resolvePathAsString(this.gui.getConfigFilePath()));
                if (!file.exists() || !file.canRead()) {
                    logger.log(Level.WARNING, "[emu] No local config file accessible, using read-only jar settings");
                    object = GUI.class.getResourceAsStream(this.gui.getConfigFilePath());
                    this.emuConfig = ConfigController.loadFromXML((InputStream)object);
                    ((InputStream)object).close();
                } else {
                    this.emuConfig = ConfigController.loadFromXML(file);
                }
                this.moduleConfig = this.emuConfig.getArchitecture().getModules();
                logger.log(Level.INFO, "[emu] Config contents: " + this.moduleConfig.getFdc().getFloppy().get(0).getImagefilepath());
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "[emu] Config file not readable: " + exception.toString());
                return;
            }
            logger.log(Level.INFO, "[emu] Retrieved settings for modules");
            boolean bl = this.setupEmu();
            if (!bl) {
                logger.log(Level.SEVERE, "[emu] Emulation process halted due to error initalizing the modules.");
                this.stop();
                return;
            }
            if (this.cpu32bit) {
                logger.log(Level.INFO, "[emu] Emulation process started (32-bit).");
                try {
                    object = null;
                    Processor processor = (Processor)this.modules.getModule(ModuleType.CPU.toString());
                    object = processor.isProtectedMode() ? (AddressSpace)((Object)this.hwComponents.get(0)) : (AddressSpace)((Object)this.hwComponents.get(1));
                    while (n2 < 15000) {
                        n = ((dioscuri.module.cpu32.Memory)object).execute(processor, processor.getInstructionPointer());
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        n2 += n;
                        ++n3;
                    }
                    while (this.isAlive) {
                        n = ((dioscuri.module.cpu32.Memory)object).execute(processor, processor.getInstructionPointer());
                        n2 += n;
                        ++n3;
                    }
                    continue;
                }
                catch (ModeSwitchException modeSwitchException) {
                    n = 1;
                    continue;
                }
            }
            logger.log(Level.INFO, "[emu] Emulation process started (16-bit).");
            if (!((ModuleCPU)this.modules.getModule("cpu")).getDebugMode()) {
                ((ModuleCPU)this.modules.getModule("cpu")).start();
                if (((ModuleCPU)this.modules.getModule("cpu")).isAbnormalTermination()) {
                    logger.log(Level.SEVERE, "[emu] Emulation process halted due to error in CPU module.");
                    this.stop();
                    return;
                }
                if (((ModuleCPU)this.modules.getModule("cpu")).isShutdown()) {
                    logger.log(Level.SEVERE, "[emu] Emulation process halted due to request for shutdown by CPU module.");
                    this.stop();
                    return;
                }
            } else {
                object = (ModuleCPU)this.modules.getModule("cpu");
                logger.log(Level.INFO, ((ModuleCPU)object).getNextInstructionInfo());
                while (this.isAlive) {
                    this.debug(this.io.getCommand());
                }
            }
            while (this.resetBusy) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    protected void stop() {
        this.isAlive = false;
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                this.modules.getModule(i).stop();
            }
            logger.log(Level.INFO, "[emu] Emulation process stopped.");
            this.gui.notifyGUI(1);
        }
    }

    protected void reset() {
        this.resetBusy = true;
        if (this.modules != null) {
            ((ModuleCPU)this.modules.getModule("cpu")).stop();
            this.coldStart = false;
            logger.log(Level.INFO, "[emu] Reset in progress...");
        }
        this.resetBusy = false;
    }

    protected void debug(int n) {
        switch (n) {
            case 3: {
                this.io.showHelp();
                break;
            }
            case 16: {
                ModuleCPU moduleCPU = (ModuleCPU)this.modules.getModule("cpu");
                String[] stringArray = this.io.getArguments();
                if (stringArray != null) {
                    int n2 = Integer.parseInt(stringArray[0]);
                    for (int i = 0; i < n2; ++i) {
                        moduleCPU.start();
                    }
                } else {
                    moduleCPU.start();
                }
                logger.log(Level.SEVERE, moduleCPU.getNextInstructionInfo());
                break;
            }
            case 20: {
                ModuleCPU moduleCPU = (ModuleCPU)this.modules.getModule("cpu");
                logger.log(Level.SEVERE, moduleCPU.dumpRegisters());
                break;
            }
            case 17: {
                String[] stringArray = this.io.getArguments();
                if (stringArray == null) break;
                String string = stringArray[0];
                Module module = this.modules.getModule(string);
                if (module != null) {
                    logger.log(Level.INFO, module.getDump());
                    break;
                }
                logger.log(Level.SEVERE, "[emu] Module not recognised.");
                break;
            }
            case 21: {
                ModuleMemory moduleMemory = (ModuleMemory)this.modules.getModule("memory");
                String[] stringArray = this.io.getArguments();
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = 0;
                n4 = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 2;
                try {
                    for (int i = 0; i < n4; ++i) {
                        logger.log(Level.SEVERE, "[emu] Value of [0x" + Integer.toHexString(n3 + i).toUpperCase() + "]: 0x" + Integer.toHexString(0x100 | moduleMemory.getByte(n3 + i) & 0xFF).substring(1).toUpperCase());
                    }
                    break;
                }
                catch (ModuleException moduleException) {
                    moduleException.printStackTrace();
                    break;
                }
            }
            default: {
                logger.log(Level.SEVERE, "[emu] No command match. Enter a correct emulator command.");
            }
        }
    }

    protected void setActive(boolean bl) {
        this.isAlive = bl;
    }

    public Modules getModules() {
        return this.modules;
    }

    public ArrayList<HardwareComponent> getHWcomponents() {
        return this.hwComponents;
    }

    public void setModules(Modules modules) {
        this.modules = modules;
    }

    public GUI getGui() {
        return this.gui;
    }

    public IO getIo() {
        return this.io;
    }

    public boolean getColdStart() {
        return this.coldStart;
    }

    public void setColdStart(boolean bl) {
        this.coldStart = bl;
    }

    protected Module getModule(String string) {
        return this.modules.getModule(string);
    }

    protected void notifyKeyboard(KeyEvent keyEvent, int n) {
        ModuleKeyboard moduleKeyboard = (ModuleKeyboard)this.modules.getModule("keyboard");
        if (moduleKeyboard != null) {
            moduleKeyboard.generateScancode(keyEvent, n);
        }
    }

    protected void notifyMouse(MouseEvent mouseEvent) {
        ModuleMouse moduleMouse = (ModuleMouse)this.modules.getModule("mouse");
        if (moduleMouse != null) {
            moduleMouse.mouseMotion(mouseEvent);
        }
    }

    protected boolean insertFloppy(String string, byte by, File file, boolean bl) {
        ModuleFDC moduleFDC = (ModuleFDC)this.modules.getModule("fdc");
        if (moduleFDC != null) {
            return moduleFDC.insertCarrier(string, by, file, bl);
        }
        return false;
    }

    protected boolean ejectFloppy(String string) {
        ModuleFDC moduleFDC = (ModuleFDC)this.modules.getModule("fdc");
        if (moduleFDC != null) {
            return moduleFDC.ejectCarrier(string);
        }
        return false;
    }

    public void statusChanged(int n) {
        switch (n) {
            case 0: {
                this.gui.updateGUI(15);
                break;
            }
            case 1: {
                this.gui.updateGUI(16);
                break;
            }
            case 2: {
                this.gui.updateGUI(7);
                break;
            }
            case 3: {
                this.gui.updateGUI(8);
                break;
            }
            case 4: {
                this.gui.updateGUI(9);
                break;
            }
            case 5: {
                this.gui.updateGUI(10);
                break;
            }
            case 6: {
                this.gui.updateGUI(11);
                break;
            }
            case 7: {
                this.gui.updateGUI(12);
                break;
            }
            case 8: {
                this.gui.updateGUI(13);
                break;
            }
            case 9: {
                this.gui.updateGUI(14);
                break;
            }
        }
    }

    public String getScreenText() {
        ModuleVideo moduleVideo = (ModuleVideo)this.modules.getModule("video");
        if (moduleVideo != null) {
            return moduleVideo.getVideoBufferCharacters();
        }
        return null;
    }

    public BufferedImage getScreenImage() {
        return null;
    }

    public boolean isCpu32bit() {
        return this.cpu32bit;
    }

    public boolean setupEmu() {
        boolean bl = true;
        if (this.coldStart) {
            logger.log(Level.INFO, "===================    COLD START   ===================");
            logger.log(Level.INFO, "=================== CREATE MODULES  ===================");
            bl &= this.createModules();
            logger.log(Level.INFO, "=================== CONNECT MODULES ===================");
            bl &= this.connectModules();
            logger.log(Level.INFO, "===================   INIT TIMERS   ===================");
            bl &= this.setTimingParams(this.modules.getModule("cpu"));
            bl &= this.setTimingParams(this.modules.getModule("video"));
            bl &= this.setTimingParams(this.modules.getModule("pit"));
            bl &= this.setTimingParams(this.modules.getModule("keyboard"));
            bl &= this.setTimingParams(this.modules.getModule("fdc"));
            bl &= this.setTimingParams(this.modules.getModule("ata"));
        } else {
            logger.log(Level.INFO, "===================    WARM START   ===================");
            this.setColdStart(true);
        }
        logger.log(Level.INFO, "===================  RESET MODULES  ===================");
        bl &= this.resetModules();
        if (this.cpu32bit) {
            // empty if block
        }
        logger.log(Level.INFO, "=================== INIT OUTPUT DEVICES ===================");
        bl &= this.initScreenOutputDevice();
        logger.log(Level.INFO, "================== INIT INPUT DEVICES =================");
        bl &= this.setMouseParams();
        bl &= this.setMemoryParams();
        logger.log(Level.INFO, "===================    LOAD BIOS    ===================");
        bl &= this.loadBIOS();
        logger.log(Level.INFO, "================= LOAD STORAGE MEDIA ==================");
        bl &= this.setFloppyParams();
        this.setHardDriveParams();
        logger.log(Level.INFO, "===================  MISC SETTINGS  ===================");
        bl &= this.setBootParams();
        if (!this.cpu32bit) {
            bl &= this.setDebugMode();
        }
        logger.log(Level.INFO, "================= READY FOR EXECUTION =================");
        return bl;
    }

    public boolean createModules() {
        Object object2;
        this.modules = new Modules(20);
        this.cpu32bit = this.moduleConfig.getCpu().isCpu32Bit();
        this.getGui().setCpyTypeLabel(this.cpu32bit ? "32 bit" : "16 bit");
        Clock clock = new Clock(this);
        this.modules.addModule(clock);
        if (this.cpu32bit) {
            this.modules.addModule(new Processor());
        } else {
            this.modules.addModule(new CPU(this));
        }
        if (this.cpu32bit) {
            object2 = new PhysicalAddressSpace();
            LinearAddressSpace object3 = new LinearAddressSpace();
            for (int i = 0; i < 0x10000000; i += 4096) {
                ((PhysicalAddressSpace)object2).allocateMemory(i, new LazyMemory(4096, clock));
            }
            this.hwComponents.add(object3);
            this.hwComponents.add((HardwareComponent)object2);
        } else if (this.dynamicMem) {
            this.modules.addModule(new DynamicAllocationMemory(this));
        } else {
            this.modules.addModule(new Memory(this));
        }
        if (this.moduleConfig.getBios() != null) {
            for (Emulator.Architecture.Modules.Bios bios : this.moduleConfig.getBios()) {
                logger.log(Level.CONFIG, "System bios file: " + bios.getSysbiosfilepath() + "; starting at 0x" + Integer.toHexString(bios.getRamaddresssysbiosstartdec().intValue()));
                logger.log(Level.CONFIG, "VGA bios file: " + bios.getVgabiosfilepath() + "; starting at 0x" + Integer.toHexString(bios.getRamaddressvgabiosstartdec().intValue()));
            }
            if (!this.cpu32bit) {
                this.modules.addModule(new BIOS(this));
            }
        }
        this.modules.addModule(new Motherboard(this));
        this.modules.addModule(new PIC(this));
        if (this.moduleConfig.getPit() != null) {
            this.modules.addModule(new PIT(this));
        }
        this.modules.addModule(new RTC(this));
        if (this.moduleConfig.getAta() != null) {
            this.modules.addModule(new ATA(this));
        }
        if (this.cpu32bit) {
            object2 = new DMAController(false, true);
            DMAController dMAController = new DMAController(false, false);
            this.hwComponents.add((HardwareComponent)object2);
            this.hwComponents.add(dMAController);
        } else {
            this.modules.addModule(new DMA(this));
        }
        if (this.moduleConfig.getFdc() != null) {
            this.modules.addModule(new FDC(this));
        }
        if (this.moduleConfig.getKeyboard() != null) {
            this.modules.addModule(new Keyboard(this));
        }
        if (this.moduleConfig.getMouse() != null) {
            this.modules.addModule(new Mouse(this));
        }
        this.modules.addModule(new ParallelPort(this));
        this.modules.addModule(new SerialPort(this));
        if (this.moduleConfig.getVideo() != null) {
            this.modules.addModule(new Video(this));
        }
        this.modules.addModule(new DeviceDummy(this));
        this.modules.addModule(new Screen(this));
        logger.log(Level.INFO, "[emu] All modules are created.");
        return true;
    }

    public boolean connectModules() {
        int n;
        boolean bl = true;
        for (n = 0; n < this.modules.size(); ++n) {
            Module module = this.modules.getModule(n);
            String[] stringArray = module.getConnection();
            for (int i = 0; i < stringArray.length; ++i) {
                Module module2 = this.modules.getModule(stringArray[i]);
                if (module2 != null) {
                    if (module.setConnection(module2)) {
                        logger.log(Level.CONFIG, "[emu] Successfully established connection between " + module.getType() + " and " + module2.getType());
                        continue;
                    }
                    logger.log(Level.SEVERE, "[emu] Failed to establish connection between " + module.getType() + " and " + module2.getType());
                    continue;
                }
                logger.log(Level.SEVERE, "[emu] Failed to establish connection between " + module.getType() + " and unknown module " + stringArray[i]);
            }
        }
        n = 1;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (this.modules.getModule(i).isConnected()) continue;
            n = 0;
            logger.log(Level.SEVERE, "[emu] Could not connect module: " + this.modules.getModule(i).getType() + ".");
        }
        if (n == 0) {
            logger.log(Level.SEVERE, "[emu] Not all modules are connected. Emulator may be unstable.");
            bl &= false;
        } else {
            logger.log(Level.INFO, "[emu] All modules are successfully connected.");
            bl &= true;
        }
        if (this.cpu32bit) {
            Processor processor = (Processor)this.modules.getModule(ModuleType.CPU.toString());
            Video video = (Video)this.modules.getModule(ModuleType.VGA.toString());
            Motherboard motherboard = (Motherboard)this.modules.getModule(ModuleType.MOTHERBOARD.toString());
            FDC fDC = (FDC)this.modules.getModule(ModuleType.FDC.toString());
            LinearAddressSpace linearAddressSpace = (LinearAddressSpace)this.hwComponents.get(0);
            PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)this.hwComponents.get(1);
            DMAController dMAController = (DMAController)this.hwComponents.get(2);
            DMAController dMAController2 = (DMAController)this.hwComponents.get(3);
            PIC pIC = (PIC)this.modules.getModule(ModuleType.PIC.toString());
            IOPortHandler iOPortHandler = new IOPortHandler();
            iOPortHandler.setConnection(motherboard);
            processor.acceptComponent(linearAddressSpace);
            processor.acceptComponent(physicalAddressSpace);
            processor.acceptComponent(iOPortHandler);
            processor.setConnection(pIC);
            physicalAddressSpace.acceptComponent(linearAddressSpace);
            linearAddressSpace.acceptComponent(physicalAddressSpace);
            video.acceptComponent(physicalAddressSpace);
            dMAController.acceptComponent(physicalAddressSpace);
            dMAController2.acceptComponent(physicalAddressSpace);
            dMAController.acceptComponent(iOPortHandler);
            dMAController2.acceptComponent(iOPortHandler);
            fDC.acceptComponent(dMAController);
            fDC.acceptComponent(dMAController2);
            bl = true;
        }
        return bl;
    }

    public boolean setTimingParams(Module module) {
        boolean bl = true;
        if (module instanceof ModuleCPU) {
            int n = this.moduleConfig.getCpu().getSpeedmhz().intValue();
            ((ModuleCPU)module).setIPS(n * 1000000);
            bl &= true;
        } else if (module instanceof ModuleDevice) {
            if (module instanceof ModulePIT) {
                ((ModuleDevice)module).setUpdateInterval(this.moduleConfig.getPit().getClockrate().intValue());
            } else if (module instanceof ModuleVideo) {
                ((ModuleDevice)module).setUpdateInterval(this.moduleConfig.getVideo().getUpdateintervalmicrosecs().intValue());
            } else if (module instanceof ModuleKeyboard) {
                ((ModuleDevice)module).setUpdateInterval(this.moduleConfig.getKeyboard().getUpdateintervalmicrosecs().intValue());
            } else if (module instanceof ModuleFDC) {
                ((ModuleDevice)module).setUpdateInterval(this.moduleConfig.getFdc().getUpdateintervalmicrosecs().intValue());
            } else if (module instanceof ModuleATA) {
                ((ModuleDevice)module).setUpdateInterval(this.moduleConfig.getAta().getUpdateintervalmicrosecs().intValue());
            }
            bl &= true;
        } else {
            bl &= false;
        }
        return bl;
    }

    public boolean resetModules() {
        boolean bl = true;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (this.modules.getModule(i).reset()) continue;
            bl = false;
            logger.log(Level.SEVERE, "[emu] Could not reset module: " + this.modules.getModule(i).getType() + ".");
        }
        if (!bl) {
            logger.log(Level.SEVERE, "[emu] Not all modules are reset. Emulator may be unstable.");
        } else {
            logger.log(Level.INFO, "[emu] All modules are successfully reset.");
        }
        return bl;
    }

    public boolean initScreenOutputDevice() {
        ModuleScreen moduleScreen = (ModuleScreen)this.modules.getModule(ModuleType.SCREEN.toString());
        if (moduleScreen != null) {
            this.getGui().setScreen(moduleScreen.getScreen());
            return true;
        }
        logger.log(Level.WARNING, "[emu] No screen available.");
        return false;
    }

    public boolean setMouseParams() {
        Mouse mouse = (Mouse)this.modules.getModule(ModuleType.MOUSE.toString());
        logger.log(Level.INFO, "mouse = " + mouse);
        if (mouse != null) {
            boolean bl = this.moduleConfig.getMouse().isEnabled();
            mouse.setMouseEnabled(bl);
            if (bl) {
                this.gui.setMouseEnabled();
                this.gui.updateGUI(17);
            } else {
                this.gui.setMouseDisabled();
                this.gui.updateGUI(18);
            }
            String string = this.moduleConfig.getMouse().getMousetype();
            mouse.setMouseType(string);
        }
        return true;
    }

    public boolean setMemoryParams() {
        ModuleMemory moduleMemory = (ModuleMemory)this.modules.getModule(ModuleType.MEMORY.toString());
        if (moduleMemory != null) {
            int n = this.moduleConfig.getMemory().getSizemb().intValue();
            moduleMemory.setRamSizeInMB(n);
        }
        return true;
    }

    public boolean loadBIOS() {
        ModuleMemory moduleMemory;
        boolean bl = true;
        if (this.cpu32bit) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(new FileInputStream(new File(Constants.BOCHS_BIOS))));
                byte[] byArray = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(byArray, 0, byArray.length);
                bufferedInputStream.close();
                Clock clock = (Clock)this.modules.getModule(ModuleType.CLOCK.toString());
                SystemBIOS systemBIOS = new SystemBIOS(byArray, clock);
                BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new DataInputStream(new FileInputStream(new File(Constants.VGA_BIOS))));
                byte[] byArray2 = new byte[bufferedInputStream2.available()];
                bufferedInputStream2.read(byArray2, 0, byArray2.length);
                bufferedInputStream2.close();
                VGABIOS vGABIOS = new VGABIOS(byArray2, clock);
                PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)this.hwComponents.get(1);
                systemBIOS.acceptComponent(physicalAddressSpace);
                vGABIOS.acceptComponent(physicalAddressSpace);
                this.hwComponents.add(systemBIOS);
                this.hwComponents.add(vGABIOS);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl &= false;
            }
            return bl;
        }
        BIOS bIOS = (BIOS)this.modules.getModule(ModuleType.BIOS.toString());
        String string = Utilities.resolvePathAsString(this.moduleConfig.getBios().get(0).getSysbiosfilepath());
        String string2 = Utilities.resolvePathAsString(this.moduleConfig.getBios().get(0).getVgabiosfilepath());
        int n = this.moduleConfig.getBios().get(0).getRamaddresssysbiosstartdec().intValue();
        int n2 = this.moduleConfig.getBios().get(0).getRamaddressvgabiosstartdec().intValue();
        try {
            if (bIOS.setSystemBIOS(this.getIo().importBinaryStream(string))) {
                logger.log(Level.CONFIG, "[emu] System BIOS successfully stored in ROM.");
                moduleMemory = (ModuleMemory)this.modules.getModule(ModuleType.MEMORY.toString());
                moduleMemory.setBytes(n, bIOS.getSystemBIOS());
                logger.log(Level.CONFIG, "[emu] System BIOS successfully loaded in RAM.");
            } else {
                logger.log(Level.SEVERE, "[emu] Not able to retrieve System BIOS binaries from file system.");
                bl &= false;
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, moduleException.getMessage());
            bl &= false;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage());
            bl &= false;
        }
        try {
            if (bIOS.setVideoBIOS(this.getIo().importBinaryStream(string2))) {
                logger.log(Level.CONFIG, "[emu] Video BIOS successfully stored in ROM.");
                moduleMemory = (ModuleMemory)this.modules.getModule(ModuleType.MEMORY.toString());
                moduleMemory.setBytes(n2, bIOS.getVideoBIOS());
                logger.log(Level.CONFIG, "[emu] Video BIOS successfully loaded in RAM.");
            } else {
                logger.log(Level.SEVERE, "[emu] Not able to retrieve Video BIOS binaries from file system.");
                bl &= false;
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, moduleException.getMessage());
            bl &= false;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage());
            bl &= false;
        }
        return bl;
    }

    public boolean setFloppyParams() {
        ModuleFDC moduleFDC = (ModuleFDC)this.modules.getModule(ModuleType.FDC.toString());
        moduleFDC.setNumberOfDrives(1);
        for (int i = 0; i < 1; ++i) {
            Emulator.Architecture.Modules.Fdc.Floppy floppy = this.moduleConfig.getFdc().getFloppy().get(i);
            boolean bl = floppy.isInserted();
            String string = floppy.getDriveletter();
            String string2 = floppy.getDiskformat();
            int n = 0;
            boolean bl2 = floppy.isWriteprotected();
            String string3 = Utilities.resolvePathAsString(floppy.getImagefilepath());
            if (string2.equals("360K")) {
                n = 1;
            } else if (string2.equals("1.2M")) {
                n = 2;
            } else if (string2.equals("720K")) {
                n = 3;
            } else if (string2.equals("1.44M")) {
                n = 4;
            } else if (string2.equals("2.88M")) {
                n = 5;
            } else if (string2.equals("160K")) {
                n = 6;
            } else if (string2.equals("180K")) {
                n = 7;
            } else if (string2.equals("320K")) {
                n = 8;
            } else {
                logger.log(Level.SEVERE, "[emu] Floppy disk format not recognised.");
            }
            if (!bl) continue;
            File file = new File(string3);
            moduleFDC.insertCarrier(string, (byte)n, file, bl2);
            if (!string.equals("A")) continue;
            this.getGui().updateGUI(3);
        }
        return true;
    }

    public boolean setHardDriveParams() {
        ATA aTA = (ATA)this.modules.getModule(ModuleType.ATA.toString());
        if (this.moduleConfig.getAta().getHarddiskdrive().isEmpty()) {
            return false;
        }
        for (int i = 0; i < 1; ++i) {
            Emulator.Architecture.Modules.Ata.Harddiskdrive harddiskdrive = this.moduleConfig.getAta().getHarddiskdrive().get(0);
            boolean bl = harddiskdrive.isEnabled();
            int n = harddiskdrive.getChannelindex().intValue();
            boolean bl2 = harddiskdrive.isMaster();
            boolean bl3 = harddiskdrive.isAutodetectcylinders();
            int n2 = harddiskdrive.getCylinders().intValue();
            int n3 = harddiskdrive.getHeads().intValue();
            int n4 = harddiskdrive.getSectorspertrack().intValue();
            String string = Utilities.resolvePathAsString(harddiskdrive.getImagefilepath());
            if (!bl || n < 0 || n >= 4) continue;
            if (bl3) {
                n2 = 0;
            }
            ((ModuleATA)aTA).initConfig(n, bl2, true, false, n2, n3, n4, ATATranslationType.AUTO, string);
            if (n != 0 || !bl2) continue;
            this.getGui().updateGUI(5);
        }
        return true;
    }

    public boolean setBootParams() {
        ATA aTA = (ATA)this.modules.getModule(ModuleType.ATA.toString());
        Emulator.Architecture.Modules.Bios bios = this.moduleConfig.getBios().get(0);
        Emulator.Architecture.Modules.Bios.Bootdrives bootdrives = bios.getBootdrives();
        boolean bl = bios.isFloppycheckdisabled();
        int[] nArray = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            String string = "none";
            if (i == 0) {
                string = bootdrives.getBootdrive0();
            }
            if (i == 1) {
                string = bootdrives.getBootdrive1();
            }
            if (i == 2) {
                string = bootdrives.getBootdrive2();
            }
            if (string.equalsIgnoreCase("Hard Drive")) {
                nArray[i] = 2;
                continue;
            }
            if (string.equalsIgnoreCase("Floppy Drive")) {
                nArray[i] = 1;
                continue;
            }
            if (string.equalsIgnoreCase("cd")) {
                nArray[i] = 3;
                continue;
            }
            if (!string.equalsIgnoreCase("none")) continue;
            nArray[i] = 0;
        }
        aTA.setCmosSettings(nArray, bl);
        return true;
    }

    public boolean setDebugMode() {
        boolean bl = true;
        boolean bl2 = this.emuConfig.isDebug();
        if (bl2) {
            for (int i = 0; i < this.modules.size(); ++i) {
                this.modules.getModule(i).setDebugMode(true);
            }
            logger.log(Level.INFO, "[emu] All modules in debug mode.");
            return bl;
        }
        this.modules.getModule(ModuleType.ATA.toString()).setDebugMode(this.moduleConfig.getAta().isDebug());
        this.modules.getModule(ModuleType.CPU.toString()).setDebugMode(this.moduleConfig.getCpu().isDebug());
        this.modules.getModule(ModuleType.MEMORY.toString()).setDebugMode(this.moduleConfig.getMemory().isDebug());
        this.modules.getModule(ModuleType.FDC.toString()).setDebugMode(this.moduleConfig.getFdc().isDebug());
        this.modules.getModule(ModuleType.PIT.toString()).setDebugMode(this.moduleConfig.getPit().isDebug());
        this.modules.getModule(ModuleType.KEYBOARD.toString()).setDebugMode(this.moduleConfig.getKeyboard().isDebug());
        this.modules.getModule(ModuleType.MOUSE.toString()).setDebugMode(this.moduleConfig.getMouse().isDebug());
        this.modules.getModule(ModuleType.VGA.toString()).setDebugMode(this.moduleConfig.getVideo().isDebug());
        boolean bl3 = this.moduleConfig.getMemory().isDebug();
        int n = this.moduleConfig.getMemory().getDebugaddressdecimal().intValue();
        if (this.moduleConfig.getMemory().isDebug().booleanValue()) {
            ((ModuleMemory)this.modules.getModule(ModuleType.MEMORY.toString())).setWatchValueAndAddress(bl3, n);
            logger.log(Level.CONFIG, "[emu] RAM address watch set to " + bl3 + "; address: " + n);
        }
        return true;
    }
}

