/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import dioscuri.util.Utilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BiosConfigDialog
extends ConfigurationDialog {
    private JFormattedTextField sysBiosStartsFTextField;
    private JFormattedTextField vgaBiosStartFTextField;
    private JButton sysBiosBrowseButton;
    private JButton vgaBiosBrowseButton;
    private File selectedVgaFile = null;
    private JLabel imageFilePathVgaLabel = null;
    Emulator emuConfig;

    public BiosConfigDialog(GUI gUI) {
        super(gUI, "BIOS Configuration", false, ModuleType.BIOS);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Bios bios = this.emuConfig.getArchitecture().getModules().getBios().get(0);
        String string = Utilities.resolvePathAsString(bios.getSysbiosfilepath());
        String string2 = Utilities.resolvePathAsString(bios.getVgabiosfilepath());
        Integer n = bios.getRamaddresssysbiosstartdec().intValue();
        Integer n2 = bios.getRamaddressvgabiosstartdec().intValue();
        this.sysBiosStartsFTextField.setValue(n);
        this.vgaBiosStartFTextField.setValue(n2);
        this.selectedfile = new File(string);
        this.selectedVgaFile = new File(string2);
        if (this.selectedfile.getName().length() > 30) {
            this.imageFilePathLabel.setText("..." + this.selectedfile.getName().substring(this.selectedfile.getName().length() - 30));
        } else {
            this.imageFilePathLabel.setText(this.selectedfile.getName());
        }
        if (this.selectedVgaFile.getName().length() > 30) {
            this.imageFilePathVgaLabel.setText("..." + this.selectedVgaFile.getName().substring(this.selectedVgaFile.getName().length() - 30));
        } else {
            this.imageFilePathVgaLabel.setText(this.selectedVgaFile.getName());
        }
    }

    @Override
    protected void initMainEntryPanel() {
        JLabel jLabel = new JLabel("Sys Bios File");
        JLabel jLabel2 = new JLabel("Vga Bios File");
        JLabel jLabel3 = new JLabel("Sys Bios Start");
        JLabel jLabel4 = new JLabel("Vga Bios Start");
        this.populateControls();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainEntryPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mainEntryPanel.add(jLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.imageFilePathLabel, gridBagConstraints);
        this.mainEntryPanel.add(this.imageFilePathLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.sysBiosBrowseButton, gridBagConstraints);
        this.mainEntryPanel.add(this.sysBiosBrowseButton);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.mainEntryPanel.add(jLabel2);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.imageFilePathVgaLabel, gridBagConstraints);
        this.mainEntryPanel.add(this.imageFilePathVgaLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.vgaBiosBrowseButton, gridBagConstraints);
        this.mainEntryPanel.add(this.vgaBiosBrowseButton);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.mainEntryPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.sysBiosStartsFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.sysBiosStartsFTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.mainEntryPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.vgaBiosStartFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.vgaBiosStartFTextField);
    }

    private void populateControls() {
        this.imageFilePathLabel = new JLabel("");
        this.imageFilePathVgaLabel = new JLabel("");
        this.sysBiosStartsFTextField = new JFormattedTextField();
        this.sysBiosStartsFTextField.setValue(new Integer(0));
        this.sysBiosStartsFTextField.setColumns(10);
        this.vgaBiosStartFTextField = new JFormattedTextField();
        this.vgaBiosStartFTextField.setValue(new Integer(0));
        this.vgaBiosStartFTextField.setColumns(10);
        this.sysBiosBrowseButton = new JButton("Browse");
        this.sysBiosBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BiosConfigDialog.this.launchFileChooser();
            }
        });
        this.vgaBiosBrowseButton = new JButton("Browse");
        this.vgaBiosBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BiosConfigDialog.this.launchFileChooserVga();
            }
        });
    }

    private void launchFileChooserVga() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.selectedVgaFile = jFileChooser.getSelectedFile();
            String string = this.selectedVgaFile.getName();
            this.imageFilePathVgaLabel.setText("   " + string);
        }
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Bios bios = this.emuConfig.getArchitecture().getModules().getBios().get(0);
        bios.setSysbiosfilepath(this.selectedfile.getAbsoluteFile().toString());
        bios.setVgabiosfilepath(this.selectedVgaFile.getAbsoluteFile().toString());
        bios.setRamaddresssysbiosstartdec(BigInteger.valueOf(((Integer)this.sysBiosStartsFTextField.getValue()).intValue()));
        bios.setRamaddressvgabiosstartdec(BigInteger.valueOf(((Integer)this.vgaBiosStartFTextField.getValue()).intValue()));
        return this.emuConfig;
    }
}

