/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.Emulator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ConfigController {
    private static final Logger logger = Logger.getLogger(ConfigController.class.getName());
    private static JAXBContext jc;
    public static String EMULATOR_XML;

    public ConfigController(GUI gUI) {
    }

    public static Unmarshaller getEmuUnmarshaller() throws JAXBException {
        return jc.createUnmarshaller();
    }

    public static Marshaller getEmuMarshaller() throws JAXBException {
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", "UTF-8");
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToXML(Emulator emulator, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            marshaller.setProperty("jaxb.encoding", "UTF-8");
            marshaller.marshal((Object)emulator, fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Emulator loadFromXML(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Emulator emulator = (Emulator)jc.createUnmarshaller().unmarshal(fileInputStream);
            return emulator;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static Emulator loadFromXML(InputStream inputStream) throws Exception {
        return (Emulator)jc.createUnmarshaller().unmarshal(inputStream);
    }

    static {
        EMULATOR_XML = "dioscuri.config";
        try {
            jc = JAXBContext.newInstance(EMULATOR_XML);
        }
        catch (JAXBException jAXBException) {
            logger.log(Level.SEVERE, "[Config] Cannot initialise JAXBContext for binding Emulator config xml files: " + jAXBException.getMessage());
            jAXBException.printStackTrace();
        }
    }
}

