/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import dioscuri.util.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class ConfigurationDialog
extends JDialog {
    protected JPanel mainEntryPanel;
    protected JPanel statusPanel;
    protected JButton doButton;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JLabel imageFilePathLabel;
    protected File selectedfile;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogXPosition;
    protected int dialogYPosition;
    protected GUI parent;
    protected boolean isMainConfigScreen;
    protected ModuleType moduleType;

    public ConfigurationDialog() {
    }

    public ConfigurationDialog(GUI gUI, String string, boolean bl, ModuleType moduleType) {
        super(gUI.asJFrame(), string, true);
        this.moduleType = moduleType;
        this.initComponents(gUI, bl);
    }

    private void initComponents(GUI gUI, boolean bl) {
        this.parent = gUI;
        this.isMainConfigScreen = bl;
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.dialogWidth = 600;
        if (!bl) {
            this.dialogWidth -= 200;
        }
        this.dialogHeight = 315;
        this.dialogXPosition = 250;
        this.dialogYPosition = 250;
        if (!bl) {
            this.dialogXPosition += 100;
            this.dialogYPosition += 100;
        }
        this.setLocation(0, 0);
        Dimension dimension = new Dimension(this.dialogWidth, this.dialogHeight);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setResizable(false);
        this.setLocation(this.dialogXPosition, this.dialogYPosition);
        this.mainEntryPanel = new JPanel();
        this.statusPanel = new JPanel(new FlowLayout(4, 0, 0));
        Dimension dimension2 = new Dimension(this.dialogWidth, 50);
        this.statusPanel.setSize(dimension2);
        this.statusPanel.setPreferredSize(dimension2);
        this.initBottomButtonPanel();
        this.initMainEntryPanel();
        if (!bl) {
            this.readInParams();
        }
        this.getContentPane().add((Component)this.mainEntryPanel, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.setVisible(true);
        this.requestFocus();
    }

    protected void initMainEntryPanel() {
    }

    protected void initDoButton() {
        this.doButton = new JButton("Save");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.saveParams();
            }
        });
    }

    private void initCancelButton() {
        Dimension dimension = new Dimension(70, 25);
        this.cancelButton.setSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dispose();
            }
        });
    }

    protected void saveParams() {
        Emulator emulator = null;
        String string = "";
        if (this.moduleType != null) {
            string = this.moduleType.toString();
        }
        if (this.moduleType != null && (this.moduleType == ModuleType.ATA || this.moduleType == ModuleType.FDC) && this.selectedfile == null) {
            JOptionPane.showMessageDialog(this, "Error saving data - please browse for an image file.", "DIOSCURI", 2);
            return;
        }
        try {
            emulator = this.getParamsFromGui();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error saving data - please correct the " + string + " parameters entered.", "DIOSCURI", 2);
            return;
        }
        if (!Utilities.saveXML(emulator, this.parent.getConfigFilePath())) {
            JOptionPane.showMessageDialog(this, "Error saving " + string + " parameter to configuration file.", "DIOSCURI", 2);
            return;
        }
        this.dispose();
    }

    protected Emulator getParamsFromGui() {
        Emulator emulator = null;
        return emulator;
    }

    protected void readInParams() {
    }

    protected void initBottomButtonPanel() {
        this.initDoButton();
        this.initConfirmButton();
        Dimension dimension = new Dimension(70, 25);
        this.okButton.setSize(dimension);
        this.okButton.setPreferredSize(dimension);
        this.doButton.setSize(dimension);
        this.doButton.setPreferredSize(dimension);
        this.statusPanel = new JPanel(new GridLayout(2, 1));
        this.getContentPane().add((Component)this.statusPanel, "Center");
        Dimension dimension2 = new Dimension(this.dialogWidth, 60);
        this.statusPanel.setSize(dimension2);
        this.statusPanel.setPreferredSize(dimension2);
        JPanel jPanel = new JPanel(new FlowLayout(4, 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.doButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel.add(this.okButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.statusPanel.add(new JPanel());
        this.statusPanel.add(jPanel);
    }

    protected void initConfirmButton() {
        this.okButton = new JButton("Cancel");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dispose();
            }
        });
    }

    protected void launchFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(this.selectedfile);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.selectedfile = jFileChooser.getSelectedFile();
            String string = this.selectedfile.getName();
            if (string.length() > 30) {
                string = string.substring(string.length() - 30);
                this.imageFilePathLabel.setText("..." + string);
            } else {
                this.imageFilePathLabel.setText(string);
            }
        }
    }
}

