/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.DioscuriFrame;
import dioscuri.config.AtaConfigDialog;
import dioscuri.config.BiosConfigDialog;
import dioscuri.config.BootConfigDialog;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.CpuConfigDialog;
import dioscuri.config.FdcConfigDialog;
import dioscuri.config.ModuleType;
import dioscuri.config.MouseConfigDialog;
import dioscuri.config.RamConfigDialog;
import dioscuri.config.SimpleConfigDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class SelectionConfigDialog
extends ConfigurationDialog {
    private JList modulesList;

    public SelectionConfigDialog(DioscuriFrame dioscuriFrame) {
        super(dioscuriFrame, "Configuration Selector", true, (ModuleType)null);
    }

    @Override
    protected void initDoButton() {
        this.doButton = new JButton("Edit");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectionConfigDialog.this.launchSpecificConfigDialog();
            }
        });
    }

    @Override
    protected void initConfirmButton() {
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectionConfigDialog.this.dispose();
            }
        });
    }

    private void launchSpecificConfigDialog() {
        ModuleType moduleType = (ModuleType)((Object)this.modulesList.getSelectedValue());
        if (moduleType.equals((Object)ModuleType.ATA)) {
            new AtaConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.BIOS)) {
            new BiosConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.BOOT)) {
            new BootConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.CPU)) {
            new CpuConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.FDC)) {
            new FdcConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.MEMORY)) {
            new RamConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.MOUSE)) {
            new MouseConfigDialog(this.parent);
        } else if (moduleType.equals((Object)ModuleType.PIT) || moduleType.equals((Object)ModuleType.KEYBOARD) || moduleType.equals((Object)ModuleType.VGA)) {
            new SimpleConfigDialog(this.parent, moduleType);
        }
    }

    @Override
    protected void initMainEntryPanel() {
        DefaultListModel<ModuleType> defaultListModel = new DefaultListModel<ModuleType>();
        defaultListModel.addElement(ModuleType.ATA);
        defaultListModel.addElement(ModuleType.BIOS);
        defaultListModel.addElement(ModuleType.BOOT);
        defaultListModel.addElement(ModuleType.CPU);
        defaultListModel.addElement(ModuleType.FDC);
        defaultListModel.addElement(ModuleType.KEYBOARD);
        defaultListModel.addElement(ModuleType.MOUSE);
        defaultListModel.addElement(ModuleType.MEMORY);
        defaultListModel.addElement(ModuleType.PIT);
        defaultListModel.addElement(ModuleType.VGA);
        this.modulesList = new JList(defaultListModel);
        this.modulesList.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(20, 30);
        Dimension dimension = new Dimension(this.dialogWidth - 50, 215);
        jScrollPane.setSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.getViewport().add(this.modulesList);
        this.mainEntryPanel.add(jScrollPane);
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        this.modulesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SelectionConfigDialog.this.launchSpecificConfigDialog();
                }
            }
        });
    }
}

