/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SimpleConfigDialog
extends ConfigurationDialog {
    private JFormattedTextField updateIntField;
    Emulator emuConfig;

    public SimpleConfigDialog(GUI gUI, ModuleType moduleType) {
        super(gUI, moduleType.toString().toUpperCase() + " Configuration", false, moduleType);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Integer n = 0;
        if (this.moduleType.equals((Object)ModuleType.PIT)) {
            n = this.emuConfig.getArchitecture().getModules().getPit().getClockrate().intValue();
        } else if (this.moduleType.equals((Object)ModuleType.KEYBOARD)) {
            n = this.emuConfig.getArchitecture().getModules().getKeyboard().getUpdateintervalmicrosecs().intValue();
        } else if (this.moduleType.equals((Object)ModuleType.VGA)) {
            n = this.emuConfig.getArchitecture().getModules().getVideo().getUpdateintervalmicrosecs().intValue();
        }
        this.updateIntField.setValue(n);
    }

    @Override
    protected void initDoButton() {
        this.doButton = new JButton("Save");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleConfigDialog.this.saveParams();
            }
        });
    }

    @Override
    protected void initMainEntryPanel() {
        int n;
        String string = "  Update Int (microSecs)";
        if (this.moduleType == ModuleType.PIT) {
            string = "  Clock Rate";
        }
        JLabel jLabel = new JLabel(string);
        this.updateIntField = new JFormattedTextField();
        this.updateIntField.setValue(new Integer(0));
        this.updateIntField.setColumns(10);
        this.mainEntryPanel = new JPanel(new GridLayout(10, 3));
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        for (n = 0; n < 3; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
        this.mainEntryPanel.add(jLabel);
        this.mainEntryPanel.add(this.updateIntField);
        this.mainEntryPanel.add(new JLabel(""));
        for (n = 0; n < 24; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
    }

    @Override
    protected Emulator getParamsFromGui() {
        if (this.moduleType.equals((Object)ModuleType.PIT)) {
            this.emuConfig.getArchitecture().getModules().getPit().setClockrate(BigInteger.valueOf(((Number)this.updateIntField.getValue()).intValue()));
        } else if (this.moduleType.equals((Object)ModuleType.KEYBOARD)) {
            this.emuConfig.getArchitecture().getModules().getKeyboard().setUpdateintervalmicrosecs(BigInteger.valueOf(((Number)this.updateIntField.getValue()).intValue()));
        } else if (this.moduleType.equals((Object)ModuleType.VGA)) {
            this.emuConfig.getArchitecture().getModules().getVideo().setUpdateintervalmicrosecs(BigInteger.valueOf(((Number)this.updateIntField.getValue()).intValue()));
        }
        return this.emuConfig;
    }
}

