/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.ata;

import dioscuri.module.ata.ATA;
import dioscuri.module.ata.ATADrive;
import dioscuri.module.ata.ATADriveController;
import dioscuri.module.ata.ATADriveType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ATAChannel {
    private static final Logger logger = Logger.getLogger(ATAChannel.class.getName());
    public static final int IDE_MASTER_INDEX = 0;
    public static final int IDE_SLAVE_INDEX = 1;
    private ATADrive[] drives = new ATADrive[2];
    private int ioAddress1;
    private int ioAddress2;
    private int irqNumber;
    private int defaultIoAddress1;
    private int defaultIoAddress2;
    private ATA parent;
    private int selectedDriveIndex;

    public ATAChannel(ATA aTA, int n, int n2) {
        this.parent = aTA;
        for (int i = 0; i < this.drives.length; ++i) {
            this.drives[i] = new ATADrive(ATADriveType.NONE, aTA, false);
        }
        this.ioAddress1 = n;
        this.ioAddress2 = n2;
        this.defaultIoAddress1 = n;
        this.defaultIoAddress2 = n2;
        this.irqNumber = -1;
        this.selectedDriveIndex = 0;
    }

    public ATADriveController getSelectedController() {
        ATADriveController aTADriveController = this.getSelectedDrive().getControl();
        return aTADriveController;
    }

    public boolean reset() {
        int n;
        this.ioAddress1 = this.defaultIoAddress1;
        this.ioAddress2 = this.defaultIoAddress2;
        this.irqNumber = this.parent.getPic().requestIRQNumber(this.parent);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, this.parent.getType() + " -> IRQ number set to: " + this.irqNumber);
            this.parent.getPic().clearIRQ(this.irqNumber);
        } else {
            logger.log(Level.WARNING, this.parent.getType() + " -> Request of IRQ number failed.");
        }
        if (this.ioAddress1 != 0) {
            this.parent.getMotherboard().setIOPort(this.ioAddress1, this.parent);
            for (n = 1; n <= 7; ++n) {
                this.parent.getMotherboard().setIOPort(this.ioAddress1 + n, this.parent);
            }
        }
        if (this.ioAddress2 != 0 && this.ioAddress2 != 1008) {
            for (n = 6; n <= 7; ++n) {
                this.parent.getMotherboard().setIOPort(this.ioAddress2 + n, this.parent);
            }
        }
        this.selectedDriveIndex = 0;
        for (n = 0; n < this.drives.length; ++n) {
            this.drives[n].reset();
        }
        return true;
    }

    public boolean isSelectedDrivePresent() {
        return this.drives[this.selectedDriveIndex].getDriveType() != ATADriveType.NONE;
    }

    public void setDisk(ATADrive aTADrive) {
        int n = this.getDriveIndex(aTADrive);
        this.drives[n] = aTADrive;
    }

    private int getDriveIndex(ATADrive aTADrive) {
        int n = aTADrive.isMaster ? 0 : 1;
        return n;
    }

    public ATADrive[] getDrives() {
        return this.drives;
    }

    public int getIoAddress1() {
        return this.ioAddress1;
    }

    public int getIoAddress2() {
        return this.ioAddress2;
    }

    public int getIrqNumber() {
        return this.irqNumber;
    }

    public ATADrive getSelectedDrive() {
        return this.drives[this.selectedDriveIndex];
    }

    public int getSelectedDriveIndex() {
        return this.selectedDriveIndex;
    }

    public void setSelectedDriveIndex(int n) {
        this.selectedDriveIndex = n;
    }

    public boolean isMasterDrivePresent() {
        boolean bl = false;
        if (this.getDrives()[0] != null && this.getDrives()[0].getDriveType() != ATADriveType.NONE) {
            bl = true;
        }
        return bl;
    }

    public boolean isSlaveDrivePresent() {
        boolean bl = false;
        if (this.getDrives()[1] != null && this.getDrives()[1].getDriveType() != ATADriveType.NONE) {
            bl = true;
        }
        return bl;
    }

    public boolean isAnyDrivePresent() {
        boolean bl = false;
        if (this.isMasterDrivePresent() || this.isSlaveDrivePresent()) {
            bl = true;
        }
        return bl;
    }

    public boolean isSlaveSelected() {
        return this.selectedDriveIndex == 1;
    }

    public boolean isMasterSelected() {
        return this.selectedDriveIndex == 0;
    }
}

