/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.ata;

import dioscuri.exception.StorageDeviceException;
import dioscuri.module.ata.ATA;
import dioscuri.module.ata.ATADriveController;
import dioscuri.module.ata.ATADriveType;
import dioscuri.module.ata.ATATranslationType;
import dioscuri.module.ata.AscType;
import dioscuri.module.ata.Atpi;
import dioscuri.module.ata.CDROM;
import dioscuri.module.ata.DiskImage;
import dioscuri.module.ata.SenseInfo;
import dioscuri.module.ata.SenseType;
import java.io.File;
import java.io.IOException;

public class ATADrive {
    protected ATADriveType driveType;
    protected int[] idDrive = new int[256];
    protected char[] modelNo = new char[40];
    protected int currentHead;
    protected int currentCylinder;
    protected int currentSector;
    protected int totalNumHeads;
    protected int totalNumCylinders;
    protected int totalNumSectors;
    protected int sectorCount;
    protected boolean isMaster;
    private DiskImage disk;
    protected boolean containsDisk;
    protected boolean isWriteProtected;
    protected int ioLightCounter;
    protected int statusbarId;
    protected int features;
    private ATADriveController control;
    private SenseInfo senseInfo;
    private CDROM cdRom;
    protected Atpi atpi;
    protected ATATranslationType translationType;
    protected int deviceNum;

    public ATADrive(ATADriveType aTADriveType, ATA aTA, boolean bl) {
        this.control = new ATADriveController(aTA);
        this.senseInfo = new SenseInfo();
        this.atpi = new Atpi();
        this.driveType = aTADriveType;
        this.currentHead = 0;
        this.sectorCount = 1;
        this.currentSector = 1;
        this.currentCylinder = 0;
        this.features = 0;
        this.disk = null;
        this.totalNumHeads = 0;
        this.totalNumCylinders = 0;
        this.totalNumSectors = 0;
        this.isWriteProtected = false;
        this.statusbarId = -1;
        this.ioLightCounter = 0;
        this.modelNo = "Generic 1234                            ".toCharArray();
    }

    public ATADrive(ATADriveType aTADriveType, ATA aTA, boolean bl, int n) {
        this(aTADriveType, aTA, bl);
        if (aTADriveType == ATADriveType.CDROM) {
            this.cdRom = new CDROM();
            this.cdRom.setLocked(false);
            this.senseInfo.setSenseKey(SenseType.NONE);
            this.senseInfo.setAsc(AscType.NOT_SET);
            this.senseInfo.setAscq((byte)0);
            this.deviceNum = ++n + 48;
            this.sectorCount = 0;
        }
    }

    public boolean calculateLogicalAddress(int n) {
        int n2;
        int n3 = this.getControl().getLbaMode() > 0 ? this.getCurrentHead() << 24 | this.getCurrentCylinder() << 8 | this.getCurrentSector() : this.getCurrentCylinder() * this.getTotalNumHeads() * this.getTotalNumSectors() + this.getCurrentHead() * this.getTotalNumSectors() + (this.getCurrentSector() - 1);
        if (n3 >= (n2 = this.getTotalNumCylinders() * this.getTotalNumHeads() * this.getTotalNumSectors())) {
            return false;
        }
        n = n3;
        return true;
    }

    public int calculateLogicalAddress() {
        int n;
        int n2 = this.getControl().getLbaMode() > 0 ? this.getCurrentHead() << 24 | this.getCurrentCylinder() << 8 | this.getCurrentSector() : this.getCurrentCylinder() * this.getTotalNumHeads() * this.getTotalNumSectors() + this.getCurrentHead() * this.getTotalNumSectors() + (this.getCurrentSector() - 1);
        if (n2 >= (n = this.getTotalNumCylinders() * this.getTotalNumHeads() * this.getTotalNumSectors())) {
            return -1;
        }
        return n2;
    }

    public void incrementAddress() {
        this.decrementSectorCount();
        if (this.getControl().getLbaMode() > 0) {
            Integer n = new Integer(0);
            this.calculateLogicalAddress(n);
            int n2 = n;
            int n3 = ++n2 >> 24 & 0xF;
            this.setCurrentHead(n3);
            int n4 = n2 >> 8 & 0xFFFF;
            this.setCurrentCylinder(n4);
            int n5 = n2 & 0xFF;
            this.setCurrentSector(n5);
        } else {
            int n = this.getCurrentSector();
            this.setCurrentSector(++n);
            if (this.getCurrentSector() > this.getTotalNumSectors()) {
                this.setCurrentSector(1);
                int n6 = this.getCurrentHead();
                this.setCurrentHead(++n6);
                if (this.getCurrentHead() >= this.getTotalNumHeads()) {
                    this.setCurrentHead(0);
                    int n7 = this.getCurrentCylinder();
                    this.setCurrentCylinder(++n7);
                    if (this.getCurrentCylinder() >= this.getTotalNumCylinders()) {
                        n7 = this.getTotalNumCylinders();
                        this.setCurrentCylinder(--n7);
                    }
                }
            }
        }
    }

    protected boolean reset() {
        this.control.reset();
        this.currentHead = 0;
        this.currentCylinder = 0;
        this.currentSector = 0;
        return true;
    }

    public ATADriveController getControl() {
        return this.control;
    }

    public SenseInfo getSenseInfo() {
        return this.senseInfo;
    }

    protected boolean containsDisk() {
        return this.disk != null;
    }

    protected ATADriveType getDriveType() {
        return this.driveType;
    }

    protected void setDriveType(ATADriveType aTADriveType) {
        this.driveType = aTADriveType;
    }

    protected long getDiskCapacity() {
        int n = this.totalNumCylinders * this.totalNumHeads * this.totalNumSectors * this.control.getNumSectorsPerBlock();
        return n;
    }

    public void setDiskCapacity(int n, int n2, int n3, int n4) {
        this.totalNumCylinders = n;
        this.totalNumHeads = n2;
        this.totalNumSectors = n3;
        this.control.setNumSectorsPerBlock(n4);
    }

    protected long getDiskImageSize() {
        if (this.containsDisk()) {
            return this.disk.getSize();
        }
        return -1L;
    }

    public void setIsMaster(boolean bl) {
        this.isMaster = bl;
    }

    public void setWriteProtected(boolean bl) {
        this.isWriteProtected = bl;
    }

    public byte[] readData(byte[] byArray, int n, int n2) throws IOException {
        if (!this.containsDisk()) {
            throw new IOException("Error: drive does not contain a disk");
        }
        byte[] byArray2 = this.disk.readFromImage(byArray, n, n2);
        return byArray2;
    }

    public void writeData(byte[] byArray, int n, int n2) throws IOException {
        if (!this.containsDisk() || this.isWriteProtected) {
            throw new IOException("Error: drive does not contain a disk or is write protected");
        }
        this.disk.writeToImage(byArray, n, n2);
    }

    public void loadImage(File file) throws StorageDeviceException {
        try {
            this.disk = new DiskImage(file);
        }
        catch (IOException iOException) {
            throw new StorageDeviceException("Disk could not be loaded.");
        }
    }

    public String toString() {
        return "Drive status info:  drivetype=" + this.driveType.toString() + ", diskPresent=" + this.containsDisk() + ", writeProtected=" + this.isWriteProtected + ", currentHead=" + this.currentHead + ", currentCylinder=" + this.currentCylinder + ", currentSector=" + this.currentSector + ", numberHeads=" + this.totalNumHeads + ", numberCylinders=" + this.totalNumCylinders + ", numberSectors=" + this.totalNumSectors;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean bl) {
        this.isMaster = bl;
    }

    public int getCurrentHead() {
        return this.currentHead;
    }

    public void setCurrentHead(int n) {
        this.currentHead = n;
    }

    public int getCurrentCylinder() {
        return this.currentCylinder;
    }

    public void setCurrentCylinder(int n) {
        this.currentCylinder = n;
    }

    public int getCurrentSector() {
        return this.currentSector;
    }

    public void setCurrentSector(int n) {
        this.currentSector = n;
    }

    public int getTotalNumSectors() {
        return this.totalNumSectors;
    }

    public Atpi getAtpi() {
        return this.atpi;
    }

    public void setAtpi(Atpi atpi) {
        this.atpi = atpi;
    }

    public int getIoLightCounter() {
        return this.ioLightCounter;
    }

    public void setIoLightCounter(int n) {
        this.ioLightCounter = n;
    }

    public int getTotalNumHeads() {
        return this.totalNumHeads;
    }

    public void setTotalNumHeads(int n) {
        this.totalNumHeads = n;
    }

    public int getTotalNumCylinders() {
        return this.totalNumCylinders;
    }

    public void setTotalNumCylinders(int n) {
        this.totalNumCylinders = n;
    }

    public void incrementSectorCount() {
        ++this.sectorCount;
    }

    public void decrementSectorCount() {
        --this.sectorCount;
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public void setSectorCount(int n) {
        this.sectorCount = n;
    }

    public int getFeatures() {
        return this.features;
    }

    public void setFeatures(int n) {
        this.features = n;
    }

    public int[] getIdDrive() {
        return this.idDrive;
    }

    public void setIdDrive(int n, int n2) {
        this.idDrive[n] = n2;
    }

    public char[] getModelNo() {
        return this.modelNo;
    }

    public CDROM getCdRom() {
        return this.cdRom;
    }

    public void setCdRom(CDROM cDROM) {
        this.cdRom = cDROM;
    }

    public ATATranslationType getTranslationType() {
        return this.translationType;
    }

    public void setTranslationType(ATATranslationType aTATranslationType) {
        this.translationType = aTATranslationType;
    }
}

