/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.clock;

import dioscuri.Emulator;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleClock;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.clock.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Clock
extends ModuleClock {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard", "cpu"};
    private ModuleMotherboard motherboard;
    private ModuleCPU cpu;
    private Timer[] timers;
    private boolean isObserved;
    private boolean debugMode;
    private boolean keepRunning;
    private long sleepTime;
    private int arrayIndex;
    private static final Logger logger = Logger.getLogger(Clock.class.getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "clock";
    public static final String MODULE_NAME = "Crystal clock";
    public static final int TIMER_ARRAY_SIZE = 10;

    public Clock(Emulator emulator) {
        this.emu = emulator;
        this.timers = new Timer[10];
        this.arrayIndex = 0;
        this.keepRunning = true;
        this.sleepTime = 1000L;
        logger.log(Level.INFO, "[clock]Crystal clock -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("cpu")) {
            this.cpu = (ModuleCPU)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null && this.cpu != null;
    }

    @Override
    public boolean reset() {
        if (!this.motherboard.registerClock(this)) {
            return false;
        }
        logger.log(Level.INFO, "[clock] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.setKeepRunning(false);
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "";
        string = "Clock dump:\n";
        for (int i = 0; i < this.timers.length; ++i) {
            if (this.timers[i] == null) continue;
            string = string + "Timer " + i + ": " + this.timers[i].user.getType() + ", updateInterval=" + this.timers[i].intervalLength + " instr., countdown=" + this.timers[i].currentCount + " instr.\n";
        }
        return string;
    }

    @Override
    public boolean registerDevice(ModuleDevice moduleDevice, int n, boolean bl) {
        if (this.arrayIndex < 10) {
            this.timers[this.arrayIndex] = new Timer(moduleDevice, n * (this.cpu.getIPS() / 1000000), bl);
            logger.log(Level.INFO, "[clock] Device '" + moduleDevice.getType() + "' registered a timer with interval " + this.timers[this.arrayIndex].intervalLength + " instructions");
            ++this.arrayIndex;
            return true;
        }
        return false;
    }

    @Override
    public boolean resetTimer(ModuleDevice moduleDevice, int n) {
        int n2 = 0;
        while (this.timers[n2] != null) {
            if (this.timers[n2].user.getType().equalsIgnoreCase(moduleDevice.getType())) {
                this.timers[n2].reset(n * (this.cpu.getIPS() / 1000000));
                logger.log(Level.INFO, "[clock] Device '" + moduleDevice.getType() + "' timer reset to " + this.timers[n2].intervalLength + " instructions");
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean setTimerActiveState(ModuleDevice moduleDevice, boolean bl) {
        int n = 0;
        while (this.timers[n] != null) {
            if (this.timers[n].user.getType().equalsIgnoreCase(moduleDevice.getType())) {
                this.timers[n].active = bl;
                logger.log(Level.INFO, "[clock] Device '" + moduleDevice.getType() + "' timer active state set to " + bl);
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void pulse() {
        int n = 0;
        while (this.timers[n] != null) {
            if (this.timers[n].active) {
                --this.timers[n].currentCount;
                if (this.timers[n].currentCount == 0) {
                    this.timers[n].reset();
                    this.timers[n].user.update();
                }
            }
            ++n;
        }
    }

    public void run() {
        while (this.keepRunning) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.keepRunning = false;
            }
        }
    }

    private void calibrate() {
        boolean bl = false;
        while (!bl) {
        }
    }

    protected void setKeepRunning(boolean bl) {
        this.keepRunning = bl;
    }

    public long getClockRate() {
        return this.sleepTime;
    }

    public void setClockRate(long l) {
        this.sleepTime = l;
    }

    public void setActiveState(ModuleDevice moduleDevice, boolean bl) {
        int n = 0;
        while (this.timers[n] != null) {
            if (this.timers[n].user.getType().equalsIgnoreCase(moduleDevice.getType())) {
                this.timers[n].active = bl;
            }
            ++n;
        }
    }
}

