/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.Emulator;
import dioscuri.exception.CPUInstructionException;
import dioscuri.exception.CPU_DE_Exception;
import dioscuri.exception.ModuleException;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleClock;
import dioscuri.module.ModuleDMA;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Instruction_2ByteEscape;
import dioscuri.module.cpu.Instruction_AAA;
import dioscuri.module.cpu.Instruction_AAD_Ib;
import dioscuri.module.cpu.Instruction_AAM_Ib;
import dioscuri.module.cpu.Instruction_ADC_ALIb;
import dioscuri.module.cpu.Instruction_ADC_AXIv;
import dioscuri.module.cpu.Instruction_ADC_EbGb;
import dioscuri.module.cpu.Instruction_ADC_EvGv;
import dioscuri.module.cpu.Instruction_ADC_GbEb;
import dioscuri.module.cpu.Instruction_ADC_GvEv;
import dioscuri.module.cpu.Instruction_ADD_ALIb;
import dioscuri.module.cpu.Instruction_ADD_AXIv;
import dioscuri.module.cpu.Instruction_ADD_EbGb;
import dioscuri.module.cpu.Instruction_ADD_EvGv;
import dioscuri.module.cpu.Instruction_ADD_GbEb;
import dioscuri.module.cpu.Instruction_ADD_GvEv;
import dioscuri.module.cpu.Instruction_AND_ALIb;
import dioscuri.module.cpu.Instruction_AND_AXIv;
import dioscuri.module.cpu.Instruction_AND_EbGb;
import dioscuri.module.cpu.Instruction_AND_EvGv;
import dioscuri.module.cpu.Instruction_AND_GbEb;
import dioscuri.module.cpu.Instruction_AND_GvEv;
import dioscuri.module.cpu.Instruction_ARPL_EwGw;
import dioscuri.module.cpu.Instruction_BOUND_GvMa;
import dioscuri.module.cpu.Instruction_CALLF_Ap;
import dioscuri.module.cpu.Instruction_CALL_Jv;
import dioscuri.module.cpu.Instruction_CBW;
import dioscuri.module.cpu.Instruction_CLC;
import dioscuri.module.cpu.Instruction_CLD;
import dioscuri.module.cpu.Instruction_CLI;
import dioscuri.module.cpu.Instruction_CMC;
import dioscuri.module.cpu.Instruction_CMPS_XbYb;
import dioscuri.module.cpu.Instruction_CMPS_XvYv;
import dioscuri.module.cpu.Instruction_CMP_ALIb;
import dioscuri.module.cpu.Instruction_CMP_AXIv;
import dioscuri.module.cpu.Instruction_CMP_EbGb;
import dioscuri.module.cpu.Instruction_CMP_EvGv;
import dioscuri.module.cpu.Instruction_CMP_GbEb;
import dioscuri.module.cpu.Instruction_CMP_GvEv;
import dioscuri.module.cpu.Instruction_CWD;
import dioscuri.module.cpu.Instruction_DAA;
import dioscuri.module.cpu.Instruction_DEC_AX;
import dioscuri.module.cpu.Instruction_DEC_BP;
import dioscuri.module.cpu.Instruction_DEC_BX;
import dioscuri.module.cpu.Instruction_DEC_CX;
import dioscuri.module.cpu.Instruction_DEC_DI;
import dioscuri.module.cpu.Instruction_DEC_DX;
import dioscuri.module.cpu.Instruction_DEC_SI;
import dioscuri.module.cpu.Instruction_DEC_SP;
import dioscuri.module.cpu.Instruction_ENTER_IwIb;
import dioscuri.module.cpu.Instruction_ESC_FPU;
import dioscuri.module.cpu.Instruction_GRP11_MOV_EbIb;
import dioscuri.module.cpu.Instruction_GRP11_MOV_EvIv;
import dioscuri.module.cpu.Instruction_GRP6;
import dioscuri.module.cpu.Instruction_GRP7;
import dioscuri.module.cpu.Instruction_HLT;
import dioscuri.module.cpu.Instruction_IMUL_GvEvIv;
import dioscuri.module.cpu.Instruction_INCDEC_GRP4;
import dioscuri.module.cpu.Instruction_INCDEC_GRP5;
import dioscuri.module.cpu.Instruction_INC_AX;
import dioscuri.module.cpu.Instruction_INC_BP;
import dioscuri.module.cpu.Instruction_INC_BX;
import dioscuri.module.cpu.Instruction_INC_CX;
import dioscuri.module.cpu.Instruction_INC_DI;
import dioscuri.module.cpu.Instruction_INC_DX;
import dioscuri.module.cpu.Instruction_INC_SI;
import dioscuri.module.cpu.Instruction_INC_SP;
import dioscuri.module.cpu.Instruction_INSB_YbDX;
import dioscuri.module.cpu.Instruction_INSW_YvDX;
import dioscuri.module.cpu.Instruction_INT3;
import dioscuri.module.cpu.Instruction_INT_Ib;
import dioscuri.module.cpu.Instruction_IN_ALDX;
import dioscuri.module.cpu.Instruction_IN_ALIb;
import dioscuri.module.cpu.Instruction_IN_eAXDX;
import dioscuri.module.cpu.Instruction_IRET;
import dioscuri.module.cpu.Instruction_ImmGRP1_EbIb;
import dioscuri.module.cpu.Instruction_ImmGRP1_EvIb;
import dioscuri.module.cpu.Instruction_ImmGRP1_EvIv;
import dioscuri.module.cpu.Instruction_JBE_JNA;
import dioscuri.module.cpu.Instruction_JBE_JNA_long;
import dioscuri.module.cpu.Instruction_JB_JNAE_JC;
import dioscuri.module.cpu.Instruction_JB_JNAE_JC_long;
import dioscuri.module.cpu.Instruction_JCXZ_JECXZ;
import dioscuri.module.cpu.Instruction_JLE_JNG;
import dioscuri.module.cpu.Instruction_JL_JNGE;
import dioscuri.module.cpu.Instruction_JMP_farAP;
import dioscuri.module.cpu.Instruction_JMP_nearJv;
import dioscuri.module.cpu.Instruction_JMP_shortJb;
import dioscuri.module.cpu.Instruction_JNBE_JA;
import dioscuri.module.cpu.Instruction_JNB_JAE_JNC;
import dioscuri.module.cpu.Instruction_JNB_JAE_JNC_long;
import dioscuri.module.cpu.Instruction_JNLE_JG;
import dioscuri.module.cpu.Instruction_JNL_JGE;
import dioscuri.module.cpu.Instruction_JNO;
import dioscuri.module.cpu.Instruction_JNP_JPO;
import dioscuri.module.cpu.Instruction_JNS;
import dioscuri.module.cpu.Instruction_JNZ_JNE;
import dioscuri.module.cpu.Instruction_JNZ_JNE_long;
import dioscuri.module.cpu.Instruction_JO;
import dioscuri.module.cpu.Instruction_JP_JPE;
import dioscuri.module.cpu.Instruction_JS;
import dioscuri.module.cpu.Instruction_JZ_JE;
import dioscuri.module.cpu.Instruction_JZ_JE_long;
import dioscuri.module.cpu.Instruction_LAHF;
import dioscuri.module.cpu.Instruction_LAR;
import dioscuri.module.cpu.Instruction_LDS_GvMp;
import dioscuri.module.cpu.Instruction_LEAVE;
import dioscuri.module.cpu.Instruction_LEA_GvM;
import dioscuri.module.cpu.Instruction_LES_GvMp;
import dioscuri.module.cpu.Instruction_LODS_ALXb;
import dioscuri.module.cpu.Instruction_LODS_AXXv;
import dioscuri.module.cpu.Instruction_LOOPE_LOOPZ_Jb;
import dioscuri.module.cpu.Instruction_LOOPNE_LOOPNZ_Jb;
import dioscuri.module.cpu.Instruction_LOOP_Jb;
import dioscuri.module.cpu.Instruction_MOVS_XbYb;
import dioscuri.module.cpu.Instruction_MOVS_XvYv;
import dioscuri.module.cpu.Instruction_MOVZX_GvEw;
import dioscuri.module.cpu.Instruction_MOV_ALOb;
import dioscuri.module.cpu.Instruction_MOV_AXOv;
import dioscuri.module.cpu.Instruction_MOV_EbGb;
import dioscuri.module.cpu.Instruction_MOV_EvGv;
import dioscuri.module.cpu.Instruction_MOV_EwSw;
import dioscuri.module.cpu.Instruction_MOV_GbEb;
import dioscuri.module.cpu.Instruction_MOV_GvEv;
import dioscuri.module.cpu.Instruction_MOV_Imm_AH;
import dioscuri.module.cpu.Instruction_MOV_Imm_AL;
import dioscuri.module.cpu.Instruction_MOV_Imm_AX;
import dioscuri.module.cpu.Instruction_MOV_Imm_BH;
import dioscuri.module.cpu.Instruction_MOV_Imm_BL;
import dioscuri.module.cpu.Instruction_MOV_Imm_BP;
import dioscuri.module.cpu.Instruction_MOV_Imm_BX;
import dioscuri.module.cpu.Instruction_MOV_Imm_CH;
import dioscuri.module.cpu.Instruction_MOV_Imm_CL;
import dioscuri.module.cpu.Instruction_MOV_Imm_CX;
import dioscuri.module.cpu.Instruction_MOV_Imm_DH;
import dioscuri.module.cpu.Instruction_MOV_Imm_DI;
import dioscuri.module.cpu.Instruction_MOV_Imm_DL;
import dioscuri.module.cpu.Instruction_MOV_Imm_DX;
import dioscuri.module.cpu.Instruction_MOV_Imm_SI;
import dioscuri.module.cpu.Instruction_MOV_Imm_SP;
import dioscuri.module.cpu.Instruction_MOV_ObAL;
import dioscuri.module.cpu.Instruction_MOV_OvAX;
import dioscuri.module.cpu.Instruction_MOV_SwEw;
import dioscuri.module.cpu.Instruction_NOP;
import dioscuri.module.cpu.Instruction_NULL;
import dioscuri.module.cpu.Instruction_OR_ALIb;
import dioscuri.module.cpu.Instruction_OR_AXIv;
import dioscuri.module.cpu.Instruction_OR_EbGb;
import dioscuri.module.cpu.Instruction_OR_EvGv;
import dioscuri.module.cpu.Instruction_OR_GbEb;
import dioscuri.module.cpu.Instruction_OR_GvEv;
import dioscuri.module.cpu.Instruction_OUTSW_DXXv;
import dioscuri.module.cpu.Instruction_OUTS_DXXb;
import dioscuri.module.cpu.Instruction_OUT_DXAL;
import dioscuri.module.cpu.Instruction_OUT_DXeAX;
import dioscuri.module.cpu.Instruction_OUT_IbAL;
import dioscuri.module.cpu.Instruction_Opd_Size;
import dioscuri.module.cpu.Instruction_POPA;
import dioscuri.module.cpu.Instruction_POPF;
import dioscuri.module.cpu.Instruction_POP_AX;
import dioscuri.module.cpu.Instruction_POP_BP;
import dioscuri.module.cpu.Instruction_POP_BX;
import dioscuri.module.cpu.Instruction_POP_CX;
import dioscuri.module.cpu.Instruction_POP_DI;
import dioscuri.module.cpu.Instruction_POP_DS;
import dioscuri.module.cpu.Instruction_POP_DX;
import dioscuri.module.cpu.Instruction_POP_ES;
import dioscuri.module.cpu.Instruction_POP_Ev;
import dioscuri.module.cpu.Instruction_POP_SI;
import dioscuri.module.cpu.Instruction_POP_SP;
import dioscuri.module.cpu.Instruction_POP_SS;
import dioscuri.module.cpu.Instruction_PUSHA;
import dioscuri.module.cpu.Instruction_PUSHF;
import dioscuri.module.cpu.Instruction_PUSH_AX;
import dioscuri.module.cpu.Instruction_PUSH_BP;
import dioscuri.module.cpu.Instruction_PUSH_BX;
import dioscuri.module.cpu.Instruction_PUSH_CS;
import dioscuri.module.cpu.Instruction_PUSH_CX;
import dioscuri.module.cpu.Instruction_PUSH_DI;
import dioscuri.module.cpu.Instruction_PUSH_DS;
import dioscuri.module.cpu.Instruction_PUSH_DX;
import dioscuri.module.cpu.Instruction_PUSH_ES;
import dioscuri.module.cpu.Instruction_PUSH_Ib;
import dioscuri.module.cpu.Instruction_PUSH_Iv;
import dioscuri.module.cpu.Instruction_PUSH_SI;
import dioscuri.module.cpu.Instruction_PUSH_SP;
import dioscuri.module.cpu.Instruction_PUSH_SS;
import dioscuri.module.cpu.Instruction_REPNE;
import dioscuri.module.cpu.Instruction_REP_REPE;
import dioscuri.module.cpu.Instruction_RETF;
import dioscuri.module.cpu.Instruction_RETF_Iw;
import dioscuri.module.cpu.Instruction_RETN;
import dioscuri.module.cpu.Instruction_RETN_Iw;
import dioscuri.module.cpu.Instruction_SAHF;
import dioscuri.module.cpu.Instruction_SALC;
import dioscuri.module.cpu.Instruction_SBB_ALIb;
import dioscuri.module.cpu.Instruction_SBB_AXIv;
import dioscuri.module.cpu.Instruction_SBB_EbGb;
import dioscuri.module.cpu.Instruction_SBB_EvGv;
import dioscuri.module.cpu.Instruction_SBB_GbEb;
import dioscuri.module.cpu.Instruction_SBB_GvEv;
import dioscuri.module.cpu.Instruction_SCAS_ALYb;
import dioscuri.module.cpu.Instruction_SCAS_AXYv;
import dioscuri.module.cpu.Instruction_SEG_CS;
import dioscuri.module.cpu.Instruction_SEG_DS;
import dioscuri.module.cpu.Instruction_SEG_ES;
import dioscuri.module.cpu.Instruction_SEG_FS;
import dioscuri.module.cpu.Instruction_SEG_GS;
import dioscuri.module.cpu.Instruction_SEG_SS;
import dioscuri.module.cpu.Instruction_STC;
import dioscuri.module.cpu.Instruction_STD;
import dioscuri.module.cpu.Instruction_STI;
import dioscuri.module.cpu.Instruction_STOSB_YbAL;
import dioscuri.module.cpu.Instruction_STOSW_YvAX;
import dioscuri.module.cpu.Instruction_SUB_ALIb;
import dioscuri.module.cpu.Instruction_SUB_AXIv;
import dioscuri.module.cpu.Instruction_SUB_EbGb;
import dioscuri.module.cpu.Instruction_SUB_EvGv;
import dioscuri.module.cpu.Instruction_SUB_GbEb;
import dioscuri.module.cpu.Instruction_SUB_GvEv;
import dioscuri.module.cpu.Instruction_ShiftGRP2_Eb1;
import dioscuri.module.cpu.Instruction_ShiftGRP2_EbCL;
import dioscuri.module.cpu.Instruction_ShiftGRP2_EbIb;
import dioscuri.module.cpu.Instruction_ShiftGRP2_Ev1;
import dioscuri.module.cpu.Instruction_ShiftGRP2_EvCL;
import dioscuri.module.cpu.Instruction_ShiftGRP2_EvIb;
import dioscuri.module.cpu.Instruction_TEST_ALIb;
import dioscuri.module.cpu.Instruction_TEST_AXIv;
import dioscuri.module.cpu.Instruction_TEST_EbGb;
import dioscuri.module.cpu.Instruction_TEST_EvGv;
import dioscuri.module.cpu.Instruction_UnaryGrp3_Eb;
import dioscuri.module.cpu.Instruction_UnaryGrp3_Ev;
import dioscuri.module.cpu.Instruction_XCHG_BPAX;
import dioscuri.module.cpu.Instruction_XCHG_BXAX;
import dioscuri.module.cpu.Instruction_XCHG_CXAX;
import dioscuri.module.cpu.Instruction_XCHG_DIAX;
import dioscuri.module.cpu.Instruction_XCHG_DXAX;
import dioscuri.module.cpu.Instruction_XCHG_EbGb;
import dioscuri.module.cpu.Instruction_XCHG_EvGv;
import dioscuri.module.cpu.Instruction_XCHG_SIAX;
import dioscuri.module.cpu.Instruction_XCHG_SPAX;
import dioscuri.module.cpu.Instruction_XLAT;
import dioscuri.module.cpu.Instruction_XOR_ALIb;
import dioscuri.module.cpu.Instruction_XOR_AXIv;
import dioscuri.module.cpu.Instruction_XOR_EbGb;
import dioscuri.module.cpu.Instruction_XOR_EvGv;
import dioscuri.module.cpu.Instruction_XOR_GbEb;
import dioscuri.module.cpu.Instruction_XOR_GvEv;
import dioscuri.module.cpu.Util;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CPU
extends ModuleCPU {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"memory", "motherboard", "pic", "clock"};
    private ModuleMemory memory;
    private ModuleMotherboard motherboard;
    private ModulePIC pic;
    private ModuleClock clock;
    private boolean isRunning;
    private boolean isObserved;
    private boolean debugMode;
    private boolean irqPending;
    private boolean irqWaited;
    private boolean holdReQuest;
    protected boolean asyncEvent;
    private ModuleDevice hRQorigin;
    private boolean breakpointSet;
    private boolean waitMessageShown;
    private boolean cpuInstructionDebug;
    private boolean abnormalTermination;
    private boolean shutDown;
    private static final Logger logger = Logger.getLogger(CPU.class.getPackage().getName());
    private long instructionCounter;
    private byte prefixCounter;
    public int ips;
    public int ipus;
    private int lowestUpdatePeriod;
    protected int codeByte;
    protected int codeByte2;
    private int tempByte;
    private byte[] tempWord;
    private static int segmentedCodeAddress;
    protected byte[] ax;
    protected byte[] eax;
    protected byte[] bx;
    protected byte[] ebx;
    protected byte[] cx;
    protected byte[] ecx;
    protected byte[] dx;
    protected byte[] edx;
    protected byte[] sp;
    protected byte[] esp;
    protected byte[] bp;
    protected byte[] ebp;
    protected byte[] si;
    protected byte[] esi;
    protected byte[] di;
    protected byte[] edi;
    protected byte[] cs;
    protected byte[] ds;
    protected byte[] ss;
    protected byte[] es;
    protected byte[] ip;
    protected byte[] oldIP;
    protected boolean[] flags;
    protected boolean[] cr0;
    protected boolean[] cr1;
    protected boolean[] cr2;
    protected boolean[] cr3;
    protected boolean[] cr4;
    protected byte[] gdtr;
    protected byte[] idtr;
    protected byte[] ldtr;
    protected int prefixInstruction;
    protected boolean prefixRep;
    protected int prefixRepType;
    protected boolean doubleWord;
    protected boolean segmentOverride;
    protected int segmentOverridePointer;
    protected Instruction[] singleByteInstructions;
    protected Instruction[] doubleByteInstructions;
    byte stackSize;
    private static final int MODULE_ID = 1;
    private static final String MODULE_TYPE = "cpu";
    private static final String MODULE_NAME = "8086 compatible CPU";
    private static final int REALADDRESS_MODE = 1;
    private static final int PROTECTED_MODE = 2;
    private static final int BYTE = 8;
    public static final int REGISTER_SIZE_GENERAL = 16;
    public static final int REGISTER_SIZE_INDEX = 16;
    public static final int REGISTER_SIZE_SEGMENT = 16;
    public static final int REGISTER_SIZE_SPECIAL = 16;
    public static final int REGISTER_LOW = 1;
    public static final int REGISTER_HIGH = 0;
    public static final int REGISTER_GENERAL_LOW = 1;
    public static final int REGISTER_GENERAL_HIGH = 0;
    public static final int REGISTER_INDEX_LOW = 1;
    public static final int REGISTER_INDEX_HIGH = 0;
    public static final int REGISTER_SEGMENT_LOW = 1;
    public static final int REGISTER_SEGMENT_HIGH = 0;
    public static final int REGISTER_FLAGS_CF = 0;
    public static final int REGISTER_FLAGS_PF = 2;
    public static final int REGISTER_FLAGS_AF = 4;
    public static final int REGISTER_FLAGS_ZF = 6;
    public static final int REGISTER_FLAGS_SF = 7;
    public static final int REGISTER_FLAGS_TF = 8;
    public static final int REGISTER_FLAGS_IF = 9;
    public static final int REGISTER_FLAGS_DF = 10;
    public static final int REGISTER_FLAGS_OF = 11;
    public static final int REGISTER_FLAGS_IOPL1 = 12;
    public static final int REGISTER_FLAGS_IOPL2 = 13;
    public static final int REGISTER_FLAGS_NT = 14;
    public static final int REGISTER_CR0_PE = 0;
    public static final int REGISTER_CR0_MP = 1;
    public static final int REGISTER_CR0_EM = 2;
    public static final int REGISTER_CR0_TS = 3;
    public static final int REGISTER_CR0_ET = 4;
    public static final int REGISTER_CR0_NE = 5;
    public static final int REGISTER_CR0_WP = 16;
    public static final int REGISTER_CR0_AM = 18;
    public static final int REGISTER_CR0_NW = 29;
    public static final int REGISTER_CR0_CD = 30;
    public static final int REGISTER_CR0_PG = 31;
    public static final int SEGMENT_OVERRIDE_CS = 0;
    public static final int SEGMENT_OVERRIDE_DS = 1;
    public static final int SEGMENT_OVERRIDE_ES = 2;
    public static final int SEGMENT_OVERRIDE_SS = 3;
    public static final byte[] WORD_0X0001;

    public CPU(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        this.irqPending = false;
        this.irqWaited = false;
        this.abnormalTermination = false;
        this.shutDown = false;
        this.ips = 1000000;
        this.ipus = this.ips / 1000000;
        this.lowestUpdatePeriod = 1;
        this.breakpointSet = false;
        this.waitMessageShown = false;
        logger.log(Level.INFO, "[cpu] 8086 compatible CPU Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equals("memory")) {
            this.memory = (ModuleMemory)module;
            return true;
        }
        if (module.getType().equals("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equals("pic")) {
            this.pic = (ModulePIC)module;
            return true;
        }
        if (module.getType().equals("clock")) {
            this.clock = (ModuleClock)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.memory != null && this.motherboard != null && this.pic != null && this.clock != null;
    }

    @Override
    public boolean reset() {
        this.isRunning = true;
        this.irqPending = false;
        this.irqWaited = false;
        this.abnormalTermination = false;
        this.shutDown = false;
        this.initRegisters();
        this.initInstructionTables();
        this.instructionCounter = 0L;
        this.prefixCounter = 0;
        this.prefixRep = false;
        this.prefixRepType = 0;
        this.tempByte = 0;
        this.tempWord = new byte[2];
        this.stackSize = 0;
        logger.log(Level.INFO, "[cpu] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
        block20: {
            long l = System.currentTimeMillis();
            try {
                if (this.debugMode) {
                    if (this.breakpointSet && (this.convertWordToInt(this.cs) << 4) + this.convertWordToInt(this.ip) == 9336542) {
                        if (!this.waitMessageShown) {
                            logger.log(Level.SEVERE, "[cpu] Breakpoint set at " + Integer.toHexString(this.convertWordToInt(this.cs)).toUpperCase() + ":" + Integer.toHexString(this.convertWordToInt(this.ip)).toUpperCase() + ", wait for prompt...");
                            this.waitMessageShown = true;
                        }
                        return;
                    }
                    this.codeByte = this.getByteFromCode() & 0xFF;
                    try {
                        while (this.isPrefix()) {
                            this.singleByteInstructions[this.codeByte].execute();
                            this.prefixCounter = (byte)(this.prefixCounter + 1);
                            this.codeByte = this.getByteFromCode() & 0xFF;
                        }
                        if (this.doubleWord && !this.isSingleByte32BitSupported()) {
                            logger.log(Level.SEVERE, "[cpu] Instruction problem (opcode " + Integer.toHexString(this.codeByte) + "h): 32-bit not supported!");
                        }
                        this.executeInstruction();
                        ++this.instructionCounter;
                        this.resetPrefixes();
                        if (this.asyncEvent && this.handleAsyncEvent()) {
                            return;
                        }
                    }
                    catch (CPU_DE_Exception cPU_DE_Exception) {
                        logger.log(Level.SEVERE, "[cpu] Instruction problem (opcode " + Integer.toHexString(this.codeByte) + "h): " + cPU_DE_Exception.getMessage());
                    }
                    this.clock.pulse();
                    if (this.cpuInstructionDebug) {
                        DecimalFormat decimalFormat = new DecimalFormat("00000000000");
                        String string = decimalFormat.format(this.instructionCounter);
                        if (this.codeByte == 15) {
                            logger.log(Level.CONFIG, string + "i[" + MODULE_TYPE + "  ] $DEBUG$ 1" + this.dumpDebug(Integer.toHexString(this.codeByte2).toUpperCase() + " "));
                        } else {
                            logger.log(Level.CONFIG, string + "i[" + MODULE_TYPE + "  ] $DEBUG$ " + this.dumpDebug(Integer.toHexString(this.codeByte).toUpperCase() + " "));
                        }
                    }
                    break block20;
                }
                while (this.isRunning) {
                    this.codeByte = this.getByteFromCode() & 0xFF;
                    try {
                        while (this.isPrefix()) {
                            this.singleByteInstructions[this.codeByte].execute();
                            this.prefixCounter = (byte)(this.prefixCounter + 1);
                            this.codeByte = this.getByteFromCode() & 0xFF;
                        }
                        this.executeInstruction();
                        ++this.instructionCounter;
                        this.resetPrefixes();
                        if (this.asyncEvent && this.handleAsyncEvent()) {
                            return;
                        }
                    }
                    catch (CPU_DE_Exception cPU_DE_Exception) {
                        logger.log(Level.SEVERE, "[cpu] Instruction problem (opcode " + Integer.toHexString(this.codeByte) + "h): " + cPU_DE_Exception.getMessage());
                    }
                    this.clock.pulse();
                }
                logger.log(Level.SEVERE, "[cpu] Execution stopped");
                float f = System.currentTimeMillis() - l;
                logger.log(Level.SEVERE, "[cpu] Total execution time: " + f / 1000.0f + " s");
                logger.log(Level.SEVERE, "[cpu] Number of instructions executed: " + this.instructionCounter);
                logger.log(Level.SEVERE, "[cpu] Performance: " + (float)this.instructionCounter / (f / 1000.0f) + " instr/sec ( " + (float)this.instructionCounter / (f / 1000.0f) / 1000000.0f + " MHz)");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.isRunning = false;
                this.abnormalTermination = true;
                logger.log(Level.SEVERE, "[cpu] Instruction failure at instruction " + this.instructionCounter + " (opcode " + Integer.toHexString(this.codeByte) + "h): (Array out of bounds)");
            }
            catch (CPUInstructionException cPUInstructionException) {
                this.isRunning = false;
                this.abnormalTermination = true;
                if (this.codeByte == 15) {
                    logger.log(Level.SEVERE, "[cpu] Instruction failure at instruction " + this.instructionCounter + " (opcode " + Integer.toHexString(this.codeByte) + " " + Integer.toHexString(this.codeByte2) + "h): " + cPUInstructionException.getMessage());
                }
                logger.log(Level.SEVERE, "[cpu] Instruction failure at instruction " + this.instructionCounter + " (opcode " + Integer.toHexString(this.codeByte) + "h): " + cPUInstructionException.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        this.setRunning(false);
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        if (module == null) {
            if (stringArray.length == 3) {
                String string = stringArray[0];
                byte[] byArray = new byte[]{Util.convertStringToByte(stringArray[1]), Util.convertStringToByte(stringArray[2])};
                if (!this.setRegisterValue(string, byArray)) {
                    logger.log(Level.WARNING, "[cpu] Data not set. Unable to change register value.");
                    return false;
                }
            } else {
                logger.log(Level.WARNING, "[cpu] Data not set. Wrong number of arguments supplied.");
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = string + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + string2;
        string = string + Integer.toHexString(0x100 | this.cs[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.cs[1] & 0xFF).substring(1).toUpperCase() + ":" + Integer.toHexString(0x100 | this.ip[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ip[1] & 0xFF).substring(1).toUpperCase() + "   ";
        try {
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF)) & 0xFF).substring(1).toUpperCase() + " ";
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF) + 1) & 0xFF).substring(1).toUpperCase() + " ";
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF) + 2) & 0xFF).substring(1).toUpperCase() + string3;
            String string4 = this.singleByteInstructions[this.memory.getByte(((this.cs[0] & 0xFF) << 12) + ((this.cs[1] & 0xFF) << 4) + ((this.ip[0] & 0xFF) << 8) + (this.ip[1] & 0xFF)) & 0xFF].toString();
            string4 = string4.substring(string4.indexOf("_") + 1, string4.indexOf("@"));
            string = string + string4 + string2;
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, "cpu -> Module exception: " + moduleException.getMessage());
            string = string + "Failed to retrieve memory information";
        }
        string = string + "ax:0x" + Integer.toHexString(0x100 | this.ax[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ax[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "bx:0x" + Integer.toHexString(0x100 | this.bx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.bx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "cx:0x" + Integer.toHexString(0x100 | this.cx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.cx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "dx:0x" + Integer.toHexString(0x100 | this.dx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.dx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + string2;
        string = string + "bp:0x" + Integer.toHexString(0x100 | this.bp[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.bp[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "sp:0x" + Integer.toHexString(0x100 | this.sp[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.sp[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "si:0x" + Integer.toHexString(0x100 | this.si[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.si[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "di:0x" + Integer.toHexString(0x100 | this.di[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.di[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + string2;
        string = string + "ip:0x" + Integer.toHexString(0x100 | this.ip[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ip[1] & 0xFF).substring(1).toUpperCase() + string3;
        int n = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            n = this.flags[i] ? n + (int)Math.pow(2.0, i) : n;
        }
        string = string + "flag:0x" + Integer.toHexString(0x100 | n & 0xFF).substring(1).toUpperCase() + string2;
        string = string + "ds:0x" + Integer.toHexString(0x100 | this.ds[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ds[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "es:0x" + Integer.toHexString(0x100 | this.es[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.es[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "ss:0x" + Integer.toHexString(0x100 | this.ss[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ss[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + "cs:0x" + Integer.toHexString(0x100 | this.cs[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.cs[1] & 0xFF).substring(1).toUpperCase() + string3;
        string = string + string2;
        string = string + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";
        return string;
    }

    @Override
    public String dumpRegisters() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = string + "------------------------" + string2;
        try {
            if ((this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF)) & 0xFF) == 102) {
                string = string + "eax: 0x" + Integer.toHexString(this.eax[0] & 0xFF) + Integer.toHexString(this.eax[1] & 0xFF) + Integer.toHexString(this.ax[0] & 0xFF) + Integer.toHexString(0x100 | this.ax[1] & 0xFF).substring(1) + string3 + (((this.eax[0] & 0xFF) << 24) + ((this.eax[1] & 0xFF) << 16) + ((this.ax[0] & 0xFF) << 8) + (this.ax[1] & 0xFF)) + string2;
                string = string + "ecx: 0x" + Integer.toHexString(this.ecx[0] & 0xFF) + Integer.toHexString(this.ecx[1] & 0xFF) + Integer.toHexString(this.cx[0] & 0xFF) + Integer.toHexString(0x100 | this.cx[1] & 0xFF).substring(1) + string3 + (((this.ecx[0] & 0xFF) << 24) + ((this.ecx[1] & 0xFF) << 16) + ((this.cx[0] & 0xFF) << 8) + (this.cx[1] & 0xFF)) + string2;
                string = string + "edx: 0x" + Integer.toHexString(this.edx[0] & 0xFF) + Integer.toHexString(this.edx[1] & 0xFF) + Integer.toHexString(this.dx[0] & 0xFF) + Integer.toHexString(0x100 | this.dx[1] & 0xFF).substring(1) + string3 + (((this.edx[0] & 0xFF) << 24) + ((this.edx[1] & 0xFF) << 16) + ((this.dx[0] & 0xFF) << 8) + (this.dx[1] & 0xFF)) + string2;
                string = string + "ebx: 0x" + Integer.toHexString(this.ebx[0] & 0xFF) + Integer.toHexString(this.ebx[1] & 0xFF) + Integer.toHexString(this.bx[0] & 0xFF) + Integer.toHexString(0x100 | this.bx[1] & 0xFF).substring(1) + string3 + (((this.ebx[0] & 0xFF) << 24) + ((this.ebx[1] & 0xFF) << 16) + ((this.bx[0] & 0xFF) << 8) + (this.bx[1] & 0xFF)) + string2;
            } else {
                string = string + "ax: 0x" + Integer.toHexString(this.ax[0] & 0xFF) + Integer.toHexString(0x100 | this.ax[1] & 0xFF).substring(1) + string3 + (((this.ax[0] & 0xFF) << 8) + (this.ax[1] & 0xFF)) + string2;
                string = string + "cx: 0x" + Integer.toHexString(this.cx[0] & 0xFF) + Integer.toHexString(0x100 | this.cx[1] & 0xFF).substring(1) + string3 + (((this.cx[0] & 0xFF) << 8) + (this.cx[1] & 0xFF)) + string2;
                string = string + "dx: 0x" + Integer.toHexString(this.dx[0] & 0xFF) + Integer.toHexString(0x100 | this.dx[1] & 0xFF).substring(1) + string3 + (((this.dx[0] & 0xFF) << 8) + (this.dx[1] & 0xFF)) + string2;
                string = string + "bx: 0x" + Integer.toHexString(this.bx[0] & 0xFF) + Integer.toHexString(0x100 | this.bx[1] & 0xFF).substring(1) + string3 + (((this.bx[0] & 0xFF) << 8) + (this.bx[1] & 0xFF)) + string2;
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, "cpu -> Module exception: " + moduleException.getMessage());
            string = string + "Failed to retrieve memory information";
        }
        string = string + "sp: 0x" + Integer.toHexString(this.sp[0] & 0xFF) + Integer.toHexString(0x100 | this.sp[1] & 0xFF).substring(1) + string3 + (((this.sp[0] & 0xFF) << 8) + (this.sp[1] & 0xFF)) + string2;
        string = string + "bp: 0x" + Integer.toHexString(this.bp[0] & 0xFF) + Integer.toHexString(0x100 | this.bp[1] & 0xFF).substring(1) + string3 + (((this.bp[0] & 0xFF) << 8) + (this.bp[1] & 0xFF)) + string2;
        string = string + "si: 0x" + Integer.toHexString(this.si[0] & 0xFF) + Integer.toHexString(0x100 | this.si[1] & 0xFF).substring(1) + string3 + (((this.si[0] & 0xFF) << 8) + (this.si[1] & 0xFF)) + string2;
        string = string + "di: 0x" + Integer.toHexString(this.di[0] & 0xFF) + Integer.toHexString(0x100 | this.di[1] & 0xFF).substring(1) + string3 + (((this.di[0] & 0xFF) << 8) + (this.di[1] & 0xFF)) + string2;
        string = string + "ip: 0x" + Integer.toHexString(this.ip[0] & 0xFF) + Integer.toHexString(0x100 | this.ip[1] & 0xFF).substring(1) + string2;
        int n = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            n = this.flags[i] ? n + (int)Math.pow(2.0, i) : n;
        }
        string = string + "flags 0x" + Integer.toHexString(n) + string2;
        string = string + "cs: 0x" + Integer.toHexString(this.cs[0] & 0xFF) + Integer.toHexString(0x100 | this.cs[1] & 0xFF).substring(1) + string2;
        string = string + "ss: 0x" + Integer.toHexString(this.ss[0] & 0xFF) + Integer.toHexString(0x100 | this.ss[1] & 0xFF).substring(1) + string2;
        string = string + "ds: 0x" + Integer.toHexString(this.ds[0] & 0xFF) + Integer.toHexString(0x100 | this.ds[1] & 0xFF).substring(1) + string2;
        string = string + "es: 0x" + Integer.toHexString(this.es[0] & 0xFF) + Integer.toHexString(0x100 | this.es[1] & 0xFF).substring(1) + string2;
        string = string + "------------------------";
        return string;
    }

    public String dumpDebug(String string) {
        String string2 = string;
        String string3 = " ";
        int n = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            n = this.flags[i] ? n + (int)Math.pow(2.0, i) : n;
        }
        string2 = string2 + Integer.toHexString(0x100 | this.cs[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.cs[1] & 0xFF).substring(1).toUpperCase() + ":";
        string2 = string2 + Integer.toHexString(0x100 | this.ip[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ip[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.ss[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ss[1] & 0xFF).substring(1).toUpperCase() + ":";
        string2 = string2 + Integer.toHexString(0x100 | this.sp[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.sp[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x10000 | n).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.ax[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ax[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.bx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.bx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.cx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.cx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.dx[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.dx[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.bp[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.bp[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.si[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.si[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.di[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.di[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.ds[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.ds[1] & 0xFF).substring(1).toUpperCase() + string3;
        string2 = string2 + Integer.toHexString(0x100 | this.es[0] & 0xFF).substring(1).toUpperCase() + Integer.toHexString(0x100 | this.es[1] & 0xFF).substring(1).toUpperCase();
        return string2;
    }

    @Override
    public boolean isAbnormalTermination() {
        return this.abnormalTermination;
    }

    @Override
    public boolean isShutdown() {
        return this.shutDown;
    }

    protected void setShutdown(boolean bl) {
        this.shutDown = bl;
    }

    @Override
    public void setHoldRequest(boolean bl, ModuleDevice moduleDevice) {
        this.holdReQuest = bl;
        this.hRQorigin = moduleDevice;
        if (bl) {
            this.asyncEvent = true;
        }
    }

    private boolean handleAsyncEvent() {
        if (!this.debugMode && !this.isRunning) {
            return true;
        }
        if (this.irqPending && this.irqWaited && this.flags[9]) {
            logger.log(Level.INFO, "[cpu] handleAsyncEvent: priority 5 - async int");
            this.handleIRQ(this.pic.interruptAcknowledge());
            this.irqPending = false;
            this.irqWaited = false;
        }
        if (this.holdReQuest) {
            logger.log(Level.INFO, "[cpu] handleAsyncEvent: priority 5 - DMA");
            if (this.hRQorigin.getType().equalsIgnoreCase("dma")) {
                ((ModuleDMA)this.hRQorigin).acknowledgeBusHold();
            }
        }
        if (this.irqPending && !this.irqWaited) {
            this.irqWaited = true;
        }
        if (!this.irqPending && !this.holdReQuest) {
            this.asyncEvent = false;
        }
        return false;
    }

    @Override
    public int getIPS() {
        return this.ips;
    }

    @Override
    public void setIPS(int n) {
        this.ips = n;
        this.ipus = this.ips / 1000000;
        logger.log(Level.INFO, "[cpu] IPS set to " + this.ips + " (" + (double)this.ips / 1000000.0 + " Mhz)");
    }

    @Override
    public void setIPS(int n, int n2) {
        this.ips = n;
        this.lowestUpdatePeriod = n2;
        this.ipus = this.ips / 1000000;
        logger.log(Level.INFO, "[cpu] IPS set to " + this.ips + " (" + (double)this.ips / 1000000.0 + " Mhz)");
    }

    @Override
    protected boolean initRegisters() {
        this.ax = new byte[2];
        this.ax[1] = 0;
        this.ax[0] = 0;
        this.eax = new byte[2];
        this.eax[1] = 0;
        this.eax[0] = 0;
        this.bx = new byte[2];
        this.bx[1] = 0;
        this.bx[0] = 0;
        this.ebx = new byte[2];
        this.ebx[1] = 0;
        this.ebx[0] = 0;
        this.cx = new byte[2];
        this.cx[1] = 0;
        this.cx[0] = 0;
        this.ecx = new byte[2];
        this.ecx[1] = 0;
        this.ecx[0] = 0;
        this.dx = new byte[2];
        this.dx[0] = 5;
        this.dx[1] = 67;
        this.edx = new byte[2];
        this.edx[1] = 0;
        this.edx[0] = 0;
        this.sp = new byte[2];
        this.sp[0] = 0;
        this.sp[1] = 0;
        this.esp = new byte[2];
        this.esp[1] = 0;
        this.esp[0] = 0;
        this.bp = new byte[2];
        this.bp[1] = 0;
        this.bp[0] = 0;
        this.ebp = new byte[2];
        this.ebp[1] = 0;
        this.ebp[0] = 0;
        this.si = new byte[2];
        this.si[1] = 0;
        this.si[0] = 0;
        this.esi = new byte[2];
        this.esi[1] = 0;
        this.esi[0] = 0;
        this.di = new byte[2];
        this.di[1] = 0;
        this.di[0] = 0;
        this.edi = new byte[2];
        this.edi[1] = 0;
        this.edi[0] = 0;
        this.cs = new byte[2];
        this.cs[0] = -16;
        this.cs[1] = 0;
        this.ds = new byte[2];
        this.ds[0] = 0;
        this.ds[1] = 0;
        this.ss = new byte[2];
        this.ss[0] = 0;
        this.ss[1] = 0;
        this.es = new byte[2];
        this.es[0] = 0;
        this.es[1] = 0;
        this.ip = new byte[2];
        this.ip[0] = -1;
        this.ip[1] = -16;
        this.oldIP = new byte[2];
        this.oldIP[1] = 0;
        this.oldIP[0] = 0;
        this.flags = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        this.cr0 = new boolean[32];
        this.cr1 = new boolean[32];
        this.cr2 = new boolean[32];
        this.cr3 = new boolean[32];
        this.cr4 = new boolean[32];
        this.gdtr = new byte[6];
        this.idtr = new byte[6];
        this.ldtr = null;
        this.doubleWord = false;
        this.segmentOverride = false;
        this.segmentOverridePointer = -1;
        return true;
    }

    @Override
    protected boolean initInstructionTables() {
        this.singleByteInstructions = new Instruction[256];
        this.singleByteInstructions[0] = new Instruction_ADD_EbGb(this);
        this.singleByteInstructions[1] = new Instruction_ADD_EvGv(this);
        this.singleByteInstructions[2] = new Instruction_ADD_GbEb(this);
        this.singleByteInstructions[3] = new Instruction_ADD_GvEv(this);
        this.singleByteInstructions[4] = new Instruction_ADD_ALIb(this);
        this.singleByteInstructions[5] = new Instruction_ADD_AXIv(this);
        this.singleByteInstructions[6] = new Instruction_PUSH_ES(this);
        this.singleByteInstructions[7] = new Instruction_POP_ES(this);
        this.singleByteInstructions[8] = new Instruction_OR_EbGb(this);
        this.singleByteInstructions[9] = new Instruction_OR_EvGv(this);
        this.singleByteInstructions[10] = new Instruction_OR_GbEb(this);
        this.singleByteInstructions[11] = new Instruction_OR_GvEv(this);
        this.singleByteInstructions[12] = new Instruction_OR_ALIb(this);
        this.singleByteInstructions[13] = new Instruction_OR_AXIv(this);
        this.singleByteInstructions[14] = new Instruction_PUSH_CS(this);
        this.singleByteInstructions[15] = new Instruction_2ByteEscape(this);
        this.singleByteInstructions[16] = new Instruction_ADC_EbGb(this);
        this.singleByteInstructions[17] = new Instruction_ADC_EvGv(this);
        this.singleByteInstructions[18] = new Instruction_ADC_GbEb(this);
        this.singleByteInstructions[19] = new Instruction_ADC_GvEv(this);
        this.singleByteInstructions[20] = new Instruction_ADC_ALIb(this);
        this.singleByteInstructions[21] = new Instruction_ADC_AXIv(this);
        this.singleByteInstructions[22] = new Instruction_PUSH_SS(this);
        this.singleByteInstructions[23] = new Instruction_POP_SS(this);
        this.singleByteInstructions[24] = new Instruction_SBB_EbGb(this);
        this.singleByteInstructions[25] = new Instruction_SBB_EvGv(this);
        this.singleByteInstructions[26] = new Instruction_SBB_GbEb(this);
        this.singleByteInstructions[27] = new Instruction_SBB_GvEv(this);
        this.singleByteInstructions[28] = new Instruction_SBB_ALIb(this);
        this.singleByteInstructions[29] = new Instruction_SBB_AXIv(this);
        this.singleByteInstructions[30] = new Instruction_PUSH_DS(this);
        this.singleByteInstructions[31] = new Instruction_POP_DS(this);
        this.singleByteInstructions[32] = new Instruction_AND_EbGb(this);
        this.singleByteInstructions[33] = new Instruction_AND_EvGv(this);
        this.singleByteInstructions[34] = new Instruction_AND_GbEb(this);
        this.singleByteInstructions[35] = new Instruction_AND_GvEv(this);
        this.singleByteInstructions[36] = new Instruction_AND_ALIb(this);
        this.singleByteInstructions[37] = new Instruction_AND_AXIv(this);
        this.singleByteInstructions[38] = new Instruction_SEG_ES(this);
        this.singleByteInstructions[39] = new Instruction_DAA(this);
        this.singleByteInstructions[40] = new Instruction_SUB_EbGb(this);
        this.singleByteInstructions[41] = new Instruction_SUB_EvGv(this);
        this.singleByteInstructions[42] = new Instruction_SUB_GbEb(this);
        this.singleByteInstructions[43] = new Instruction_SUB_GvEv(this);
        this.singleByteInstructions[44] = new Instruction_SUB_ALIb(this);
        this.singleByteInstructions[45] = new Instruction_SUB_AXIv(this);
        this.singleByteInstructions[46] = new Instruction_SEG_CS(this);
        this.singleByteInstructions[47] = new Instruction_NULL(this);
        this.singleByteInstructions[48] = new Instruction_XOR_EbGb(this);
        this.singleByteInstructions[49] = new Instruction_XOR_EvGv(this);
        this.singleByteInstructions[50] = new Instruction_XOR_GbEb(this);
        this.singleByteInstructions[51] = new Instruction_XOR_GvEv(this);
        this.singleByteInstructions[52] = new Instruction_XOR_ALIb(this);
        this.singleByteInstructions[53] = new Instruction_XOR_AXIv(this);
        this.singleByteInstructions[54] = new Instruction_SEG_SS(this);
        this.singleByteInstructions[55] = new Instruction_AAA(this);
        this.singleByteInstructions[56] = new Instruction_CMP_EbGb(this);
        this.singleByteInstructions[57] = new Instruction_CMP_EvGv(this);
        this.singleByteInstructions[58] = new Instruction_CMP_GbEb(this);
        this.singleByteInstructions[59] = new Instruction_CMP_GvEv(this);
        this.singleByteInstructions[60] = new Instruction_CMP_ALIb(this);
        this.singleByteInstructions[61] = new Instruction_CMP_AXIv(this);
        this.singleByteInstructions[62] = new Instruction_SEG_DS(this);
        this.singleByteInstructions[63] = new Instruction_NULL(this);
        this.singleByteInstructions[64] = new Instruction_INC_AX(this);
        this.singleByteInstructions[65] = new Instruction_INC_CX(this);
        this.singleByteInstructions[66] = new Instruction_INC_DX(this);
        this.singleByteInstructions[67] = new Instruction_INC_BX(this);
        this.singleByteInstructions[68] = new Instruction_INC_SP(this);
        this.singleByteInstructions[69] = new Instruction_INC_BP(this);
        this.singleByteInstructions[70] = new Instruction_INC_SI(this);
        this.singleByteInstructions[71] = new Instruction_INC_DI(this);
        this.singleByteInstructions[72] = new Instruction_DEC_AX(this);
        this.singleByteInstructions[73] = new Instruction_DEC_CX(this);
        this.singleByteInstructions[74] = new Instruction_DEC_DX(this);
        this.singleByteInstructions[75] = new Instruction_DEC_BX(this);
        this.singleByteInstructions[76] = new Instruction_DEC_SP(this);
        this.singleByteInstructions[77] = new Instruction_DEC_BP(this);
        this.singleByteInstructions[78] = new Instruction_DEC_SI(this);
        this.singleByteInstructions[79] = new Instruction_DEC_DI(this);
        this.singleByteInstructions[80] = new Instruction_PUSH_AX(this);
        this.singleByteInstructions[81] = new Instruction_PUSH_CX(this);
        this.singleByteInstructions[82] = new Instruction_PUSH_DX(this);
        this.singleByteInstructions[83] = new Instruction_PUSH_BX(this);
        this.singleByteInstructions[84] = new Instruction_PUSH_SP(this);
        this.singleByteInstructions[85] = new Instruction_PUSH_BP(this);
        this.singleByteInstructions[86] = new Instruction_PUSH_SI(this);
        this.singleByteInstructions[87] = new Instruction_PUSH_DI(this);
        this.singleByteInstructions[88] = new Instruction_POP_AX(this);
        this.singleByteInstructions[89] = new Instruction_POP_CX(this);
        this.singleByteInstructions[90] = new Instruction_POP_DX(this);
        this.singleByteInstructions[91] = new Instruction_POP_BX(this);
        this.singleByteInstructions[92] = new Instruction_POP_SP(this);
        this.singleByteInstructions[93] = new Instruction_POP_BP(this);
        this.singleByteInstructions[94] = new Instruction_POP_SI(this);
        this.singleByteInstructions[95] = new Instruction_POP_DI(this);
        this.singleByteInstructions[96] = new Instruction_PUSHA(this);
        this.singleByteInstructions[97] = new Instruction_POPA(this);
        this.singleByteInstructions[98] = new Instruction_BOUND_GvMa(this);
        this.singleByteInstructions[99] = new Instruction_ARPL_EwGw(this);
        this.singleByteInstructions[100] = new Instruction_SEG_FS(this);
        this.singleByteInstructions[101] = new Instruction_SEG_GS(this);
        this.singleByteInstructions[102] = new Instruction_Opd_Size(this);
        this.singleByteInstructions[103] = new Instruction_NULL(this);
        this.singleByteInstructions[104] = new Instruction_PUSH_Iv(this);
        this.singleByteInstructions[105] = new Instruction_IMUL_GvEvIv(this);
        this.singleByteInstructions[106] = new Instruction_PUSH_Ib(this);
        this.singleByteInstructions[107] = new Instruction_NULL(this);
        this.singleByteInstructions[108] = new Instruction_INSB_YbDX(this);
        this.singleByteInstructions[109] = new Instruction_INSW_YvDX(this);
        this.singleByteInstructions[110] = new Instruction_OUTS_DXXb(this);
        this.singleByteInstructions[111] = new Instruction_OUTSW_DXXv(this);
        this.singleByteInstructions[112] = new Instruction_JO(this);
        this.singleByteInstructions[113] = new Instruction_JNO(this);
        this.singleByteInstructions[114] = new Instruction_JB_JNAE_JC(this);
        this.singleByteInstructions[115] = new Instruction_JNB_JAE_JNC(this);
        this.singleByteInstructions[116] = new Instruction_JZ_JE(this);
        this.singleByteInstructions[117] = new Instruction_JNZ_JNE(this);
        this.singleByteInstructions[118] = new Instruction_JBE_JNA(this);
        this.singleByteInstructions[119] = new Instruction_JNBE_JA(this);
        this.singleByteInstructions[120] = new Instruction_JS(this);
        this.singleByteInstructions[121] = new Instruction_JNS(this);
        this.singleByteInstructions[122] = new Instruction_JP_JPE(this);
        this.singleByteInstructions[123] = new Instruction_JNP_JPO(this);
        this.singleByteInstructions[124] = new Instruction_JL_JNGE(this);
        this.singleByteInstructions[125] = new Instruction_JNL_JGE(this);
        this.singleByteInstructions[126] = new Instruction_JLE_JNG(this);
        this.singleByteInstructions[127] = new Instruction_JNLE_JG(this);
        this.singleByteInstructions[128] = new Instruction_ImmGRP1_EbIb(this);
        this.singleByteInstructions[129] = new Instruction_ImmGRP1_EvIv(this);
        this.singleByteInstructions[130] = new Instruction_ImmGRP1_EbIb(this);
        this.singleByteInstructions[131] = new Instruction_ImmGRP1_EvIb(this);
        this.singleByteInstructions[132] = new Instruction_TEST_EbGb(this);
        this.singleByteInstructions[133] = new Instruction_TEST_EvGv(this);
        this.singleByteInstructions[134] = new Instruction_XCHG_EbGb(this);
        this.singleByteInstructions[135] = new Instruction_XCHG_EvGv(this);
        this.singleByteInstructions[136] = new Instruction_MOV_EbGb(this);
        this.singleByteInstructions[137] = new Instruction_MOV_EvGv(this);
        this.singleByteInstructions[138] = new Instruction_MOV_GbEb(this);
        this.singleByteInstructions[139] = new Instruction_MOV_GvEv(this);
        this.singleByteInstructions[140] = new Instruction_MOV_EwSw(this);
        this.singleByteInstructions[141] = new Instruction_LEA_GvM(this);
        this.singleByteInstructions[142] = new Instruction_MOV_SwEw(this);
        this.singleByteInstructions[143] = new Instruction_POP_Ev(this);
        this.singleByteInstructions[144] = new Instruction_NOP(this);
        this.singleByteInstructions[145] = new Instruction_XCHG_CXAX(this);
        this.singleByteInstructions[146] = new Instruction_XCHG_DXAX(this);
        this.singleByteInstructions[147] = new Instruction_XCHG_BXAX(this);
        this.singleByteInstructions[148] = new Instruction_XCHG_SPAX(this);
        this.singleByteInstructions[149] = new Instruction_XCHG_BPAX(this);
        this.singleByteInstructions[150] = new Instruction_XCHG_SIAX(this);
        this.singleByteInstructions[151] = new Instruction_XCHG_DIAX(this);
        this.singleByteInstructions[152] = new Instruction_CBW(this);
        this.singleByteInstructions[153] = new Instruction_CWD(this);
        this.singleByteInstructions[154] = new Instruction_CALLF_Ap(this);
        this.singleByteInstructions[155] = new Instruction_NULL(this);
        this.singleByteInstructions[156] = new Instruction_PUSHF(this);
        this.singleByteInstructions[157] = new Instruction_POPF(this);
        this.singleByteInstructions[158] = new Instruction_SAHF(this);
        this.singleByteInstructions[159] = new Instruction_LAHF(this);
        this.singleByteInstructions[160] = new Instruction_MOV_ALOb(this);
        this.singleByteInstructions[161] = new Instruction_MOV_AXOv(this);
        this.singleByteInstructions[162] = new Instruction_MOV_ObAL(this);
        this.singleByteInstructions[163] = new Instruction_MOV_OvAX(this);
        this.singleByteInstructions[164] = new Instruction_MOVS_XbYb(this);
        this.singleByteInstructions[165] = new Instruction_MOVS_XvYv(this);
        this.singleByteInstructions[166] = new Instruction_CMPS_XbYb(this);
        this.singleByteInstructions[167] = new Instruction_CMPS_XvYv(this);
        this.singleByteInstructions[168] = new Instruction_TEST_ALIb(this);
        this.singleByteInstructions[169] = new Instruction_TEST_AXIv(this);
        this.singleByteInstructions[170] = new Instruction_STOSB_YbAL(this);
        this.singleByteInstructions[171] = new Instruction_STOSW_YvAX(this);
        this.singleByteInstructions[172] = new Instruction_LODS_ALXb(this);
        this.singleByteInstructions[173] = new Instruction_LODS_AXXv(this);
        this.singleByteInstructions[174] = new Instruction_SCAS_ALYb(this);
        this.singleByteInstructions[175] = new Instruction_SCAS_AXYv(this);
        this.singleByteInstructions[176] = new Instruction_MOV_Imm_AL(this);
        this.singleByteInstructions[177] = new Instruction_MOV_Imm_CL(this);
        this.singleByteInstructions[178] = new Instruction_MOV_Imm_DL(this);
        this.singleByteInstructions[179] = new Instruction_MOV_Imm_BL(this);
        this.singleByteInstructions[180] = new Instruction_MOV_Imm_AH(this);
        this.singleByteInstructions[181] = new Instruction_MOV_Imm_CH(this);
        this.singleByteInstructions[182] = new Instruction_MOV_Imm_DH(this);
        this.singleByteInstructions[183] = new Instruction_MOV_Imm_BH(this);
        this.singleByteInstructions[184] = new Instruction_MOV_Imm_AX(this);
        this.singleByteInstructions[185] = new Instruction_MOV_Imm_CX(this);
        this.singleByteInstructions[186] = new Instruction_MOV_Imm_DX(this);
        this.singleByteInstructions[187] = new Instruction_MOV_Imm_BX(this);
        this.singleByteInstructions[188] = new Instruction_MOV_Imm_SP(this);
        this.singleByteInstructions[189] = new Instruction_MOV_Imm_BP(this);
        this.singleByteInstructions[190] = new Instruction_MOV_Imm_SI(this);
        this.singleByteInstructions[191] = new Instruction_MOV_Imm_DI(this);
        this.singleByteInstructions[192] = new Instruction_ShiftGRP2_EbIb(this);
        this.singleByteInstructions[193] = new Instruction_ShiftGRP2_EvIb(this);
        this.singleByteInstructions[194] = new Instruction_RETN_Iw(this);
        this.singleByteInstructions[195] = new Instruction_RETN(this);
        this.singleByteInstructions[196] = new Instruction_LES_GvMp(this);
        this.singleByteInstructions[197] = new Instruction_LDS_GvMp(this);
        this.singleByteInstructions[198] = new Instruction_GRP11_MOV_EbIb(this);
        this.singleByteInstructions[199] = new Instruction_GRP11_MOV_EvIv(this);
        this.singleByteInstructions[200] = new Instruction_ENTER_IwIb(this);
        this.singleByteInstructions[201] = new Instruction_LEAVE(this);
        this.singleByteInstructions[202] = new Instruction_RETF_Iw(this);
        this.singleByteInstructions[203] = new Instruction_RETF(this);
        this.singleByteInstructions[204] = new Instruction_INT3(this);
        this.singleByteInstructions[205] = new Instruction_INT_Ib(this);
        this.singleByteInstructions[206] = new Instruction_NULL(this);
        this.singleByteInstructions[207] = new Instruction_IRET(this);
        this.singleByteInstructions[208] = new Instruction_ShiftGRP2_Eb1(this);
        this.singleByteInstructions[209] = new Instruction_ShiftGRP2_Ev1(this);
        this.singleByteInstructions[210] = new Instruction_ShiftGRP2_EbCL(this);
        this.singleByteInstructions[211] = new Instruction_ShiftGRP2_EvCL(this);
        this.singleByteInstructions[212] = new Instruction_AAM_Ib(this);
        this.singleByteInstructions[213] = new Instruction_AAD_Ib(this);
        this.singleByteInstructions[214] = new Instruction_SALC(this);
        this.singleByteInstructions[215] = new Instruction_XLAT(this);
        this.singleByteInstructions[216] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[217] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[218] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[219] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[220] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[221] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[222] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[223] = new Instruction_ESC_FPU(this);
        this.singleByteInstructions[224] = new Instruction_LOOPNE_LOOPNZ_Jb(this);
        this.singleByteInstructions[225] = new Instruction_LOOPE_LOOPZ_Jb(this);
        this.singleByteInstructions[226] = new Instruction_LOOP_Jb(this);
        this.singleByteInstructions[227] = new Instruction_JCXZ_JECXZ(this);
        this.singleByteInstructions[228] = new Instruction_IN_ALIb(this);
        this.singleByteInstructions[229] = new Instruction_NULL(this);
        this.singleByteInstructions[230] = new Instruction_OUT_IbAL(this);
        this.singleByteInstructions[231] = new Instruction_NULL(this);
        this.singleByteInstructions[232] = new Instruction_CALL_Jv(this);
        this.singleByteInstructions[233] = new Instruction_JMP_nearJv(this);
        this.singleByteInstructions[234] = new Instruction_JMP_farAP(this);
        this.singleByteInstructions[235] = new Instruction_JMP_shortJb(this);
        this.singleByteInstructions[236] = new Instruction_IN_ALDX(this);
        this.singleByteInstructions[237] = new Instruction_IN_eAXDX(this);
        this.singleByteInstructions[238] = new Instruction_OUT_DXAL(this);
        this.singleByteInstructions[239] = new Instruction_OUT_DXeAX(this);
        this.singleByteInstructions[240] = new Instruction_NULL(this);
        this.singleByteInstructions[241] = new Instruction_NULL(this);
        this.singleByteInstructions[242] = new Instruction_REPNE(this);
        this.singleByteInstructions[243] = new Instruction_REP_REPE(this);
        this.singleByteInstructions[244] = new Instruction_HLT(this);
        this.singleByteInstructions[245] = new Instruction_CMC(this);
        this.singleByteInstructions[246] = new Instruction_UnaryGrp3_Eb(this);
        this.singleByteInstructions[247] = new Instruction_UnaryGrp3_Ev(this);
        this.singleByteInstructions[248] = new Instruction_CLC(this);
        this.singleByteInstructions[249] = new Instruction_STC(this);
        this.singleByteInstructions[250] = new Instruction_CLI(this);
        this.singleByteInstructions[251] = new Instruction_STI(this);
        this.singleByteInstructions[252] = new Instruction_CLD(this);
        this.singleByteInstructions[253] = new Instruction_STD(this);
        this.singleByteInstructions[254] = new Instruction_INCDEC_GRP4(this);
        this.singleByteInstructions[255] = new Instruction_INCDEC_GRP5(this);
        this.doubleByteInstructions = new Instruction[256];
        this.doubleByteInstructions[0] = new Instruction_GRP6(this);
        this.doubleByteInstructions[1] = new Instruction_GRP7(this);
        this.doubleByteInstructions[2] = new Instruction_LAR(this);
        this.doubleByteInstructions[3] = new Instruction_NULL(this);
        this.doubleByteInstructions[4] = new Instruction_NULL(this);
        this.doubleByteInstructions[5] = new Instruction_NULL(this);
        this.doubleByteInstructions[6] = new Instruction_NULL(this);
        this.doubleByteInstructions[7] = new Instruction_NULL(this);
        this.doubleByteInstructions[8] = new Instruction_NULL(this);
        this.doubleByteInstructions[9] = new Instruction_NULL(this);
        this.doubleByteInstructions[10] = new Instruction_NULL(this);
        this.doubleByteInstructions[11] = new Instruction_NULL(this);
        this.doubleByteInstructions[12] = new Instruction_NULL(this);
        this.doubleByteInstructions[13] = new Instruction_NULL(this);
        this.doubleByteInstructions[14] = new Instruction_NULL(this);
        this.doubleByteInstructions[15] = new Instruction_NULL(this);
        this.doubleByteInstructions[16] = new Instruction_NULL(this);
        this.doubleByteInstructions[17] = new Instruction_NULL(this);
        this.doubleByteInstructions[18] = new Instruction_NULL(this);
        this.doubleByteInstructions[19] = new Instruction_NULL(this);
        this.doubleByteInstructions[20] = new Instruction_NULL(this);
        this.doubleByteInstructions[21] = new Instruction_NULL(this);
        this.doubleByteInstructions[22] = new Instruction_NULL(this);
        this.doubleByteInstructions[23] = new Instruction_NULL(this);
        this.doubleByteInstructions[24] = new Instruction_NULL(this);
        this.doubleByteInstructions[25] = new Instruction_NULL(this);
        this.doubleByteInstructions[26] = new Instruction_NULL(this);
        this.doubleByteInstructions[27] = new Instruction_NULL(this);
        this.doubleByteInstructions[28] = new Instruction_NULL(this);
        this.doubleByteInstructions[29] = new Instruction_NULL(this);
        this.doubleByteInstructions[30] = new Instruction_NULL(this);
        this.doubleByteInstructions[31] = new Instruction_NULL(this);
        this.doubleByteInstructions[32] = new Instruction_NULL(this);
        this.doubleByteInstructions[33] = new Instruction_NULL(this);
        this.doubleByteInstructions[34] = new Instruction_NULL(this);
        this.doubleByteInstructions[35] = new Instruction_NULL(this);
        this.doubleByteInstructions[36] = new Instruction_NULL(this);
        this.doubleByteInstructions[37] = new Instruction_NULL(this);
        this.doubleByteInstructions[38] = new Instruction_NULL(this);
        this.doubleByteInstructions[39] = new Instruction_NULL(this);
        this.doubleByteInstructions[40] = new Instruction_NULL(this);
        this.doubleByteInstructions[41] = new Instruction_NULL(this);
        this.doubleByteInstructions[42] = new Instruction_NULL(this);
        this.doubleByteInstructions[43] = new Instruction_NULL(this);
        this.doubleByteInstructions[44] = new Instruction_NULL(this);
        this.doubleByteInstructions[45] = new Instruction_NULL(this);
        this.doubleByteInstructions[46] = new Instruction_NULL(this);
        this.doubleByteInstructions[47] = new Instruction_NULL(this);
        this.doubleByteInstructions[48] = new Instruction_NULL(this);
        this.doubleByteInstructions[49] = new Instruction_NULL(this);
        this.doubleByteInstructions[50] = new Instruction_NULL(this);
        this.doubleByteInstructions[51] = new Instruction_NULL(this);
        this.doubleByteInstructions[52] = new Instruction_NULL(this);
        this.doubleByteInstructions[53] = new Instruction_NULL(this);
        this.doubleByteInstructions[54] = new Instruction_NULL(this);
        this.doubleByteInstructions[55] = new Instruction_NULL(this);
        this.doubleByteInstructions[56] = new Instruction_NULL(this);
        this.doubleByteInstructions[57] = new Instruction_NULL(this);
        this.doubleByteInstructions[58] = new Instruction_NULL(this);
        this.doubleByteInstructions[59] = new Instruction_NULL(this);
        this.doubleByteInstructions[60] = new Instruction_NULL(this);
        this.doubleByteInstructions[61] = new Instruction_NULL(this);
        this.doubleByteInstructions[62] = new Instruction_NULL(this);
        this.doubleByteInstructions[63] = new Instruction_NULL(this);
        this.doubleByteInstructions[64] = new Instruction_NULL(this);
        this.doubleByteInstructions[65] = new Instruction_NULL(this);
        this.doubleByteInstructions[66] = new Instruction_NULL(this);
        this.doubleByteInstructions[67] = new Instruction_NULL(this);
        this.doubleByteInstructions[68] = new Instruction_NULL(this);
        this.doubleByteInstructions[69] = new Instruction_NULL(this);
        this.doubleByteInstructions[70] = new Instruction_NULL(this);
        this.doubleByteInstructions[71] = new Instruction_NULL(this);
        this.doubleByteInstructions[72] = new Instruction_NULL(this);
        this.doubleByteInstructions[73] = new Instruction_NULL(this);
        this.doubleByteInstructions[74] = new Instruction_NULL(this);
        this.doubleByteInstructions[75] = new Instruction_NULL(this);
        this.doubleByteInstructions[76] = new Instruction_NULL(this);
        this.doubleByteInstructions[77] = new Instruction_NULL(this);
        this.doubleByteInstructions[78] = new Instruction_NULL(this);
        this.doubleByteInstructions[79] = new Instruction_NULL(this);
        this.doubleByteInstructions[80] = new Instruction_NULL(this);
        this.doubleByteInstructions[81] = new Instruction_NULL(this);
        this.doubleByteInstructions[82] = new Instruction_NULL(this);
        this.doubleByteInstructions[83] = new Instruction_NULL(this);
        this.doubleByteInstructions[84] = new Instruction_NULL(this);
        this.doubleByteInstructions[85] = new Instruction_NULL(this);
        this.doubleByteInstructions[86] = new Instruction_NULL(this);
        this.doubleByteInstructions[87] = new Instruction_NULL(this);
        this.doubleByteInstructions[88] = new Instruction_NULL(this);
        this.doubleByteInstructions[89] = new Instruction_NULL(this);
        this.doubleByteInstructions[90] = new Instruction_NULL(this);
        this.doubleByteInstructions[91] = new Instruction_NULL(this);
        this.doubleByteInstructions[92] = new Instruction_NULL(this);
        this.doubleByteInstructions[93] = new Instruction_NULL(this);
        this.doubleByteInstructions[94] = new Instruction_NULL(this);
        this.doubleByteInstructions[95] = new Instruction_NULL(this);
        this.doubleByteInstructions[96] = new Instruction_NULL(this);
        this.doubleByteInstructions[97] = new Instruction_NULL(this);
        this.doubleByteInstructions[98] = new Instruction_NULL(this);
        this.doubleByteInstructions[99] = new Instruction_NULL(this);
        this.doubleByteInstructions[100] = new Instruction_NULL(this);
        this.doubleByteInstructions[101] = new Instruction_NULL(this);
        this.doubleByteInstructions[102] = new Instruction_NULL(this);
        this.doubleByteInstructions[103] = new Instruction_NULL(this);
        this.doubleByteInstructions[104] = new Instruction_NULL(this);
        this.doubleByteInstructions[105] = new Instruction_NULL(this);
        this.doubleByteInstructions[106] = new Instruction_NULL(this);
        this.doubleByteInstructions[107] = new Instruction_NULL(this);
        this.doubleByteInstructions[108] = new Instruction_NULL(this);
        this.doubleByteInstructions[109] = new Instruction_NULL(this);
        this.doubleByteInstructions[110] = new Instruction_NULL(this);
        this.doubleByteInstructions[111] = new Instruction_NULL(this);
        this.doubleByteInstructions[112] = new Instruction_NULL(this);
        this.doubleByteInstructions[113] = new Instruction_NULL(this);
        this.doubleByteInstructions[114] = new Instruction_NULL(this);
        this.doubleByteInstructions[115] = new Instruction_NULL(this);
        this.doubleByteInstructions[116] = new Instruction_NULL(this);
        this.doubleByteInstructions[117] = new Instruction_NULL(this);
        this.doubleByteInstructions[118] = new Instruction_NULL(this);
        this.doubleByteInstructions[119] = new Instruction_NULL(this);
        this.doubleByteInstructions[120] = new Instruction_NULL(this);
        this.doubleByteInstructions[121] = new Instruction_NULL(this);
        this.doubleByteInstructions[122] = new Instruction_NULL(this);
        this.doubleByteInstructions[123] = new Instruction_NULL(this);
        this.doubleByteInstructions[124] = new Instruction_NULL(this);
        this.doubleByteInstructions[125] = new Instruction_NULL(this);
        this.doubleByteInstructions[126] = new Instruction_NULL(this);
        this.doubleByteInstructions[127] = new Instruction_NULL(this);
        this.doubleByteInstructions[128] = new Instruction_NULL(this);
        this.doubleByteInstructions[129] = new Instruction_NULL(this);
        this.doubleByteInstructions[130] = new Instruction_JB_JNAE_JC_long(this);
        this.doubleByteInstructions[131] = new Instruction_JNB_JAE_JNC_long(this);
        this.doubleByteInstructions[132] = new Instruction_JZ_JE_long(this);
        this.doubleByteInstructions[133] = new Instruction_JNZ_JNE_long(this);
        this.doubleByteInstructions[134] = new Instruction_JBE_JNA_long(this);
        this.doubleByteInstructions[135] = new Instruction_NULL(this);
        this.doubleByteInstructions[136] = new Instruction_NULL(this);
        this.doubleByteInstructions[137] = new Instruction_NULL(this);
        this.doubleByteInstructions[138] = new Instruction_NULL(this);
        this.doubleByteInstructions[139] = new Instruction_NULL(this);
        this.doubleByteInstructions[140] = new Instruction_NULL(this);
        this.doubleByteInstructions[141] = new Instruction_NULL(this);
        this.doubleByteInstructions[142] = new Instruction_NULL(this);
        this.doubleByteInstructions[143] = new Instruction_NULL(this);
        this.doubleByteInstructions[144] = new Instruction_NULL(this);
        this.doubleByteInstructions[145] = new Instruction_NULL(this);
        this.doubleByteInstructions[146] = new Instruction_NULL(this);
        this.doubleByteInstructions[147] = new Instruction_NULL(this);
        this.doubleByteInstructions[148] = new Instruction_NULL(this);
        this.doubleByteInstructions[149] = new Instruction_NULL(this);
        this.doubleByteInstructions[150] = new Instruction_NULL(this);
        this.doubleByteInstructions[151] = new Instruction_NULL(this);
        this.doubleByteInstructions[152] = new Instruction_NULL(this);
        this.doubleByteInstructions[153] = new Instruction_NULL(this);
        this.doubleByteInstructions[154] = new Instruction_NULL(this);
        this.doubleByteInstructions[155] = new Instruction_NULL(this);
        this.doubleByteInstructions[156] = new Instruction_NULL(this);
        this.doubleByteInstructions[157] = new Instruction_NULL(this);
        this.doubleByteInstructions[158] = new Instruction_NULL(this);
        this.doubleByteInstructions[159] = new Instruction_NULL(this);
        this.doubleByteInstructions[160] = new Instruction_NULL(this);
        this.doubleByteInstructions[161] = new Instruction_NULL(this);
        this.doubleByteInstructions[162] = new Instruction_NULL(this);
        this.doubleByteInstructions[163] = new Instruction_NULL(this);
        this.doubleByteInstructions[164] = new Instruction_NULL(this);
        this.doubleByteInstructions[165] = new Instruction_NULL(this);
        this.doubleByteInstructions[166] = new Instruction_NULL(this);
        this.doubleByteInstructions[167] = new Instruction_NULL(this);
        this.doubleByteInstructions[168] = new Instruction_NULL(this);
        this.doubleByteInstructions[169] = new Instruction_NULL(this);
        this.doubleByteInstructions[170] = new Instruction_NULL(this);
        this.doubleByteInstructions[171] = new Instruction_NULL(this);
        this.doubleByteInstructions[172] = new Instruction_NULL(this);
        this.doubleByteInstructions[173] = new Instruction_NULL(this);
        this.doubleByteInstructions[174] = new Instruction_NULL(this);
        this.doubleByteInstructions[175] = new Instruction_NULL(this);
        this.doubleByteInstructions[176] = new Instruction_NULL(this);
        this.doubleByteInstructions[177] = new Instruction_NULL(this);
        this.doubleByteInstructions[178] = new Instruction_NULL(this);
        this.doubleByteInstructions[179] = new Instruction_NULL(this);
        this.doubleByteInstructions[180] = new Instruction_NULL(this);
        this.doubleByteInstructions[181] = new Instruction_NULL(this);
        this.doubleByteInstructions[182] = new Instruction_NULL(this);
        this.doubleByteInstructions[183] = new Instruction_MOVZX_GvEw(this);
        this.doubleByteInstructions[184] = new Instruction_NULL(this);
        this.doubleByteInstructions[185] = new Instruction_NULL(this);
        this.doubleByteInstructions[186] = new Instruction_NULL(this);
        this.doubleByteInstructions[187] = new Instruction_NULL(this);
        this.doubleByteInstructions[188] = new Instruction_NULL(this);
        this.doubleByteInstructions[189] = new Instruction_NULL(this);
        this.doubleByteInstructions[190] = new Instruction_NULL(this);
        this.doubleByteInstructions[191] = new Instruction_NULL(this);
        this.doubleByteInstructions[192] = new Instruction_NULL(this);
        this.doubleByteInstructions[193] = new Instruction_NULL(this);
        this.doubleByteInstructions[194] = new Instruction_NULL(this);
        this.doubleByteInstructions[195] = new Instruction_NULL(this);
        this.doubleByteInstructions[196] = new Instruction_NULL(this);
        this.doubleByteInstructions[197] = new Instruction_NULL(this);
        this.doubleByteInstructions[198] = new Instruction_NULL(this);
        this.doubleByteInstructions[199] = new Instruction_NULL(this);
        this.doubleByteInstructions[200] = new Instruction_NULL(this);
        this.doubleByteInstructions[201] = new Instruction_NULL(this);
        this.doubleByteInstructions[202] = new Instruction_NULL(this);
        this.doubleByteInstructions[203] = new Instruction_NULL(this);
        this.doubleByteInstructions[204] = new Instruction_NULL(this);
        this.doubleByteInstructions[205] = new Instruction_NULL(this);
        this.doubleByteInstructions[206] = new Instruction_NULL(this);
        this.doubleByteInstructions[207] = new Instruction_NULL(this);
        this.doubleByteInstructions[208] = new Instruction_NULL(this);
        this.doubleByteInstructions[209] = new Instruction_NULL(this);
        this.doubleByteInstructions[210] = new Instruction_NULL(this);
        this.doubleByteInstructions[211] = new Instruction_NULL(this);
        this.doubleByteInstructions[212] = new Instruction_NULL(this);
        this.doubleByteInstructions[213] = new Instruction_NULL(this);
        this.doubleByteInstructions[214] = new Instruction_NULL(this);
        this.doubleByteInstructions[215] = new Instruction_NULL(this);
        this.doubleByteInstructions[216] = new Instruction_NULL(this);
        this.doubleByteInstructions[217] = new Instruction_NULL(this);
        this.doubleByteInstructions[218] = new Instruction_NULL(this);
        this.doubleByteInstructions[219] = new Instruction_NULL(this);
        this.doubleByteInstructions[220] = new Instruction_NULL(this);
        this.doubleByteInstructions[221] = new Instruction_NULL(this);
        this.doubleByteInstructions[222] = new Instruction_NULL(this);
        this.doubleByteInstructions[223] = new Instruction_NULL(this);
        this.doubleByteInstructions[224] = new Instruction_NULL(this);
        this.doubleByteInstructions[225] = new Instruction_NULL(this);
        this.doubleByteInstructions[226] = new Instruction_NULL(this);
        this.doubleByteInstructions[227] = new Instruction_NULL(this);
        this.doubleByteInstructions[228] = new Instruction_NULL(this);
        this.doubleByteInstructions[229] = new Instruction_NULL(this);
        this.doubleByteInstructions[230] = new Instruction_NULL(this);
        this.doubleByteInstructions[231] = new Instruction_NULL(this);
        this.doubleByteInstructions[232] = new Instruction_NULL(this);
        this.doubleByteInstructions[233] = new Instruction_NULL(this);
        this.doubleByteInstructions[234] = new Instruction_NULL(this);
        this.doubleByteInstructions[235] = new Instruction_NULL(this);
        this.doubleByteInstructions[236] = new Instruction_NULL(this);
        this.doubleByteInstructions[237] = new Instruction_NULL(this);
        this.doubleByteInstructions[238] = new Instruction_NULL(this);
        this.doubleByteInstructions[239] = new Instruction_NULL(this);
        this.doubleByteInstructions[240] = new Instruction_NULL(this);
        this.doubleByteInstructions[241] = new Instruction_NULL(this);
        this.doubleByteInstructions[242] = new Instruction_NULL(this);
        this.doubleByteInstructions[243] = new Instruction_NULL(this);
        this.doubleByteInstructions[244] = new Instruction_NULL(this);
        this.doubleByteInstructions[245] = new Instruction_NULL(this);
        this.doubleByteInstructions[246] = new Instruction_NULL(this);
        this.doubleByteInstructions[247] = new Instruction_NULL(this);
        this.doubleByteInstructions[248] = new Instruction_NULL(this);
        this.doubleByteInstructions[249] = new Instruction_NULL(this);
        this.doubleByteInstructions[250] = new Instruction_NULL(this);
        this.doubleByteInstructions[251] = new Instruction_NULL(this);
        this.doubleByteInstructions[252] = new Instruction_NULL(this);
        this.doubleByteInstructions[253] = new Instruction_NULL(this);
        this.doubleByteInstructions[254] = new Instruction_NULL(this);
        this.doubleByteInstructions[255] = new Instruction_NULL(this);
        return true;
    }

    @Override
    protected void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    @Override
    public byte[] getRegisterValue(String string) {
        byte[] byArray = this.convertStringToRegister(string);
        if (byArray != null) {
            return byArray;
        }
        return null;
    }

    @Override
    public boolean setRegisterValue(String string, byte[] byArray) {
        byte[] byArray2 = this.convertStringToRegister(string);
        if (byArray2 != null) {
            byArray2[0] = byArray[0];
            byArray2[1] = byArray[1];
            return true;
        }
        return false;
    }

    public boolean getFlagValue(char c) {
        switch (c) {
            case 'C': 
            case 'c': {
                return this.flags[0];
            }
            case 'P': 
            case 'p': {
                return this.flags[2];
            }
            case 'A': 
            case 'a': {
                return this.flags[4];
            }
            case 'Z': 
            case 'z': {
                return this.flags[6];
            }
            case 'S': 
            case 's': {
                return this.flags[7];
            }
            case 'T': 
            case 't': {
                return this.flags[8];
            }
            case 'I': 
            case 'i': {
                return this.flags[9];
            }
            case 'D': 
            case 'd': {
                return this.flags[10];
            }
            case 'O': 
            case 'o': {
                return this.flags[11];
            }
        }
        return false;
    }

    @Override
    public String getNextInstructionInfo() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "Instruction number = " + this.instructionCounter + string2;
        string = string + Integer.toHexString(0x100 | this.cs[0] & 0xFF).substring(1) + Integer.toHexString(0x100 | this.cs[1] & 0xFF).substring(1) + ":" + Integer.toHexString(0x100 | this.ip[0] & 0xFF).substring(1) + Integer.toHexString(0x100 | this.ip[1] & 0xFF).substring(1) + "   ";
        try {
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF)) & 0xFF).substring(1).toUpperCase() + " ";
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF) + 1) & 0xFF).substring(1).toUpperCase() + " ";
            string = string + Integer.toHexString(0x100 | this.memory.getByte((this.cs[0] << 12 & 0xFFFFF) + (this.cs[1] << 4 & 0xFFF) + (this.ip[0] << 8 & 0xFFFF) + (this.ip[1] & 0xFF) + 2) & 0xFF).substring(1).toUpperCase() + string3;
            String string4 = this.singleByteInstructions[this.memory.getByte(((this.cs[0] & 0xFF) << 12) + ((this.cs[1] & 0xFF) << 4) + ((this.ip[0] & 0xFF) << 8) + (this.ip[1] & 0xFF)) & 0xFF].toString();
            string4 = string4.substring(string4.indexOf("_") + 1, string4.indexOf("@"));
            string = string + string4;
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, "[cpu] Module exception: " + moduleException.getMessage());
            string = string + "Failed to retrieve memory information";
        }
        return string;
    }

    @Override
    public long getCurrentInstructionNumber() {
        return this.instructionCounter;
    }

    @Override
    protected void incrementInstructionCounter() {
    }

    @Override
    protected byte getIOPortByte(int n) throws ModuleException {
        return this.motherboard.getIOPortByte(n);
    }

    @Override
    protected void setIOPortByte(int n, byte by) throws ModuleException {
        this.motherboard.setIOPortByte(n, by);
    }

    @Override
    protected byte[] getIOPortWord(int n) throws ModuleException {
        return this.motherboard.getIOPortWord(n);
    }

    @Override
    protected void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        this.motherboard.setIOPortWord(n, byArray);
    }

    @Override
    protected byte[] getIOPortDoubleWord(int n) throws ModuleException {
        return this.motherboard.getIOPortDoubleWord(n);
    }

    @Override
    protected void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        this.motherboard.setIOPortDoubleWord(n, byArray);
    }

    @Override
    public void interruptRequest(boolean bl) {
        this.irqPending = bl;
        this.asyncEvent = true;
    }

    private boolean isPrefix() {
        return this.codeByte == 242 || this.codeByte == 243 || this.codeByte == 38 || this.codeByte == 46 || this.codeByte == 54 || this.codeByte == 62 || this.codeByte == 102;
    }

    protected void resetPrefixes() {
        this.segmentOverride = false;
        this.doubleWord = false;
        this.prefixRep = false;
        this.prefixCounter = 0;
    }

    private boolean isSingleByte32BitSupported() {
        switch (this.codeByte) {
            case 1: 
            case 37: 
            case 49: 
            case 53: 
            case 61: 
            case 64: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 104: 
            case 109: 
            case 137: 
            case 156: 
            case 157: 
            case 161: 
            case 163: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 237: 
            case 239: 
            case 247: {
                break;
            }
            case 129: 
            case 131: 
            case 193: 
            case 209: 
            case 211: {
                logger.log(Level.WARNING, "[cpu] Instruction problem (opcode " + Integer.toHexString(this.codeByte) + "h, at " + Integer.toHexString(this.convertWordToInt(this.cs)).toUpperCase() + ":" + Integer.toHexString(this.convertWordToInt(this.ip)).toUpperCase() + "): 32-bit not fully supported!");
                break;
            }
            case 15: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean isDoubleByte32BitSupported() {
        switch (this.codeByte2) {
            case 1: {
                logger.log(Level.SEVERE, "[cpu] Instruction problem (opcode " + Integer.toHexString(this.codeByte) + " " + Integer.toHexString(this.codeByte2) + "h): 32-bit not fully supported!");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void executeInstruction() throws CPUInstructionException {
        if (this.prefixRep) {
            if (this.cx[1] == 0 && this.cx[0] == 0) {
                return;
            }
            this.singleByteInstructions[this.codeByte].execute();
            this.tempWord = Util.subtractWords(this.cx, WORD_0X0001, 0);
            System.arraycopy(this.tempWord, 0, this.cx, 0, this.tempWord.length);
            if (this.cx[1] == 0 && this.cx[0] == 0) {
                return;
            }
            if (this.prefixRepType == 243 ? (this.codeByte == 166 || this.codeByte == 167 || this.codeByte == 174 || this.codeByte == 175) && !this.flags[6] : this.prefixRepType == 242 && (this.codeByte == 166 || this.codeByte == 167 || this.codeByte == 174 || this.codeByte == 175) && this.flags[6]) {
                return;
            }
            this.tempWord = Util.subtractWords(this.ip, new byte[]{0, (byte)(this.prefixCounter + 1)}, 0);
            System.arraycopy(this.tempWord, 0, this.ip, 0, this.tempWord.length);
        } else {
            this.singleByteInstructions[this.codeByte].execute();
        }
    }

    protected byte getByteFromCode() {
        segmentedCodeAddress = this.getSegmentedCodeAddress();
        this.ip = Util.addWords(this.ip, new byte[]{0, 1}, 0);
        try {
            return this.memory.getByte(segmentedCodeAddress);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return -1;
        }
    }

    protected byte getByteFromCode(byte[] byArray) {
        try {
            return this.memory.getByte(this.getSegmentedCodeAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return -1;
        }
    }

    protected byte getByteFromData(byte[] byArray) {
        try {
            return this.memory.getByte(this.getSegmentedDataAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return -1;
        }
    }

    protected byte getByteFromStack(byte[] byArray) {
        try {
            return this.memory.getByte(this.getSegmentedStackAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return -1;
        }
    }

    protected byte getByteFromExtra(byte[] byArray) {
        try {
            return this.memory.getByte(this.getSegmentedExtraAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return -1;
        }
    }

    protected byte[] getWordFromCode() {
        segmentedCodeAddress = this.getSegmentedCodeAddress();
        this.ip = Util.addWords(this.ip, new byte[]{0, 2}, 0);
        try {
            return this.memory.getWord(segmentedCodeAddress);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte[] getWordFromCode(byte[] byArray) {
        try {
            return this.memory.getWord(this.getSegmentedCodeAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte[] getWordFromData(byte[] byArray) {
        try {
            return this.memory.getWord(this.getSegmentedDataAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte[] getWordFromStack() {
        try {
            byte[] byArray = this.memory.getWord(this.getSegmentedStackAddress());
            this.sp = Util.addWords(this.sp, new byte[]{0, 2}, 0);
            return byArray;
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte[] getWordFromStack(byte[] byArray) {
        try {
            return this.memory.getWord(this.getSegmentedStackAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte[] getWordFromExtra(byte[] byArray) {
        try {
            return this.memory.getWord(this.getSegmentedExtraAddress(byArray));
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
            return null;
        }
    }

    protected byte getByteFromMemorySegment(byte by, byte[] byArray) {
        this.tempByte = by & 7;
        if (this.segmentOverride) {
            switch (this.segmentOverridePointer) {
                case 0: {
                    return this.getByteFromCode(byArray);
                }
                case 1: {
                    return this.getByteFromData(byArray);
                }
                case 2: {
                    return this.getByteFromExtra(byArray);
                }
                case 3: {
                    return this.getByteFromStack(byArray);
                }
            }
            logger.log(Level.WARNING, "[cpu] Read byte: segment overriden with unknown segment");
            return this.getByteFromCode(byArray);
        }
        if (this.tempByte == 2 || this.tempByte == 3 || this.tempByte == 6) {
            if (this.tempByte == 6 && (by & 0xC0) >> 6 == 0) {
                return this.getByteFromData(byArray);
            }
            return this.getByteFromStack(byArray);
        }
        return this.getByteFromData(byArray);
    }

    protected byte[] getWordFromMemorySegment(byte by, byte[] byArray) {
        this.tempByte = by & 7;
        if (this.segmentOverride) {
            switch (this.segmentOverridePointer) {
                case 0: {
                    return this.getWordFromCode(byArray);
                }
                case 1: {
                    return this.getWordFromData(byArray);
                }
                case 2: {
                    return this.getWordFromExtra(byArray);
                }
                case 3: {
                    return this.getWordFromStack(byArray);
                }
            }
            logger.log(Level.WARNING, "[cpu] Read word: segment overriden with unknown segment");
            return this.getWordFromCode(byArray);
        }
        if (this.tempByte == 2 || this.tempByte == 3 || this.tempByte == 6) {
            if (this.tempByte == 6 && (by & 0xC0) >> 6 == 0) {
                return this.getWordFromData(byArray);
            }
            return this.getWordFromStack(byArray);
        }
        return this.getWordFromData(byArray);
    }

    protected void setByteToCode(byte[] byArray, byte by) {
        try {
            this.memory.setByte(this.getSegmentedCodeAddress(byArray), by);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setWordToCode(byte[] byArray, byte[] byArray2) {
        try {
            this.memory.setWord(this.getSegmentedCodeAddress(byArray), byArray2);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setByteToData(byte[] byArray, byte by) {
        try {
            this.memory.setByte(this.getSegmentedDataAddress(byArray), by);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setWordToData(byte[] byArray, byte[] byArray2) {
        try {
            this.memory.setWord(this.getSegmentedDataAddress(byArray), byArray2);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setByteToExtra(byte[] byArray, byte by) {
        try {
            this.memory.setByte(this.getSegmentedExtraAddress(byArray), by);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setWordToExtra(byte[] byArray, byte[] byArray2) {
        try {
            this.memory.setWord(this.getSegmentedExtraAddress(byArray), byArray2);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setByteToStack(byte by) {
        try {
            this.memory.setByte(this.getSegmentedStackAddress(), by);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setByteToStack(byte[] byArray, byte by) {
        try {
            this.memory.setByte(this.getSegmentedStackAddress(byArray), by);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setWordToStack(byte[] byArray) {
        this.sp = Util.subtractWords(this.sp, new byte[]{0, 2}, 0);
        try {
            this.memory.setWord(this.getSegmentedStackAddress(), byArray);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setWordToStack(byte[] byArray, byte[] byArray2) {
        try {
            this.memory.setWord(this.getSegmentedStackAddress(byArray), byArray2);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[cpu] Module exception: " + moduleException.getMessage());
        }
    }

    protected void setByteInMemorySegment(byte by, byte[] byArray, byte by2) {
        this.tempByte = by & 7;
        if (this.segmentOverride) {
            switch (this.segmentOverridePointer) {
                case 0: {
                    this.setByteToCode(byArray, by2);
                    break;
                }
                case 1: {
                    this.setByteToData(byArray, by2);
                    break;
                }
                case 2: {
                    this.setByteToExtra(byArray, by2);
                    break;
                }
                case 3: {
                    this.setByteToStack(byArray, by2);
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "[cpu] Write byte: segment overriden with unknown segment");
                    break;
                }
            }
        } else if (this.tempByte == 2 || this.tempByte == 3 || this.tempByte == 6) {
            if (this.tempByte == 6 && (by & 0xC0) >> 6 == 0) {
                this.setByteToData(byArray, by2);
            } else {
                this.setByteToStack(byArray, by2);
            }
        } else {
            this.setByteToData(byArray, by2);
        }
    }

    protected void setWordInMemorySegment(byte by, byte[] byArray, byte[] byArray2) {
        this.tempByte = by & 7;
        if (this.segmentOverride) {
            switch (this.segmentOverridePointer) {
                case 0: {
                    this.setWordToCode(byArray, byArray2);
                    break;
                }
                case 1: {
                    this.setWordToData(byArray, byArray2);
                    break;
                }
                case 2: {
                    this.setWordToExtra(byArray, byArray2);
                    break;
                }
                case 3: {
                    this.setWordToStack(byArray, byArray2);
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "[cpu] Write word: segment overriden with unknown segment");
                    break;
                }
            }
        } else if (this.tempByte == 2 || this.tempByte == 3 || this.tempByte == 6) {
            if (this.tempByte == 6 && (by >> 6 & 3) == 0) {
                this.setWordToData(byArray, byArray2);
            } else {
                this.setWordToStack(byArray, byArray2);
            }
        } else {
            this.setWordToData(byArray, byArray2);
        }
    }

    protected byte[] decodeMM(int n) {
        switch (n >> 6 & 3) {
            case 0: {
                if ((n & 7) == 6) {
                    return this.getWordFromCode();
                }
                return new byte[2];
            }
            case 1: {
                byte by = this.getByteFromCode();
                return new byte[]{Util.signExtend(by), by};
            }
            case 2: {
                return this.getWordFromCode();
            }
            case 3: {
                return new byte[2];
            }
        }
        logger.log(Level.WARNING, "[cpu] Addressbyte MM-bits do not match");
        return new byte[2];
    }

    protected byte[] decodeSSSMemDest(byte by, byte[] byArray) {
        switch (by & 7) {
            case 0: {
                return Util.addRegRegDisp(this.bx, this.si, byArray);
            }
            case 1: {
                return Util.addRegRegDisp(this.bx, this.di, byArray);
            }
            case 2: {
                return Util.addRegRegDisp(this.bp, this.si, byArray);
            }
            case 3: {
                return Util.addRegRegDisp(this.bp, this.di, byArray);
            }
            case 4: {
                return Util.addRegRegDisp(this.si, new byte[2], byArray);
            }
            case 5: {
                return Util.addRegRegDisp(this.di, new byte[2], byArray);
            }
            case 6: {
                if ((by & 0xC0) >> 6 == 0) {
                    return byArray;
                }
                return Util.addRegRegDisp(this.bp, new byte[2], byArray);
            }
            case 7: {
                return Util.addRegRegDisp(this.bx, new byte[2], byArray);
            }
        }
        logger.log(Level.WARNING, "[cpu] Addressbyte SSS-bits do not match");
        return new byte[]{0, 0};
    }

    protected byte[] decodeRegister(boolean bl, int n) {
        if (bl) {
            switch (n) {
                case 0: {
                    return this.ax;
                }
                case 1: {
                    return this.cx;
                }
                case 2: {
                    return this.dx;
                }
                case 3: {
                    return this.bx;
                }
                case 4: {
                    return this.sp;
                }
                case 5: {
                    return this.bp;
                }
                case 6: {
                    return this.si;
                }
                case 7: {
                    return this.di;
                }
            }
            logger.log(Level.WARNING, "[cpu] Addressbyte RRR/SSS-bits do not match");
            return new byte[2];
        }
        switch (n) {
            case 0: {
                return this.ax;
            }
            case 1: {
                return this.cx;
            }
            case 2: {
                return this.dx;
            }
            case 3: {
                return this.bx;
            }
            case 4: {
                return this.ax;
            }
            case 5: {
                return this.cx;
            }
            case 6: {
                return this.dx;
            }
            case 7: {
                return this.bx;
            }
        }
        logger.log(Level.WARNING, "[cpu] Addressbyte RRR/SSS-bits do not match");
        return new byte[2];
    }

    protected byte[] decodeExtraRegister(int n) {
        switch (n) {
            case 0: {
                return this.eax;
            }
            case 1: {
                return this.ecx;
            }
            case 2: {
                return this.edx;
            }
            case 3: {
                return this.ebx;
            }
            case 4: {
                return this.esp;
            }
            case 5: {
                return this.ebp;
            }
            case 6: {
                return this.esi;
            }
            case 7: {
                return this.edi;
            }
        }
        logger.log(Level.WARNING, "[cpu] Addressbyte RRR/SSS-bits do not match");
        return new byte[2];
    }

    protected byte[] decodeSegmentRegister(int n) {
        switch (n) {
            case 0: {
                return this.es;
            }
            case 1: {
                return this.cs;
            }
            case 2: {
                return this.ss;
            }
            case 3: {
                return this.ds;
            }
            case 4: {
                return new byte[2];
            }
            case 5: {
                return new byte[2];
            }
            case 6: {
                return new byte[2];
            }
            case 7: {
                return new byte[2];
            }
        }
        logger.log(Level.WARNING, "[cpu] Addressbyte RRR/SSS-bits do not match");
        return new byte[2];
    }

    private int getSegmentedCodeAddress() {
        return ((this.cs[0] & 0xFF) << 12) + ((this.cs[1] & 0xFF) << 4) + ((this.ip[0] & 0xFF) << 8) + (this.ip[1] & 0xFF);
    }

    private int getSegmentedCodeAddress(byte[] byArray) {
        return ((this.cs[0] & 0xFF) << 12) + ((this.cs[1] & 0xFF) << 4) + ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
    }

    private int getSegmentedDataAddress(byte[] byArray) {
        return ((this.ds[0] & 0xFF) << 12) + ((this.ds[1] & 0xFF) << 4) + ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
    }

    private int getSegmentedStackAddress() {
        return ((this.ss[0] & 0xFF) << 12) + ((this.ss[1] & 0xFF) << 4) + ((this.sp[0] & 0xFF) << 8) + (this.sp[1] & 0xFF);
    }

    private int getSegmentedStackAddress(byte[] byArray) {
        return ((this.ss[0] & 0xFF) << 12) + ((this.ss[1] & 0xFF) << 4) + ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
    }

    private int getSegmentedExtraAddress(byte[] byArray) {
        return ((this.es[0] & 0xFF) << 12) + ((this.es[1] & 0xFF) << 4) + ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
    }

    private byte[] convertStringToRegister(String string) {
        if (string.equalsIgnoreCase("AX")) {
            return this.ax;
        }
        if (string.equalsIgnoreCase("BX")) {
            return this.bx;
        }
        if (string.equalsIgnoreCase("CX")) {
            return this.cx;
        }
        if (string.equalsIgnoreCase("DX")) {
            return this.dx;
        }
        if (string.equalsIgnoreCase("SP")) {
            return this.sp;
        }
        if (string.equalsIgnoreCase("BP")) {
            return this.bp;
        }
        if (string.equalsIgnoreCase("SI")) {
            return this.si;
        }
        if (string.equalsIgnoreCase("DI")) {
            return this.di;
        }
        if (string.equalsIgnoreCase("CS")) {
            return this.cs;
        }
        if (string.equalsIgnoreCase("DS")) {
            return this.ds;
        }
        if (string.equalsIgnoreCase("SS")) {
            return this.ss;
        }
        if (string.equalsIgnoreCase("ES")) {
            return this.es;
        }
        if (string.equalsIgnoreCase("IP")) {
            return this.ip;
        }
        return null;
    }

    private void handleIRQ(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        this.setWordToStack(Util.booleansToBytes(this.flags));
        this.setWordToStack(this.cs);
        this.setWordToStack(this.ip);
        this.flags[9] = false;
        this.flags[8] = false;
        byArray[1] = 0;
        this.cs[1] = 0;
        byArray[0] = 0;
        this.cs[0] = 0;
        int n2 = n * 4;
        this.ip[1] = byArray2[1] = (byte)(n2 & 0xFF);
        this.ip[0] = byArray2[0] = (byte)(n2 >> 8 & 0xFF);
        byte[] byArray3 = this.getWordFromCode();
        byte[] byArray4 = this.getWordFromCode();
        this.cs[1] = byArray4[1];
        this.cs[0] = byArray4[0];
        this.ip[1] = byArray3[1];
        this.ip[0] = byArray3[0];
        this.flags[9] = false;
        logger.log(Level.CONFIG, "[cpu] Handling IRQ: IDT at IP=0x" + Util.convertWordToString(byArray2) + ", CS=0x" + Util.convertWordToString(byArray) + " and ISR at IP=0x" + Util.convertWordToString(byArray3) + ", CS=0x" + Util.convertWordToString(byArray4));
    }

    private int convertWordToInt(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        return n += byArray[0] << 8 & 0xFF00;
    }

    @Override
    public String getRegisterHex(int n) {
        switch (n) {
            case 0: {
                return Integer.toHexString(((this.cs[0] & 0xFF) << 8) + (this.cs[1] & 0xFF)).toUpperCase();
            }
            case 1: {
                return Integer.toHexString(((this.ip[0] & 0xFF) << 8) + (this.ip[1] & 0xFF)).toUpperCase();
            }
        }
        return "NULL";
    }

    @Override
    public boolean getCpuInstructionDebug() {
        return this.cpuInstructionDebug;
    }

    @Override
    public void setCpuInstructionDebug(boolean bl) {
        this.cpuInstructionDebug = bl;
    }

    public String startDebug() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("***************************\nBEFORE\n").append(this.registerDump());
        this.start();
        stringBuilder.append("***************************\nAFTER\n").append(this.registerDump());
        return stringBuilder.toString() + "***************************";
    }

    public String registerDump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ax=" + this.toHexString(this.ax)).append('\n');
        stringBuilder.append("eax=" + this.toHexString(this.eax)).append('\n');
        stringBuilder.append("bx=" + this.toHexString(this.bx)).append('\n');
        stringBuilder.append("ebx=" + this.toHexString(this.ebx)).append('\n');
        stringBuilder.append("cx=" + this.toHexString(this.cx)).append('\n');
        stringBuilder.append("ecx=" + this.toHexString(this.ecx)).append('\n');
        stringBuilder.append("dx=" + this.toHexString(this.dx)).append('\n');
        stringBuilder.append("edx=" + this.toHexString(this.edx)).append('\n');
        stringBuilder.append("sp=" + this.toHexString(this.sp)).append('\n');
        stringBuilder.append("esp=" + this.toHexString(this.esp)).append('\n');
        stringBuilder.append("bp=" + this.toHexString(this.bp)).append('\n');
        stringBuilder.append("ebp=" + this.toHexString(this.ebp)).append('\n');
        stringBuilder.append("si=" + this.toHexString(this.si)).append('\n');
        stringBuilder.append("esi=" + this.toHexString(this.esi)).append('\n');
        stringBuilder.append("di=" + this.toHexString(this.di)).append('\n');
        stringBuilder.append("edi=" + this.toHexString(this.edi)).append('\n');
        stringBuilder.append("cs=" + this.toHexString(this.cs)).append('\n');
        stringBuilder.append("ds=" + this.toHexString(this.ds)).append('\n');
        stringBuilder.append("ss=" + this.toHexString(this.ss)).append('\n');
        stringBuilder.append("es=" + this.toHexString(this.es)).append('\n');
        stringBuilder.append("ip=" + this.toHexString(this.ip)).append('\n');
        stringBuilder.append("oldIP=" + this.toHexString(this.oldIP)).append('\n');
        stringBuilder.append("flags=" + this.toHexString(this.flags)).append('\n');
        stringBuilder.append("cr0=" + this.toHexString(this.cr0)).append('\n');
        stringBuilder.append("cr1=" + this.toHexString(this.cr1)).append('\n');
        stringBuilder.append("cr2=" + this.toHexString(this.cr2)).append('\n');
        stringBuilder.append("cr3=" + this.toHexString(this.cr3)).append('\n');
        stringBuilder.append("cr4=" + this.toHexString(this.cr4)).append('\n');
        stringBuilder.append("gdtr=" + this.toHexString(this.gdtr)).append('\n');
        stringBuilder.append("idtr=" + this.toHexString(this.idtr)).append('\n');
        stringBuilder.append("ldtr=" + this.toHexString(this.ldtr)).append('\n');
        return stringBuilder.toString();
    }

    private String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "<<NULL>>";
        }
        if (byArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[" + this.byteToHex(byArray[0]));
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(", " + this.byteToHex(byArray[i]));
        }
        return stringBuilder.toString() + "]";
    }

    private String toHexString(boolean[] blArray) {
        if (blArray == null) {
            return "<<NULL>>";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[" + (blArray[0] ? "1" : "0"));
        for (int i = 1; i < blArray.length; ++i) {
            stringBuilder.append(", " + (blArray[i] ? "1" : "0"));
        }
        return stringBuilder.toString() + "]";
    }

    private String byteToHex(byte by) {
        String string = Integer.toHexString(by);
        string = string.length() == 1 ? "0" + string : string.substring(string.length() - 2);
        return "0x" + string;
    }

    static {
        WORD_0X0001 = new byte[]{0, 1};
    }
}

