/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_CMP_GbEb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceValue = 0;
    byte destinationValue = 0;
    byte registerHighLow = 0;
    byte tempResult = 0;

    public Instruction_CMP_GbEb() {
    }

    public Instruction_CMP_GbEb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.registerHighLow = (this.addressByte & 0x20) >> 5 == 0 ? (byte)1 : 0;
        this.destinationValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3)[this.registerHighLow];
        this.tempResult = (byte)(this.destinationValue - this.sourceValue);
        this.cpu.flags[4] = Util.test_AF_SUB(this.destinationValue, this.tempResult);
        this.cpu.flags[0] = Util.test_CF_SUB(this.destinationValue, this.sourceValue, 0);
        this.cpu.flags[11] = Util.test_OF_SUB(this.destinationValue, this.sourceValue, this.tempResult, 0);
        this.cpu.flags[6] = this.tempResult == 0;
        this.cpu.flags[7] = this.tempResult < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
    }
}

