/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_IN_eAXDX
implements Instruction {
    private CPU cpu;
    byte data;
    int portAddress;
    private static final Logger logger = Logger.getLogger(Instruction_IN_eAXDX.class.getName());

    public Instruction_IN_eAXDX() {
    }

    public Instruction_IN_eAXDX(CPU cPU) {
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
        try {
            if (this.cpu.doubleWord) {
                byte[] byArray = this.cpu.getIOPortDoubleWord(this.portAddress);
                this.cpu.ax[1] = byArray[3];
                this.cpu.ax[0] = byArray[2];
                this.cpu.eax[1] = byArray[1];
                this.cpu.eax[0] = byArray[0];
            } else {
                byte[] byArray = this.cpu.getIOPortWord(this.portAddress);
                this.cpu.ax[1] = byArray[1];
                this.cpu.ax[0] = byArray[0];
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[" + this.cpu.getType() + "] " + moduleException.getMessage());
        }
    }
}

