/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ImmGRP1_EbIb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceByte = 0;
    byte destByte = 0;
    byte oldDest = 0;
    byte[] destinationRegister = new byte[2];
    byte registerHighLow = 0;
    int iCarryFlag = 0;
    byte tempResult = 0;
    byte tempResultByte = 0;

    public Instruction_ImmGRP1_EbIb() {
    }

    public Instruction_ImmGRP1_EbIb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceByte = this.cpu.getByteFromCode();
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.oldDest = this.destinationRegister[this.registerHighLow];
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] + this.sourceByte);
                    this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest, this.destinationRegister[this.registerHighLow]);
                    this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceByte, 0);
                    this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceByte, this.destinationRegister[this.registerHighLow], 0);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.oldDest = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult = (byte)(this.sourceByte + this.oldDest);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest, this.tempResult);
                this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceByte, 0);
                this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceByte, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult == 0;
                this.cpu.flags[7] = this.tempResult < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
                break;
            }
            case 1: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] | this.sourceByte);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.destByte = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.destByte = (byte)(this.destByte | this.sourceByte);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.destByte);
                this.cpu.flags[6] = this.destByte == 0;
                this.cpu.flags[7] = this.destByte < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.destByte);
                break;
            }
            case 2: {
                this.iCarryFlag = (byte)(this.cpu.flags[0] ? 1 : 0);
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.oldDest = this.destinationRegister[this.registerHighLow];
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] + (this.sourceByte + this.iCarryFlag));
                    this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest, this.destinationRegister[this.registerHighLow]);
                    this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceByte, this.iCarryFlag);
                    this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceByte, this.destinationRegister[this.registerHighLow], this.iCarryFlag);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.destByte = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResultByte = (byte)(this.destByte + (this.sourceByte + this.iCarryFlag));
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResultByte);
                this.cpu.flags[4] = Util.test_AF_ADD(this.destByte, this.tempResultByte);
                this.cpu.flags[0] = Util.test_CF_ADD(this.destByte, this.sourceByte, this.iCarryFlag);
                this.cpu.flags[11] = Util.test_OF_ADD(this.destByte, this.sourceByte, this.tempResultByte, 0);
                this.cpu.flags[6] = this.tempResultByte == 0;
                this.cpu.flags[7] = this.tempResultByte < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResultByte);
                break;
            }
            case 3: {
                int n = this.iCarryFlag = this.cpu.flags[0] ? 1 : 0;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.oldDest = this.destinationRegister[this.registerHighLow];
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] - (this.sourceByte + this.iCarryFlag));
                    this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest, this.destinationRegister[this.registerHighLow]);
                    this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceByte, this.iCarryFlag);
                    this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceByte, this.destinationRegister[this.registerHighLow], this.iCarryFlag);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.oldDest = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.destByte = (byte)(this.oldDest - (this.sourceByte + this.iCarryFlag) & 0xFF);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.destByte);
                this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest, this.destByte);
                this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceByte, this.iCarryFlag);
                this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceByte, this.destByte, this.iCarryFlag);
                this.cpu.flags[6] = this.destByte == 0;
                this.cpu.flags[7] = this.destByte < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.destByte);
                break;
            }
            case 4: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] & this.sourceByte);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.tempResult = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult = (byte)(this.tempResult & this.sourceByte);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.tempResult == 0;
                this.cpu.flags[7] = this.tempResult < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
                break;
            }
            case 5: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.oldDest = this.destinationRegister[this.registerHighLow];
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] - this.sourceByte);
                    this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest, this.destinationRegister[this.registerHighLow]);
                    this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceByte, 0);
                    this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceByte, this.destinationRegister[this.registerHighLow], 0);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.oldDest = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.destByte = (byte)(this.oldDest - this.sourceByte);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.destByte);
                this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest, this.destByte);
                this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceByte, 0);
                this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceByte, this.destByte, 0);
                this.cpu.flags[6] = this.destByte == 0;
                this.cpu.flags[7] = this.destByte < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.destByte);
                break;
            }
            case 6: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    byte by = this.registerHighLow;
                    this.destinationRegister[by] = (byte)(this.destinationRegister[by] ^ this.sourceByte);
                    this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
                    this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
                    this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.tempResult = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.tempResult = (byte)(this.tempResult ^ this.sourceByte);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.tempResult);
                this.cpu.flags[6] = this.tempResult == 0;
                this.cpu.flags[7] = this.tempResult < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
                break;
            }
            case 7: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.oldDest = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 1;
                    this.oldDest = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.tempResult = (byte)(this.oldDest - this.sourceByte);
                this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest, this.tempResult);
                this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.sourceByte, 0);
                this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.sourceByte, this.tempResult, 0);
                this.cpu.flags[6] = this.tempResult == 0;
                this.cpu.flags[7] = this.tempResult < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
                break;
            }
            default: {
                throw new CPUInstructionException("Immediate Group 1 (0x80) instruction no case match.");
            }
        }
    }
}

