/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ReplacementBlockTrigger;

public class AbstractCodeBlockWrapper
implements CodeBlock {
    private static long nextBlockIndex = 0L;
    private long blockIndex = nextBlockIndex++;
    private CodeBlock actualBlock;

    public AbstractCodeBlockWrapper(CodeBlock codeBlock) {
        this.actualBlock = codeBlock;
    }

    @Override
    public final int getX86Length() {
        return this.actualBlock.getX86Length();
    }

    @Override
    public final int getX86Count() {
        return this.actualBlock.getX86Count();
    }

    @Override
    public int execute(Processor processor) {
        return this.actualBlock.execute(processor);
    }

    @Override
    public String getDisplayString() {
        return "WRAP[" + this.blockIndex + "] " + this.actualBlock.getDisplayString();
    }

    public final void setBlock(CodeBlock codeBlock) {
        this.actualBlock = codeBlock;
    }

    public final CodeBlock getBlock() {
        return this.actualBlock;
    }

    public final long getBlockIndex() {
        return this.blockIndex;
    }

    @Override
    public boolean handleMemoryRegionChange(int n, int n2) {
        return this.actualBlock.handleMemoryRegionChange(n, n2);
    }

    void replaceInOwner(CodeBlock codeBlock) {
        this.setBlock(new ReplacementBlockTrigger(codeBlock));
    }
}

