/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleDevice;
import dioscuri.module.cpu32.DMATransferCapable;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.IOPortCapable;
import dioscuri.module.cpu32.IOPortHandler;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DMAController
extends ModuleDevice
implements IOPortCapable,
HardwareComponent {
    private static final int pagePortList0 = 1;
    private static final int pagePortList1 = 2;
    private static final int pagePortList2 = 3;
    private static final int pagePortList3 = 7;
    private static final int[] pagePortList = new int[]{1, 2, 3, 7};
    private static final int CMD_MEMORY_TO_MEMORY = 1;
    private static final int CMD_FIXED_ADDRESS = 2;
    private static final int CMD_BLOCK_CONTROLLER = 4;
    private static final int CMD_COMPRESSED_TIME = 8;
    private static final int CMD_CYCLIC_PRIORITY = 16;
    private static final int CMD_EXTENDED_WRITE = 32;
    private static final int CMD_LOW_DREQ = 64;
    private static final int CMD_LOW_DACK = 128;
    private static final int CMD_NOT_SUPPORTED = 251;
    private int status;
    private int command;
    private int mask;
    private boolean flipFlop;
    private int dShift;
    private int iobase;
    private int pageBase;
    private int pageHBase;
    private int controllerNumber;
    private PhysicalAddressSpace memory;
    private DMARegister[] dmaRegs;
    private static final int[] channels = new int[]{-1, 2, 3, 1, -1, -1, -1, 0};
    private boolean ioportRegistered = false;

    public DMAController(boolean bl, boolean bl2) {
        this.dShift = bl2 ? 0 : 1;
        this.iobase = bl2 ? 0 : 192;
        int n = this.pageBase = bl2 ? 128 : 136;
        this.pageHBase = bl ? (bl2 ? 1152 : 1160) : -1;
        this.controllerNumber = bl2 ? 0 : 1;
        this.dmaRegs = new DMARegister[4];
        for (int i = 0; i < 4; ++i) {
            this.dmaRegs[i] = new DMARegister();
        }
        this.reset();
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.status);
        dataOutput.writeInt(this.command);
        dataOutput.writeInt(this.mask);
        dataOutput.writeBoolean(this.flipFlop);
        dataOutput.writeInt(this.dShift);
        dataOutput.writeInt(this.iobase);
        dataOutput.writeInt(this.pageBase);
        dataOutput.writeInt(this.pageHBase);
        dataOutput.writeInt(this.controllerNumber);
        dataOutput.writeInt(this.dmaRegs.length);
        for (int i = 0; i < this.dmaRegs.length; ++i) {
            this.dmaRegs[i].dumpState(dataOutput);
        }
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        this.ioportRegistered = false;
        this.status = dataInput.readInt();
        this.command = dataInput.readInt();
        this.mask = dataInput.readInt();
        this.flipFlop = dataInput.readBoolean();
        this.dShift = dataInput.readInt();
        this.iobase = dataInput.readInt();
        this.pageBase = dataInput.readInt();
        this.pageHBase = dataInput.readInt();
        this.controllerNumber = dataInput.readInt();
        int n = dataInput.readInt();
        this.dmaRegs = new DMARegister[n];
        for (int i = 0; i < this.dmaRegs.length; ++i) {
            this.dmaRegs[i] = new DMARegister();
            this.dmaRegs[i].loadState(dataInput);
        }
    }

    public boolean isFirst() {
        return this.dShift == 0;
    }

    @Override
    public boolean reset() {
        for (int i = 0; i < this.dmaRegs.length; ++i) {
            this.dmaRegs[i].reset();
        }
        this.writeController(13 << this.dShift, 0);
        this.memory = null;
        this.ioportRegistered = false;
        return true;
    }

    private void writeChannel(int n, int n2) {
        int n3 = n >>> this.dShift & 0xF;
        int n4 = n3 >>> 1;
        DMARegister dMARegister = this.dmaRegs[n4];
        if (this.getFlipFlop()) {
            if ((n3 & 1) == 0) {
                dMARegister.baseAddress = (short)(dMARegister.baseAddress & 0xFF | n2 << 8 & 0xFF00);
            } else {
                dMARegister.baseCount = (short)(dMARegister.baseCount & 0xFF | n2 << 8 & 0xFF00);
            }
            this.initChannel(n4);
        } else if ((n3 & 1) == 0) {
            dMARegister.baseAddress = (short)(dMARegister.baseAddress & 0xFF00 | n2 & 0xFF);
        } else {
            dMARegister.baseCount = (short)(dMARegister.baseCount & 0xFF00 | n2 & 0xFF);
        }
    }

    private void writeController(int n, int n2) {
        int n3 = n >>> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                if (n2 != 0 && (n2 & 0xFB) != 0) break;
                this.command = n2;
                break;
            }
            case 9: {
                int n4 = n2 & 3;
                this.status = (n2 & 4) != 0 ? (this.status |= 1 << n4 + 4) : (this.status &= ~(1 << n4 + 4));
                this.status &= ~(1 << n4);
                this.runTransfers();
                break;
            }
            case 10: {
                if ((n2 & 4) != 0) {
                    this.mask |= 1 << (n2 & 3);
                    break;
                }
                this.mask &= ~(1 << (n2 & 3));
                this.runTransfers();
                break;
            }
            case 11: {
                int n5 = n2 & 3;
                this.dmaRegs[n5].mode = n2;
                break;
            }
            case 12: {
                this.flipFlop = false;
                break;
            }
            case 13: {
                this.flipFlop = false;
                this.mask = -1;
                this.status = 0;
                this.command = 0;
                break;
            }
            case 14: {
                this.mask = 0;
                this.runTransfers();
                break;
            }
            case 15: {
                this.mask = n2;
                this.runTransfers();
                break;
            }
        }
    }

    private void writePage(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaRegs[n3].page = (byte)n2;
    }

    private void writePageH(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaRegs[n3].pageh = (byte)n2;
    }

    private int readChannel(int n) {
        int n2 = n >>> this.dShift & 0xF;
        int n3 = n2 >>> 1;
        int n4 = n2 & 1;
        DMARegister dMARegister = this.dmaRegs[n3];
        int n5 = (dMARegister.mode & 0x20) == 0 ? 1 : -1;
        boolean bl = this.getFlipFlop();
        int n6 = n4 != 0 ? ((0xFFFF & dMARegister.baseCount) << this.dShift) - dMARegister.nowCount : dMARegister.nowAddress + dMARegister.nowCount * n5;
        return n6 >>> this.dShift + (bl ? 8 : 0) & 0xFF;
    }

    private int readController(int n) {
        int n2;
        int n3 = n >>> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                n2 = this.status;
                this.status &= 0xF0;
                break;
            }
            case 15: {
                n2 = this.mask;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private int readPage(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return 0xFF & this.dmaRegs[n2].page;
    }

    private int readPageH(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return 0xFF & this.dmaRegs[n2].pageh;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n - this.iobase >>> this.dShift) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeChannel(n, n2);
                return;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.writeController(n, n2);
                return;
            }
        }
        switch (n - this.pageBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePage(n, n2);
                return;
            }
        }
        switch (n - this.pageHBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePageH(n, n2);
                return;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >>> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    @Override
    public int ioPortReadByte(int n) {
        switch (n - this.iobase >>> this.dShift) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.readChannel(n);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.readController(n);
            }
        }
        switch (n - this.pageBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPage(n);
            }
        }
        switch (n - this.pageHBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPageH(n);
            }
        }
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 8 & 0xFF;
    }

    @Override
    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 16 & 0xFFFF;
    }

    @Override
    public int[] ioPortsRequested() {
        int n;
        int[] nArray = this.pageHBase >= 0 ? new int[16 + 2 * pagePortList.length] : new int[16 + pagePortList.length];
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.iobase + (n << this.dShift);
        }
        for (n = 0; n < pagePortList.length; ++n) {
            nArray[n2++] = this.pageBase + pagePortList[n];
            if (this.pageHBase < 0) continue;
            nArray[n2++] = this.pageHBase + pagePortList[n];
        }
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.iobase + (n + 8 << this.dShift);
        }
        return nArray;
    }

    private boolean getFlipFlop() {
        boolean bl = this.flipFlop;
        this.flipFlop = !bl;
        return bl;
    }

    private void initChannel(int n) {
        DMARegister dMARegister = this.dmaRegs[n];
        dMARegister.nowAddress = (0xFFFF & dMARegister.baseAddress) << this.dShift;
        dMARegister.nowCount = 0;
    }

    public void runTransfers() {
        int n;
        int n2 = ~this.mask & this.status >>> 4 & 0xF;
        if (n2 == 0) {
            return;
        }
        while (n2 != 0 && (n = Integer.numberOfTrailingZeros(n2)) < 4) {
            this.runChannel(n);
            n2 &= ~(1 << n);
        }
    }

    private void runChannel(int n) {
        int n2;
        DMARegister dMARegister = this.dmaRegs[n];
        dMARegister.nowCount = n2 = dMARegister.transferDevice.transferHandler(n + (this.controllerNumber << 2), dMARegister.nowCount, dMARegister.baseCount + 1 << this.controllerNumber);
    }

    public int getChannelMode(int n) {
        return this.dmaRegs[n].mode;
    }

    public void holdDREQ(int n) {
        this.status |= 1 << n + 4;
        this.runTransfers();
    }

    public void releaseDREQ(int n) {
        this.status &= ~(1 << n + 4);
    }

    public void registerChannel(int n, DMATransferCapable dMATransferCapable) {
        this.dmaRegs[n].transferDevice = dMATransferCapable;
    }

    public int readMemory(int n, byte[] byArray, int n2, int n3, int n4) {
        DMARegister dMARegister = this.dmaRegs[n];
        long l = ((long)dMARegister.pageh & 0x7FL) << 24 | (0xFFL & (long)dMARegister.page) << 16 | 0xFFFFFFFFL & (long)dMARegister.nowAddress;
        if ((dMARegister.mode & 0x20) != 0) {
            System.err.println("DMA Read In Address Decrement Mode!");
            this.memory.copyContentsInto((int)(l - (long)n3 - (long)n4), byArray, n2, n4);
            int n5 = n2;
            for (int i = n2 + n4 - 1; n5 < i; ++n5, --i) {
                byte by = byArray[n5];
                byArray[n5] = byArray[i];
                byArray[i] = by;
            }
        } else {
            this.memory.copyContentsInto((int)(l + (long)n3), byArray, n2, n4);
        }
        return n4;
    }

    public int writeMemory(int n, byte[] byArray, int n2, int n3, int n4) {
        DMARegister dMARegister = this.dmaRegs[n];
        long l = (0x7FL & (long)dMARegister.pageh) << 24 | (0xFFL & (long)dMARegister.page) << 16 | 0xFFFFFFFFL & (long)dMARegister.nowAddress;
        if ((dMARegister.mode & 0x20) != 0) {
            System.err.println("DMA Write In Address Decrement Mode!");
            int n5 = n2;
            for (int i = n2 + n4 - 1; n5 < i; ++n5, --i) {
                byte by = byArray[n5];
                byArray[n5] = byArray[i];
                byArray[i] = by;
            }
            this.memory.copyContentsFrom((int)(l - (long)n3 - (long)n4), byArray, n2, n4);
        } else {
            this.memory.copyContentsFrom((int)(l + (long)n3), byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public boolean initialised() {
        return this.memory != null && this.ioportRegistered;
    }

    @Override
    public boolean updated() {
        return this.memory.updated() && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.memory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof IOPortHandler) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public void timerCallback() {
    }

    public String toString() {
        return "DMA Controller [element " + this.dShift + "]";
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, ModuleUnknownPort, ModuleWriteOnlyPortException {
        int n2 = this.ioPortReadByte(n);
        return (byte)n2;
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleUnknownPort, ModuleWriteOnlyPortException {
        int n2 = this.ioPortReadWord(n);
        return new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleUnknownPort, ModuleWriteOnlyPortException {
        int n2 = this.ioPortReadLong(n);
        return new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, ModuleUnknownPort {
        this.ioPortWriteByte(n, by);
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException, ModuleUnknownPort {
        this.ioPortWriteLong(n, ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException, ModuleUnknownPort {
        this.ioPortWriteLong(n, ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF));
    }

    public void notImplemented() {
        System.out.println("[DMAController]: ModuleDevice method not implemented");
    }

    @Override
    public int getUpdateInterval() {
        this.notImplemented();
        return 0;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.notImplemented();
    }

    @Override
    public void update() {
        this.notImplemented();
    }

    @Override
    public String[] getConnection() {
        this.notImplemented();
        return null;
    }

    @Override
    public byte[] getData(Module module) {
        this.notImplemented();
        return null;
    }

    @Override
    public boolean getDebugMode() {
        this.notImplemented();
        return false;
    }

    @Override
    public String getDump() {
        this.notImplemented();
        return null;
    }

    @Override
    public int getID() {
        this.notImplemented();
        return 0;
    }

    @Override
    public String getName() {
        this.notImplemented();
        return null;
    }

    @Override
    public String getType() {
        this.notImplemented();
        return null;
    }

    @Override
    public boolean isConnected() {
        this.notImplemented();
        return false;
    }

    @Override
    public boolean isObserved() {
        this.notImplemented();
        return false;
    }

    @Override
    public boolean setConnection(Module module) {
        this.notImplemented();
        return false;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        this.notImplemented();
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        this.notImplemented();
        return false;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.notImplemented();
    }

    @Override
    public void setObserved(boolean bl) {
        this.notImplemented();
    }

    @Override
    public void start() {
        this.notImplemented();
    }

    @Override
    public void stop() {
        this.notImplemented();
    }

    static class DMARegister {
        public static final int ADDRESS = 0;
        public static final int COUNT = 1;
        public int nowAddress;
        public int nowCount;
        public short baseAddress;
        public short baseCount;
        public int mode;
        public byte page;
        public byte pageh;
        public byte dack;
        public byte eop;
        public DMATransferCapable transferDevice;

        public void dumpState(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.nowAddress);
            dataOutput.writeInt(this.nowCount);
            dataOutput.writeShort(this.baseAddress);
            dataOutput.writeShort(this.baseCount);
            dataOutput.writeInt(this.mode);
            dataOutput.writeByte(this.page);
            dataOutput.writeByte(this.pageh);
            dataOutput.writeByte(this.dack);
            dataOutput.writeByte(this.eop);
        }

        public void loadState(DataInput dataInput) throws IOException {
            this.nowAddress = dataInput.readInt();
            this.nowCount = dataInput.readInt();
            this.baseAddress = dataInput.readShort();
            this.baseCount = dataInput.readShort();
            this.mode = dataInput.readInt();
            this.page = dataInput.readByte();
            this.pageh = dataInput.readByte();
            this.dack = dataInput.readByte();
            this.eop = dataInput.readByte();
        }

        public void reset() {
            this.transferDevice = null;
            this.mode = 0;
            this.nowCount = 0;
            this.nowAddress = 0;
            this.baseCount = 0;
            this.baseAddress = 0;
            this.eop = 0;
            this.dack = 0;
            this.pageh = 0;
            this.page = 0;
        }
    }
}

