/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.FpuState;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FpuState64
extends FpuState {
    public static final int FPU_SPECIAL_TAG_NONE = 0;
    public static final int FPU_SPECIAL_TAG_NAN = 1;
    public static final int FPU_SPECIAL_TAG_UNSUPPORTED = 2;
    public static final int FPU_SPECIAL_TAG_INFINITY = 3;
    public static final int FPU_SPECIAL_TAG_DENORMAL = 4;
    public static final int FPU_SPECIAL_TAG_SNAN = 5;
    public static final double UNDERFLOW_THRESHOLD = Math.pow(2.0, -1022.0);
    private final Processor cpu;
    double[] data;
    int[] tag;
    int[] specialTag;
    private int statusWord;
    private boolean invalidOperation;
    private boolean denormalizedOperand;
    private boolean zeroDivide;
    private boolean overflow;
    private boolean underflow;
    private boolean precision;
    private boolean stackFault;
    private int maskWord;
    private int precisionControl;
    private int roundingControl;

    public FpuState64(Processor processor) {
        this.cpu = processor;
        this.data = new double[8];
        this.tag = new int[8];
        this.specialTag = new int[8];
        this.init();
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeInt(this.statusWord);
        dataOutput.writeInt(this.maskWord);
        dataOutput.writeInt(this.precisionControl);
        dataOutput.writeInt(this.roundingControl);
        dataOutput.writeBoolean(this.invalidOperation);
        dataOutput.writeBoolean(this.denormalizedOperand);
        dataOutput.writeBoolean(this.zeroDivide);
        dataOutput.writeBoolean(this.overflow);
        dataOutput.writeBoolean(this.underflow);
        dataOutput.writeBoolean(this.precision);
        dataOutput.writeBoolean(this.stackFault);
        dataOutput.writeInt(this.data.length);
        for (n = 0; n < this.data.length; ++n) {
            dataOutput.writeDouble(this.data[n]);
        }
        dataOutput.writeInt(this.tag.length);
        for (n = 0; n < this.tag.length; ++n) {
            dataOutput.writeInt(this.tag[n]);
        }
        dataOutput.writeInt(this.specialTag.length);
        for (n = 0; n < this.specialTag.length; ++n) {
            dataOutput.writeInt(this.specialTag[n]);
        }
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        int n;
        this.statusWord = dataInput.readInt();
        this.maskWord = dataInput.readInt();
        this.precisionControl = dataInput.readInt();
        this.roundingControl = dataInput.readInt();
        this.invalidOperation = dataInput.readBoolean();
        this.denormalizedOperand = dataInput.readBoolean();
        this.zeroDivide = dataInput.readBoolean();
        this.overflow = dataInput.readBoolean();
        this.underflow = dataInput.readBoolean();
        this.precision = dataInput.readBoolean();
        this.stackFault = dataInput.readBoolean();
        int n2 = dataInput.readInt();
        this.data = new double[n2];
        for (n = 0; n < this.data.length; ++n) {
            this.data[n] = dataInput.readDouble();
        }
        n2 = dataInput.readInt();
        this.tag = new int[n2];
        for (n = 0; n < this.tag.length; ++n) {
            this.tag[n] = dataInput.readInt();
        }
        n2 = dataInput.readInt();
        this.specialTag = new int[n2];
        for (n = 0; n < this.specialTag.length; ++n) {
            this.specialTag[n] = dataInput.readInt();
        }
    }

    @Override
    public boolean getInvalidOperation() {
        return (this.statusWord & 1) != 0;
    }

    @Override
    public boolean getDenormalizedOperand() {
        return (this.statusWord & 2) != 0;
    }

    @Override
    public boolean getZeroDivide() {
        return (this.statusWord & 4) != 0;
    }

    @Override
    public boolean getOverflow() {
        return (this.statusWord & 8) != 0;
    }

    @Override
    public boolean getUnderflow() {
        return (this.statusWord & 0x10) != 0;
    }

    @Override
    public boolean getPrecision() {
        return (this.statusWord & 0x20) != 0;
    }

    @Override
    public boolean getStackFault() {
        return (this.statusWord & 0x40) != 0;
    }

    @Override
    public void setInvalidOperation() {
        this.statusWord |= 1;
    }

    @Override
    public void setDenormalizedOperand() {
        this.statusWord |= 2;
    }

    @Override
    public void setZeroDivide() {
        this.statusWord |= 4;
    }

    @Override
    public void setOverflow() {
        this.statusWord |= 8;
    }

    @Override
    public void setUnderflow() {
        this.statusWord |= 0x10;
    }

    @Override
    public void setPrecision() {
        this.statusWord |= 0x20;
    }

    @Override
    public void setStackFault() {
        this.statusWord |= 0x40;
    }

    @Override
    public boolean getBusy() {
        return this.getErrorSummaryStatus();
    }

    @Override
    public boolean getErrorSummaryStatus() {
        return (this.statusWord & 0x3F & ~this.maskWord) != 0;
    }

    @Override
    public void checkExceptions() throws ProcessorException {
        if (this.getErrorSummaryStatus()) {
            this.cpu.reportFPUException();
        }
    }

    @Override
    public void clearExceptions() {
        this.statusWord = 0;
    }

    @Override
    public boolean getInvalidOperationMask() {
        return (this.maskWord & 1) != 0;
    }

    @Override
    public boolean getDenormalizedOperandMask() {
        return (this.maskWord & 2) != 0;
    }

    @Override
    public boolean getZeroDivideMask() {
        return (this.maskWord & 4) != 0;
    }

    @Override
    public boolean getOverflowMask() {
        return (this.maskWord & 8) != 0;
    }

    @Override
    public boolean getUnderflowMask() {
        return (this.maskWord & 0x10) != 0;
    }

    @Override
    public boolean getPrecisionMask() {
        return (this.maskWord & 0x20) != 0;
    }

    @Override
    public int getPrecisionControl() {
        return this.precisionControl;
    }

    @Override
    public int getRoundingControl() {
        return this.roundingControl;
    }

    @Override
    public void setInvalidOperationMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 1) : (this.maskWord &= 0xFFFFFFFE);
    }

    @Override
    public void setDenormalizedOperandMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 2) : (this.maskWord &= 0xFFFFFFFD);
    }

    @Override
    public void setZeroDivideMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 4) : (this.maskWord &= 0xFFFFFFFB);
    }

    @Override
    public void setOverflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 8) : (this.maskWord &= 0xFFFFFFF7);
    }

    @Override
    public void setUnderflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x10) : (this.maskWord &= 0xFFFFFFEF);
    }

    @Override
    public void setPrecisionMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x20) : (this.maskWord &= 0xFFFFFFDF);
    }

    @Override
    public void setAllMasks(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x3F) : 0;
    }

    @Override
    public void setPrecisionControl(int n) {
        if (n != 2) {
            System.err.println("WARNING:  attempt to set non-double FP precision in Fpu64 mode");
        }
        this.precisionControl = 2;
    }

    @Override
    public void setRoundingControl(int n) {
        if (n != 0) {
            System.err.println("WARNING:  attempt to set non-nearest rounding in Fpu64 mode");
        }
        this.roundingControl = 0;
    }

    @Override
    public void init() {
        int n;
        for (n = 0; n < 8; ++n) {
            this.tag[n] = 3;
        }
        for (n = 0; n < 8; ++n) {
            this.specialTag[n] = 0;
        }
        this.clearExceptions();
        this.conditionCode = 0;
        this.top = 0;
        this.setAllMasks(true);
        this.infinityControl = false;
        this.setPrecisionControl(2);
        this.setRoundingControl(0);
        this.lastOpcode = 0;
        this.lastIP = this.lastData = (long)0;
    }

    public int tagCode(double d) {
        if (d == 0.0) {
            return 1;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return 2;
        }
        return 0;
    }

    public static boolean isDenormal(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 0) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        return l2 != 0L;
    }

    public static boolean isSNaN(long l) {
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 2047) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if ((l2 & 0x8000000000000L) != 0L) {
            return false;
        }
        return l2 != 0L;
    }

    public static int specialTagCode(double d) {
        if (Double.isNaN(d)) {
            return 1;
        }
        if (Double.isInfinite(d)) {
            return 3;
        }
        if (FpuState64.isDenormal(d)) {
            return 4;
        }
        return 0;
    }

    @Override
    public void push(double d) throws ProcessorException {
        if (--this.top < 0) {
            this.top = 7;
        }
        if (this.tag[this.top] != 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode |= 2;
            this.checkExceptions();
        }
        this.data[this.top] = d;
        this.tag[this.top] = this.tagCode(d);
        this.specialTag[this.top] = FpuState64.specialTagCode(d);
    }

    @Override
    public double pop() throws ProcessorException {
        if (this.tag[this.top] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[this.top] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        double d = this.data[this.top];
        this.tag[this.top] = 3;
        if (++this.top >= 8) {
            this.top = 0;
        }
        return d;
    }

    @Override
    public double ST(int n) throws ProcessorException {
        int n2 = this.top + n & 7;
        if (this.tag[n2] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[n2] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        return this.data[n2];
    }

    @Override
    public int getTag(int n) {
        int n2 = this.top + n & 7;
        return this.tag[n2];
    }

    public int getSpecialTag(int n) {
        int n2 = this.top + n & 7;
        return this.specialTag[n2];
    }

    @Override
    public void setST(int n, double d) {
        int n2 = this.top + n & 7;
        this.data[n2] = d;
        this.tag[n2] = this.tagCode(d);
        this.specialTag[n2] = FpuState64.specialTagCode(d);
    }

    @Override
    public int getStatus() {
        int n = this.statusWord;
        if (this.getErrorSummaryStatus()) {
            n |= 0x80;
        }
        if (this.getBusy()) {
            n |= 0x8000;
        }
        n |= this.top << 11;
        n |= (this.conditionCode & 7) << 8;
        return n |= (this.conditionCode & 8) << 11;
    }

    @Override
    public void setStatus(int n) {
        this.statusWord &= 0xFFFFFF80;
        this.statusWord |= n & 0x7F;
        this.top = n >> 11 & 7;
        this.conditionCode = n >> 8 & 7;
        this.conditionCode |= n >>> 14 & 1;
    }

    @Override
    public int getControl() {
        int n = this.maskWord;
        n |= (this.precisionControl & 3) << 8;
        n |= (this.roundingControl & 3) << 10;
        if (this.infinityControl) {
            n |= 0x1000;
        }
        return n;
    }

    @Override
    public void setControl(int n) {
        this.maskWord &= 0xFFFFFFC0;
        this.maskWord |= n & 0x3F;
        this.infinityControl = (n & 0x1000) != 0;
        this.setPrecisionControl(n >> 8 & 3);
        this.setRoundingControl(n >> 10 & 3);
    }

    @Override
    public int getTagWord() {
        int n = 0;
        for (int i = 7; i >= 0; --i) {
            n = n << 2 | this.tag[i] & 3;
        }
        return n;
    }

    @Override
    public void setTagWord(int n) {
        for (int i = 0; i < 8; ++i) {
            int n2 = n & 3;
            if (n2 == 3) {
                this.tag[i] = 3;
            } else {
                this.tag[i] = this.tagCode(this.data[i]);
                if (this.specialTag[i] != 5) {
                    this.specialTag[i] = FpuState64.specialTagCode(this.data[i]);
                }
            }
            n >>= 2;
        }
    }

    public static byte[] doubleToExtended(double d, boolean bl) {
        byte[] byArray = new byte[10];
        long l = 0L;
        int n = 0;
        if (bl) {
            l = -4611686018427387904L;
        } else {
            long l2 = Double.doubleToRawLongBits(d);
            l = l2 & 0xFFFFFL;
            n = (int)(l2 >> 52) & 0x7FF;
            boolean bl2 = (l2 & Integer.MIN_VALUE) != 0L;
            l |= 0x100000L;
            l <<= 11;
            n += 15360;
            if (bl2) {
                n |= 0x8000;
            }
        }
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        byArray[8] = (byte)n;
        byArray[9] = (byte)(n >>> 8);
        return byArray;
    }

    public static int specialTagCode(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = (byArray[9] & 0x80) != 0;
        boolean bl3 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                return 4;
            }
            return 4;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return 2;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return 3;
                }
                if (l >>> 62 == 0L) {
                    return 5;
                }
                return 1;
            }
            return 2;
        }
        if (bl) {
            return 0;
        }
        return 2;
    }

    public static double extendedToDouble(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = (byArray[9] & 0x80) != 0;
        boolean bl3 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                n = 1;
            }
            return 0.0;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return Double.NaN;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
        if (bl) {
            l >>>= 11;
            if ((n -= 15360) > 2047) {
                return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (n < 0) {
                l >>>= -n;
                n = 0;
            }
            l &= 0xFFFFFFFFFFFFFL;
            l |= ((long)n & 0x7FFL) << 52;
            if (bl2) {
                l |= Integer.MIN_VALUE;
            }
            return Double.longBitsToDouble(l);
        }
        return Double.NaN;
    }
}

