/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModulePIC;
import dioscuri.module.cpu32.AlignmentCheckedAddressSpace;
import dioscuri.module.cpu32.FpuState;
import dioscuri.module.cpu32.FpuState64;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.IOPortHandler;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.ModeSwitchException;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.Segment;
import dioscuri.module.cpu32.SegmentFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class Processor
extends ModuleCPU
implements HardwareComponent {
    public static final int STATE_VERSION = 1;
    public static final int STATE_MINOR_VERSION = 0;
    public static final int CLOCK_SPEED = 50;
    public static final int IFLAGS_HARDWARE_INTERRUPT = 1;
    public static final int IFLAGS_PROCESSOR_EXCEPTION = 2;
    public static final int IFLAGS_RESET_REQUEST = 4;
    public static final int PROC_EXCEPTION_DE = 0;
    public static final int PROC_EXCEPTION_DB = 1;
    public static final int PROC_EXCEPTION_BP = 3;
    public static final int PROC_EXCEPTION_OF = 4;
    public static final int PROC_EXCEPTION_BR = 5;
    public static final int PROC_EXCEPTION_UD = 6;
    public static final int PROC_EXCEPTION_NM = 7;
    public static final int PROC_EXCEPTION_DF = 8;
    public static final int PROC_EXCEPTION_MF_09 = 9;
    public static final int PROC_EXCEPTION_TS = 10;
    public static final int PROC_EXCEPTION_NP = 11;
    public static final int PROC_EXCEPTION_SS = 12;
    public static final int PROC_EXCEPTION_GP = 13;
    public static final int PROC_EXCEPTION_PF = 14;
    public static final int PROC_EXCEPTION_MF_10 = 16;
    public static final int PROC_EXCEPTION_AC = 17;
    public static final int PROC_EXCEPTION_MC = 18;
    public static final int PROC_EXCEPTION_XF = 19;
    public static final int PROC_EXCEPTION_MAX = 19;
    public static final int CR0_PROTECTION_ENABLE = 1;
    public static final int CR0_MONITOR_COPROCESSOR = 2;
    public static final int CR0_FPU_EMULATION = 4;
    public static final int CR0_TASK_SWITCHED = 8;
    public static final int CR0_NUMERIC_ERROR = 32;
    public static final int CR0_WRITE_PROTECT = 65536;
    public static final int CR0_ALIGNMENT_MASK = 262144;
    public static final int CR0_NOT_WRITETHROUGH = 0x20000000;
    public static final int CR0_CACHE_DISABLE = 0x40000000;
    public static final int CR0_PAGING = Integer.MIN_VALUE;
    public static final int CR3_PAGE_CACHE_DISABLE = 16;
    public static final int CR3_PAGE_WRITES_TRANSPARENT = 8;
    public static final int CR4_VIRTUAL8086_MODE_EXTENSIONS = 1;
    public static final int CR4_PROTECTED_MODE_VIRTUAL_INTERRUPTS = 2;
    public static final int CR4_TIME_STAMP_DISABLE = 4;
    public static final int CR4_DEBUGGING_EXTENSIONS = 8;
    public static final int CR4_PAGE_SIZE_EXTENSIONS = 16;
    public static final int CR4_PHYSICAL_ADDRESS_EXTENSION = 32;
    public static final int CR4_MACHINE_CHECK_ENABLE = 64;
    public static final int CR4_PAGE_GLOBAL_ENABLE = 128;
    public static final int CR4_PERFORMANCE_MONITORING_COUNTER_ENABLE = 256;
    public static final int CR4_OS_SUPPORT_FXSAVE_FXSTORE = 512;
    public static final int CR4_OS_SUPPORT_UNMASKED_SIMD_EXCEPTIONS = 1024;
    public static final int SYSENTER_CS_MSR = 372;
    public static final int SYSENTER_ESP_MSR = 373;
    public static final int SYSENTER_EIP_MSR = 374;
    public int eax;
    public int ebx;
    public int edx;
    public int ecx;
    public int esi;
    public int edi;
    public int esp;
    public int ebp;
    public int eip;
    private int cr0;
    private int cr1;
    private int cr2;
    private int cr3;
    private int cr4;
    public int dr0;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dr4;
    public int dr5;
    public int dr6;
    public int dr7;
    public Segment cs;
    public Segment ds;
    public Segment ss;
    public Segment es;
    public Segment fs;
    public Segment gs;
    public Segment idtr;
    public Segment gdtr;
    public Segment ldtr;
    public Segment tss;
    public boolean eflagsCarry;
    public boolean eflagsParity;
    public boolean eflagsAuxiliaryCarry;
    public boolean eflagsZero;
    public boolean eflagsSign;
    public boolean eflagsTrap;
    public boolean eflagsInterruptEnable;
    public boolean eflagsDirection;
    public boolean eflagsOverflow;
    public int eflagsIOPrivilegeLevel;
    public boolean eflagsNestedTask;
    public boolean eflagsResume;
    public boolean eflagsVirtual8086Mode;
    public boolean eflagsAlignmentCheck;
    public boolean eflagsVirtualInterrupt;
    public boolean eflagsVirtualInterruptPending;
    public boolean eflagsID;
    public boolean eflagsInterruptEnableSoon;
    public LinearAddressSpace linearMemory = null;
    public PhysicalAddressSpace physicalMemory = null;
    public AlignmentCheckedAddressSpace alignmentCheckedMemory = null;
    public IOPortHandler ioports = null;
    private int interruptFlags;
    private ModulePIC interruptController;
    private boolean alignmentChecking = false;
    private Hashtable<Integer, Long> modelSpecificRegisters;
    private long resetTime;
    private int currentPrivilegeLevel;
    private boolean started = false;
    public FpuState fpu = new FpuState64(this);
    private int auxiliaryCarryOne;
    private int auxiliaryCarryTwo;
    private int auxiliaryCarryThree;
    private boolean auxiliaryCarryCalculated;
    private int auxiliaryCarryMethod;
    public static final int AC_XOR = 1;
    public static final int AC_BIT4_NEQ = 2;
    public static final int AC_LNIBBLE_MAX = 3;
    public static final int AC_LNIBBLE_ZERO = 4;
    public static final int AC_LNIBBLE_NZERO = 5;
    private static final boolean[] parityMap = new boolean[256];
    private int parityOne;
    private boolean parityCalculated;
    private int overflowOne;
    private int overflowTwo;
    private int overflowThree;
    private long overflowLong;
    private boolean overflowCalculated;
    private int overflowMethod;
    public static final int OF_NZ = 1;
    public static final int OF_NOT_BYTE = 2;
    public static final int OF_NOT_SHORT = 3;
    public static final int OF_NOT_INT = 4;
    public static final int OF_LOW_WORD_NZ = 5;
    public static final int OF_HIGH_BYTE_NZ = 6;
    public static final int OF_BIT6_XOR_CARRY = 7;
    public static final int OF_BIT7_XOR_CARRY = 8;
    public static final int OF_BIT14_XOR_CARRY = 9;
    public static final int OF_BIT15_XOR_CARRY = 10;
    public static final int OF_BIT30_XOR_CARRY = 11;
    public static final int OF_BIT31_XOR_CARRY = 12;
    public static final int OF_BIT7_DIFFERENT = 13;
    public static final int OF_BIT15_DIFFERENT = 14;
    public static final int OF_BIT31_DIFFERENT = 15;
    public static final int OF_MAX_BYTE = 16;
    public static final int OF_MAX_SHORT = 17;
    public static final int OF_MAX_INT = 18;
    public static final int OF_MIN_BYTE = 19;
    public static final int OF_MIN_SHORT = 20;
    public static final int OF_MIN_INT = 21;
    public static final int OF_ADD_BYTE = 22;
    public static final int OF_ADD_SHORT = 23;
    public static final int OF_ADD_INT = 24;
    public static final int OF_SUB_BYTE = 25;
    public static final int OF_SUB_SHORT = 26;
    public static final int OF_SUB_INT = 27;
    private int carryOne;
    private int carryTwo;
    private int carryThree;
    private long carryLong;
    private boolean carryCalculated;
    private int carryMethod;
    public static final int CY_NZ = 1;
    public static final int CY_NOT_BYTE = 2;
    public static final int CY_NOT_SHORT = 3;
    public static final int CY_NOT_INT = 4;
    public static final int CY_LOW_WORD_NZ = 5;
    public static final int CY_HIGH_BYTE_NZ = 6;
    public static final int CY_NTH_BIT_SET = 7;
    public static final int CY_GREATER_FF = 8;
    public static final int CY_TWIDDLE_FF = 9;
    public static final int CY_TWIDDLE_FFFF = 10;
    public static final int CY_TWIDDLE_FFFFFFFF = 11;
    public static final int CY_SHL_OUTBIT_BYTE = 12;
    public static final int CY_SHL_OUTBIT_SHORT = 13;
    public static final int CY_SHL_OUTBIT_INT = 14;
    public static final int CY_SHR_OUTBIT = 15;
    public static final int CY_LOWBIT = 16;
    public static final int CY_HIGHBIT_BYTE = 17;
    public static final int CY_HIGHBIT_SHORT = 18;
    public static final int CY_HIGHBIT_INT = 19;
    public static final int CY_OFFENDBIT_BYTE = 20;
    public static final int CY_OFFENDBIT_SHORT = 21;
    public static final int CY_OFFENDBIT_INT = 22;
    private int zeroOne;
    private boolean zeroCalculated;
    private int zeroMethod;
    private int signOne;
    private boolean signCalculated;
    private int signMethod;

    public Processor() {
        this.modelSpecificRegisters = new Hashtable();
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.eax);
        dataOutput.writeInt(this.ebx);
        dataOutput.writeInt(this.edx);
        dataOutput.writeInt(this.ecx);
        dataOutput.writeInt(this.esi);
        dataOutput.writeInt(this.edi);
        dataOutput.writeInt(this.esp);
        dataOutput.writeInt(this.ebp);
        dataOutput.writeInt(this.eip);
        dataOutput.writeInt(this.dr0);
        dataOutput.writeInt(this.dr1);
        dataOutput.writeInt(this.dr2);
        dataOutput.writeInt(this.dr3);
        dataOutput.writeInt(this.dr4);
        dataOutput.writeInt(this.dr5);
        dataOutput.writeInt(this.dr6);
        dataOutput.writeInt(this.dr7);
        dataOutput.writeInt(this.cr0);
        dataOutput.writeInt(this.cr1);
        dataOutput.writeInt(this.cr2);
        dataOutput.writeInt(this.cr3);
        dataOutput.writeInt(this.cr4);
        dataOutput.writeBoolean(this.eflagsCarry);
        dataOutput.writeBoolean(this.eflagsParity);
        dataOutput.writeBoolean(this.eflagsAuxiliaryCarry);
        dataOutput.writeBoolean(this.eflagsZero);
        dataOutput.writeBoolean(this.eflagsSign);
        dataOutput.writeBoolean(this.eflagsTrap);
        dataOutput.writeBoolean(this.eflagsInterruptEnable);
        dataOutput.writeBoolean(this.eflagsDirection);
        dataOutput.writeBoolean(this.eflagsOverflow);
        dataOutput.writeInt(this.eflagsIOPrivilegeLevel);
        dataOutput.writeBoolean(this.eflagsNestedTask);
        dataOutput.writeBoolean(this.eflagsResume);
        dataOutput.writeBoolean(this.eflagsVirtual8086Mode);
        dataOutput.writeBoolean(this.eflagsAlignmentCheck);
        dataOutput.writeBoolean(this.eflagsVirtualInterrupt);
        dataOutput.writeBoolean(this.eflagsVirtualInterruptPending);
        dataOutput.writeBoolean(this.eflagsID);
        dataOutput.writeBoolean(this.eflagsInterruptEnableSoon);
        this.fpu.dumpState(dataOutput);
        dataOutput.writeInt(this.interruptFlags);
        dataOutput.writeBoolean(this.alignmentChecking);
        dataOutput.writeLong(this.resetTime);
        dataOutput.writeInt(this.currentPrivilegeLevel);
        dataOutput.writeInt(this.modelSpecificRegisters.size());
        Set<Map.Entry<Integer, Long>> set = this.modelSpecificRegisters.entrySet();
        for (Map.Entry<Integer, Long> entry : set) {
            dataOutput.writeInt(entry.getKey());
            dataOutput.writeLong(entry.getValue());
        }
        this.cs.dumpState(dataOutput);
        this.ds.dumpState(dataOutput);
        this.ss.dumpState(dataOutput);
        this.es.dumpState(dataOutput);
        this.fs.dumpState(dataOutput);
        this.gs.dumpState(dataOutput);
        this.idtr.dumpState(dataOutput);
        this.gdtr.dumpState(dataOutput);
        this.ldtr.dumpState(dataOutput);
        this.tss.dumpState(dataOutput);
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        this.eax = dataInput.readInt();
        this.ebx = dataInput.readInt();
        this.edx = dataInput.readInt();
        this.ecx = dataInput.readInt();
        this.esi = dataInput.readInt();
        this.edi = dataInput.readInt();
        this.esp = dataInput.readInt();
        this.ebp = dataInput.readInt();
        this.eip = dataInput.readInt();
        this.dr0 = dataInput.readInt();
        this.dr1 = dataInput.readInt();
        this.dr2 = dataInput.readInt();
        this.dr3 = dataInput.readInt();
        this.dr4 = dataInput.readInt();
        this.dr5 = dataInput.readInt();
        this.dr6 = dataInput.readInt();
        this.dr7 = dataInput.readInt();
        this.cr0 = dataInput.readInt();
        this.cr1 = dataInput.readInt();
        this.cr2 = dataInput.readInt();
        this.cr3 = dataInput.readInt();
        this.cr4 = dataInput.readInt();
        this.eflagsCarry = dataInput.readBoolean();
        this.eflagsParity = dataInput.readBoolean();
        this.eflagsAuxiliaryCarry = dataInput.readBoolean();
        this.eflagsZero = dataInput.readBoolean();
        this.eflagsSign = dataInput.readBoolean();
        this.eflagsTrap = dataInput.readBoolean();
        this.eflagsInterruptEnable = dataInput.readBoolean();
        this.eflagsDirection = dataInput.readBoolean();
        this.eflagsOverflow = dataInput.readBoolean();
        this.eflagsIOPrivilegeLevel = dataInput.readInt();
        this.eflagsNestedTask = dataInput.readBoolean();
        this.eflagsResume = dataInput.readBoolean();
        this.eflagsVirtual8086Mode = dataInput.readBoolean();
        this.eflagsAlignmentCheck = dataInput.readBoolean();
        this.eflagsVirtualInterrupt = dataInput.readBoolean();
        this.eflagsVirtualInterruptPending = dataInput.readBoolean();
        this.eflagsID = dataInput.readBoolean();
        this.eflagsInterruptEnableSoon = dataInput.readBoolean();
        this.fpu.loadState(dataInput);
        this.interruptFlags = dataInput.readInt();
        this.alignmentChecking = dataInput.readBoolean();
        this.resetTime = dataInput.readLong();
        this.currentPrivilegeLevel = dataInput.readInt();
        int n = dataInput.readInt();
        this.modelSpecificRegisters = new Hashtable();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readInt();
            long l = dataInput.readLong();
            this.modelSpecificRegisters.put(new Integer(n2), new Long(l));
        }
        this.cs = this.loadSegment(dataInput);
        this.ds = this.loadSegment(dataInput);
        this.ss = this.loadSegment(dataInput);
        this.es = this.loadSegment(dataInput);
        this.fs = this.loadSegment(dataInput);
        this.gs = this.loadSegment(dataInput);
        this.idtr = this.loadSegment(dataInput);
        this.gdtr = this.loadSegment(dataInput);
        this.ldtr = this.loadSegment(dataInput);
        this.tss = this.loadSegment(dataInput);
    }

    private Segment loadSegment(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == 1) {
            int n2 = dataInput.readInt();
            if (!this.isProtectedMode()) {
                return SegmentFactory.createRealModeSegment(this.physicalMemory, n2);
            }
            if (this.alignmentChecking) {
                return SegmentFactory.createRealModeSegment(this.alignmentCheckedMemory, n2);
            }
            return SegmentFactory.createRealModeSegment(this.linearMemory, n2);
        }
        if (n == 2) {
            int n3 = dataInput.readInt();
            int n4 = dataInput.readInt();
            if (!this.isProtectedMode()) {
                return SegmentFactory.createDescriptorTableSegment(this.physicalMemory, n3, n4);
            }
            if (this.alignmentChecking) {
                return SegmentFactory.createDescriptorTableSegment(this.alignmentCheckedMemory, n3, n4);
            }
            return SegmentFactory.createDescriptorTableSegment(this.linearMemory, n3, n4);
        }
        if (n == 3) {
            int n5 = dataInput.readInt();
            long l = dataInput.readLong();
            if (!this.isProtectedMode()) {
                System.out.println("tried to load a Protected Mode segment in Real Mode");
                return null;
            }
            if (this.alignmentChecking) {
                return SegmentFactory.createProtectedModeSegment(this.alignmentCheckedMemory, n5, l);
            }
            return SegmentFactory.createProtectedModeSegment(this.linearMemory, n5, l);
        }
        if (n == 4) {
            return new SegmentFactory.NullSegment();
        }
        throw new IOException();
    }

    public int getEFlags() {
        int n = 2;
        if (this.getCarryFlag()) {
            n |= 1;
        }
        if (this.getParityFlag()) {
            n |= 4;
        }
        if (this.getAuxiliaryCarryFlag()) {
            n |= 0x10;
        }
        if (this.getZeroFlag()) {
            n |= 0x40;
        }
        if (this.getSignFlag()) {
            n |= 0x80;
        }
        if (this.eflagsTrap) {
            n |= 0x100;
        }
        if (this.eflagsInterruptEnable) {
            n |= 0x200;
        }
        if (this.eflagsDirection) {
            n |= 0x400;
        }
        if (this.getOverflowFlag()) {
            n |= 0x800;
        }
        n |= this.eflagsIOPrivilegeLevel << 12;
        if (this.eflagsNestedTask) {
            n |= 0x4000;
        }
        if (this.eflagsResume) {
            n |= 0x10000;
        }
        if (this.eflagsVirtual8086Mode) {
            n |= 0x20000;
        }
        if (this.eflagsAlignmentCheck) {
            n |= 0x40000;
        }
        if (this.eflagsVirtualInterrupt) {
            n |= 0x80000;
        }
        if (this.eflagsVirtualInterruptPending) {
            n |= 0x100000;
        }
        if (this.eflagsID) {
            n |= 0x200000;
        }
        return n;
    }

    public void setEFlags(int n) {
        this.setCarryFlag((n & 1) != 0);
        this.setParityFlag((n & 4) != 0);
        this.setAuxiliaryCarryFlag((n & 0x10) != 0);
        this.setZeroFlag((n & 0x40) != 0);
        this.setSignFlag((n & 0x80) != 0);
        this.eflagsTrap = (n & 0x100) != 0;
        this.eflagsInterruptEnable = (n & 0x200) != 0;
        this.eflagsInterruptEnableSoon = this.eflagsInterruptEnable;
        this.eflagsDirection = (n & 0x400) != 0;
        this.setOverflowFlag((n & 0x800) != 0);
        this.eflagsIOPrivilegeLevel = n >> 12 & 3;
        this.eflagsNestedTask = (n & 0x4000) != 0;
        this.eflagsResume = (n & 0x10000) != 0;
        this.eflagsVirtualInterrupt = (n & 0x80000) != 0;
        this.eflagsVirtualInterruptPending = (n & 0x100000) != 0;
        this.eflagsID = (n & 0x200000) != 0;
        if (this.eflagsAlignmentCheck != ((n & 0x40000) != 0)) {
            this.eflagsAlignmentCheck = (n & 0x40000) != 0;
            this.checkAlignmentChecking();
        }
        if (this.eflagsVirtual8086Mode != ((n & 0x20000) != 0)) {
            boolean bl = this.eflagsVirtual8086Mode = (n & 0x20000) != 0;
            if (this.eflagsVirtual8086Mode) {
                throw ModeSwitchException.VIRTUAL8086_MODE_EXCEPTION;
            }
            throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
        }
    }

    public void processClock() {
        System.out.println("JPC CPU called Clock.process()");
    }

    public void setCPL(int n) {
        this.currentPrivilegeLevel = n;
        this.linearMemory.setSupervisor(this.currentPrivilegeLevel == 0);
        this.checkAlignmentChecking();
    }

    public int getCPL() {
        return this.currentPrivilegeLevel;
    }

    public void reportFPUException() {
        if ((this.cr0 & 0x20) != 0) {
            System.err.println("Reporting FPU Error Via Exception 0x10");
            throw new ProcessorException(16, true);
        }
        System.err.println("Reporting FPU Error Via IRQ#13");
        this.interruptController.setIRQ(13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseInterrupt() {
        Processor processor = this;
        synchronized (processor) {
            this.interruptFlags |= 1;
            this.notifyAll();
        }
    }

    public void clearInterrupt() {
        this.interruptFlags &= 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForInterrupt(long l) {
        Processor processor = this;
        synchronized (processor) {
            if ((this.interruptFlags & 1) != 0) {
                return true;
            }
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (this.interruptFlags & 1) != 0;
        }
    }

    public void requestReset() {
        this.interruptFlags |= 4;
    }

    public int getInterruptFlags() {
        return this.interruptFlags;
    }

    public boolean isProtectedMode() {
        return (this.cr0 & 1) == 1;
    }

    public boolean isVirtual8086Mode() {
        return this.eflagsVirtual8086Mode;
    }

    public void setCR0(int n) {
        boolean bl;
        int n2 = (n |= 0x10) ^ this.cr0;
        if (n2 == 0) {
            return;
        }
        this.cr0 = n;
        boolean bl2 = (n2 & Integer.MIN_VALUE) != 0;
        boolean bl3 = (n2 & 0x40000000) != 0;
        boolean bl4 = (n2 & 1) != 0;
        boolean bl5 = (n2 & 0x10000) != 0;
        boolean bl6 = bl = (n2 & 0x40000) != 0;
        if ((n2 & 0x20000000) != 0) {
            System.err.println("INFO: Unimplemented CR0 flags changed (" + Integer.toHexString(n2) + "). Now is " + Integer.toHexString(n));
        }
        if (bl2 && (n & 1) == 0 && (n & Integer.MIN_VALUE) != 0) {
            throw new ProcessorException(13, 0, true);
        }
        if (bl) {
            this.checkAlignmentChecking();
        }
        if (bl2 || bl3) {
            this.linearMemory.setPagingEnabled((n & Integer.MIN_VALUE) != 0);
            this.linearMemory.setPageCacheEnabled((n & 0x40000000) == 0);
        }
        if (bl5) {
            this.linearMemory.setWriteProtectUserPages((n & 0x10000) != 0);
        }
        if (bl4) {
            if ((n & 1) != 0) {
                this.convertSegmentsToProtectedMode();
                throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
            }
            this.setCPL(0);
            this.convertSegmentsToRealMode();
            throw ModeSwitchException.REAL_MODE_EXCEPTION;
        }
    }

    public int getCR0() {
        return this.cr0;
    }

    public void setCR3(int n) {
        this.cr3 = n;
        this.linearMemory.setPageWriteThroughEnabled((n & 8) != 0);
        this.linearMemory.setPageCacheEnabled((n & 0x10) == 0);
        this.linearMemory.setPageDirectoryBaseAddress(n);
    }

    public int getCR3() {
        return this.cr3;
    }

    public int getCR2() {
        return this.cr2;
    }

    public void setCR2(int n) {
        this.cr2 = n;
    }

    public void setCR4(int n) {
        if (this.cr4 == n) {
            return;
        }
        this.cr4 = n;
        if ((this.cr4 & 1) != 0) {
            System.err.println("WARNING: Virtual 8086 Mode Extensions enabled in the processor");
        }
        if ((this.cr4 & 2) != 0) {
            System.err.println("WARNING: Protected Mode Virtual Interrupts enabled in the processor");
        }
        if ((this.cr4 & 0x400) != 0) {
            System.err.println("WARNING: SIMD instruction support modified in the processor");
        }
        if ((this.cr4 & 0x200) != 0) {
            System.err.println("WARNING: FXSave and FXRStore flag enabled in the processor");
        }
        if ((this.cr4 & 8) != 0) {
            System.err.println("WARNING: debugging extensions enabled");
        }
        if ((this.cr4 & 4) != 0) {
            System.err.println("WARNING: timestamp restricted to CPL0");
        }
        if ((this.cr4 & 0x20) != 0) {
            throw new IllegalStateException("36 Bit Addressing enabled");
        }
        this.linearMemory.setGlobalPagesEnabled((n & 0x80) != 0);
        this.linearMemory.setPageSizeExtensionsEnabled((this.cr4 & 0x10) != 0);
    }

    public int getCR4() {
        return this.cr4;
    }

    public void setDR0(int n) {
        this.dr0 = n;
    }

    public void setDR1(int n) {
        this.dr1 = n;
    }

    public void setDR2(int n) {
        this.dr2 = n;
    }

    public void setDR3(int n) {
        this.dr3 = n;
    }

    public void setDR6(int n) {
        this.dr6 = n;
    }

    public void setDR7(int n) {
        this.dr7 = n;
    }

    public int getDR0() {
        return this.dr0;
    }

    public int getDR1() {
        return this.dr1;
    }

    public int getDR2() {
        return this.dr2;
    }

    public int getDR3() {
        return this.dr3;
    }

    public int getDR6() {
        return this.dr6;
    }

    public int getDR7() {
        return this.dr7;
    }

    public long getMSR(int n) {
        try {
            return this.modelSpecificRegisters.get(new Integer(n));
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Reading unset MSR " + n + " : Returning 0");
            return 0L;
        }
    }

    public void setMSR(int n, long l) {
        this.modelSpecificRegisters.put(new Integer(n), new Long(l));
    }

    private void convertSegmentsToRealMode() {
        try {
            this.cs = this.createRealModeSegment(this.cs.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.cs = this.createRealModeSegment(0);
        }
        try {
            this.ds = this.createRealModeSegment(this.ds.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.ds = this.createRealModeSegment(0);
        }
        try {
            this.ss = this.createRealModeSegment(this.ss.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.ss = this.createRealModeSegment(0);
        }
        try {
            this.es = this.createRealModeSegment(this.es.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.es = this.createRealModeSegment(0);
        }
        try {
            this.fs = this.createRealModeSegment(this.fs.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.fs = this.createRealModeSegment(0);
        }
        try {
            this.gs = this.createRealModeSegment(this.gs.translateAddressRead(0) >>> 4);
        }
        catch (ProcessorException processorException) {
            this.gs = this.createRealModeSegment(0);
        }
    }

    private void convertSegmentsToProtectedMode() {
        this.cs.setAddressSpace(this.linearMemory);
        this.ds.setAddressSpace(this.linearMemory);
        this.ss.setAddressSpace(this.linearMemory);
        this.es.setAddressSpace(this.linearMemory);
        this.fs.setAddressSpace(this.linearMemory);
        this.gs.setAddressSpace(this.linearMemory);
    }

    private void updateAlignmentCheckingInDataSegments() {
        if (this.alignmentChecking) {
            this.ds.setAddressSpace(this.alignmentCheckedMemory);
            this.ss.setAddressSpace(this.alignmentCheckedMemory);
            this.es.setAddressSpace(this.alignmentCheckedMemory);
            this.fs.setAddressSpace(this.alignmentCheckedMemory);
            this.gs.setAddressSpace(this.alignmentCheckedMemory);
        } else {
            this.ds.setAddressSpace(this.linearMemory);
            this.ss.setAddressSpace(this.linearMemory);
            this.es.setAddressSpace(this.linearMemory);
            this.fs.setAddressSpace(this.linearMemory);
            this.gs.setAddressSpace(this.linearMemory);
        }
    }

    public Segment createRealModeSegment(int n) {
        return SegmentFactory.createRealModeSegment(this.physicalMemory, n);
    }

    public Segment createDescriptorTableSegment(int n, int n2) {
        return SegmentFactory.createDescriptorTableSegment(this.linearMemory, n, n2);
    }

    public void correctAlignmentChecking(Segment segment) {
        if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
            segment.setAddressSpace(this.alignmentCheckedMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment(int n) {
        boolean bl = this.linearMemory.isSupervisor();
        try {
            long l = 0L;
            this.linearMemory.setSupervisor(true);
            if ((n & 4) != 0) {
                l = this.ldtr.getQuadWord(n & 0xFFF8);
            } else {
                if (n < 4) {
                    Segment segment = SegmentFactory.NULL_SEGMENT;
                    return segment;
                }
                l = this.gdtr.getQuadWord(n & 0xFFF8);
            }
            Segment segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n, l);
            if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
                segment.setAddressSpace(this.alignmentCheckedMemory);
            }
            Segment segment2 = segment;
            return segment2;
        }
        finally {
            this.linearMemory.setSupervisor(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment(int n, Segment segment, Segment segment2) {
        boolean bl = this.linearMemory.isSupervisor();
        try {
            long l = 0L;
            this.linearMemory.setSupervisor(true);
            if ((n & 4) != 0) {
                l = segment.getQuadWord(n & 0xFFF8);
            } else {
                if (n < 4) {
                    Segment segment3 = SegmentFactory.NULL_SEGMENT;
                    return segment3;
                }
                l = segment2.getQuadWord(n & 0xFFF8);
            }
            Segment segment4 = SegmentFactory.createProtectedModeSegment(this.linearMemory, n, l);
            if (this.alignmentChecking && (segment4.getType() & 0x18) == 16) {
                segment4.setAddressSpace(this.alignmentCheckedMemory);
            }
            Segment segment5 = segment4;
            return segment5;
        }
        finally {
            this.linearMemory.setSupervisor(bl);
        }
    }

    @Override
    public boolean reset() {
        this.resetTime = System.currentTimeMillis();
        this.edx = 0;
        this.ecx = 0;
        this.ebx = 0;
        this.eax = 0;
        this.esp = 0;
        this.ebp = 0;
        this.esi = 0;
        this.edi = 0;
        this.edx = 1587;
        this.interruptFlags = 0;
        this.currentPrivilegeLevel = 0;
        this.linearMemory.reset();
        this.alignmentChecking = false;
        this.eip = 65520;
        this.cr0 = 0x60000010;
        this.cr4 = 0;
        this.cr3 = 0;
        this.cr2 = 0;
        this.dr3 = 0;
        this.dr2 = 0;
        this.dr1 = 0;
        this.dr0 = 0;
        this.dr6 = -61456;
        this.dr7 = 1792;
        this.eflagsInterruptEnable = false;
        this.eflagsTrap = false;
        this.eflagsSign = false;
        this.eflagsZero = false;
        this.eflagsAuxiliaryCarry = false;
        this.eflagsParity = false;
        this.eflagsCarry = false;
        this.signCalculated = true;
        this.zeroCalculated = true;
        this.auxiliaryCarryCalculated = true;
        this.parityCalculated = true;
        this.carryCalculated = true;
        this.eflagsVirtual8086Mode = false;
        this.eflagsResume = false;
        this.eflagsNestedTask = false;
        this.eflagsOverflow = false;
        this.eflagsDirection = false;
        this.overflowCalculated = true;
        this.eflagsID = false;
        this.eflagsVirtualInterruptPending = false;
        this.eflagsVirtualInterrupt = false;
        this.eflagsAlignmentCheck = false;
        this.eflagsIOPrivilegeLevel = 0;
        this.eflagsZero = true;
        this.eflagsInterruptEnableSoon = false;
        this.cs = this.createRealModeSegment(61440);
        this.ds = this.createRealModeSegment(0);
        this.ss = this.createRealModeSegment(0);
        this.es = this.createRealModeSegment(0);
        this.fs = this.createRealModeSegment(0);
        this.gs = this.createRealModeSegment(0);
        this.idtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.ldtr = SegmentFactory.NULL_SEGMENT;
        this.gdtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.tss = SegmentFactory.NULL_SEGMENT;
        this.modelSpecificRegisters.clear();
        this.fpu.init();
        return true;
    }

    public long getClockCount() {
        return (System.currentTimeMillis() - this.resetTime) * 1000L * 50L;
    }

    public final int getInstructionPointer() {
        return this.cs.translateAddressRead(this.eip);
    }

    public final void processRealModeInterrupts() {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                int n = this.interruptController.interruptAcknowledge();
                this.handleRealModeInterrupt(n);
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void processProtectedModeInterrupts() {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                this.handleHardProtectedModeInterrupt(this.interruptController.interruptAcknowledge());
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void processVirtual8086ModeInterrupts() {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                if ((this.getCR4() & 1) != 0) {
                    throw new IllegalStateException();
                }
                this.handleHardVirtual8086ModeInterrupt(this.interruptController.interruptAcknowledge());
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void handleRealModeException(int n) {
        if (n <= 19) {
            this.handleRealModeInterrupt(n);
        }
    }

    private final void handleRealModeInterrupt(int n) {
        if ((this.esp & 0xFFFF) < 6 && (this.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        int n2 = 0xFFFF & this.idtr.getWord(n *= 4);
        int n3 = 0xFFFF & this.idtr.getWord(n + 2);
        short s = (short)this.esp;
        s = (short)(s - 2);
        int n4 = this.getEFlags() & 0xFFFF;
        this.ss.setWord(s & 0xFFFF, (short)n4);
        this.eflagsInterruptEnable = false;
        this.eflagsInterruptEnableSoon = false;
        this.eflagsTrap = false;
        this.eflagsAlignmentCheck = false;
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.cs.getSelector());
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.eip);
        this.esp = 0xFFFF0000 & this.esp | s & 0xFFFF;
        this.eip = n2;
        if (!this.cs.setSelector(n3)) {
            this.cs = this.createRealModeSegment(n3);
            this.setCPL(0);
        }
    }

    public final void handleProtectedModeException(int n, boolean bl, int n2) {
        int n3 = this.esp;
        int n4 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, bl, n2, false, false);
        }
        catch (ProcessorException processorException) {
            processorException.printStackTrace();
            this.esp = n3;
            this.eip = n4;
            this.cs = segment;
            this.ss = segment2;
            if (n == 8) {
                System.err.println("Triple-Fault: Unhandleable, machine will halt!");
                throw new IllegalStateException("Triple Fault " + processorException);
            }
            if (processorException.combinesToDoubleFault(n)) {
                System.err.println(n);
                this.handleProtectedModeException(8, true, 0);
            }
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleSoftProtectedModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, false, true);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleHardProtectedModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, true, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    private final void checkGate(Segment segment, int n, boolean bl) {
        if (bl && segment.getDPL() < this.currentPrivilegeLevel) {
            throw new ProcessorException(13, n + 2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void followProtectedModeException(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        Segment segment;
        if (n == 14) {
            this.setCR2(this.linearMemory.getLastWalkedAddress());
        }
        int n3 = n << 3;
        int n4 = bl2 ? 1 : 0;
        boolean bl4 = this.linearMemory.isSupervisor();
        try {
            this.linearMemory.setSupervisor(true);
            long l = this.idtr.getQuadWord(n3);
            segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n3, l);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(13, n3 + 2 + n4, true);
        }
        finally {
            this.linearMemory.setSupervisor(bl4);
        }
        block8 : switch (segment.getType()) {
            default: {
                System.err.println("Invalid Gate Type For Throwing Interrupt: 0x" + Integer.toHexString(segment.getType()));
                throw new ProcessorException(13, n3 + 2 + n4, true);
            }
            case 5: {
                System.out.println("Unimplemented Interrupt Handler: Task Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: Task Gate");
            }
            case 6: {
                System.out.println("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
            }
            case 7: {
                System.out.println("Unimplemented Interrupt Handler: 16-bit Trap Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Trap Gate");
            }
            case 14: {
                Segment segment2;
                SegmentFactory.InterruptGate32Bit interruptGate32Bit = (SegmentFactory.InterruptGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n5 = interruptGate32Bit.getTargetSegment();
                try {
                    segment2 = this.getSegment(n5);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                if (segment2.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(13, n5 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(11, n5 + n4, true);
                        }
                        if (segment2.getDPL() < this.currentPrivilegeLevel) {
                            int n6;
                            int n7 = 0;
                            int n8 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n6 = segment2.getDPL() * 8 + 4;
                                if (n6 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n7 = 0xFFFF & this.tss.getWord(n6 + 4);
                                    n8 = this.tss.getDoubleWord(n6);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n6 = segment2.getDPL() * 4 + 2;
                                if (n6 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                n7 = 0xFFFF & this.tss.getWord(n6 + 2);
                                n8 = 0xFFFF & this.tss.getWord(n6);
                            }
                            Segment segment3 = null;
                            try {
                                segment3 = this.getSegment(n7);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getRPL() != segment2.getDPL()) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment3.getDPL() != segment2.getDPL() || (segment3.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (!segment3.isPresent()) {
                                throw new ProcessorException(12, n7, true);
                            }
                            if (bl ? segment3.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24 && (this.esp & 0xFFFF) > 0 : segment3.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n9 = interruptGate32Bit.getTargetOffset();
                            segment2.checkAddress(n9);
                            int n10 = this.ss.getSelector();
                            int n11 = this.esp;
                            int n12 = this.cs.getSelector();
                            int n13 = this.eip;
                            this.ss = segment3;
                            this.esp = n8;
                            this.cs = segment2;
                            this.eip = n9;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n10);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n11);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n12);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n13);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n10);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n11);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n12);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n13);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        if (segment2.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n14 = interruptGate32Bit.getTargetOffset();
                            segment2.checkAddress(n14);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment2;
                            this.eip = n14;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        throw new ProcessorException(13, n5 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(11, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                int n15 = interruptGate32Bit.getTargetOffset();
                segment2.checkAddress(n15);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment2;
                this.eip = n15;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsInterruptEnableSoon = false;
                this.eflagsInterruptEnable = false;
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
                break;
            }
            case 15: {
                Segment segment4;
                SegmentFactory.TrapGate32Bit trapGate32Bit = (SegmentFactory.TrapGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n16 = trapGate32Bit.getTargetSegment();
                try {
                    segment4 = this.getSegment(n16);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n16 + n4, true);
                }
                if (segment4.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(13, n16 + n4, true);
                }
                switch (segment4.getType()) {
                    default: {
                        throw new ProcessorException(13, n16 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment4.isPresent()) {
                            throw new ProcessorException(11, n16 + n4, true);
                        }
                        if (segment4.getDPL() < this.currentPrivilegeLevel) {
                            int n17;
                            int n18 = 0;
                            int n19 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n17 = segment4.getDPL() * 8 + 4;
                                if (n17 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n18 = 0xFFFF & this.tss.getWord(n17 + 4);
                                    n19 = this.tss.getDoubleWord(n17);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n17 = segment4.getDPL() * 4 + 2;
                                if (n17 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                n18 = 0xFFFF & this.tss.getWord(n17 + 2);
                                n19 = 0xFFFF & this.tss.getWord(n17);
                            }
                            Segment segment5 = null;
                            try {
                                segment5 = this.getSegment(n18);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (segment5.getRPL() != segment4.getDPL()) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (segment5.getDPL() != segment4.getDPL() || (segment5.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n18, true);
                            }
                            if (!segment5.isPresent()) {
                                throw new ProcessorException(12, n18, true);
                            }
                            if (bl ? segment5.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24 && (this.esp & 0xFFFF) > 0 : segment5.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n20 = trapGate32Bit.getTargetOffset();
                            segment4.checkAddress(n20);
                            int n21 = this.ss.getSelector();
                            int n22 = this.esp;
                            int n23 = this.cs.getSelector();
                            int n24 = this.eip;
                            this.ss = segment5;
                            this.esp = n19;
                            this.cs = segment4;
                            this.eip = n20;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n21);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n22);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n23);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n24);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n21);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n22);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n23);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n24);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        if (segment4.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n25 = trapGate32Bit.getTargetOffset();
                            segment4.checkAddress(n25);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment4;
                            this.eip = n25;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block8;
                        }
                        throw new ProcessorException(13, n16 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment4.isPresent()) {
                    throw new ProcessorException(11, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 && (this.esp & 0xFFFF) > 0 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 && (this.esp & 0xFFFF) > 0) {
                    throw new ProcessorException(12, 0, true);
                }
                int n26 = trapGate32Bit.getTargetOffset();
                segment4.checkAddress(n26);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment4;
                this.eip = n26;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
            }
        }
    }

    public final void handleVirtual8086ModeException(int n, boolean bl, int n2) {
        int n3 = this.esp;
        int n4 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followVirtual8086ModeException(n, bl, n2, false, false);
        }
        catch (ProcessorException processorException) {
            processorException.printStackTrace();
            this.esp = n3;
            this.eip = n4;
            this.cs = segment;
            this.ss = segment2;
            if (n == 8) {
                System.err.println("Triple-Fault: Unhandleable, machine will halt!");
                throw new IllegalStateException("Triple Fault " + processorException);
            }
            if (processorException.combinesToDoubleFault(n)) {
                System.err.println(n);
                this.handleVirtual8086ModeException(8, true, 0);
            }
            this.handleVirtual8086ModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleSoftVirtual8086ModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        if (this.eflagsIOPrivilegeLevel < 3) {
            throw new ProcessorException(13, 0, true);
        }
        try {
            this.followVirtual8086ModeException(n, false, 0, false, true);
        }
        catch (ProcessorException processorException) {
            processorException.printStackTrace();
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleVirtual8086ModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    public final void handleHardVirtual8086ModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followVirtual8086ModeException(n, false, 0, true, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleVirtual8086ModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void followVirtual8086ModeException(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        Segment segment;
        Segment segment2;
        if (n == 14) {
            this.setCR2(this.linearMemory.getLastWalkedAddress());
        }
        int n3 = n << 3;
        int n4 = bl2 ? 1 : 0;
        boolean bl4 = this.linearMemory.isSupervisor();
        try {
            this.linearMemory.setSupervisor(true);
            long l = this.idtr.getQuadWord(n3);
            segment2 = SegmentFactory.createProtectedModeSegment(this.linearMemory, n3, l);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(13, n3 + 2 + n4, true);
        }
        finally {
            this.linearMemory.setSupervisor(bl4);
        }
        switch (segment2.getType()) {
            default: {
                System.err.println("Invalid Gate Type For Throwing Interrupt: 0x" + Integer.toHexString(segment2.getType()));
                throw new ProcessorException(13, n3 + 2 + n4, true);
            }
            case 5: {
                System.out.println("Unimplemented Interrupt Handler: Task Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: Task Gate");
            }
            case 6: {
                System.out.println("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
            }
            case 7: {
                System.out.println("Unimplemented Interrupt Handler: 16-bit Trap Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Trap Gate");
            }
            case 14: {
                Segment segment3;
                SegmentFactory.InterruptGate32Bit interruptGate32Bit = (SegmentFactory.InterruptGate32Bit)segment2;
                this.checkGate(segment2, n3, bl3);
                int n5 = interruptGate32Bit.getTargetSegment();
                try {
                    segment3 = this.getSegment(n5);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                if (segment3.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(13, n5 + n4, true);
                }
                switch (segment3.getType()) {
                    default: {
                        System.err.println(segment3);
                        throw new ProcessorException(13, n5 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment3.isPresent()) {
                            throw new ProcessorException(11, n5 + n4, true);
                        }
                        if (segment3.getDPL() < this.currentPrivilegeLevel) {
                            int n6;
                            if (segment3.getDPL() != 0) {
                                throw new ProcessorException(13, n5, true);
                            }
                            int n7 = 0;
                            int n8 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n6 = segment3.getDPL() * 8 + 4;
                                if (n6 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n7 = 0xFFFF & this.tss.getWord(n6 + 4);
                                    n8 = this.tss.getDoubleWord(n6);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n6 = segment3.getDPL() * 4 + 2;
                                if (n6 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(10, this.tss.getSelector(), true);
                                }
                                n7 = 0xFFFF & this.tss.getWord(n6 + 2);
                                n8 = 0xFFFF & this.tss.getWord(n6);
                            }
                            Segment segment4 = null;
                            try {
                                segment4 = this.getSegment(n7);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment4.getRPL() != segment3.getDPL()) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (segment4.getDPL() != segment3.getDPL() || (segment4.getType() & 0x1A) != 18) {
                                throw new ProcessorException(10, n7, true);
                            }
                            if (!segment4.isPresent()) {
                                throw new ProcessorException(12, n7, true);
                            }
                            if (bl ? segment4.getDefaultSizeFlag() && this.esp < 40 && this.esp > 0 || !segment4.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 40 && (this.esp & 0xFFFF) > 0 : segment4.getDefaultSizeFlag() && this.esp < 36 && this.esp > 0 || !segment4.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 36 && (this.esp & 0xFFFF) > 0) {
                                throw new ProcessorException(12, 0, true);
                            }
                            int n9 = interruptGate32Bit.getTargetOffset();
                            segment3.checkAddress(n9);
                            int n10 = this.ss.getSelector() & 0xFFFF;
                            int n11 = this.esp;
                            int n12 = this.cs.getSelector() & 0xFFFF;
                            int n13 = this.eip & 0xFFFF;
                            this.ss = segment4;
                            this.esp = n8;
                            this.cs = segment3;
                            this.eip = n9;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.gs.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.fs.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.ds.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.es.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n10);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n11);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n12);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n13);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.gs.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.fs.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.ds.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.es.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n10);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n11);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n12);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n13);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.gs = SegmentFactory.NULL_SEGMENT;
                            this.fs = SegmentFactory.NULL_SEGMENT;
                            this.ds = SegmentFactory.NULL_SEGMENT;
                            this.es = SegmentFactory.NULL_SEGMENT;
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
                        }
                        throw new ProcessorException(13, n5, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment3.isPresent()) {
                    throw new ProcessorException(11, n3, true);
                }
                throw new ProcessorException(13, n5, true);
            }
            case 15: 
        }
        SegmentFactory.TrapGate32Bit trapGate32Bit = (SegmentFactory.TrapGate32Bit)segment2;
        this.checkGate(segment2, n3, bl3);
        int n14 = trapGate32Bit.getTargetSegment();
        try {
            segment = this.getSegment(n14);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(13, n14 + n4, true);
        }
        if (segment.getDPL() > this.currentPrivilegeLevel) {
            throw new ProcessorException(13, n14 + n4, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(13, n14 + n4, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (!segment.isPresent()) {
                    throw new ProcessorException(11, n14 + n4, true);
                }
                if (segment.getDPL() < this.currentPrivilegeLevel) {
                    int n15;
                    if (segment.getDPL() != 0) {
                        throw new ProcessorException(13, n14, true);
                    }
                    int n16 = 0;
                    int n17 = 0;
                    if ((this.tss.getType() & 8) != 0) {
                        n15 = segment.getDPL() * 8 + 4;
                        if (n15 + 7 > this.tss.getLimit()) {
                            throw new ProcessorException(10, this.tss.getSelector(), true);
                        }
                        bl4 = this.linearMemory.isSupervisor();
                        try {
                            this.linearMemory.setSupervisor(true);
                            n16 = 0xFFFF & this.tss.getWord(n15 + 4);
                            n17 = this.tss.getDoubleWord(n15);
                        }
                        finally {
                            this.linearMemory.setSupervisor(bl4);
                        }
                    } else {
                        n15 = segment.getDPL() * 4 + 2;
                        if (n15 + 4 > this.tss.getLimit()) {
                            throw new ProcessorException(10, this.tss.getSelector(), true);
                        }
                        n16 = 0xFFFF & this.tss.getWord(n15 + 2);
                        n17 = 0xFFFF & this.tss.getWord(n15);
                    }
                    Segment segment5 = null;
                    try {
                        segment5 = this.getSegment(n16);
                    }
                    catch (ProcessorException processorException) {
                        throw new ProcessorException(10, n16, true);
                    }
                    if (segment5.getRPL() != segment.getDPL()) {
                        throw new ProcessorException(10, n16, true);
                    }
                    if (segment5.getDPL() != segment.getDPL() || (segment5.getType() & 0x1A) != 18) {
                        throw new ProcessorException(10, n16, true);
                    }
                    if (!segment5.isPresent()) {
                        throw new ProcessorException(12, n16, true);
                    }
                    if (bl ? segment5.getDefaultSizeFlag() && this.esp < 40 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 40 && (this.esp & 0xFFFF) > 0 : segment5.getDefaultSizeFlag() && this.esp < 36 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 36 && (this.esp & 0xFFFF) > 0) {
                        throw new ProcessorException(12, 0, true);
                    }
                    int n18 = trapGate32Bit.getTargetOffset();
                    segment.checkAddress(n18);
                    int n19 = this.ss.getSelector() & 0xFFFF;
                    int n20 = this.esp;
                    int n21 = this.cs.getSelector() & 0xFFFF;
                    int n22 = this.eip & 0xFFFF;
                    this.ss = segment5;
                    this.esp = n17;
                    this.cs = segment;
                    this.eip = n18;
                    this.setCPL(this.cs.getDPL());
                    if (this.ss.getDefaultSizeFlag()) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.gs.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.fs.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.ds.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.es.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n19);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n20);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.getEFlags());
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n21);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n22);
                        if (bl) {
                            this.esp -= 4;
                            this.ss.setDoubleWord(this.esp, n2);
                        }
                    } else {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.gs.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.fs.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.ds.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.es.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n19);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n20);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n21);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n22);
                        if (bl) {
                            this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                            this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                        }
                    }
                    this.gs = SegmentFactory.NULL_SEGMENT;
                    this.fs = SegmentFactory.NULL_SEGMENT;
                    this.ds = SegmentFactory.NULL_SEGMENT;
                    this.es = SegmentFactory.NULL_SEGMENT;
                    this.eflagsTrap = false;
                    this.eflagsNestedTask = false;
                    this.eflagsVirtual8086Mode = false;
                    this.eflagsResume = false;
                    throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
                }
                throw new ProcessorException(13, n14, true);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(11, n3, true);
        }
        throw new ProcessorException(13, n14, true);
    }

    private void checkAlignmentChecking() {
        if (this.getCPL() == 3 && this.eflagsAlignmentCheck && (this.cr0 & 0x40000) != 0) {
            if (!this.alignmentChecking) {
                System.err.println("Alignment Checking Enabled");
                this.alignmentChecking = true;
                this.updateAlignmentCheckingInDataSegments();
            }
        } else if (this.alignmentChecking) {
            System.err.println("Alignment Checking Disabled");
            this.alignmentChecking = false;
            this.updateAlignmentCheckingInDataSegments();
        }
    }

    @Override
    public boolean initialised() {
        boolean bl;
        boolean bl2 = bl = this.physicalMemory != null && this.linearMemory != null && this.ioports != null && this.interruptController != null;
        if (bl && !this.started) {
            this.reset();
            this.started = true;
        }
        return bl;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearMemory = (LinearAddressSpace)hardwareComponent;
            this.alignmentCheckedMemory = new AlignmentCheckedAddressSpace(this.linearMemory);
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalMemory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            this.ioports = (IOPortHandler)hardwareComponent;
        }
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equals("pic")) {
            this.interruptController = (ModulePIC)module;
            return true;
        }
        return false;
    }

    public boolean getAuxiliaryCarryFlag() {
        if (this.auxiliaryCarryCalculated) {
            return this.eflagsAuxiliaryCarry;
        }
        this.auxiliaryCarryCalculated = true;
        if (this.auxiliaryCarryMethod == 1) {
            this.eflagsAuxiliaryCarry = ((this.auxiliaryCarryOne ^ this.auxiliaryCarryTwo ^ this.auxiliaryCarryThree) & 0x10) != 0;
            return this.eflagsAuxiliaryCarry;
        }
        if (this.auxiliaryCarryMethod == 3) {
            this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 15;
            return this.eflagsAuxiliaryCarry;
        }
        if (this.auxiliaryCarryMethod == 4) {
            this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 0;
            return this.eflagsAuxiliaryCarry;
        }
        switch (this.auxiliaryCarryMethod) {
            case 2: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 8) != (this.auxiliaryCarryTwo & 8);
                return this.eflagsAuxiliaryCarry;
            }
            case 5: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) != 0;
                return this.eflagsAuxiliaryCarry;
            }
        }
        System.err.println("Missing AC Flag Calculation Method");
        return this.eflagsAuxiliaryCarry;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3, int n4) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryThree = n3;
        this.auxiliaryCarryMethod = n4;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryMethod = n3;
    }

    public void setAuxiliaryCarryFlag(int n, int n2) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryMethod = n2;
    }

    public void setAuxiliaryCarryFlag(boolean bl) {
        this.auxiliaryCarryCalculated = true;
        this.eflagsAuxiliaryCarry = bl;
    }

    public boolean getParityFlag() {
        if (this.parityCalculated) {
            return this.eflagsParity;
        }
        this.parityCalculated = true;
        this.eflagsParity = parityMap[this.parityOne & 0xFF];
        return this.eflagsParity;
    }

    public void setParityFlag(boolean bl) {
        this.parityCalculated = true;
        this.eflagsParity = bl;
    }

    public void setParityFlag(int n) {
        this.parityCalculated = false;
        this.parityOne = n;
    }

    public boolean getOverflowFlag() {
        if (this.overflowCalculated) {
            return this.eflagsOverflow;
        }
        this.overflowCalculated = true;
        if (this.overflowMethod == 22) {
            return (this.overflowTwo & 0x80) == (this.overflowThree & 0x80) && (this.overflowTwo & 0x80) != (this.overflowOne & 0x80);
        }
        if (this.overflowMethod == 23) {
            return (this.overflowTwo & 0x8000) == (this.overflowThree & 0x8000) && (this.overflowTwo & 0x8000) != (this.overflowOne & 0x8000);
        }
        if (this.overflowMethod == 24) {
            return (this.overflowTwo & Integer.MIN_VALUE) == (this.overflowThree & Integer.MIN_VALUE) && (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowOne & Integer.MIN_VALUE);
        }
        if (this.overflowMethod == 25) {
            return (this.overflowTwo & 0x80) != (this.overflowThree & 0x80) && (this.overflowTwo & 0x80) != (this.overflowOne & 0x80);
        }
        if (this.overflowMethod == 26) {
            return (this.overflowTwo & 0x8000) != (this.overflowThree & 0x8000) && (this.overflowTwo & 0x8000) != (this.overflowOne & 0x8000);
        }
        if (this.overflowMethod == 27) {
            return (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowThree & Integer.MIN_VALUE) && (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowOne & Integer.MIN_VALUE);
        }
        if (this.overflowMethod == 16) {
            this.eflagsOverflow = this.overflowOne == 127;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 17) {
            this.eflagsOverflow = this.overflowOne == Short.MAX_VALUE;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 20) {
            this.eflagsOverflow = this.overflowOne == Short.MIN_VALUE;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 10) {
            this.eflagsOverflow = (this.overflowOne & 0x8000) != 0 ^ this.getCarryFlag();
            return this.eflagsOverflow;
        }
        switch (this.overflowMethod) {
            case 1: {
                this.eflagsOverflow = this.overflowOne != 0;
                return this.eflagsOverflow;
            }
            case 2: {
                this.eflagsOverflow = this.overflowOne != (byte)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 3: {
                this.eflagsOverflow = this.overflowOne != (short)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 4: {
                this.eflagsOverflow = this.overflowLong != (long)((int)this.overflowLong);
                return this.eflagsOverflow;
            }
            case 5: {
                this.eflagsOverflow = (this.overflowOne & 0xFFFF) != 0;
                return this.eflagsOverflow;
            }
            case 6: {
                this.eflagsOverflow = (this.overflowOne & 0xFF00) != 0;
                return this.eflagsOverflow;
            }
            case 7: {
                this.eflagsOverflow = (this.overflowOne & 0x40) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 8: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 9: {
                this.eflagsOverflow = (this.overflowOne & 0x4000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 11: {
                this.eflagsOverflow = (this.overflowOne & 0x40000000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 12: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 13: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != (this.overflowTwo & 0x80);
                return this.eflagsOverflow;
            }
            case 14: {
                this.eflagsOverflow = (this.overflowOne & 0x8000) != (this.overflowTwo & 0x8000);
                return this.eflagsOverflow;
            }
            case 15: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != (this.overflowTwo & Integer.MIN_VALUE);
                return this.eflagsOverflow;
            }
            case 18: {
                this.eflagsOverflow = this.overflowOne == Integer.MAX_VALUE;
                return this.eflagsOverflow;
            }
            case 19: {
                this.eflagsOverflow = this.overflowOne == -128;
                return this.eflagsOverflow;
            }
            case 21: {
                this.eflagsOverflow = this.overflowOne == Integer.MIN_VALUE;
                return this.eflagsOverflow;
            }
        }
        System.err.println("Missing OF Flag Calculation Method");
        return this.eflagsOverflow;
    }

    public void setOverflowFlag(boolean bl) {
        this.overflowCalculated = true;
        this.eflagsOverflow = bl;
    }

    public void setOverflowFlag(long l, int n) {
        this.overflowCalculated = false;
        this.overflowLong = l;
        this.overflowMethod = n;
    }

    public void setOverflowFlag(int n, int n2) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowMethod = n2;
    }

    public void setOverflowFlag(int n, int n2, int n3) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowMethod = n3;
    }

    public void setOverflowFlag(int n, int n2, int n3, int n4) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowThree = n3;
        this.overflowMethod = n4;
    }

    public boolean getCarryFlag() {
        if (this.carryCalculated) {
            return this.eflagsCarry;
        }
        this.carryCalculated = true;
        if (this.carryMethod == 10) {
            this.eflagsCarry = (this.carryOne & 0xFFFF0000) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 9) {
            this.eflagsCarry = (this.carryOne & 0xFFFFFF00) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 15) {
            this.eflagsCarry = (this.carryOne >>> this.carryTwo - 1 & 1) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 11) {
            this.eflagsCarry = (this.carryLong & 0xFFFFFFFF00000000L) != 0L;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 13) {
            this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x8000) != 0;
            return this.eflagsCarry;
        }
        switch (this.carryMethod) {
            case 1: {
                this.eflagsCarry = this.carryOne != 0;
                return this.eflagsCarry;
            }
            case 2: {
                this.eflagsCarry = this.carryOne != (byte)this.carryOne;
                return this.eflagsCarry;
            }
            case 3: {
                this.eflagsCarry = this.carryOne != (short)this.carryOne;
                return this.eflagsCarry;
            }
            case 4: {
                this.eflagsCarry = this.carryLong != (long)((int)this.carryLong);
                return this.eflagsCarry;
            }
            case 5: {
                this.eflagsCarry = (this.carryOne & 0xFFFF) != 0;
                return this.eflagsCarry;
            }
            case 6: {
                this.eflagsCarry = (this.carryOne & 0xFF00) != 0;
                return this.eflagsCarry;
            }
            case 7: {
                this.eflagsCarry = (this.carryOne & 1 << this.carryTwo) != 0;
                return this.eflagsCarry;
            }
            case 8: {
                this.eflagsCarry = this.carryOne > 255;
                return this.eflagsCarry;
            }
            case 12: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 14: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 16: {
                this.eflagsCarry = (this.carryOne & 1) != 0;
                return this.eflagsCarry;
            }
            case 17: {
                this.eflagsCarry = (this.carryOne & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 18: {
                this.eflagsCarry = (this.carryOne & 0x8000) != 0;
                return this.eflagsCarry;
            }
            case 19: {
                this.eflagsCarry = (this.carryOne & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 20: {
                this.eflagsCarry = (this.carryOne & 0x100) != 0;
                return this.eflagsCarry;
            }
            case 21: {
                this.eflagsCarry = (this.carryOne & 0x10000) != 0;
                return this.eflagsCarry;
            }
            case 22: {
                this.eflagsCarry = (this.carryLong & 0x100000000L) != 0L;
                return this.eflagsCarry;
            }
        }
        System.err.println("Missing CY Flag Calculation Method");
        return this.eflagsCarry;
    }

    public void setCarryFlag(boolean bl) {
        this.carryCalculated = true;
        this.eflagsCarry = bl;
    }

    public void setCarryFlag(long l, int n) {
        this.carryCalculated = false;
        this.carryLong = l;
        this.carryMethod = n;
    }

    public void setCarryFlag(int n, int n2) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryMethod = n2;
    }

    public void setCarryFlag(int n, int n2, int n3) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryTwo = n2;
        this.carryMethod = n3;
    }

    public void setCarryFlag(int n, int n2, int n3, int n4) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryTwo = n2;
        this.carryThree = n3;
        this.carryMethod = n4;
    }

    public boolean getZeroFlag() {
        if (this.zeroCalculated) {
            return this.eflagsZero;
        }
        this.zeroCalculated = true;
        this.eflagsZero = this.zeroOne == 0;
        return this.eflagsZero;
    }

    public void setZeroFlag(boolean bl) {
        this.zeroCalculated = true;
        this.eflagsZero = bl;
    }

    public void setZeroFlag(int n) {
        this.zeroCalculated = false;
        this.zeroOne = n;
    }

    public boolean getSignFlag() {
        if (this.signCalculated) {
            return this.eflagsSign;
        }
        this.signCalculated = true;
        this.eflagsSign = this.signOne < 0;
        return this.eflagsSign;
    }

    public void setSignFlag(boolean bl) {
        this.signCalculated = true;
        this.eflagsSign = bl;
    }

    public void setSignFlag(int n) {
        this.signCalculated = false;
        this.signOne = n;
    }

    @Override
    public boolean updated() {
        boolean bl = this.physicalMemory.updated() && this.linearMemory.updated() && this.ioports.updated() && this.interruptController.isConnected();
        return bl;
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.alignmentCheckedMemory = new AlignmentCheckedAddressSpace(this.linearMemory);
        }
    }

    @Override
    public void timerCallback() {
    }

    @Override
    public String dumpRegisters() {
        return null;
    }

    @Override
    public boolean getCpuInstructionDebug() {
        return false;
    }

    @Override
    public long getCurrentInstructionNumber() {
        return 0L;
    }

    @Override
    protected byte getIOPortByte(int n) throws ModuleException, ModuleWriteOnlyPortException {
        return 0;
    }

    @Override
    protected byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        return null;
    }

    @Override
    protected byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        return null;
    }

    @Override
    public int getIPS() {
        return 5000000;
    }

    @Override
    public String getNextInstructionInfo() {
        return null;
    }

    @Override
    public String getRegisterHex(int n) {
        return null;
    }

    @Override
    protected byte[] getRegisterValue(String string) {
        return null;
    }

    @Override
    protected void incrementInstructionCounter() {
    }

    @Override
    protected boolean initInstructionTables() {
        return false;
    }

    @Override
    protected boolean initRegisters() {
        return false;
    }

    @Override
    public void interruptRequest(boolean bl) {
        if (bl) {
            this.raiseInterrupt();
        } else {
            this.clearInterrupt();
        }
    }

    @Override
    public boolean isAbnormalTermination() {
        return false;
    }

    @Override
    public void setCpuInstructionDebug(boolean bl) {
    }

    @Override
    public void setHoldRequest(boolean bl, ModuleDevice moduleDevice) {
    }

    @Override
    protected void setIOPortByte(int n, byte by) throws ModuleException {
    }

    @Override
    protected void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
    }

    @Override
    protected void setIOPortWord(int n, byte[] byArray) throws ModuleException {
    }

    @Override
    public void setIPS(int n) {
    }

    @Override
    public void setIPS(int n, int n2) {
    }

    @Override
    protected boolean setRegisterValue(String string, byte[] byArray) {
        return false;
    }

    @Override
    protected void setRunning(boolean bl) {
    }

    @Override
    public String[] getConnection() {
        return new String[0];
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean getDebugMode() {
        return false;
    }

    @Override
    public String getDump() {
        return null;
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getName() {
        return "8086 compatible CPU";
    }

    @Override
    public String getType() {
        return "cpu";
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isObserved() {
        return false;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public void setDebugMode(boolean bl) {
    }

    @Override
    public void setObserved(boolean bl) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8; ++j) {
                if ((1 & i >> j) != 1) continue;
                bl = !bl;
            }
            Processor.parityMap[i] = bl;
        }
    }
}

