/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSource;
import dioscuri.module.cpu32.Decoder;
import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.MicrocodeSet;

public final class ProtectedModeUDecoder
implements MicrocodeSet,
Decoder,
InstructionSource {
    private static final boolean[] modrmArray = new boolean[]{true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true};
    private static final boolean[] sibArray = new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] twoByte_0f_modrmArray = new boolean[]{true, true, true, true, false, false, false, false, false, false, false, true, false, false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] twoByte_0f_sibArray = new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int PREFICES_SG = 7;
    private static final int PREFICES_ES = 1;
    private static final int PREFICES_CS = 2;
    private static final int PREFICES_SS = 3;
    private static final int PREFICES_DS = 4;
    private static final int PREFICES_FS = 5;
    private static final int PREFICES_GS = 6;
    private static final int PREFICES_OPERAND = 8;
    private static final int PREFICES_ADDRESS = 16;
    private static final int PREFICES_REPNE = 32;
    private static final int PREFICES_REPE = 64;
    private static final int PREFICES_REP = 96;
    private static final int PREFICES_LOCK = 128;
    private ByteSource source;
    private Operation current = new Operation();
    private Operation waiting = new Operation();
    private Operation working = new Operation();
    private boolean blockComplete;
    private boolean addressModeDecoded;
    private boolean operandSizeIs32Bit;

    @Override
    public InstructionSource decodeReal(ByteSource byteSource) {
        return null;
    }

    @Override
    public InstructionSource decodeVirtual8086(ByteSource byteSource) {
        return null;
    }

    @Override
    public InstructionSource decodeProtected(ByteSource byteSource, boolean bl) {
        this.reset();
        this.operandSizeIs32Bit = bl;
        this.source = byteSource;
        return this;
    }

    private void blockFinished() {
        this.blockComplete = true;
    }

    private void rotate() {
        Operation operation = this.current;
        this.current = this.waiting;
        this.waiting = this.working;
        this.working = operation;
    }

    @Override
    public boolean getNext() {
        this.decode();
        this.rotate();
        if (this.current.decoded()) {
            return true;
        }
        if (this.current.terminal()) {
            this.reset();
            return false;
        }
        return this.getNext();
    }

    private void reset() {
        this.working.reset();
        this.waiting.reset();
        this.current.reset();
        this.blockComplete = false;
    }

    @Override
    public int getMicrocode() {
        return this.current.getMicrocode();
    }

    @Override
    public int getLength() {
        return this.current.getLength();
    }

    @Override
    public int getX86Length() {
        return this.current.getX86Length();
    }

    private boolean decodingAddressMode() {
        if (this.addressModeDecoded) {
            return false;
        }
        this.addressModeDecoded = true;
        return true;
    }

    private void decodeComplete(int n) {
        if (this.addressModeDecoded) {
            this.working.write(0);
            this.addressModeDecoded = false;
        }
        this.working.finish(n);
    }

    private void decode() {
        this.working.reset();
        if (this.blockComplete) {
            this.working.makeTerminal();
            return;
        }
        int n = 0;
        try {
            n = this.decodeOpcode(this.operandSizeIs32Bit);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (RuntimeException runtimeException) {
            if (!this.waiting.decoded()) {
                throw runtimeException;
            }
            this.waiting.write(2);
            this.working.makeTerminal();
            this.blockFinished();
            return;
        }
        if (n < 0) {
            this.decodeComplete(-n);
            this.blockFinished();
        } else {
            this.decodeComplete(n);
        }
    }

    private int decodeOpcode(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = bl ? 24 : 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        block34: while (true) {
            ++n4;
            n = 0xFF & this.source.getByte();
            switch (n) {
                case 15: {
                    n2 = n2 << 8 | n;
                    n = 0xFF & this.source.getByte();
                    ++n4;
                    n5 = n;
                    break block34;
                }
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: {
                    n2 = n2 << 8 | n;
                    n = 0;
                    n5 = 0xFF & this.source.getByte();
                    ++n4;
                    break block34;
                }
                case 46: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 2;
                    continue block34;
                }
                case 62: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 4;
                    continue block34;
                }
                case 38: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 1;
                    continue block34;
                }
                case 54: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 3;
                    continue block34;
                }
                case 100: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 5;
                    continue block34;
                }
                case 101: {
                    n3 &= 0xFFFFFFF8;
                    n3 |= 6;
                    continue block34;
                }
                case 102: {
                    n3 ^= 8;
                    continue block34;
                }
                case 103: {
                    n3 ^= 0x10;
                    continue block34;
                }
                case 242: {
                    n3 |= 0x20;
                    continue block34;
                }
                case 243: {
                    n3 |= 0x40;
                    continue block34;
                }
                case 240: {
                    n3 |= 0x80;
                    continue block34;
                }
            }
            break;
        }
        n = n2 << 8 | n;
        switch (n2) {
            case 0: {
                if (modrmArray[n]) {
                    n5 = 0xFF & this.source.getByte();
                    ++n4;
                } else {
                    n5 = -1;
                }
                if (n5 == -1 || (n3 & 0x10) == 0) {
                    n6 = -1;
                    break;
                }
                if (sibArray[n5]) {
                    n6 = 0xFF & this.source.getByte();
                    ++n4;
                    break;
                }
                n6 = -1;
                break;
            }
            case 15: {
                if (twoByte_0f_modrmArray[0xFF & n]) {
                    n5 = 0xFF & this.source.getByte();
                    ++n4;
                } else {
                    n5 = -1;
                }
                if (n5 == -1 || (n3 & 0x10) == 0) {
                    n6 = -1;
                    break;
                }
                if (twoByte_0f_sibArray[n5]) {
                    n6 = 0xFF & this.source.getByte();
                    ++n4;
                    break;
                }
                n6 = -1;
                break;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (sibArray[n5]) {
                    n6 = 0xFF & this.source.getByte();
                    ++n4;
                    break;
                }
                n6 = -1;
                break;
            }
            default: {
                n5 = -1;
                n6 = -1;
            }
        }
        if (ProtectedModeUDecoder.isJump(n, n5)) {
            this.working.write(2);
        }
        int n7 = 0;
        switch (ProtectedModeUDecoder.operationHasDisplacement(n3, n, n5, n6)) {
            case 0: {
                break;
            }
            case 1: {
                n7 = this.source.getByte();
                ++n4;
                break;
            }
            case 2: {
                n7 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00;
                n4 += 2;
                break;
            }
            case 4: {
                n7 = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000;
                n4 += 4;
                break;
            }
            default: {
                System.err.println("Displacement Longer Than 4-bytes");
            }
        }
        long l = 0L;
        switch (ProtectedModeUDecoder.operationHasImmediate(n3, n, n5)) {
            case 0: {
                break;
            }
            case 1: {
                l = this.source.getByte();
                ++n4;
                break;
            }
            case 2: {
                l = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00;
                n4 += 2;
                break;
            }
            case 3: {
                l = this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000 | this.source.getByte() & 0xFF;
                n4 += 3;
                break;
            }
            case 4: {
                l = this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000;
                n4 += 4;
                break;
            }
            case 6: {
                l = 0xFFFFFFFFL & (long)(this.source.getByte() & 0xFF | this.source.getByte() << 8 & 0xFF00 | this.source.getByte() << 16 & 0xFF0000 | this.source.getByte() << 24 & 0xFF000000);
                l |= ((long)this.source.getByte() & 0xFFL | (long)(this.source.getByte() << 8) & 0xFF00L) << 32;
                n4 += 6;
                break;
            }
            default: {
                System.err.println("Immediate Longer Than 6-bytes");
            }
        }
        this.writeInputOperands(n3, n, n5, n6, n7, l);
        this.writeOperation(n3, n, n5);
        this.writeOutputOperands(n3, n, n5, n6, n7);
        this.writeFlags(n3, n, n5);
        if (ProtectedModeUDecoder.isJump(n, n5)) {
            return -n4;
        }
        return n4;
    }

    private void writeOperation(int n, int n2, int n3) {
        block0 : switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 4032: 
            case 4033: {
                this.working.write(20);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.working.write(84);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.working.write(69);
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.working.write(117);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 132: 
            case 133: 
            case 168: 
            case 169: {
                this.working.write(57);
                break;
            }
            case 39: {
                this.working.write(468);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.working.write(16);
                break;
            }
            case 47: {
                this.working.write(469);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.working.write(41);
                break;
            }
            case 55: {
                this.working.write(464);
                break;
            }
            case 63: {
                this.working.write(467);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.working.write(54);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.working.write(77);
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 104: 
            case 106: 
            case 4000: 
            case 4008: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(4);
                        break;
                    }
                    case 8: {
                        this.working.write(165);
                        break;
                    }
                    case 16: {
                        this.working.write(513);
                        break;
                    }
                    case 24: {
                        this.working.write(514);
                    }
                }
                break;
            }
            case 156: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(521);
                        break;
                    }
                    case 8: {
                        this.working.write(522);
                        break;
                    }
                    case 16: {
                        this.working.write(523);
                        break;
                    }
                    case 24: {
                        this.working.write(524);
                    }
                }
                break;
            }
            case 7: 
            case 23: 
            case 31: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 143: 
            case 4001: 
            case 4009: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(11);
                        break;
                    }
                    case 8: {
                        this.working.write(164);
                        break;
                    }
                    case 16: {
                        this.working.write(515);
                        break;
                    }
                    case 24: {
                        this.working.write(516);
                    }
                }
                break;
            }
            case 157: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(517);
                        break;
                    }
                    case 8: {
                        this.working.write(518);
                        break;
                    }
                    case 16: {
                        this.working.write(519);
                        break;
                    }
                    case 24: {
                        this.working.write(520);
                    }
                }
                break;
            }
            case 96: {
                switch (n & 8) {
                    case 0: {
                        this.working.write(232);
                        break;
                    }
                    case 8: {
                        this.working.write(526);
                    }
                }
                break;
            }
            case 97: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(124);
                        break;
                    }
                    case 8: {
                        this.working.write(231);
                        break;
                    }
                    case 16: {
                        this.working.write(527);
                        break;
                    }
                    case 24: {
                        this.working.write(528);
                    }
                }
                break;
            }
            case 98: {
                if ((n & 8) != 0) {
                    this.working.write(508);
                    break;
                }
                this.working.write(507);
                break;
            }
            case 105: 
            case 107: 
            case 4015: {
                if ((n & 8) != 0) {
                    this.working.write(353);
                    break;
                }
                this.working.write(352);
                break;
            }
            case 108: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(555);
                        break;
                    }
                    this.working.write(554);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(549);
                    break;
                }
                this.working.write(548);
                break;
            }
            case 109: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(559);
                            break;
                        }
                        this.working.write(558);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(553);
                        break;
                    }
                    this.working.write(552);
                    break;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(557);
                        break;
                    }
                    this.working.write(556);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(551);
                    break;
                }
                this.working.write(550);
                break;
            }
            case 110: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(585);
                        break;
                    }
                    this.working.write(584);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(579);
                    break;
                }
                this.working.write(578);
                break;
            }
            case 111: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(589);
                            break;
                        }
                        this.working.write(588);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(583);
                        break;
                    }
                    this.working.write(582);
                    break;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(587);
                        break;
                    }
                    this.working.write(586);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(581);
                    break;
                }
                this.working.write(580);
                break;
            }
            case 112: {
                this.working.write(397);
                break;
            }
            case 113: {
                this.working.write(398);
                break;
            }
            case 114: {
                this.working.write(72);
                break;
            }
            case 115: {
                this.working.write(71);
                break;
            }
            case 116: {
                this.working.write(45);
                break;
            }
            case 117: {
                this.working.write(23);
                break;
            }
            case 118: {
                this.working.write(99);
                break;
            }
            case 119: {
                this.working.write(98);
                break;
            }
            case 120: {
                this.working.write(399);
                break;
            }
            case 121: {
                this.working.write(201);
                break;
            }
            case 122: {
                this.working.write(400);
                break;
            }
            case 123: {
                this.working.write(401);
                break;
            }
            case 124: {
                this.working.write(105);
                break;
            }
            case 125: {
                this.working.write(149);
                break;
            }
            case 126: {
                this.working.write(156);
                break;
            }
            case 127: {
                this.working.write(138);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(20);
                        break;
                    }
                    case 8: {
                        this.working.write(84);
                        break;
                    }
                    case 16: {
                        this.working.write(69);
                        break;
                    }
                    case 24: {
                        this.working.write(117);
                        break;
                    }
                    case 32: {
                        this.working.write(57);
                        break;
                    }
                    case 40: 
                    case 56: {
                        this.working.write(16);
                        break;
                    }
                    case 48: {
                        this.working.write(41);
                    }
                }
                break;
            }
            case 152: {
                if ((n & 8) != 0) {
                    this.working.write(6);
                    this.working.write(530);
                    this.working.write(155);
                    break;
                }
                this.working.write(34);
                this.working.write(111);
                this.working.write(12);
                break;
            }
            case 153: {
                if ((n & 8) != 0) {
                    this.working.write(389);
                    break;
                }
                this.working.write(143);
                break;
            }
            case 154: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(139);
                        break;
                    }
                    case 8: {
                        this.working.write(346);
                        break;
                    }
                    case 16: {
                        this.working.write(347);
                        break;
                    }
                    case 24: {
                        this.working.write(348);
                    }
                }
                break;
            }
            case 155: {
                this.working.write(506);
                break;
            }
            case 158: {
                this.working.write(390);
                break;
            }
            case 159: {
                this.working.write(173);
                break;
            }
            case 164: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(574);
                        break;
                    }
                    this.working.write(127);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(570);
                    break;
                }
                this.working.write(112);
                break;
            }
            case 165: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(577);
                            break;
                        }
                        this.working.write(576);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(573);
                        break;
                    }
                    this.working.write(572);
                    break;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(575);
                        break;
                    }
                    this.working.write(130);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(571);
                    break;
                }
                this.working.write(221);
                break;
            }
            case 166: {
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(537);
                        break;
                    }
                    this.working.write(158);
                    break;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(543);
                        break;
                    }
                    this.working.write(542);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(532);
                    break;
                }
                this.working.write(531);
                break;
            }
            case 167: {
                if ((n & 8) != 0) {
                    if ((n & 0x40) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(541);
                            break;
                        }
                        this.working.write(540);
                        break;
                    }
                    if ((n & 0x20) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(547);
                            break;
                        }
                        this.working.write(546);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(536);
                        break;
                    }
                    this.working.write(535);
                    break;
                }
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(539);
                        break;
                    }
                    this.working.write(538);
                    break;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(545);
                        break;
                    }
                    this.working.write(544);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(534);
                    break;
                }
                this.working.write(533);
                break;
            }
            case 170: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(612);
                        break;
                    }
                    this.working.write(611);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(607);
                    break;
                }
                this.working.write(148);
                break;
            }
            case 171: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(615);
                            break;
                        }
                        this.working.write(614);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(610);
                        break;
                    }
                    this.working.write(609);
                    break;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(613);
                        break;
                    }
                    this.working.write(179);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(608);
                    break;
                }
                this.working.write(186);
                break;
            }
            case 172: {
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(565);
                        break;
                    }
                    this.working.write(564);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(560);
                    break;
                }
                this.working.write(123);
                break;
            }
            case 173: {
                if ((n & 8) != 0) {
                    if ((n & 0x60) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(569);
                            break;
                        }
                        this.working.write(568);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(563);
                        break;
                    }
                    this.working.write(562);
                    break;
                }
                if ((n & 0x60) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(567);
                        break;
                    }
                    this.working.write(566);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(561);
                    break;
                }
                this.working.write(157);
                break;
            }
            case 174: {
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(597);
                        break;
                    }
                    this.working.write(596);
                    break;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(602);
                        break;
                    }
                    this.working.write(166);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(591);
                    break;
                }
                this.working.write(590);
                break;
            }
            case 175: {
                if ((n & 8) != 0) {
                    if ((n & 0x40) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(601);
                            break;
                        }
                        this.working.write(600);
                        break;
                    }
                    if ((n & 0x20) != 0) {
                        if ((n & 0x10) != 0) {
                            this.working.write(606);
                            break;
                        }
                        this.working.write(605);
                        break;
                    }
                    if ((n & 0x10) != 0) {
                        this.working.write(595);
                        break;
                    }
                    this.working.write(594);
                    break;
                }
                if ((n & 0x40) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(599);
                        break;
                    }
                    this.working.write(598);
                    break;
                }
                if ((n & 0x20) != 0) {
                    if ((n & 0x10) != 0) {
                        this.working.write(604);
                        break;
                    }
                    this.working.write(603);
                    break;
                }
                if ((n & 0x10) != 0) {
                    this.working.write(593);
                    break;
                }
                this.working.write(592);
                break;
            }
            case 192: 
            case 208: 
            case 210: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(361);
                        break;
                    }
                    case 8: {
                        this.working.write(163);
                        break;
                    }
                    case 16: {
                        this.working.write(366);
                        break;
                    }
                    case 24: {
                        this.working.write(368);
                        break;
                    }
                    case 32: {
                        this.working.write(80);
                        break;
                    }
                    case 40: {
                        this.working.write(96);
                        break;
                    }
                    case 48: {
                        System.err.println("Using invalid SHL encoding");
                        this.working.write(80);
                        break;
                    }
                    case 56: {
                        this.working.write(359);
                    }
                }
                break;
            }
            case 193: 
            case 209: 
            case 211: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(363);
                            break;
                        }
                        case 8: {
                            this.working.write(365);
                            break;
                        }
                        case 16: {
                            this.working.write(367);
                            break;
                        }
                        case 24: {
                            this.working.write(370);
                            break;
                        }
                        case 32: {
                            this.working.write(80);
                            break;
                        }
                        case 40: {
                            this.working.write(96);
                            break;
                        }
                        case 48: {
                            System.err.println("Using invalid SHL encoding");
                            this.working.write(80);
                            break;
                        }
                        case 56: {
                            this.working.write(360);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(362);
                        break;
                    }
                    case 8: {
                        this.working.write(364);
                        break;
                    }
                    case 16: {
                        this.working.write(213);
                        break;
                    }
                    case 24: {
                        this.working.write(369);
                        break;
                    }
                    case 32: {
                        this.working.write(80);
                        break;
                    }
                    case 40: {
                        this.working.write(96);
                        break;
                    }
                    case 48: {
                        System.err.println("Using invalid SHL encoding");
                        this.working.write(80);
                        break;
                    }
                    case 56: {
                        this.working.write(198);
                    }
                }
                break;
            }
            case 194: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(114);
                        break;
                    }
                    case 8: {
                        this.working.write(476);
                        break;
                    }
                    case 16: {
                        this.working.write(477);
                        break;
                    }
                    case 24: {
                        this.working.write(478);
                    }
                }
                break;
            }
            case 195: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(32);
                        break;
                    }
                    case 8: {
                        this.working.write(473);
                        break;
                    }
                    case 16: {
                        this.working.write(474);
                        break;
                    }
                    case 24: {
                        this.working.write(475);
                    }
                }
                break;
            }
            case 200: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(159);
                        break;
                    }
                    case 8: {
                        this.working.write(485);
                        break;
                    }
                    case 16: {
                        this.working.write(486);
                        break;
                    }
                    case 24: {
                        this.working.write(487);
                    }
                }
                break;
            }
            case 201: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(160);
                        break;
                    }
                    case 8: {
                        this.working.write(488);
                        break;
                    }
                    case 16: {
                        this.working.write(489);
                        break;
                    }
                    case 24: {
                        this.working.write(490);
                    }
                }
                break;
            }
            case 202: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(153);
                        break;
                    }
                    case 8: {
                        this.working.write(482);
                        break;
                    }
                    case 16: {
                        this.working.write(483);
                        break;
                    }
                    case 24: {
                        this.working.write(484);
                    }
                }
                break;
            }
            case 203: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(140);
                        break;
                    }
                    case 8: {
                        this.working.write(479);
                        break;
                    }
                    case 16: {
                        this.working.write(480);
                        break;
                    }
                    case 24: {
                        this.working.write(481);
                    }
                }
                break;
            }
            case 204: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(494);
                        break;
                    }
                    case 8: {
                        this.working.write(495);
                        break;
                    }
                    case 16: {
                        this.working.write(496);
                        break;
                    }
                    case 24: {
                        this.working.write(497);
                    }
                }
                break;
            }
            case 205: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(100);
                        break;
                    }
                    case 8: {
                        this.working.write(491);
                        break;
                    }
                    case 16: {
                        this.working.write(492);
                        break;
                    }
                    case 24: {
                        this.working.write(493);
                    }
                }
                break;
            }
            case 206: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(498);
                        break;
                    }
                    case 8: {
                        this.working.write(499);
                        break;
                    }
                    case 16: {
                        this.working.write(500);
                        break;
                    }
                    case 24: {
                        this.working.write(501);
                    }
                }
                break;
            }
            case 207: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(106);
                        break;
                    }
                    case 8: {
                        this.working.write(502);
                        break;
                    }
                    case 16: {
                        this.working.write(503);
                        break;
                    }
                    case 24: {
                        this.working.write(504);
                    }
                }
                break;
            }
            case 212: {
                this.working.write(466);
                break;
            }
            case 213: {
                this.working.write(465);
                break;
            }
            case 224: {
                if ((n & 0x10) != 0) {
                    this.working.write(511);
                    break;
                }
                this.working.write(512);
                break;
            }
            case 225: {
                if ((n & 0x10) != 0) {
                    this.working.write(510);
                    break;
                }
                this.working.write(196);
                break;
            }
            case 226: {
                if ((n & 0x10) != 0) {
                    this.working.write(509);
                    break;
                }
                this.working.write(113);
                break;
            }
            case 227: {
                if ((n & 0x10) != 0) {
                    this.working.write(429);
                    break;
                }
                this.working.write(89);
                break;
            }
            case 228: 
            case 236: {
                this.working.write(116);
                break;
            }
            case 229: 
            case 237: {
                if ((n & 8) != 0) {
                    this.working.write(393);
                    break;
                }
                this.working.write(392);
                break;
            }
            case 230: 
            case 238: {
                this.working.write(103);
                break;
            }
            case 231: 
            case 239: {
                if ((n & 8) != 0) {
                    this.working.write(391);
                    break;
                }
                this.working.write(230);
                break;
            }
            case 232: {
                switch (n & 0x18) {
                    case 0: {
                        this.working.write(28);
                        break;
                    }
                    case 8: {
                        this.working.write(470);
                        break;
                    }
                    case 16: {
                        this.working.write(471);
                        break;
                    }
                    case 24: {
                        this.working.write(472);
                    }
                }
                break;
            }
            case 233: {
                if ((n & 8) != 0) {
                    this.working.write(430);
                    break;
                }
                this.working.write(75);
                break;
            }
            case 234: {
                if ((n & 8) != 0) {
                    this.working.write(344);
                    break;
                }
                this.working.write(142);
                break;
            }
            case 235: {
                this.working.write(70);
                break;
            }
            case 244: {
                this.working.write(505);
                break;
            }
            case 245: {
                this.working.write(463);
                break;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(57);
                        break block0;
                    }
                    case 16: {
                        this.working.write(128);
                        break block0;
                    }
                    case 24: {
                        this.working.write(182);
                        break block0;
                    }
                    case 32: {
                        this.working.write(187);
                        break block0;
                    }
                    case 40: {
                        this.working.write(354);
                        break block0;
                    }
                    case 48: {
                        this.working.write(188);
                        break block0;
                    }
                    case 56: {
                        this.working.write(357);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 3 Instruction?");
            }
            case 247: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(57);
                            break block0;
                        }
                        case 16: {
                            this.working.write(128);
                            break block0;
                        }
                        case 24: {
                            this.working.write(182);
                            break block0;
                        }
                        case 32: {
                            this.working.write(235);
                            break block0;
                        }
                        case 40: {
                            this.working.write(355);
                            break block0;
                        }
                        case 48: {
                            this.working.write(356);
                            break block0;
                        }
                        case 56: {
                            this.working.write(358);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid Gp 3 Instruction?");
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(57);
                        break block0;
                    }
                    case 16: {
                        this.working.write(128);
                        break block0;
                    }
                    case 24: {
                        this.working.write(182);
                        break block0;
                    }
                    case 32: {
                        this.working.write(133);
                        break block0;
                    }
                    case 40: {
                        this.working.write(107);
                        break block0;
                    }
                    case 48: {
                        this.working.write(132);
                        break block0;
                    }
                    case 56: {
                        this.working.write(147);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 3 Instruction?");
            }
            case 248: {
                this.working.write(195);
                break;
            }
            case 249: {
                this.working.write(194);
                break;
            }
            case 250: {
                this.working.write(135);
                break;
            }
            case 251: {
                this.working.write(101);
                break;
            }
            case 252: {
                this.working.write(109);
                break;
            }
            case 253: {
                this.working.write(462);
                break;
            }
            case 254: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(54);
                        break block0;
                    }
                    case 8: {
                        this.working.write(77);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 4 Instruction?");
            }
            case 255: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(54);
                        break block0;
                    }
                    case 8: {
                        this.working.write(77);
                        break block0;
                    }
                    case 16: {
                        switch (n & 0x18) {
                            case 0: {
                                this.working.write(177);
                                break;
                            }
                            case 8: {
                                this.working.write(349);
                                break;
                            }
                            case 16: {
                                this.working.write(350);
                                break;
                            }
                            case 24: {
                                this.working.write(351);
                            }
                        }
                        break block0;
                    }
                    case 24: {
                        switch (n & 0x18) {
                            case 0: {
                                this.working.write(139);
                                break;
                            }
                            case 8: {
                                this.working.write(346);
                                break;
                            }
                            case 16: {
                                this.working.write(347);
                                break;
                            }
                            case 24: {
                                this.working.write(348);
                            }
                        }
                        break block0;
                    }
                    case 32: {
                        if ((n & 8) != 0) {
                            this.working.write(345);
                            break block0;
                        }
                        this.working.write(93);
                        break block0;
                    }
                    case 40: {
                        if ((n & 8) != 0) {
                            this.working.write(344);
                            break block0;
                        }
                        this.working.write(142);
                        break block0;
                    }
                    case 48: {
                        switch (n & 0x18) {
                            case 0: {
                                this.working.write(4);
                                break;
                            }
                            case 8: {
                                this.working.write(165);
                                break;
                            }
                            case 16: {
                                this.working.write(513);
                                break;
                            }
                            case 24: {
                                this.working.write(514);
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 5 Instruction?");
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 215: {
                break;
            }
            default: {
                System.out.println("undecoded instruction 0x" + Integer.toHexString(n2));
                throw new IllegalStateException("Missing Operation: 0x" + Integer.toHexString(n2));
            }
            case 3840: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(625);
                        break block0;
                    }
                    case 8: {
                        this.working.write(623);
                        break block0;
                    }
                    case 16: {
                        this.working.write(626);
                        break block0;
                    }
                    case 24: {
                        this.working.write(624);
                        break block0;
                    }
                    case 32: {
                        this.working.write(635);
                        break block0;
                    }
                    case 40: {
                        this.working.write(636);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 6 Instruction?");
            }
            case 3841: {
                switch (n3 & 0x38) {
                    case 0: {
                        if ((n & 8) != 0) {
                            this.working.write(627);
                            break block0;
                        }
                        this.working.write(628);
                        break block0;
                    }
                    case 8: {
                        if ((n & 8) != 0) {
                            this.working.write(629);
                            break block0;
                        }
                        this.working.write(630);
                        break block0;
                    }
                    case 16: {
                        if ((n & 8) != 0) {
                            this.working.write(631);
                            break block0;
                        }
                        this.working.write(227);
                        break block0;
                    }
                    case 24: {
                        if ((n & 8) != 0) {
                            this.working.write(632);
                            break block0;
                        }
                        this.working.write(633);
                        break block0;
                    }
                    case 32: {
                        this.working.write(228);
                        break block0;
                    }
                    case 48: {
                        this.working.write(634);
                        break block0;
                    }
                    case 56: {
                        this.working.write(637);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 7 Instruction?");
            }
            case 3842: {
                if ((n & 8) != 0) {
                    this.working.write(639);
                    break;
                }
                this.working.write(638);
                break;
            }
            case 3843: {
                if ((n & 8) != 0) {
                    this.working.write(641);
                    break;
                }
                this.working.write(640);
                break;
            }
            case 3846: {
                this.working.write(622);
                break;
            }
            case 3888: {
                this.working.write(617);
                break;
            }
            case 3889: {
                this.working.write(619);
                break;
            }
            case 3890: {
                this.working.write(618);
                break;
            }
            case 3892: {
                this.working.write(620);
                break;
            }
            case 3893: {
                this.working.write(621);
                break;
            }
            case 3904: {
                this.working.write(446);
                break;
            }
            case 3905: {
                this.working.write(447);
                break;
            }
            case 3906: {
                this.working.write(448);
                break;
            }
            case 3907: {
                this.working.write(449);
                break;
            }
            case 3908: {
                this.working.write(450);
                break;
            }
            case 3909: {
                this.working.write(451);
                break;
            }
            case 3910: {
                this.working.write(452);
                break;
            }
            case 3911: {
                this.working.write(453);
                break;
            }
            case 3912: {
                this.working.write(454);
                break;
            }
            case 3913: {
                this.working.write(455);
                break;
            }
            case 3914: {
                this.working.write(456);
                break;
            }
            case 3915: {
                this.working.write(457);
                break;
            }
            case 3916: {
                this.working.write(458);
                break;
            }
            case 3917: {
                this.working.write(459);
                break;
            }
            case 3918: {
                this.working.write(460);
                break;
            }
            case 3919: {
                this.working.write(461);
                break;
            }
            case 3968: {
                if ((n & 8) != 0) {
                    this.working.write(413);
                    break;
                }
                this.working.write(402);
                break;
            }
            case 3969: {
                if ((n & 8) != 0) {
                    this.working.write(414);
                    break;
                }
                this.working.write(403);
                break;
            }
            case 3970: {
                if ((n & 8) != 0) {
                    this.working.write(415);
                    break;
                }
                this.working.write(178);
                break;
            }
            case 3971: {
                if ((n & 8) != 0) {
                    this.working.write(416);
                    break;
                }
                this.working.write(185);
                break;
            }
            case 3972: {
                if ((n & 8) != 0) {
                    this.working.write(417);
                    break;
                }
                this.working.write(104);
                break;
            }
            case 3973: {
                if ((n & 8) != 0) {
                    this.working.write(418);
                    break;
                }
                this.working.write(136);
                break;
            }
            case 3974: {
                if ((n & 8) != 0) {
                    this.working.write(419);
                    break;
                }
                this.working.write(404);
                break;
            }
            case 3975: {
                if ((n & 8) != 0) {
                    this.working.write(420);
                    break;
                }
                this.working.write(214);
                break;
            }
            case 3976: {
                if ((n & 8) != 0) {
                    this.working.write(421);
                    break;
                }
                this.working.write(405);
                break;
            }
            case 3977: {
                if ((n & 8) != 0) {
                    this.working.write(422);
                    break;
                }
                this.working.write(406);
                break;
            }
            case 3978: {
                if ((n & 8) != 0) {
                    this.working.write(423);
                    break;
                }
                this.working.write(407);
                break;
            }
            case 3979: {
                if ((n & 8) != 0) {
                    this.working.write(424);
                    break;
                }
                this.working.write(408);
                break;
            }
            case 3980: {
                if ((n & 8) != 0) {
                    this.working.write(425);
                    break;
                }
                this.working.write(409);
                break;
            }
            case 3981: {
                if ((n & 8) != 0) {
                    this.working.write(426);
                    break;
                }
                this.working.write(410);
                break;
            }
            case 3982: {
                if ((n & 8) != 0) {
                    this.working.write(427);
                    break;
                }
                this.working.write(411);
                break;
            }
            case 3983: {
                if ((n & 8) != 0) {
                    this.working.write(428);
                    break;
                }
                this.working.write(412);
                break;
            }
            case 3984: {
                this.working.write(431);
                break;
            }
            case 3985: {
                this.working.write(432);
                break;
            }
            case 3986: {
                this.working.write(236);
                break;
            }
            case 3987: {
                this.working.write(433);
                break;
            }
            case 3988: {
                this.working.write(434);
                break;
            }
            case 3989: {
                this.working.write(435);
                break;
            }
            case 3990: {
                this.working.write(436);
                break;
            }
            case 3991: {
                this.working.write(437);
                break;
            }
            case 3992: {
                this.working.write(438);
                break;
            }
            case 3993: {
                this.working.write(439);
                break;
            }
            case 3994: {
                this.working.write(440);
                break;
            }
            case 3995: {
                this.working.write(441);
                break;
            }
            case 3996: {
                this.working.write(442);
                break;
            }
            case 3997: {
                this.working.write(443);
                break;
            }
            case 3998: {
                this.working.write(444);
                break;
            }
            case 3999: {
                this.working.write(445);
                break;
            }
            case 4002: {
                this.working.write(616);
                break;
            }
            case 4004: 
            case 4005: {
                if ((n & 8) != 0) {
                    this.working.write(372);
                    break;
                }
                this.working.write(371);
                break;
            }
            case 4012: 
            case 4013: {
                if ((n & 8) != 0) {
                    this.working.write(374);
                    break;
                }
                this.working.write(373);
                break;
            }
            case 4016: 
            case 4017: {
                this.working.write(394);
                break;
            }
            case 4003: {
                switch (n3 & 0xC7) {
                    default: {
                        this.working.write(375);
                        break block0;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                }
                if ((n & 8) != 0) {
                    this.working.write(377);
                    break;
                }
                this.working.write(376);
                break;
            }
            case 4011: {
                switch (n3 & 0xC7) {
                    default: {
                        this.working.write(378);
                        break block0;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                }
                if ((n & 8) != 0) {
                    this.working.write(380);
                    break;
                }
                this.working.write(379);
                break;
            }
            case 4019: {
                switch (n3 & 0xC7) {
                    default: {
                        this.working.write(381);
                        break block0;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                }
                if ((n & 8) != 0) {
                    this.working.write(383);
                    break;
                }
                this.working.write(382);
                break;
            }
            case 4027: {
                switch (n3 & 0xC7) {
                    default: {
                        this.working.write(384);
                        break block0;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                }
                if ((n & 8) != 0) {
                    this.working.write(386);
                    break;
                }
                this.working.write(385);
                break;
            }
            case 4026: {
                switch (n3 & 0x38) {
                    case 32: {
                        switch (n3 & 0xC7) {
                            default: {
                                this.working.write(375);
                                break block0;
                            }
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                        }
                        if ((n & 8) != 0) {
                            this.working.write(377);
                            break block0;
                        }
                        this.working.write(376);
                        break block0;
                    }
                    case 40: {
                        switch (n3 & 0xC7) {
                            default: {
                                this.working.write(378);
                                break block0;
                            }
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                        }
                        if ((n & 8) != 0) {
                            this.working.write(380);
                            break block0;
                        }
                        this.working.write(379);
                        break block0;
                    }
                    case 48: {
                        switch (n3 & 0xC7) {
                            default: {
                                this.working.write(381);
                                break block0;
                            }
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                        }
                        if ((n & 8) != 0) {
                            this.working.write(383);
                            break block0;
                        }
                        this.working.write(382);
                        break block0;
                    }
                    case 56: {
                        switch (n3 & 0xC7) {
                            default: {
                                this.working.write(384);
                                break block0;
                            }
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                        }
                        if ((n & 8) != 0) {
                            this.working.write(386);
                            break block0;
                        }
                        this.working.write(385);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 8 Instruction?");
            }
            case 4028: {
                this.working.write(387);
                break;
            }
            case 4029: {
                this.working.write(388);
                break;
            }
            case 4030: {
                if ((n & 8) != 0) {
                    this.working.write(529);
                    break;
                }
                this.working.write(111);
                break;
            }
            case 4031: {
                if ((n & 8) == 0) break;
                this.working.write(530);
                break;
            }
            case 4039: {
                switch (n3 & 0x38) {
                    case 8: {
                        this.working.write(395);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 6 Instruction?");
            }
            case 4040: 
            case 4041: 
            case 4042: 
            case 4043: 
            case 4044: 
            case 4045: 
            case 4046: 
            case 4047: {
                this.working.write(396);
                break;
            }
            case 3872: 
            case 3873: 
            case 3874: 
            case 3875: 
            case 4018: 
            case 4020: 
            case 4021: 
            case 4022: 
            case 4023: {
                break;
            }
            case 55296: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(702);
                        break;
                    }
                    case 8: {
                        this.working.write(703);
                        break;
                    }
                    case 16: 
                    case 24: {
                        this.working.write(704);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.working.write(708);
                        break;
                    }
                    case 48: 
                    case 56: {
                        this.working.write(709);
                    }
                }
                break;
            }
            case 55552: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(701);
                            break;
                        }
                        case 16: 
                        case 24: 
                        case 40: 
                        case 56: {
                            break;
                        }
                        case 32: {
                            if ((n & 8) != 0) {
                                this.working.write(737);
                                break;
                            }
                            this.working.write(736);
                            break;
                        }
                        case 48: {
                            if ((n & 8) != 0) {
                                this.working.write(739);
                                break;
                            }
                            this.working.write(738);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(701);
                        break;
                    }
                }
                switch (n3) {
                    case 208: {
                        break;
                    }
                    case 224: {
                        this.working.write(710);
                        break;
                    }
                    case 225: {
                        this.working.write(711);
                        break;
                    }
                    case 228: {
                        this.working.write(704);
                        break;
                    }
                    case 229: {
                        this.working.write(712);
                        break;
                    }
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 238: {
                        this.working.write(701);
                        break;
                    }
                    case 240: {
                        this.working.write(713);
                        break;
                    }
                    case 241: {
                        this.working.write(714);
                        break;
                    }
                    case 242: {
                        this.working.write(715);
                        break;
                    }
                    case 243: {
                        this.working.write(716);
                        break;
                    }
                    case 244: {
                        this.working.write(717);
                        break;
                    }
                    case 245: {
                        this.working.write(718);
                        break;
                    }
                    case 246: {
                        this.working.write(719);
                        break;
                    }
                    case 247: {
                        this.working.write(720);
                        break;
                    }
                    case 248: {
                        this.working.write(721);
                        break;
                    }
                    case 249: {
                        this.working.write(722);
                        break;
                    }
                    case 250: {
                        this.working.write(723);
                        break;
                    }
                    case 251: {
                        this.working.write(724);
                        break;
                    }
                    case 252: {
                        this.working.write(725);
                        break;
                    }
                    case 253: {
                        this.working.write(726);
                        break;
                    }
                    case 254: {
                        this.working.write(727);
                        break;
                    }
                    case 255: {
                        this.working.write(728);
                    }
                }
                break;
            }
            case 55808: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(702);
                            break;
                        }
                        case 8: {
                            this.working.write(703);
                            break;
                        }
                        case 16: 
                        case 24: {
                            this.working.write(704);
                            break;
                        }
                        case 32: 
                        case 40: {
                            this.working.write(708);
                            break;
                        }
                        case 48: 
                        case 56: {
                            this.working.write(709);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(740);
                        break;
                    }
                    case 200: {
                        this.working.write(741);
                        break;
                    }
                    case 208: {
                        this.working.write(742);
                        break;
                    }
                    case 216: {
                        this.working.write(743);
                    }
                }
                switch (n3) {
                    case 233: {
                        this.working.write(705);
                    }
                }
                break;
            }
            case 56064: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(701);
                            break block0;
                        }
                        case 8: {
                            this.working.write(748);
                            break block0;
                        }
                        case 16: 
                        case 24: {
                            this.working.write(725);
                            break block0;
                        }
                        case 40: {
                            this.working.write(701);
                            break block0;
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(744);
                        break;
                    }
                    case 200: {
                        this.working.write(745);
                        break;
                    }
                    case 208: {
                        this.working.write(746);
                        break;
                    }
                    case 216: {
                        this.working.write(747);
                        break;
                    }
                    case 232: {
                        this.working.write(707);
                        break;
                    }
                    case 240: {
                        this.working.write(706);
                    }
                }
                switch (n3) {
                    case 226: {
                        this.working.write(749);
                        break block0;
                    }
                    case 227: {
                        this.working.write(750);
                        break block0;
                    }
                }
                break;
            }
            case 56320: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(702);
                        break;
                    }
                    case 8: {
                        this.working.write(703);
                        break;
                    }
                    case 16: 
                    case 24: {
                        this.working.write(704);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.working.write(708);
                        break;
                    }
                    case 48: 
                    case 56: {
                        this.working.write(709);
                    }
                }
                break;
            }
            case 56576: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(701);
                            break;
                        }
                        case 8: {
                            this.working.write(748);
                            break;
                        }
                        case 16: 
                        case 24: 
                        case 56: {
                            break;
                        }
                        case 32: {
                            if ((n & 8) != 0) {
                                this.working.write(730);
                                break;
                            }
                            this.working.write(729);
                            break;
                        }
                        case 48: {
                            if ((n & 8) != 0) {
                                this.working.write(732);
                                break;
                            }
                            this.working.write(731);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(733);
                        break;
                    }
                    case 208: 
                    case 216: {
                        break;
                    }
                    case 224: 
                    case 232: {
                        this.working.write(705);
                    }
                }
                break;
            }
            case 56832: {
                switch (n3) {
                    case 217: {
                        this.working.write(704);
                        break block0;
                    }
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(702);
                        break;
                    }
                    case 8: {
                        this.working.write(703);
                        break;
                    }
                    case 16: 
                    case 24: {
                        this.working.write(704);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.working.write(708);
                        break;
                    }
                    case 48: 
                    case 56: {
                        this.working.write(709);
                    }
                }
                break;
            }
            case 57088: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(701);
                            break;
                        }
                        case 8: {
                            this.working.write(748);
                            break;
                        }
                        case 16: 
                        case 24: 
                        case 56: {
                            this.working.write(725);
                            break;
                        }
                        case 32: {
                            this.working.write(734);
                            break;
                        }
                        case 40: {
                            this.working.write(701);
                            break;
                        }
                        case 48: {
                            this.working.write(735);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 232: {
                        this.working.write(707);
                        break block0;
                    }
                    case 240: {
                        this.working.write(706);
                    }
                }
            }
        }
    }

    private void writeFlags(int n, int n2, int n3) {
        block0 : switch (n2) {
            case 0: 
            case 2: 
            case 4: 
            case 4032: {
                this.working.write(62);
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                this.working.write(102);
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                this.working.write(181);
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 56: 
            case 58: 
            case 60: {
                this.working.write(44);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 4033: {
                if ((n & 8) != 0) {
                    this.working.write(202);
                    break;
                }
                this.working.write(35);
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                if ((n & 8) != 0) {
                    this.working.write(643);
                    break;
                }
                this.working.write(74);
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                if ((n & 8) != 0) {
                    this.working.write(644);
                    break;
                }
                this.working.write(122);
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 57: 
            case 59: 
            case 61: {
                if ((n & 8) != 0) {
                    this.working.write(167);
                    break;
                }
                this.working.write(36);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 32: 
            case 34: 
            case 36: 
            case 48: 
            case 50: 
            case 52: 
            case 132: 
            case 168: {
                this.working.write(39);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 33: 
            case 35: 
            case 37: 
            case 49: 
            case 51: 
            case 53: 
            case 133: 
            case 169: {
                if ((n & 8) != 0) {
                    this.working.write(191);
                    break;
                }
                this.working.write(50);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                if ((n & 8) != 0) {
                    this.working.write(170);
                    break;
                }
                this.working.write(56);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                if ((n & 8) != 0) {
                    this.working.write(642);
                    break;
                }
                this.working.write(78);
                break;
            }
            case 128: 
            case 130: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(62);
                        break;
                    }
                    case 8: {
                        this.working.write(39);
                        break;
                    }
                    case 16: {
                        this.working.write(102);
                        break;
                    }
                    case 24: {
                        this.working.write(181);
                        break;
                    }
                    case 32: {
                        this.working.write(39);
                        break;
                    }
                    case 40: 
                    case 56: {
                        this.working.write(44);
                        break;
                    }
                    case 48: {
                        this.working.write(39);
                    }
                }
                break;
            }
            case 129: 
            case 131: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(202);
                            break;
                        }
                        case 8: {
                            this.working.write(191);
                            break;
                        }
                        case 16: {
                            this.working.write(643);
                            break;
                        }
                        case 24: {
                            this.working.write(644);
                            break;
                        }
                        case 32: {
                            this.working.write(191);
                            break;
                        }
                        case 40: 
                        case 56: {
                            this.working.write(167);
                            break;
                        }
                        case 48: {
                            this.working.write(191);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(35);
                        break;
                    }
                    case 8: {
                        this.working.write(50);
                        break;
                    }
                    case 16: {
                        this.working.write(74);
                        break;
                    }
                    case 24: {
                        this.working.write(122);
                        break;
                    }
                    case 32: {
                        this.working.write(50);
                        break;
                    }
                    case 40: 
                    case 56: {
                        this.working.write(36);
                        break;
                    }
                    case 48: {
                        this.working.write(50);
                    }
                }
                break;
            }
            case 192: 
            case 208: 
            case 210: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(652);
                        break;
                    }
                    case 8: {
                        this.working.write(162);
                        break;
                    }
                    case 16: {
                        this.working.write(647);
                        break;
                    }
                    case 24: {
                        this.working.write(649);
                        break;
                    }
                    case 32: {
                        this.working.write(184);
                        break;
                    }
                    case 40: {
                        this.working.write(211);
                        break;
                    }
                    case 48: {
                        System.err.println("Using invalid SHL encoding");
                        this.working.write(184);
                        break;
                    }
                    case 56: {
                        this.working.write(645);
                    }
                }
                break;
            }
            case 193: 
            case 209: 
            case 211: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(654);
                            break;
                        }
                        case 8: {
                            this.working.write(656);
                            break;
                        }
                        case 16: {
                            this.working.write(648);
                            break;
                        }
                        case 24: {
                            this.working.write(651);
                            break;
                        }
                        case 32: {
                            this.working.write(216);
                            break;
                        }
                        case 40: {
                            this.working.write(210);
                            break;
                        }
                        case 48: {
                            System.err.println("Using invalid SHL encoding");
                            this.working.write(216);
                            break;
                        }
                        case 56: {
                            this.working.write(646);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(653);
                        break;
                    }
                    case 8: {
                        this.working.write(655);
                        break;
                    }
                    case 16: {
                        this.working.write(212);
                        break;
                    }
                    case 24: {
                        this.working.write(650);
                        break;
                    }
                    case 32: {
                        this.working.write(82);
                        break;
                    }
                    case 40: {
                        this.working.write(97);
                        break;
                    }
                    case 48: {
                        System.err.println("Using invalid SHL encoding");
                        this.working.write(82);
                        break;
                    }
                    case 56: {
                        this.working.write(197);
                    }
                }
                break;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(39);
                        break;
                    }
                    case 24: {
                        this.working.write(226);
                    }
                }
                break;
            }
            case 247: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(191);
                            break;
                        }
                        case 24: {
                            this.working.write(657);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(50);
                        break;
                    }
                    case 24: {
                        this.working.write(183);
                    }
                }
                break;
            }
            case 254: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.working.write(151);
                        break;
                    }
                    case 8: {
                        this.working.write(150);
                    }
                }
                break;
            }
            case 255: {
                switch (n3 & 0x38) {
                    case 0: {
                        if ((n & 8) != 0) {
                            this.working.write(170);
                            break;
                        }
                        this.working.write(56);
                        break;
                    }
                    case 8: {
                        if ((n & 8) != 0) {
                            this.working.write(642);
                            break;
                        }
                        this.working.write(78);
                    }
                }
                break;
            }
            case 7: 
            case 23: 
            case 31: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 4001: 
            case 4009: {
                this.working.write(10);
                break;
            }
            case 143: {
                block121: for (int i = 0; i < this.working.getLength(); ++i) {
                    switch (this.working.getMicrocodeAt(i)) {
                        case 311: 
                        case 318: {
                            this.working.replace(i, 303);
                            continue block121;
                        }
                        case 323: {
                            this.working.replace(i, 304);
                            continue block121;
                        }
                        case 331: {
                            this.working.replace(i, 305);
                            continue block121;
                        }
                        case 339: {
                            this.working.replace(i, 306);
                            continue block121;
                        }
                        case 3: 
                        case 49: 
                        case 229: {
                            ++i;
                        }
                    }
                }
                switch (this.working.getMicrocodeAt(this.working.getLength() - 1)) {
                    case 33: 
                    case 256: {
                        break block0;
                    }
                }
                this.working.write(10);
                break;
            }
            case 207: {
                switch (n & 8) {
                    case 0: {
                        this.working.write(118);
                        break;
                    }
                    case 8: {
                        this.working.write(119);
                    }
                }
                break;
            }
            case 4004: 
            case 4005: {
                if ((n & 8) != 0) {
                    this.working.write(216);
                    break;
                }
                this.working.write(82);
                break;
            }
            case 4012: 
            case 4013: {
                if ((n & 8) != 0) {
                    this.working.write(210);
                    break;
                }
                this.working.write(97);
                break;
            }
            case 4016: {
                this.working.write(658);
                break;
            }
            case 4017: {
                if ((n & 8) != 0) {
                    this.working.write(660);
                    break;
                }
                this.working.write(659);
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 39: 
            case 47: 
            case 55: 
            case 63: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 212: 
            case 213: 
            case 215: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 244: 
            case 245: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 3840: 
            case 3841: 
            case 3842: 
            case 3843: 
            case 3846: 
            case 3872: 
            case 3873: 
            case 3874: 
            case 3875: 
            case 3888: 
            case 3889: 
            case 3890: 
            case 3892: 
            case 3893: 
            case 3904: 
            case 3905: 
            case 3906: 
            case 3907: 
            case 3908: 
            case 3909: 
            case 3910: 
            case 3911: 
            case 3912: 
            case 3913: 
            case 3914: 
            case 3915: 
            case 3916: 
            case 3917: 
            case 3918: 
            case 3919: 
            case 3968: 
            case 3969: 
            case 3970: 
            case 3971: 
            case 3972: 
            case 3973: 
            case 3974: 
            case 3975: 
            case 3976: 
            case 3977: 
            case 3978: 
            case 3979: 
            case 3980: 
            case 3981: 
            case 3982: 
            case 3983: 
            case 3984: 
            case 3985: 
            case 3986: 
            case 3987: 
            case 3988: 
            case 3989: 
            case 3990: 
            case 3991: 
            case 3992: 
            case 3993: 
            case 3994: 
            case 3995: 
            case 3996: 
            case 3997: 
            case 3998: 
            case 3999: 
            case 4000: 
            case 4002: 
            case 4003: 
            case 4008: 
            case 4011: 
            case 4015: 
            case 4018: 
            case 4019: 
            case 4020: 
            case 4021: 
            case 4022: 
            case 4023: 
            case 4026: 
            case 4027: 
            case 4028: 
            case 4029: 
            case 4030: 
            case 4031: 
            case 4039: 
            case 4040: 
            case 4041: 
            case 4042: 
            case 4043: 
            case 4044: 
            case 4045: 
            case 4046: 
            case 4047: 
            case 55296: 
            case 55552: 
            case 55808: 
            case 56064: 
            case 56320: 
            case 56576: 
            case 56832: 
            case 57088: {
                return;
            }
            default: {
                throw new IllegalStateException("Missing Flags: 0x" + Integer.toHexString(n2));
            }
        }
    }

    private void writeInputOperands(int n, int n2, int n3, int n4, int n5, long l) {
        block0 : switch (n2) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 32: 
            case 40: 
            case 48: 
            case 56: 
            case 132: 
            case 134: {
                this.load0_Eb(n, n3, n4, n5);
                this.load1_Gb(n3);
                break;
            }
            case 136: {
                this.load0_Gb(n3);
                break;
            }
            case 2: 
            case 10: 
            case 18: 
            case 26: 
            case 34: 
            case 42: 
            case 50: 
            case 58: 
            case 4032: {
                this.load0_Gb(n3);
                this.load1_Eb(n, n3, n4, n5);
                break;
            }
            case 138: 
            case 4022: 
            case 4030: {
                this.load0_Eb(n, n3, n4, n5);
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 25: 
            case 33: 
            case 41: 
            case 49: 
            case 57: 
            case 133: 
            case 135: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.load1_Gd(n3);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.load1_Gw(n3);
                break;
            }
            case 137: {
                if ((n & 8) != 0) {
                    this.load0_Gd(n3);
                    break;
                }
                this.load0_Gw(n3);
                break;
            }
            case 3: 
            case 11: 
            case 19: 
            case 27: 
            case 35: 
            case 43: 
            case 51: 
            case 59: 
            case 4015: 
            case 4028: 
            case 4029: 
            case 4033: {
                if ((n & 8) != 0) {
                    this.load0_Gd(n3);
                    this.load1_Ed(n, n3, n4, n5);
                    break;
                }
                this.load0_Gw(n3);
                this.load1_Ew(n, n3, n4, n5);
                break;
            }
            case 139: 
            case 3843: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                break;
            }
            case 3904: 
            case 3905: 
            case 3906: 
            case 3907: 
            case 3908: 
            case 3909: 
            case 3910: 
            case 3911: 
            case 3912: 
            case 3913: 
            case 3915: 
            case 3916: 
            case 3917: 
            case 3918: 
            case 3919: {
                if ((n & 8) != 0) {
                    this.load0_Gd(n3);
                    this.load1_Ed(n, n3, n4, n5);
                    break;
                }
                this.load0_Gw(n3);
                this.load1_Ew(n, n3, n4, n5);
                break;
            }
            case 141: {
                this.load0_M(n, n3, n4, n5);
                break;
            }
            case 128: 
            case 130: 
            case 192: {
                this.load0_Eb(n, n3, n4, n5);
                this.working.write(26);
                this.working.write((int)l);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 198: 
            case 205: 
            case 212: 
            case 213: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 235: {
                this.working.write(8);
                this.working.write((int)l);
                break;
            }
            case 129: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(168);
                    this.working.write((int)l);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(27);
                this.working.write((int)l);
                break;
            }
            case 104: 
            case 106: 
            case 199: 
            case 232: 
            case 233: 
            case 3968: 
            case 3969: 
            case 3970: 
            case 3971: 
            case 3972: 
            case 3973: 
            case 3974: 
            case 3975: 
            case 3976: 
            case 3977: 
            case 3978: 
            case 3979: 
            case 3980: 
            case 3981: 
            case 3982: 
            case 3983: {
                if ((n & 8) != 0) {
                    this.working.write(255);
                    this.working.write((int)l);
                    break;
                }
                this.working.write(13);
                this.working.write((int)l);
                break;
            }
            case 193: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(26);
                    this.working.write((int)l);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(26);
                this.working.write((int)l);
                break;
            }
            case 131: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(168);
                    this.working.write((int)l);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(27);
                this.working.write((int)l);
                break;
            }
            case 7: 
            case 23: 
            case 31: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 143: {
                break;
            }
            case 194: 
            case 202: {
                this.working.write(13);
                this.working.write((int)l);
                break;
            }
            case 154: 
            case 234: {
                if ((n & 8) != 0) {
                    this.working.write(255);
                    this.working.write((int)l);
                    this.working.write(27);
                    this.working.write((int)(l >>> 32));
                    break;
                }
                this.working.write(13);
                this.working.write((int)(0xFFFFL & l));
                this.working.write(27);
                this.working.write((int)(l >>> 16));
                break;
            }
            case 156: {
                switch (n & 8) {
                    case 0: {
                        this.working.write(120);
                        break;
                    }
                    case 8: {
                        this.working.write(121);
                    }
                }
                break;
            }
            case 236: 
            case 237: {
                this.working.write(38);
                break;
            }
            case 238: {
                this.working.write(38);
                this.working.write(73);
                break;
            }
            case 239: {
                if ((n & 8) != 0) {
                    this.working.write(38);
                    this.working.write(192);
                    break;
                }
                this.working.write(38);
                this.working.write(63);
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 52: 
            case 60: 
            case 168: {
                this.working.write(34);
                this.working.write(26);
                this.working.write((int)l);
                break;
            }
            case 200: {
                this.working.write(13);
                this.working.write((int)(0xFFFFL & l >>> 16));
                this.working.write(26);
                this.working.write((int)(0xFFL & l));
                break;
            }
            case 105: 
            case 107: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(168);
                    this.working.write((int)l);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(27);
                this.working.write((int)l);
                break;
            }
            case 230: {
                this.working.write(8);
                this.working.write((int)l);
                this.working.write(73);
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 53: 
            case 61: 
            case 169: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(168);
                    this.working.write((int)l);
                    break;
                }
                this.working.write(6);
                this.working.write(27);
                this.working.write((int)l);
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                if ((n & 8) != 0) {
                    this.working.write(255);
                    this.working.write((int)l);
                    break;
                }
                this.working.write(13);
                this.working.write((int)l);
                break;
            }
            case 231: {
                if ((n & 8) != 0) {
                    this.working.write(8);
                    this.working.write((int)l);
                    this.working.write(192);
                    break;
                }
                this.working.write(8);
                this.working.write((int)l);
                this.working.write(63);
                break;
            }
            case 64: 
            case 72: 
            case 80: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    break;
                }
                this.working.write(6);
                break;
            }
            case 65: 
            case 73: 
            case 81: {
                if ((n & 8) != 0) {
                    this.working.write(203);
                    break;
                }
                this.working.write(30);
                break;
            }
            case 66: 
            case 74: 
            case 82: {
                if ((n & 8) != 0) {
                    this.working.write(220);
                    break;
                }
                this.working.write(38);
                break;
            }
            case 67: 
            case 75: 
            case 83: {
                if ((n & 8) != 0) {
                    this.working.write(199);
                    break;
                }
                this.working.write(25);
                break;
            }
            case 68: 
            case 76: 
            case 84: {
                if ((n & 8) != 0) {
                    this.working.write(240);
                    break;
                }
                this.working.write(19);
                break;
            }
            case 69: 
            case 77: 
            case 85: {
                if ((n & 8) != 0) {
                    this.working.write(241);
                    break;
                }
                this.working.write(31);
                break;
            }
            case 70: 
            case 78: 
            case 86: {
                if ((n & 8) != 0) {
                    this.working.write(204);
                    break;
                }
                this.working.write(48);
                break;
            }
            case 71: 
            case 79: 
            case 87: {
                if ((n & 8) != 0) {
                    this.working.write(208);
                    break;
                }
                this.working.write(53);
                break;
            }
            case 145: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(219);
                    break;
                }
                this.working.write(6);
                this.working.write(61);
                break;
            }
            case 146: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(217);
                    break;
                }
                this.working.write(6);
                this.working.write(108);
                break;
            }
            case 147: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(222);
                    break;
                }
                this.working.write(6);
                this.working.write(83);
                break;
            }
            case 148: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(270);
                    break;
                }
                this.working.write(6);
                this.working.write(189);
                break;
            }
            case 149: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(271);
                    break;
                }
                this.working.write(6);
                this.working.write(129);
                break;
            }
            case 150: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(272);
                    break;
                }
                this.working.write(6);
                this.working.write(90);
                break;
            }
            case 151: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    this.working.write(223);
                    break;
                }
                this.working.write(6);
                this.working.write(87);
                break;
            }
            case 208: {
                this.load0_Eb(n, n3, n4, n5);
                this.working.write(26);
                this.working.write(1);
                break;
            }
            case 210: {
                this.load0_Eb(n, n3, n4, n5);
                this.working.write(92);
                break;
            }
            case 209: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(26);
                    this.working.write(1);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(26);
                this.working.write(1);
                break;
            }
            case 211: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(92);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(92);
                break;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 0: {
                        this.load0_Eb(n, n3, n4, n5);
                        this.working.write(26);
                        this.working.write((int)l);
                        break;
                    }
                    case 16: 
                    case 24: {
                        this.load0_Eb(n, n3, n4, n5);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.load0_Eb(n, n3, n4, n5);
                        break;
                    }
                    case 48: 
                    case 56: {
                        this.load0_Eb(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 247: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.load0_Ed(n, n3, n4, n5);
                            this.working.write(168);
                            this.working.write((int)l);
                            break;
                        }
                        case 16: 
                        case 24: {
                            this.load0_Ed(n, n3, n4, n5);
                            break;
                        }
                        case 32: 
                        case 40: {
                            this.load0_Ed(n, n3, n4, n5);
                            break;
                        }
                        case 48: 
                        case 56: {
                            this.load0_Ed(n, n3, n4, n5);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: {
                        this.load0_Ew(n, n3, n4, n5);
                        this.working.write(27);
                        this.working.write((int)l);
                        break;
                    }
                    case 16: 
                    case 24: {
                        this.load0_Ew(n, n3, n4, n5);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.load0_Ew(n, n3, n4, n5);
                        break;
                    }
                    case 48: 
                    case 56: {
                        this.load0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 254: {
                this.load0_Eb(n, n3, n4, n5);
                break;
            }
            case 6: {
                this.working.write(67);
                break;
            }
            case 14: {
                this.working.write(171);
                break;
            }
            case 22: {
                this.working.write(134);
                break;
            }
            case 30: {
                this.working.write(51);
                break;
            }
            case 98: {
                if ((n & 8) != 0) {
                    this.load0_Eq(n, n3, n4, n5);
                    this.load1_Gd(n3);
                    break;
                }
                this.load0_Ed(n, n3, n4, n5);
                this.load1_Gw(n3);
                break;
            }
            case 140: {
                this.load0_Sw(n3);
                break;
            }
            case 142: 
            case 4023: 
            case 4031: {
                this.load0_Ew(n, n3, n4, n5);
                break;
            }
            case 160: {
                this.load0_Ob(n, n5);
                break;
            }
            case 162: {
                this.working.write(34);
                break;
            }
            case 161: {
                if ((n & 8) != 0) {
                    this.load0_Od(n, n5);
                    break;
                }
                this.load0_Ow(n, n5);
                break;
            }
            case 163: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    break;
                }
                this.working.write(6);
                break;
            }
            case 108: 
            case 109: {
                this.working.write(38);
                break;
            }
            case 110: 
            case 111: {
                this.working.write(38);
                this.decodeSegmentPrefix(n);
                break;
            }
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 172: 
            case 173: {
                this.decodeSegmentPrefix(n);
                break;
            }
            case 170: {
                this.working.write(34);
                break;
            }
            case 171: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    break;
                }
                this.working.write(6);
                break;
            }
            case 174: {
                this.working.write(34);
                break;
            }
            case 175: {
                if ((n & 8) != 0) {
                    this.working.write(152);
                    break;
                }
                this.working.write(6);
                break;
            }
            case 255: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 48: {
                            this.load0_Ed(n, n3, n4, n5);
                            break;
                        }
                        case 24: 
                        case 40: {
                            this.load0_Ed(n, n3, n4, n5);
                            this.working.write(3);
                            this.working.write(4);
                            this.working.write(52);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 48: {
                        this.load0_Ew(n, n3, n4, n5);
                        break;
                    }
                    case 24: 
                    case 40: {
                        this.load0_Ew(n, n3, n4, n5);
                        this.working.write(3);
                        this.working.write(2);
                        this.working.write(52);
                    }
                }
                break;
            }
            case 196: 
            case 197: 
            case 4018: 
            case 4020: 
            case 4021: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.working.write(3);
                    this.working.write(4);
                    this.working.write(52);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.working.write(3);
                this.working.write(2);
                this.working.write(52);
                break;
            }
            case 215: {
                switch (n & 7) {
                    case 1: {
                        this.working.write(59);
                        break;
                    }
                    case 2: {
                        this.working.write(76);
                        break;
                    }
                    case 3: {
                        this.working.write(5);
                        break;
                    }
                    default: {
                        this.working.write(14);
                        break;
                    }
                    case 5: {
                        this.working.write(301);
                        break;
                    }
                    case 6: {
                        this.working.write(302);
                    }
                }
                if ((n & 0x10) != 0) {
                    if (this.decodingAddressMode()) {
                        this.working.write(310);
                        this.working.write(343);
                    }
                } else if (this.decodingAddressMode()) {
                    this.working.write(18);
                    this.working.write(343);
                    this.working.write(1);
                }
                this.working.write(22);
                break;
            }
            case 3840: {
                switch (n3 & 0x38) {
                    case 16: 
                    case 24: 
                    case 32: 
                    case 40: {
                        this.load0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 3841: {
                switch (n3 & 0x38) {
                    case 16: 
                    case 24: {
                        this.load0_Ew(n, n3, n4, n5);
                        this.working.write(229);
                        this.working.write(2);
                        this.working.write(215);
                        break;
                    }
                    case 48: {
                        this.load0_Ew(n, n3, n4, n5);
                        break;
                    }
                    case 56: {
                        this.decodeM(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 4000: {
                this.working.write(242);
                break;
            }
            case 4008: {
                this.working.write(243);
                break;
            }
            case 3872: {
                this.load0_Cd(n3);
                break;
            }
            case 3873: {
                this.load0_Dd(n3);
                break;
            }
            case 3874: 
            case 3875: {
                this.load0_Rd(n3);
                break;
            }
            case 3888: {
                this.working.write(203);
                this.working.write(217);
                this.working.write(296);
                break;
            }
            case 3890: {
                this.working.write(203);
                break;
            }
            case 3893: {
                this.working.write(203);
                this.working.write(217);
                break;
            }
            case 4004: 
            case 4012: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.load1_Gd(n3);
                    this.working.write(300);
                    this.working.write((int)l);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.load1_Gw(n3);
                this.working.write(300);
                this.working.write((int)l);
                break;
            }
            case 4005: 
            case 4013: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.load1_Gd(n3);
                    this.working.write(299);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.load1_Gw(n3);
                this.working.write(299);
                break;
            }
            case 4016: {
                this.load0_Eb(n, n3, n4, n5);
                this.load1_Gb(n3);
                this.working.write(298);
                break;
            }
            case 4017: {
                if ((n & 8) != 0) {
                    this.load0_Ed(n, n3, n4, n5);
                    this.load1_Gd(n3);
                    this.working.write(296);
                    break;
                }
                this.load0_Ew(n, n3, n4, n5);
                this.load1_Gw(n3);
                this.working.write(297);
                break;
            }
            case 4003: 
            case 4011: 
            case 4019: 
            case 4027: {
                if ((n & 8) != 0) {
                    switch (n3 & 0xC7) {
                        default: {
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 192: {
                            this.working.write(152);
                            break;
                        }
                        case 193: {
                            this.working.write(203);
                            break;
                        }
                        case 194: {
                            this.working.write(220);
                            break;
                        }
                        case 195: {
                            this.working.write(199);
                            break;
                        }
                        case 196: {
                            this.working.write(240);
                            break;
                        }
                        case 197: {
                            this.working.write(241);
                            break;
                        }
                        case 198: {
                            this.working.write(204);
                            break;
                        }
                        case 199: {
                            this.working.write(208);
                        }
                    }
                    this.load1_Gd(n3);
                    break;
                }
                switch (n3 & 0xC7) {
                    default: {
                        this.decodeM(n, n3, n4, n5);
                        break;
                    }
                    case 192: {
                        this.working.write(6);
                        break;
                    }
                    case 193: {
                        this.working.write(30);
                        break;
                    }
                    case 194: {
                        this.working.write(38);
                        break;
                    }
                    case 195: {
                        this.working.write(25);
                        break;
                    }
                    case 196: {
                        this.working.write(19);
                        break;
                    }
                    case 197: {
                        this.working.write(31);
                        break;
                    }
                    case 198: {
                        this.working.write(48);
                        break;
                    }
                    case 199: {
                        this.working.write(53);
                    }
                }
                this.load1_Gw(n3);
                break;
            }
            case 4026: {
                if ((n & 8) != 0) {
                    switch (n3 & 0xC7) {
                        default: {
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 192: {
                            this.working.write(152);
                            break;
                        }
                        case 193: {
                            this.working.write(203);
                            break;
                        }
                        case 194: {
                            this.working.write(220);
                            break;
                        }
                        case 195: {
                            this.working.write(199);
                            break;
                        }
                        case 196: {
                            this.working.write(240);
                            break;
                        }
                        case 197: {
                            this.working.write(241);
                            break;
                        }
                        case 198: {
                            this.working.write(204);
                            break;
                        }
                        case 199: {
                            this.working.write(208);
                            break;
                        }
                    }
                } else {
                    switch (n3 & 0xC7) {
                        default: {
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 192: {
                            this.working.write(6);
                            break;
                        }
                        case 193: {
                            this.working.write(30);
                            break;
                        }
                        case 194: {
                            this.working.write(38);
                            break;
                        }
                        case 195: {
                            this.working.write(25);
                            break;
                        }
                        case 196: {
                            this.working.write(19);
                            break;
                        }
                        case 197: {
                            this.working.write(31);
                            break;
                        }
                        case 198: {
                            this.working.write(48);
                            break;
                        }
                        case 199: {
                            this.working.write(53);
                        }
                    }
                }
                this.working.write(26);
                this.working.write((int)l & 0x1F);
                break;
            }
            case 4039: {
                switch (n3 & 0x38) {
                    case 8: {
                        this.decodeM(n, n3, n4, n5);
                        this.working.write(253);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 6 Instruction?");
            }
            case 4040: {
                this.working.write(152);
                break;
            }
            case 4041: {
                this.working.write(203);
                break;
            }
            case 4042: {
                this.working.write(220);
                break;
            }
            case 4043: {
                this.working.write(199);
                break;
            }
            case 4044: {
                this.working.write(240);
                break;
            }
            case 4045: {
                this.working.write(241);
                break;
            }
            case 4046: {
                this.working.write(204);
                break;
            }
            case 4047: {
                this.working.write(208);
                break;
            }
            case 55296: {
                this.working.write(506);
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 40: 
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(664);
                            this.working.write(676);
                            break block0;
                        }
                    }
                    this.working.write(662);
                    this.decodeM(n, n3, n4, n5);
                    this.working.write(678);
                    break;
                }
                switch (n3 & 0xF8) {
                    case 232: 
                    case 248: {
                        this.working.write(663);
                        this.working.write(n3 & 7);
                        this.working.write(676);
                        break block0;
                    }
                }
                this.working.write(662);
                this.working.write(677);
                this.working.write(n3 & 7);
                break;
            }
            case 55552: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(506);
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(664);
                            break;
                        }
                        case 16: 
                        case 24: {
                            this.working.write(506);
                            this.working.write(662);
                            break;
                        }
                        case 32: {
                            this.working.write(506);
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 40: {
                            this.working.write(506);
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(9);
                            break;
                        }
                        case 48: {
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 56: {
                            this.working.write(696);
                        }
                    }
                    break;
                }
                this.working.write(506);
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(663);
                        this.working.write(n3 & 7);
                        break;
                    }
                    case 200: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(n3 & 7);
                    }
                }
                switch (n3) {
                    case 208: 
                    case 246: 
                    case 247: {
                        break;
                    }
                    case 224: 
                    case 225: 
                    case 229: 
                    case 240: 
                    case 242: 
                    case 244: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 254: 
                    case 255: {
                        this.working.write(662);
                        break;
                    }
                    case 241: 
                    case 243: 
                    case 245: 
                    case 248: 
                    case 249: 
                    case 253: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(1);
                        break;
                    }
                    case 228: {
                        this.working.write(662);
                        this.working.write(683);
                        break;
                    }
                    case 232: {
                        this.working.write(669);
                        break;
                    }
                    case 233: {
                        this.working.write(670);
                        break;
                    }
                    case 234: {
                        this.working.write(671);
                        break;
                    }
                    case 235: {
                        this.working.write(672);
                        break;
                    }
                    case 236: {
                        this.working.write(673);
                        break;
                    }
                    case 237: {
                        this.working.write(674);
                        break;
                    }
                    case 238: {
                        this.working.write(675);
                    }
                }
                break;
            }
            case 55808: {
                this.working.write(506);
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 40: 
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(169);
                            this.working.write(667);
                            this.working.write(676);
                            break block0;
                        }
                    }
                    this.working.write(662);
                    this.decodeM(n, n3, n4, n5);
                    this.working.write(169);
                    this.working.write(681);
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 200: 
                    case 208: 
                    case 216: {
                        this.working.write(663);
                        this.working.write(n3 & 7);
                    }
                }
                switch (n3) {
                    case 233: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(1);
                    }
                }
                break;
            }
            case 56064: {
                if ((n3 & 0xC0) != 192) {
                    this.working.write(506);
                    switch (n3 & 0x38) {
                        case 0: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(169);
                            this.working.write(667);
                            break;
                        }
                        case 8: 
                        case 16: 
                        case 24: 
                        case 56: {
                            this.working.write(662);
                            break;
                        }
                        case 40: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(666);
                        }
                    }
                    break;
                }
                switch (n3) {
                    case 226: 
                    case 227: {
                        break;
                    }
                    default: {
                        this.working.write(506);
                    }
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 200: 
                    case 208: 
                    case 216: {
                        this.working.write(663);
                        this.working.write(n3 & 7);
                        break;
                    }
                    case 232: 
                    case 240: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(n3 & 7);
                    }
                }
                break;
            }
            case 56320: {
                this.working.write(506);
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 40: 
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(665);
                            this.working.write(676);
                            break block0;
                        }
                    }
                    this.working.write(662);
                    this.decodeM(n, n3, n4, n5);
                    this.working.write(679);
                    break;
                }
                switch (n3 & 0xF8) {
                    case 232: 
                    case 248: {
                        this.working.write(663);
                        this.working.write(n3 & 7);
                        this.working.write(676);
                        break block0;
                    }
                }
                this.working.write(662);
                this.working.write(677);
                this.working.write(n3 & 7);
                break;
            }
            case 56576: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: {
                            this.working.write(506);
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(665);
                            break;
                        }
                        case 8: 
                        case 16: 
                        case 24: {
                            this.working.write(506);
                            this.working.write(662);
                            break;
                        }
                        case 32: {
                            this.working.write(506);
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 48: {
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 56: {
                            this.working.write(698);
                        }
                    }
                    break;
                }
                this.working.write(506);
                switch (n3 & 0xF8) {
                    case 192: {
                        this.working.write(255);
                        this.working.write(n3 & 7);
                        break;
                    }
                    case 208: 
                    case 216: {
                        this.working.write(662);
                        break;
                    }
                    case 224: 
                    case 232: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(n3 & 7);
                    }
                }
                break;
            }
            case 56832: {
                this.working.write(506);
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 40: 
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(9);
                            this.working.write(667);
                            this.working.write(676);
                            break block0;
                        }
                        case 48: {
                            this.working.write(662);
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(253);
                            this.working.write(682);
                            break block0;
                        }
                    }
                    this.working.write(662);
                    this.decodeM(n, n3, n4, n5);
                    this.working.write(9);
                    this.working.write(681);
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 200: 
                    case 224: 
                    case 240: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(n3 & 7);
                        break;
                    }
                    case 232: 
                    case 248: {
                        this.working.write(676);
                        this.working.write(663);
                        this.working.write(n3 & 7);
                    }
                }
                switch (n3) {
                    case 217: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(1);
                    }
                }
                break;
            }
            case 57088: {
                if ((n3 & 0xC0) != 192) {
                    this.working.write(506);
                    switch (n3 & 0x38) {
                        case 0: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(9);
                            this.working.write(667);
                            break;
                        }
                        case 40: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(253);
                            this.working.write(668);
                            break;
                        }
                        case 8: 
                        case 16: 
                        case 24: 
                        case 56: {
                            this.working.write(662);
                            break;
                        }
                        case 48: {
                            this.working.write(662);
                            this.decodeM(n, n3, n4, n5);
                            break;
                        }
                        case 32: {
                            this.decodeM(n, n3, n4, n5);
                        }
                    }
                    break;
                }
                switch (n3) {
                    case 224: {
                        this.working.write(698);
                        break;
                    }
                    default: {
                        this.working.write(506);
                    }
                }
                switch (n3 & 0xF8) {
                    case 232: 
                    case 240: {
                        this.working.write(662);
                        this.working.write(677);
                        this.working.write(n3 & 7);
                    }
                }
            }
        }
    }

    private void writeOutputOperands(int n, int n2, int n3, int n4, int n5) {
        block0 : switch (n2) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 32: 
            case 40: 
            case 48: 
            case 136: 
            case 192: 
            case 198: 
            case 254: 
            case 3984: 
            case 3985: 
            case 3986: 
            case 3987: 
            case 3988: 
            case 3989: 
            case 3990: 
            case 3991: 
            case 3992: 
            case 3993: 
            case 3994: 
            case 3995: 
            case 3996: 
            case 3997: 
            case 3998: 
            case 3999: {
                this.store0_Eb(n, n3, n4, n5);
                break;
            }
            case 4016: {
                this.working.write(218);
                this.store0_Eb(n, n3, n4, n5);
                break;
            }
            case 128: 
            case 130: {
                if ((n3 & 0x38) == 56) break;
                this.store0_Eb(n, n3, n4, n5);
                break;
            }
            case 134: {
                this.store0_Gb(n3);
                this.store1_Eb(n, n3, n4, n5);
                break;
            }
            case 2: 
            case 10: 
            case 18: 
            case 26: 
            case 34: 
            case 42: 
            case 50: 
            case 138: {
                this.store0_Gb(n3);
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 25: 
            case 33: 
            case 41: 
            case 49: 
            case 137: 
            case 143: 
            case 193: 
            case 199: 
            case 209: 
            case 211: {
                if ((n & 8) != 0) {
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 4017: {
                if ((n & 8) != 0) {
                    this.working.write(273);
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                this.working.write(86);
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 129: 
            case 131: {
                if ((n3 & 0x38) == 56) break;
                if ((n & 8) != 0) {
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 135: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.store1_Ed(n, n3, n4, n5);
                    break;
                }
                this.store0_Gw(n3);
                this.store1_Ew(n, n3, n4, n5);
                break;
            }
            case 3: 
            case 11: 
            case 19: 
            case 27: 
            case 35: 
            case 43: 
            case 51: 
            case 105: 
            case 107: 
            case 139: 
            case 141: 
            case 3842: 
            case 3904: 
            case 3905: 
            case 3906: 
            case 3907: 
            case 3908: 
            case 3909: 
            case 3910: 
            case 3911: 
            case 3912: 
            case 3913: 
            case 3914: 
            case 3915: 
            case 3916: 
            case 3917: 
            case 3918: 
            case 3919: 
            case 4015: 
            case 4022: 
            case 4023: 
            case 4028: 
            case 4029: 
            case 4030: 
            case 4031: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    break;
                }
                this.store0_Gw(n3);
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 52: 
            case 176: 
            case 228: 
            case 236: {
                this.working.write(24);
                break;
            }
            case 177: {
                this.working.write(94);
                break;
            }
            case 178: {
                this.working.write(115);
                break;
            }
            case 179: {
                this.working.write(81);
                break;
            }
            case 180: {
                this.working.write(60);
                break;
            }
            case 181: {
                this.working.write(144);
                break;
            }
            case 182: {
                this.working.write(174);
                break;
            }
            case 183: {
                this.working.write(58);
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 53: 
            case 64: 
            case 72: 
            case 88: 
            case 184: 
            case 229: 
            case 237: {
                if ((n & 8) != 0) {
                    this.working.write(155);
                    break;
                }
                this.working.write(12);
                break;
            }
            case 65: 
            case 73: 
            case 89: 
            case 185: {
                if ((n & 8) != 0) {
                    this.working.write(205);
                    break;
                }
                this.working.write(29);
                break;
            }
            case 66: 
            case 74: 
            case 90: 
            case 186: {
                if ((n & 8) != 0) {
                    this.working.write(209);
                    break;
                }
                this.working.write(42);
                break;
            }
            case 67: 
            case 75: 
            case 91: 
            case 187: {
                if ((n & 8) != 0) {
                    this.working.write(200);
                    break;
                }
                this.working.write(15);
                break;
            }
            case 68: 
            case 76: 
            case 92: 
            case 188: {
                if ((n & 8) != 0) {
                    this.working.write(256);
                    break;
                }
                this.working.write(33);
                break;
            }
            case 69: 
            case 77: 
            case 93: 
            case 189: {
                if ((n & 8) != 0) {
                    this.working.write(257);
                    break;
                }
                this.working.write(17);
                break;
            }
            case 70: 
            case 78: 
            case 94: 
            case 190: {
                if ((n & 8) != 0) {
                    this.working.write(207);
                    break;
                }
                this.working.write(40);
                break;
            }
            case 71: 
            case 79: 
            case 95: 
            case 191: {
                if ((n & 8) != 0) {
                    this.working.write(206);
                    break;
                }
                this.working.write(47);
                break;
            }
            case 145: {
                if ((n & 8) != 0) {
                    this.working.write(205);
                    this.working.write(273);
                    break;
                }
                this.working.write(29);
                this.working.write(86);
                break;
            }
            case 146: {
                if ((n & 8) != 0) {
                    this.working.write(209);
                    this.working.write(273);
                    break;
                }
                this.working.write(42);
                this.working.write(86);
                break;
            }
            case 147: {
                if ((n & 8) != 0) {
                    this.working.write(200);
                    this.working.write(273);
                    break;
                }
                this.working.write(15);
                this.working.write(86);
                break;
            }
            case 148: {
                if ((n & 8) != 0) {
                    this.working.write(256);
                    this.working.write(273);
                    break;
                }
                this.working.write(33);
                this.working.write(86);
                break;
            }
            case 149: {
                if ((n & 8) != 0) {
                    this.working.write(257);
                    this.working.write(273);
                    break;
                }
                this.working.write(17);
                this.working.write(86);
                break;
            }
            case 150: {
                if ((n & 8) != 0) {
                    this.working.write(207);
                    this.working.write(273);
                    break;
                }
                this.working.write(40);
                this.working.write(86);
                break;
            }
            case 151: {
                if ((n & 8) != 0) {
                    this.working.write(206);
                    this.working.write(273);
                    break;
                }
                this.working.write(47);
                this.working.write(86);
                break;
            }
            case 157: {
                switch (n & 8) {
                    case 0: {
                        this.working.write(118);
                        break;
                    }
                    case 8: {
                        this.working.write(119);
                    }
                }
                break;
            }
            case 208: 
            case 210: {
                this.store0_Eb(n, n3, n4, n5);
                break;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 16: 
                    case 24: {
                        this.store0_Eb(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 247: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 16: 
                        case 24: {
                            this.store0_Ed(n, n3, n4, n5);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 16: 
                    case 24: {
                        this.store0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 7: {
                this.working.write(55);
                break;
            }
            case 23: {
                this.working.write(141);
                break;
            }
            case 31: {
                this.working.write(37);
                break;
            }
            case 140: {
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 142: {
                this.store0_Sw(n3);
                break;
            }
            case 160: {
                this.working.write(24);
                break;
            }
            case 162: {
                this.store0_Ob(n, n5);
                break;
            }
            case 161: {
                if ((n & 8) != 0) {
                    this.working.write(155);
                    break;
                }
                this.working.write(12);
                break;
            }
            case 163: {
                if ((n & 8) != 0) {
                    this.store0_Od(n, n5);
                    break;
                }
                this.store0_Ow(n, n5);
                break;
            }
            case 255: {
                if ((n & 8) != 0) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 8: {
                            this.store0_Ed(n, n3, n4, n5);
                        }
                    }
                    break;
                }
                switch (n3 & 0x38) {
                    case 0: 
                    case 8: {
                        this.store0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 196: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.working.write(85);
                    break;
                }
                this.store0_Gw(n3);
                this.working.write(85);
                break;
            }
            case 197: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.working.write(91);
                    break;
                }
                this.store0_Gw(n3);
                this.working.write(91);
                break;
            }
            case 3840: {
                block104 : switch (n3 & 0x38) {
                    case 0: {
                        this.store0_Ew(n, n3, n4, n5);
                        break;
                    }
                    case 8: {
                        if ((n & 8) != 0) {
                            switch (n3 & 0xC7) {
                                default: {
                                    this.decodeM(n, n3, n4, n5);
                                    this.working.write(21);
                                    break block104;
                                }
                                case 192: {
                                    this.working.write(155);
                                    break block104;
                                }
                                case 193: {
                                    this.working.write(205);
                                    break block104;
                                }
                                case 194: {
                                    this.working.write(209);
                                    break block104;
                                }
                                case 195: {
                                    this.working.write(200);
                                    break block104;
                                }
                                case 196: {
                                    this.working.write(256);
                                    break block104;
                                }
                                case 197: {
                                    this.working.write(257);
                                    break block104;
                                }
                                case 198: {
                                    this.working.write(207);
                                    break block104;
                                }
                                case 199: 
                            }
                            this.working.write(206);
                            break;
                        }
                        this.store0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 3841: {
                switch (n3 & 0x38) {
                    case 0: 
                    case 8: {
                        this.store0_Ew(n, n3, n4, n5);
                        this.working.write(229);
                        this.working.write(2);
                        this.working.write(295);
                        break;
                    }
                    case 32: {
                        this.store0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 4004: 
            case 4005: 
            case 4012: 
            case 4013: {
                if ((n & 8) != 0) {
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 4018: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.working.write(292);
                    break;
                }
                this.store0_Gw(n3);
                this.working.write(292);
                break;
            }
            case 4020: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.working.write(293);
                    break;
                }
                this.store0_Gw(n3);
                this.working.write(293);
                break;
            }
            case 4021: {
                if ((n & 8) != 0) {
                    this.store0_Gd(n3);
                    this.working.write(294);
                    break;
                }
                this.store0_Gw(n3);
                this.working.write(294);
                break;
            }
            case 4032: {
                this.store1_Gb(n3);
                this.store0_Eb(n, n3, n4, n5);
                break;
            }
            case 4033: {
                if ((n & 8) != 0) {
                    this.store1_Gd(n3);
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                this.store1_Gw(n3);
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 215: {
                this.working.write(24);
                break;
            }
            case 3872: 
            case 3873: {
                this.store0_Rd(n3);
                break;
            }
            case 3874: {
                this.store0_Cd(n3);
                break;
            }
            case 3875: {
                this.store0_Dd(n3);
                break;
            }
            case 3889: 
            case 3890: {
                this.working.write(155);
                this.working.write(275);
                break;
            }
            case 4001: {
                this.working.write(259);
                break;
            }
            case 4009: {
                this.working.write(260);
                break;
            }
            case 4011: 
            case 4019: 
            case 4027: {
                if ((n & 8) != 0) {
                    if ((n3 & 0xC0) != 192) break;
                    this.store0_Ed(n, n3, n4, n5);
                    break;
                }
                if ((n3 & 0xC0) != 192) break;
                this.store0_Ew(n, n3, n4, n5);
                break;
            }
            case 4026: {
                switch (n3 & 0x38) {
                    case 40: 
                    case 48: 
                    case 56: {
                        if ((n & 8) != 0) {
                            if ((n3 & 0xC0) != 192) break;
                            this.store0_Ed(n, n3, n4, n5);
                            break;
                        }
                        if ((n3 & 0xC0) != 192) break;
                        this.store0_Ew(n, n3, n4, n5);
                    }
                }
                break;
            }
            case 4039: {
                switch (n3 & 0x38) {
                    case 8: {
                        this.decodeM(n, n3, n4, n5);
                        this.working.write(254);
                        break block0;
                    }
                }
                throw new IllegalStateException("Invalid Gp 6 Instruction?");
            }
            case 4040: {
                this.working.write(155);
                break;
            }
            case 4041: {
                this.working.write(205);
                break;
            }
            case 4042: {
                this.working.write(209);
                break;
            }
            case 4043: {
                this.working.write(200);
                break;
            }
            case 4044: {
                this.working.write(256);
                break;
            }
            case 4045: {
                this.working.write(257);
                break;
            }
            case 4046: {
                this.working.write(207);
                break;
            }
            case 4047: {
                this.working.write(206);
                break;
            }
            case 55296: {
                switch (n3 & 0x38) {
                    case 0: 
                    case 8: 
                    case 32: 
                    case 40: 
                    case 48: 
                    case 56: {
                        this.working.write(684);
                        this.working.write(751);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 24: {
                        this.working.write(700);
                    }
                }
                break;
            }
            case 55552: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 32: 
                        case 48: {
                            break;
                        }
                        case 16: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(686);
                            break;
                        }
                        case 24: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(686);
                            this.working.write(700);
                            break;
                        }
                        case 40: {
                            this.working.write(697);
                            break;
                        }
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(21);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: {
                        break;
                    }
                    case 200: {
                        this.working.write(685);
                        this.working.write(n3 & 7);
                        this.working.write(690);
                    }
                }
                switch (n3) {
                    case 208: 
                    case 228: 
                    case 229: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 238: 
                    case 246: 
                    case 247: {
                        break;
                    }
                    case 224: 
                    case 225: 
                    case 254: 
                    case 255: {
                        this.working.write(684);
                        break;
                    }
                    case 240: 
                    case 245: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: {
                        this.working.write(684);
                        this.working.write(751);
                        break;
                    }
                    case 242: {
                        this.working.write(684);
                        this.working.write(669);
                        this.working.write(701);
                        break;
                    }
                    case 241: 
                    case 243: {
                        this.working.write(700);
                        this.working.write(684);
                        break;
                    }
                    case 249: {
                        this.working.write(700);
                        this.working.write(684);
                        this.working.write(751);
                        break;
                    }
                    case 244: {
                        this.working.write(690);
                        this.working.write(701);
                        break;
                    }
                    case 251: {
                        this.working.write(690);
                        this.working.write(701);
                        this.working.write(751);
                        this.working.write(752);
                    }
                }
                break;
            }
            case 55808: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 8: 
                        case 32: 
                        case 40: 
                        case 48: 
                        case 56: {
                            this.working.write(684);
                            this.working.write(751);
                            break;
                        }
                        case 16: {
                            break;
                        }
                        case 24: {
                            this.working.write(700);
                        }
                    }
                    break;
                }
                switch (n3) {
                    case 233: {
                        this.working.write(700);
                        this.working.write(700);
                    }
                }
                break;
            }
            case 56064: {
                if ((n3 & 0xC0) == 192) break;
                switch (n3 & 0x38) {
                    case 0: 
                    case 40: {
                        break;
                    }
                    case 16: {
                        this.decodeM(n, n3, n4, n5);
                        this.working.write(161);
                        break;
                    }
                    case 8: 
                    case 24: {
                        this.decodeM(n, n3, n4, n5);
                        this.working.write(161);
                        this.working.write(700);
                        break;
                    }
                    case 56: {
                        this.decodeM(n, n3, n4, n5);
                        this.working.write(688);
                        this.working.write(700);
                    }
                }
                break;
            }
            case 56320: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 8: 
                        case 32: 
                        case 40: 
                        case 48: 
                        case 56: {
                            this.working.write(684);
                            this.working.write(751);
                            break;
                        }
                        case 16: {
                            break;
                        }
                        case 24: {
                            this.working.write(700);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 200: 
                    case 224: 
                    case 232: 
                    case 240: 
                    case 248: {
                        this.working.write(685);
                        this.working.write(n3 & 7);
                        this.working.write(751);
                    }
                }
                break;
            }
            case 56576: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 32: 
                        case 48: {
                            break;
                        }
                        case 8: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(254);
                            this.working.write(700);
                            break;
                        }
                        case 16: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(687);
                            break;
                        }
                        case 24: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(687);
                            this.working.write(700);
                            break;
                        }
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(21);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 224: {
                        break;
                    }
                    case 208: {
                        this.working.write(685);
                        this.working.write(n3 & 7);
                        break;
                    }
                    case 216: {
                        this.working.write(685);
                        this.working.write(n3 & 7);
                        this.working.write(700);
                        break;
                    }
                    case 232: {
                        this.working.write(700);
                    }
                }
                break;
            }
            case 56832: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 8: 
                        case 32: 
                        case 40: 
                        case 48: 
                        case 56: {
                            this.working.write(684);
                            this.working.write(751);
                            break;
                        }
                        case 16: {
                            break;
                        }
                        case 24: {
                            this.working.write(700);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 192: 
                    case 200: 
                    case 224: 
                    case 232: 
                    case 240: 
                    case 248: {
                        this.working.write(685);
                        this.working.write(n3 & 7);
                        this.working.write(700);
                        this.working.write(751);
                        break;
                    }
                }
                switch (n3) {
                    case 217: {
                        this.working.write(700);
                        this.working.write(700);
                    }
                }
                break;
            }
            case 57088: {
                if ((n3 & 0xC0) != 192) {
                    switch (n3 & 0x38) {
                        case 0: 
                        case 32: 
                        case 40: 
                        case 48: {
                            break;
                        }
                        case 8: 
                        case 24: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(21);
                            this.working.write(700);
                            break;
                        }
                        case 16: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(21);
                            break;
                        }
                        case 56: {
                            this.decodeM(n, n3, n4, n5);
                            this.working.write(254);
                            this.working.write(700);
                        }
                    }
                    break;
                }
                switch (n3 & 0xF8) {
                    case 232: 
                    case 240: {
                        this.working.write(700);
                    }
                }
                switch (n3) {
                    case 224: {
                        this.working.write(12);
                    }
                }
            }
        }
    }

    private static int operationHasImmediate(int n, int n2, int n3) {
        switch (n2) {
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 52: 
            case 60: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 168: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 192: 
            case 193: 
            case 198: 
            case 205: 
            case 212: 
            case 213: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 235: 
            case 4004: 
            case 4012: 
            case 4026: {
                return 1;
            }
            case 194: 
            case 202: {
                return 2;
            }
            case 200: {
                return 3;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 53: 
            case 61: 
            case 104: 
            case 105: 
            case 129: 
            case 169: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 199: 
            case 232: 
            case 233: 
            case 3968: 
            case 3969: 
            case 3970: 
            case 3971: 
            case 3972: 
            case 3973: 
            case 3974: 
            case 3975: 
            case 3976: 
            case 3977: 
            case 3978: 
            case 3979: 
            case 3980: 
            case 3981: 
            case 3982: 
            case 3983: {
                if ((n & 8) != 0) {
                    return 4;
                }
                return 2;
            }
            case 154: 
            case 234: {
                if ((n & 8) != 0) {
                    return 6;
                }
                return 4;
            }
            case 246: {
                switch (n3 & 0x38) {
                    case 0: {
                        return 1;
                    }
                }
                return 0;
            }
            case 247: {
                switch (n3 & 0x38) {
                    case 0: {
                        if ((n & 8) != 0) {
                            return 4;
                        }
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    private static int operationHasDisplacement(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 98: 
            case 105: 
            case 107: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 246: 
            case 247: 
            case 254: 
            case 255: 
            case 3840: 
            case 3841: 
            case 3872: 
            case 3874: 
            case 3904: 
            case 3905: 
            case 3906: 
            case 3907: 
            case 3908: 
            case 3909: 
            case 3910: 
            case 3911: 
            case 3912: 
            case 3913: 
            case 3914: 
            case 3915: 
            case 3916: 
            case 3917: 
            case 3918: 
            case 3919: 
            case 3984: 
            case 3985: 
            case 3986: 
            case 3987: 
            case 3988: 
            case 3989: 
            case 3990: 
            case 3991: 
            case 3992: 
            case 3993: 
            case 3994: 
            case 3995: 
            case 3996: 
            case 3997: 
            case 3998: 
            case 3999: 
            case 4003: 
            case 4004: 
            case 4005: 
            case 4011: 
            case 4012: 
            case 4013: 
            case 4015: 
            case 4016: 
            case 4017: 
            case 4018: 
            case 4019: 
            case 4020: 
            case 4021: 
            case 4022: 
            case 4023: 
            case 4026: 
            case 4027: 
            case 4028: 
            case 4029: 
            case 4030: 
            case 4031: 
            case 4032: 
            case 4033: 
            case 4039: {
                return ProtectedModeUDecoder.modrmHasDisplacement(n, n3, n4);
            }
            case 55296: 
            case 55552: 
            case 55808: 
            case 56064: 
            case 56320: 
            case 56576: 
            case 56832: 
            case 57088: {
                if ((n3 & 0xC0) != 192) {
                    return ProtectedModeUDecoder.modrmHasDisplacement(n, n3, n4);
                }
                return 0;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                if ((n & 0x10) != 0) {
                    return 4;
                }
                return 2;
            }
        }
        return 0;
    }

    private static int modrmHasDisplacement(int n, int n2, int n3) {
        if ((n & 0x10) != 0) {
            switch (n2 & 0xC0) {
                case 0: {
                    switch (n2 & 7) {
                        case 4: {
                            if ((n3 & 7) == 5) {
                                return 4;
                            }
                            return 0;
                        }
                        case 5: {
                            return 4;
                        }
                    }
                    break;
                }
                case 64: {
                    return 1;
                }
                case 128: {
                    return 4;
                }
            }
        } else {
            switch (n2 & 0xC0) {
                case 0: {
                    if ((n2 & 7) == 6) {
                        return 2;
                    }
                    return 0;
                }
                case 64: {
                    return 1;
                }
                case 128: {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static boolean isFarJump(int n, int n2) {
        switch (n) {
            case 154: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 234: 
            case 241: 
            case 3892: 
            case 3893: {
                return true;
            }
            case 255: {
                switch (n2 & 0x38) {
                    case 24: 
                    case 40: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isNearJump(int n, int n2) {
        switch (n) {
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 194: 
            case 195: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 232: 
            case 233: 
            case 235: {
                return true;
            }
            case 255: {
                switch (n2 & 0x38) {
                    case 16: 
                    case 32: {
                        return true;
                    }
                }
                return false;
            }
            case 3968: 
            case 3969: 
            case 3970: 
            case 3971: 
            case 3972: 
            case 3973: 
            case 3974: 
            case 3975: 
            case 3976: 
            case 3977: 
            case 3978: 
            case 3979: 
            case 3980: 
            case 3981: 
            case 3982: 
            case 3983: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModeSwitch(int n, int n2) {
        switch (n) {
            case 3874: {
                return true;
            }
            case 3841: {
                return (n2 & 0x38) == 48;
            }
        }
        return false;
    }

    public static boolean isBlockTerminating(int n, int n2) {
        switch (n) {
            case 244: 
            case 251: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJump(int n, int n2) {
        return ProtectedModeUDecoder.isNearJump(n, n2) || ProtectedModeUDecoder.isFarJump(n, n2) || ProtectedModeUDecoder.isModeSwitch(n, n2) || ProtectedModeUDecoder.isBlockTerminating(n, n2);
    }

    private void store0_Cd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(225);
                break;
            }
            case 16: {
                this.working.write(261);
                break;
            }
            case 24: {
                this.working.write(262);
                break;
            }
            case 32: {
                this.working.write(263);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Control Register Operand");
            }
        }
    }

    private void load0_Cd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(224);
                break;
            }
            case 16: {
                this.working.write(244);
                break;
            }
            case 24: {
                this.working.write(245);
                break;
            }
            case 32: {
                this.working.write(246);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Control Register Operand");
            }
        }
    }

    private void store0_Dd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(264);
                break;
            }
            case 8: {
                this.working.write(265);
                break;
            }
            case 16: {
                this.working.write(266);
                break;
            }
            case 24: {
                this.working.write(267);
                break;
            }
            case 48: {
                this.working.write(268);
                break;
            }
            case 56: {
                this.working.write(269);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Debug Register Operand");
            }
        }
    }

    private void load0_Dd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(247);
                break;
            }
            case 8: {
                this.working.write(248);
                break;
            }
            case 16: {
                this.working.write(249);
                break;
            }
            case 24: {
                this.working.write(250);
                break;
            }
            case 48: {
                this.working.write(251);
                break;
            }
            case 56: {
                this.working.write(252);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Debug Register Operand");
            }
        }
    }

    private void load0_Eb(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(22);
                break;
            }
            case 192: {
                this.working.write(34);
                break;
            }
            case 193: {
                this.working.write(137);
                break;
            }
            case 194: {
                this.working.write(110);
                break;
            }
            case 195: {
                this.working.write(131);
                break;
            }
            case 196: {
                this.working.write(46);
                break;
            }
            case 197: {
                this.working.write(146);
                break;
            }
            case 198: {
                this.working.write(175);
                break;
            }
            case 199: {
                this.working.write(65);
            }
        }
    }

    private void load1_Eb(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(88);
                break;
            }
            case 192: {
                this.working.write(73);
                break;
            }
            case 193: {
                this.working.write(92);
                break;
            }
            case 194: {
                this.working.write(126);
                break;
            }
            case 195: {
                this.working.write(154);
                break;
            }
            case 196: {
                this.working.write(68);
                break;
            }
            case 197: {
                this.working.write(145);
                break;
            }
            case 198: {
                this.working.write(176);
                break;
            }
            case 199: {
                this.working.write(64);
            }
        }
    }

    private void store0_Eb(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(66);
                break;
            }
            case 192: {
                this.working.write(24);
                break;
            }
            case 193: {
                this.working.write(94);
                break;
            }
            case 194: {
                this.working.write(115);
                break;
            }
            case 195: {
                this.working.write(81);
                break;
            }
            case 196: {
                this.working.write(60);
                break;
            }
            case 197: {
                this.working.write(144);
                break;
            }
            case 198: {
                this.working.write(174);
                break;
            }
            case 199: {
                this.working.write(58);
            }
        }
    }

    private void store1_Eb(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(234);
                break;
            }
            case 192: {
                this.working.write(218);
                break;
            }
            case 193: {
                this.working.write(180);
                break;
            }
            case 194: {
                this.working.write(285);
                break;
            }
            case 195: {
                this.working.write(286);
                break;
            }
            case 196: {
                this.working.write(287);
                break;
            }
            case 197: {
                this.working.write(288);
                break;
            }
            case 198: {
                this.working.write(289);
                break;
            }
            case 199: {
                this.working.write(290);
            }
        }
    }

    private void load0_Ew(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(9);
                break;
            }
            case 192: {
                this.working.write(6);
                break;
            }
            case 193: {
                this.working.write(30);
                break;
            }
            case 194: {
                this.working.write(38);
                break;
            }
            case 195: {
                this.working.write(25);
                break;
            }
            case 196: {
                this.working.write(19);
                break;
            }
            case 197: {
                this.working.write(31);
                break;
            }
            case 198: {
                this.working.write(48);
                break;
            }
            case 199: {
                this.working.write(53);
            }
        }
    }

    private void store0_Ew(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(21);
                break;
            }
            case 192: {
                this.working.write(12);
                break;
            }
            case 193: {
                this.working.write(29);
                break;
            }
            case 194: {
                this.working.write(42);
                break;
            }
            case 195: {
                this.working.write(15);
                break;
            }
            case 196: {
                this.working.write(33);
                break;
            }
            case 197: {
                this.working.write(17);
                break;
            }
            case 198: {
                this.working.write(40);
                break;
            }
            case 199: {
                this.working.write(47);
            }
        }
    }

    private void load1_Ew(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(52);
                break;
            }
            case 192: {
                this.working.write(63);
                break;
            }
            case 193: {
                this.working.write(61);
                break;
            }
            case 194: {
                this.working.write(108);
                break;
            }
            case 195: {
                this.working.write(83);
                break;
            }
            case 196: {
                this.working.write(189);
                break;
            }
            case 197: {
                this.working.write(129);
                break;
            }
            case 198: {
                this.working.write(90);
                break;
            }
            case 199: {
                this.working.write(87);
            }
        }
    }

    private void store1_Ew(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(190);
                break;
            }
            case 192: {
                this.working.write(86);
                break;
            }
            case 193: {
                this.working.write(280);
                break;
            }
            case 194: {
                this.working.write(281);
                break;
            }
            case 195: {
                this.working.write(282);
                break;
            }
            case 196: {
                this.working.write(283);
                break;
            }
            case 197: {
                this.working.write(284);
                break;
            }
            case 198: {
                this.working.write(233);
                break;
            }
            case 199: {
                this.working.write(172);
            }
        }
    }

    private void load0_Ed(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(169);
                break;
            }
            case 192: {
                this.working.write(152);
                break;
            }
            case 193: {
                this.working.write(203);
                break;
            }
            case 194: {
                this.working.write(220);
                break;
            }
            case 195: {
                this.working.write(199);
                break;
            }
            case 196: {
                this.working.write(240);
                break;
            }
            case 197: {
                this.working.write(241);
                break;
            }
            case 198: {
                this.working.write(204);
                break;
            }
            case 199: {
                this.working.write(208);
            }
        }
    }

    private void store0_Ed(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(161);
                break;
            }
            case 192: {
                this.working.write(155);
                break;
            }
            case 193: {
                this.working.write(205);
                break;
            }
            case 194: {
                this.working.write(209);
                break;
            }
            case 195: {
                this.working.write(200);
                break;
            }
            case 196: {
                this.working.write(256);
                break;
            }
            case 197: {
                this.working.write(257);
                break;
            }
            case 198: {
                this.working.write(207);
                break;
            }
            case 199: {
                this.working.write(206);
            }
        }
    }

    private void load1_Ed(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(215);
                break;
            }
            case 192: {
                this.working.write(192);
                break;
            }
            case 193: {
                this.working.write(219);
                break;
            }
            case 194: {
                this.working.write(217);
                break;
            }
            case 195: {
                this.working.write(222);
                break;
            }
            case 196: {
                this.working.write(270);
                break;
            }
            case 197: {
                this.working.write(271);
                break;
            }
            case 198: {
                this.working.write(272);
                break;
            }
            case 199: {
                this.working.write(223);
            }
        }
    }

    private void store1_Ed(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(295);
                break;
            }
            case 192: {
                this.working.write(273);
                break;
            }
            case 193: {
                this.working.write(274);
                break;
            }
            case 194: {
                this.working.write(275);
                break;
            }
            case 195: {
                this.working.write(276);
                break;
            }
            case 196: {
                this.working.write(10);
                break;
            }
            case 197: {
                this.working.write(277);
                break;
            }
            case 198: {
                this.working.write(278);
                break;
            }
            case 199: {
                this.working.write(279);
            }
        }
    }

    private void load0_Eq(int n, int n2, int n3, int n4) {
        switch (n2 & 0xC7) {
            default: {
                this.decodeM(n, n2, n3, n4);
                this.working.write(253);
                break;
            }
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                throw new IllegalStateException("There are no 64bit GP Registers");
            }
        }
    }

    private void load0_Gb(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(34);
                break;
            }
            case 8: {
                this.working.write(137);
                break;
            }
            case 16: {
                this.working.write(110);
                break;
            }
            case 24: {
                this.working.write(131);
                break;
            }
            case 32: {
                this.working.write(46);
                break;
            }
            case 40: {
                this.working.write(146);
                break;
            }
            case 48: {
                this.working.write(175);
                break;
            }
            case 56: {
                this.working.write(65);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Byte Register Operand");
            }
        }
    }

    private void store0_Gb(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(24);
                break;
            }
            case 8: {
                this.working.write(94);
                break;
            }
            case 16: {
                this.working.write(115);
                break;
            }
            case 24: {
                this.working.write(81);
                break;
            }
            case 32: {
                this.working.write(60);
                break;
            }
            case 40: {
                this.working.write(144);
                break;
            }
            case 48: {
                this.working.write(174);
                break;
            }
            case 56: {
                this.working.write(58);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Byte Register Operand");
            }
        }
    }

    private void load1_Gb(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(73);
                break;
            }
            case 8: {
                this.working.write(92);
                break;
            }
            case 16: {
                this.working.write(126);
                break;
            }
            case 24: {
                this.working.write(154);
                break;
            }
            case 32: {
                this.working.write(68);
                break;
            }
            case 40: {
                this.working.write(145);
                break;
            }
            case 48: {
                this.working.write(176);
                break;
            }
            case 56: {
                this.working.write(64);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Byte Register Operand");
            }
        }
    }

    private void store1_Gb(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(218);
                break;
            }
            case 8: {
                this.working.write(180);
                break;
            }
            case 16: {
                this.working.write(285);
                break;
            }
            case 24: {
                this.working.write(286);
                break;
            }
            case 32: {
                this.working.write(287);
                break;
            }
            case 40: {
                this.working.write(288);
                break;
            }
            case 48: {
                this.working.write(289);
                break;
            }
            case 56: {
                this.working.write(290);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Byte Register Operand");
            }
        }
    }

    private void load0_Gw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(6);
                break;
            }
            case 8: {
                this.working.write(30);
                break;
            }
            case 16: {
                this.working.write(38);
                break;
            }
            case 24: {
                this.working.write(25);
                break;
            }
            case 32: {
                this.working.write(19);
                break;
            }
            case 40: {
                this.working.write(31);
                break;
            }
            case 48: {
                this.working.write(48);
                break;
            }
            case 56: {
                this.working.write(53);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Word Register Operand");
            }
        }
    }

    private void store0_Gw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(12);
                break;
            }
            case 8: {
                this.working.write(29);
                break;
            }
            case 16: {
                this.working.write(42);
                break;
            }
            case 24: {
                this.working.write(15);
                break;
            }
            case 32: {
                this.working.write(33);
                break;
            }
            case 40: {
                this.working.write(17);
                break;
            }
            case 48: {
                this.working.write(40);
                break;
            }
            case 56: {
                this.working.write(47);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Word Register Operand");
            }
        }
    }

    private void load1_Gw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(63);
                break;
            }
            case 8: {
                this.working.write(61);
                break;
            }
            case 16: {
                this.working.write(108);
                break;
            }
            case 24: {
                this.working.write(83);
                break;
            }
            case 32: {
                this.working.write(189);
                break;
            }
            case 40: {
                this.working.write(129);
                break;
            }
            case 48: {
                this.working.write(90);
                break;
            }
            case 56: {
                this.working.write(87);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Word Register Operand");
            }
        }
    }

    private void store1_Gw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(86);
                break;
            }
            case 8: {
                this.working.write(280);
                break;
            }
            case 16: {
                this.working.write(281);
                break;
            }
            case 24: {
                this.working.write(282);
                break;
            }
            case 32: {
                this.working.write(283);
                break;
            }
            case 40: {
                this.working.write(284);
                break;
            }
            case 48: {
                this.working.write(233);
                break;
            }
            case 56: {
                this.working.write(172);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Word Register Operand");
            }
        }
    }

    private void load0_Gd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(152);
                break;
            }
            case 8: {
                this.working.write(203);
                break;
            }
            case 16: {
                this.working.write(220);
                break;
            }
            case 24: {
                this.working.write(199);
                break;
            }
            case 32: {
                this.working.write(240);
                break;
            }
            case 40: {
                this.working.write(241);
                break;
            }
            case 48: {
                this.working.write(204);
                break;
            }
            case 56: {
                this.working.write(208);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DoubleWord Register Operand");
            }
        }
    }

    private void store0_Gd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(155);
                break;
            }
            case 8: {
                this.working.write(205);
                break;
            }
            case 16: {
                this.working.write(209);
                break;
            }
            case 24: {
                this.working.write(200);
                break;
            }
            case 32: {
                this.working.write(256);
                break;
            }
            case 40: {
                this.working.write(257);
                break;
            }
            case 48: {
                this.working.write(207);
                break;
            }
            case 56: {
                this.working.write(206);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DoubleWord Register Operand");
            }
        }
    }

    private void load1_Gd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(192);
                break;
            }
            case 8: {
                this.working.write(219);
                break;
            }
            case 16: {
                this.working.write(217);
                break;
            }
            case 24: {
                this.working.write(222);
                break;
            }
            case 32: {
                this.working.write(270);
                break;
            }
            case 40: {
                this.working.write(271);
                break;
            }
            case 48: {
                this.working.write(272);
                break;
            }
            case 56: {
                this.working.write(223);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DoubleWord Register Operand");
            }
        }
    }

    private void store1_Gd(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(273);
                break;
            }
            case 8: {
                this.working.write(274);
                break;
            }
            case 16: {
                this.working.write(275);
                break;
            }
            case 24: {
                this.working.write(276);
                break;
            }
            case 32: {
                this.working.write(10);
                break;
            }
            case 40: {
                this.working.write(277);
                break;
            }
            case 48: {
                this.working.write(278);
                break;
            }
            case 56: {
                this.working.write(279);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DoubleWord Register Operand");
            }
        }
    }

    private void load0_Sw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(67);
                break;
            }
            case 8: {
                this.working.write(171);
                break;
            }
            case 16: {
                this.working.write(134);
                break;
            }
            case 24: {
                this.working.write(51);
                break;
            }
            case 32: {
                this.working.write(242);
                break;
            }
            case 40: {
                this.working.write(243);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Segment Register Operand");
            }
        }
    }

    private void store0_Sw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(55);
                break;
            }
            case 8: {
                this.working.write(258);
                break;
            }
            case 16: {
                this.working.write(141);
                break;
            }
            case 24: {
                this.working.write(37);
                break;
            }
            case 32: {
                this.working.write(259);
                break;
            }
            case 40: {
                this.working.write(260);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Segment Register Operand");
            }
        }
    }

    private void store1_Sw(int n) {
        switch (n & 0x38) {
            case 0: {
                this.working.write(85);
                break;
            }
            case 8: {
                this.working.write(291);
                break;
            }
            case 16: {
                this.working.write(292);
                break;
            }
            case 24: {
                this.working.write(91);
                break;
            }
            case 32: {
                this.working.write(293);
                break;
            }
            case 40: {
                this.working.write(294);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Segment Register Operand");
            }
        }
    }

    private void decodeO(int n, int n2) {
        switch (n & 7) {
            default: {
                this.working.write(14);
                break;
            }
            case 1: {
                this.working.write(59);
                break;
            }
            case 3: {
                this.working.write(5);
                break;
            }
            case 2: {
                this.working.write(76);
                break;
            }
            case 5: {
                this.working.write(301);
                break;
            }
            case 6: {
                this.working.write(302);
            }
        }
        if ((n & 0x10) != 0) {
            if (this.decodingAddressMode()) {
                this.working.write(229);
            }
            this.working.write(n2);
        } else if (this.decodingAddressMode()) {
            this.working.write(49);
            this.working.write(n2);
            this.working.write(1);
        }
    }

    private void load0_Ob(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(22);
    }

    private void store0_Ob(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(66);
    }

    private void load0_Ow(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(9);
    }

    private void store0_Ow(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(21);
    }

    private void load0_Od(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(169);
    }

    private void store0_Od(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(161);
    }

    private void load1_Ob(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(88);
    }

    private void load1_Ow(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(52);
    }

    private void load1_Od(int n, int n2) {
        this.decodeO(n, n2);
        this.working.write(215);
    }

    private void load0_M(int n, int n2, int n3, int n4) {
        this.decodeM(n, n2, n3, n4);
        this.working.write(79);
    }

    private void decodeM(int n, int n2, int n3, int n4) {
        if (!this.decodingAddressMode()) {
            return;
        }
        if ((n & 0x10) != 0) {
            block0 : switch (n & 7) {
                default: {
                    switch (n2 & 0xC7) {
                        default: {
                            this.working.write(14);
                            break block0;
                        }
                        case 4: 
                        case 68: 
                        case 132: {
                            break block0;
                        }
                        case 69: 
                        case 133: 
                    }
                    this.working.write(5);
                    break;
                }
                case 2: {
                    this.working.write(76);
                    break;
                }
                case 4: {
                    this.working.write(14);
                    break;
                }
                case 3: {
                    this.working.write(5);
                    break;
                }
                case 1: {
                    this.working.write(59);
                    break;
                }
                case 5: {
                    this.working.write(301);
                    break;
                }
                case 6: {
                    this.working.write(302);
                }
            }
            switch (n2 & 7) {
                case 0: {
                    this.working.write(307);
                    break;
                }
                case 1: {
                    this.working.write(308);
                    break;
                }
                case 2: {
                    this.working.write(309);
                    break;
                }
                case 3: {
                    this.working.write(310);
                    break;
                }
                case 4: {
                    this.decodeSIB(n, n2, n3, n4);
                    break;
                }
                case 5: {
                    if ((n2 & 0xC0) == 0) {
                        this.working.write(229);
                        this.working.write(n4);
                        break;
                    }
                    this.working.write(312);
                    break;
                }
                case 6: {
                    this.working.write(313);
                    break;
                }
                case 7: {
                    this.working.write(314);
                }
            }
            switch (n2 & 0xC0) {
                case 64: {
                    this.working.write(3);
                    this.working.write(n4);
                    break;
                }
                case 128: {
                    this.working.write(229);
                    this.working.write(n4);
                }
            }
        } else {
            block26 : switch (n & 7) {
                default: {
                    switch (n2 & 0xC7) {
                        default: {
                            this.working.write(14);
                            break block26;
                        }
                        case 2: 
                        case 3: {
                            this.working.write(5);
                            break block26;
                        }
                        case 66: 
                        case 67: 
                        case 70: {
                            this.working.write(5);
                            break block26;
                        }
                        case 130: 
                        case 131: 
                        case 134: 
                    }
                    this.working.write(5);
                    break;
                }
                case 2: {
                    this.working.write(76);
                    break;
                }
                case 4: {
                    this.working.write(14);
                    break;
                }
                case 3: {
                    this.working.write(5);
                    break;
                }
                case 1: {
                    this.working.write(59);
                    break;
                }
                case 5: {
                    this.working.write(301);
                    break;
                }
                case 6: {
                    this.working.write(302);
                }
            }
            switch (n2 & 7) {
                case 0: {
                    this.working.write(18);
                    this.working.write(43);
                    break;
                }
                case 1: {
                    this.working.write(18);
                    this.working.write(95);
                    break;
                }
                case 2: {
                    this.working.write(7);
                    this.working.write(43);
                    break;
                }
                case 3: {
                    this.working.write(7);
                    this.working.write(95);
                    break;
                }
                case 4: {
                    this.working.write(43);
                    break;
                }
                case 5: {
                    this.working.write(95);
                    break;
                }
                case 6: {
                    if ((n2 & 0xC0) == 0) {
                        this.working.write(49);
                        this.working.write(n4);
                        break;
                    }
                    this.working.write(7);
                    break;
                }
                case 7: {
                    this.working.write(18);
                }
            }
            switch (n2 & 0xC0) {
                case 64: {
                    this.working.write(3);
                    this.working.write(n4);
                    break;
                }
                case 128: {
                    this.working.write(49);
                    this.working.write(n4);
                }
            }
            this.working.write(1);
        }
    }

    private void decodeSIB(int n, int n2, int n3, int n4) {
        block0 : switch (n & 7) {
            default: {
                switch (n3 & 7) {
                    default: {
                        this.working.write(14);
                        break block0;
                    }
                    case 4: {
                        this.working.write(5);
                        break block0;
                    }
                    case 5: 
                }
                switch (n2 & 0xC0) {
                    default: {
                        this.working.write(5);
                        break block0;
                    }
                    case 0: 
                }
                this.working.write(14);
                break;
            }
            case 2: {
                this.working.write(76);
                break;
            }
            case 4: {
                this.working.write(14);
                break;
            }
            case 3: {
                this.working.write(5);
                break;
            }
            case 1: {
                this.working.write(59);
                break;
            }
            case 5: {
                this.working.write(301);
                break;
            }
            case 6: {
                this.working.write(302);
            }
        }
        block15 : switch (n3 & 7) {
            case 0: {
                this.working.write(307);
                break;
            }
            case 1: {
                this.working.write(308);
                break;
            }
            case 2: {
                this.working.write(309);
                break;
            }
            case 3: {
                this.working.write(310);
                break;
            }
            case 4: {
                this.working.write(311);
                break;
            }
            case 5: {
                switch (n2 & 0xC0) {
                    default: {
                        this.working.write(312);
                        break block15;
                    }
                    case 0: 
                }
                this.working.write(229);
                this.working.write(n4);
                break;
            }
            case 6: {
                this.working.write(313);
                break;
            }
            case 7: {
                this.working.write(314);
            }
        }
        switch (n3 & 0xF8) {
            case 0: {
                this.working.write(307);
                break;
            }
            case 8: {
                this.working.write(308);
                break;
            }
            case 16: {
                this.working.write(309);
                break;
            }
            case 24: {
                this.working.write(310);
                break;
            }
            case 32: {
                break;
            }
            case 40: {
                this.working.write(312);
                break;
            }
            case 48: {
                this.working.write(313);
                break;
            }
            case 56: {
                this.working.write(314);
                break;
            }
            case 64: {
                this.working.write(319);
                break;
            }
            case 72: {
                this.working.write(320);
                break;
            }
            case 80: {
                this.working.write(321);
                break;
            }
            case 88: {
                this.working.write(322);
                break;
            }
            case 96: {
                break;
            }
            case 104: {
                this.working.write(324);
                break;
            }
            case 112: {
                this.working.write(325);
                break;
            }
            case 120: {
                this.working.write(326);
                break;
            }
            case 128: {
                this.working.write(327);
                break;
            }
            case 136: {
                this.working.write(328);
                break;
            }
            case 144: {
                this.working.write(329);
                break;
            }
            case 152: {
                this.working.write(330);
                break;
            }
            case 160: {
                break;
            }
            case 168: {
                this.working.write(332);
                break;
            }
            case 176: {
                this.working.write(333);
                break;
            }
            case 184: {
                this.working.write(334);
                break;
            }
            case 192: {
                this.working.write(335);
                break;
            }
            case 200: {
                this.working.write(336);
                break;
            }
            case 208: {
                this.working.write(337);
                break;
            }
            case 216: {
                this.working.write(338);
                break;
            }
            case 224: {
                break;
            }
            case 232: {
                this.working.write(340);
                break;
            }
            case 240: {
                this.working.write(341);
                break;
            }
            case 248: {
                this.working.write(342);
            }
        }
    }

    private void decodeSegmentPrefix(int n) {
        switch (n & 7) {
            default: {
                this.working.write(14);
                break;
            }
            case 1: {
                this.working.write(59);
                break;
            }
            case 3: {
                this.working.write(5);
                break;
            }
            case 2: {
                this.working.write(76);
                break;
            }
            case 5: {
                this.working.write(301);
                break;
            }
            case 6: {
                this.working.write(302);
            }
        }
    }

    private void store0_Rd(int n) {
        switch (n & 0xC7) {
            case 192: {
                this.working.write(155);
                break;
            }
            case 193: {
                this.working.write(205);
                break;
            }
            case 194: {
                this.working.write(209);
                break;
            }
            case 195: {
                this.working.write(200);
                break;
            }
            case 196: {
                this.working.write(256);
                break;
            }
            case 197: {
                this.working.write(257);
                break;
            }
            case 198: {
                this.working.write(207);
                break;
            }
            case 199: {
                this.working.write(206);
                break;
            }
            default: {
                throw new IllegalStateException("Rd cannot be a memory location");
            }
        }
    }

    private void load0_Rd(int n) {
        switch (n & 0xC7) {
            case 192: {
                this.working.write(152);
                break;
            }
            case 193: {
                this.working.write(203);
                break;
            }
            case 194: {
                this.working.write(220);
                break;
            }
            case 195: {
                this.working.write(199);
                break;
            }
            case 196: {
                this.working.write(240);
                break;
            }
            case 197: {
                this.working.write(241);
                break;
            }
            case 198: {
                this.working.write(204);
                break;
            }
            case 199: {
                this.working.write(208);
                break;
            }
            default: {
                throw new IllegalStateException("Rd cannot be a memory location");
            }
        }
    }

    private static class Operation {
        private int[] microcodes = new int[10];
        private int microcodesLength;
        private int x86Length;
        private int readOffset;
        private boolean decoded;
        private boolean terminal;

        Operation() {
        }

        void write(int n) {
            try {
                this.microcodes[this.microcodesLength++] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = new int[2 * this.microcodes.length];
                System.arraycopy(this.microcodes, 0, nArray, 0, this.microcodes.length);
                this.microcodes = nArray;
                this.microcodes[this.microcodesLength++] = n;
            }
        }

        void replace(int n, int n2) {
            this.microcodes[n] = n2;
        }

        void finish(int n) {
            this.x86Length = n;
            this.decoded = true;
        }

        void makeTerminal() {
            this.reset();
            this.terminal = true;
        }

        boolean terminal() {
            return this.terminal;
        }

        boolean decoded() {
            return this.decoded;
        }

        void reset() {
            this.microcodesLength = 0;
            this.x86Length = 0;
            this.readOffset = 0;
            this.decoded = false;
            this.terminal = false;
        }

        int getMicrocodeAt(int n) {
            return this.microcodes[n];
        }

        int getMicrocode() {
            if (this.readOffset < this.microcodesLength) {
                return this.microcodes[this.readOffset++];
            }
            throw new IllegalStateException();
        }

        int getLength() {
            return this.microcodesLength;
        }

        int getX86Length() {
            return this.x86Length;
        }
    }
}

