/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.exception.ModuleException;
import dioscuri.module.clock.Clock;
import dioscuri.module.cpu.Util;
import dioscuri.module.cpu32.ArrayBackedInstructionSource;
import dioscuri.module.cpu32.FpuState;
import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.MicrocodeSet;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.Segment;

public class RealModeUBlock
implements RealModeCodeBlock,
MicrocodeSet {
    private static final ProcessorException exceptionDE = new ProcessorException(0, true);
    private static final ProcessorException exceptionGP = new ProcessorException(13, true);
    private static final ProcessorException exceptionSS = new ProcessorException(12, true);
    private static final ProcessorException exceptionUD = new ProcessorException(6, true);
    private static final ProcessorException exceptionBR = new ProcessorException(5, true);
    private static final boolean[] parityMap = new boolean[256];
    private Clock clock;
    private static final double L2TEN;
    private static final double L2E;
    private static final double LOG2;
    private static final double LN2;
    private static final double POS0;
    private Processor cpu;
    private FpuState fpu;
    private int x86Count;
    protected int[] microcodes;
    protected int[] cumulativeX86Length;
    private int executeCount;
    private Segment transferSeg0 = null;
    private int transferAddr0 = 0;
    private int transferReg0 = 0;
    private int transferReg1 = 0;
    private int transferReg2 = 0;
    private long transferReg0l = 0L;
    private boolean transferEipUpdated = false;
    private int transferPosition = 0;
    private double transferFReg0 = 0.0;
    private double transferFReg1 = 0.0;
    private int uCodeXferReg0 = 0;
    private int uCodeXferReg1 = 0;
    private int uCodeXferReg2 = 0;
    private boolean uCodeXferLoaded = false;

    public RealModeUBlock() {
    }

    public RealModeUBlock(int[] nArray, int[] nArray2, Clock clock) {
        this.clock = clock;
        this.microcodes = nArray;
        this.cumulativeX86Length = nArray2;
        if (this.cumulativeX86Length.length == 0) {
            this.x86Count = 0;
        } else {
            int n = 1;
            for (int i = 1; i < this.cumulativeX86Length.length; ++i) {
                if (this.cumulativeX86Length[i] <= this.cumulativeX86Length[i - 1]) continue;
                ++n;
            }
            this.x86Count = n;
        }
    }

    @Override
    public int getX86Length() {
        if (this.microcodes.length == 0) {
            return 0;
        }
        return this.cumulativeX86Length[this.microcodes.length - 1];
    }

    @Override
    public int getX86Count() {
        return this.x86Count;
    }

    @Override
    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString() + "\n");
        for (int i = 0; i < this.microcodes.length; ++i) {
            stringBuffer.append(i + ": " + this.microcodes[i] + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean handleMemoryRegionChange(int n, int n2) {
        return false;
    }

    public String toString() {
        return "Real Mode Interpreted Block: " + this.hashCode();
    }

    public InstructionSource getAsInstructionSource() {
        int[] nArray = new int[this.microcodes.length];
        int[] nArray2 = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        System.arraycopy(this.cumulativeX86Length, 0, nArray2, 0, nArray2.length);
        return new ArrayBackedInstructionSource(nArray, nArray2);
    }

    public int[] getMicrocodes() {
        int[] nArray = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fullExecute(Processor processor) {
        FpuState fpuState = processor.fpu;
        Segment segment = this.transferSeg0;
        int n = this.transferAddr0;
        int n2 = this.transferReg0;
        int n3 = this.transferReg1;
        int n4 = this.transferReg2;
        long l = this.transferReg0l;
        double d = this.transferFReg0;
        double d2 = this.transferFReg1;
        boolean bl = this.transferEipUpdated;
        int n5 = this.transferPosition;
        try {
            switch (this.microcodes[n5++]) {
                case 2: {
                    if (bl) return;
                    bl = true;
                    processor.eip += this.cumulativeX86Length[n5 - 1];
                    return;
                }
                case 661: {
                    System.err.println("Undefined Opcode");
                    throw exceptionUD;
                }
                case 0: {
                    n = 0;
                    segment = null;
                    return;
                }
                case 152: {
                    n2 = processor.eax;
                    return;
                }
                case 203: {
                    n2 = processor.ecx;
                    return;
                }
                case 220: {
                    n2 = processor.edx;
                    return;
                }
                case 199: {
                    n2 = processor.ebx;
                    return;
                }
                case 240: {
                    n2 = processor.esp;
                    return;
                }
                case 241: {
                    n2 = processor.ebp;
                    return;
                }
                case 204: {
                    n2 = processor.esi;
                    return;
                }
                case 208: {
                    n2 = processor.edi;
                    return;
                }
                case 155: {
                    processor.eax = n2;
                    return;
                }
                case 205: {
                    processor.ecx = n2;
                    return;
                }
                case 209: {
                    processor.edx = n2;
                    return;
                }
                case 200: {
                    processor.ebx = n2;
                    return;
                }
                case 256: {
                    processor.esp = n2;
                    return;
                }
                case 257: {
                    processor.ebp = n2;
                    return;
                }
                case 207: {
                    processor.esi = n2;
                    return;
                }
                case 206: {
                    processor.edi = n2;
                    return;
                }
                case 192: {
                    n3 = processor.eax;
                    return;
                }
                case 219: {
                    n3 = processor.ecx;
                    return;
                }
                case 217: {
                    n3 = processor.edx;
                    return;
                }
                case 222: {
                    n3 = processor.ebx;
                    return;
                }
                case 270: {
                    n3 = processor.esp;
                    return;
                }
                case 271: {
                    n3 = processor.ebp;
                    return;
                }
                case 272: {
                    n3 = processor.esi;
                    return;
                }
                case 223: {
                    n3 = processor.edi;
                    return;
                }
                case 273: {
                    processor.eax = n3;
                    return;
                }
                case 274: {
                    processor.ecx = n3;
                    return;
                }
                case 275: {
                    processor.edx = n3;
                    return;
                }
                case 276: {
                    processor.ebx = n3;
                    return;
                }
                case 10: {
                    processor.esp = n3;
                    return;
                }
                case 277: {
                    processor.ebp = n3;
                    return;
                }
                case 278: {
                    processor.esi = n3;
                    return;
                }
                case 279: {
                    processor.edi = n3;
                    return;
                }
                case 6: {
                    n2 = processor.eax & 0xFFFF;
                    return;
                }
                case 30: {
                    n2 = processor.ecx & 0xFFFF;
                    return;
                }
                case 38: {
                    n2 = processor.edx & 0xFFFF;
                    return;
                }
                case 25: {
                    n2 = processor.ebx & 0xFFFF;
                    return;
                }
                case 19: {
                    n2 = processor.esp & 0xFFFF;
                    return;
                }
                case 31: {
                    n2 = processor.ebp & 0xFFFF;
                    return;
                }
                case 48: {
                    n2 = processor.esi & 0xFFFF;
                    return;
                }
                case 53: {
                    n2 = processor.edi & 0xFFFF;
                    return;
                }
                case 12: {
                    processor.eax = processor.eax & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 29: {
                    processor.ecx = processor.ecx & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 42: {
                    processor.edx = processor.edx & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 15: {
                    processor.ebx = processor.ebx & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 33: {
                    processor.esp = processor.esp & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 17: {
                    processor.ebp = processor.ebp & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 40: {
                    processor.esi = processor.esi & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 47: {
                    processor.edi = processor.edi & 0xFFFF0000 | n2 & 0xFFFF;
                    return;
                }
                case 86: {
                    processor.eax = processor.eax & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 280: {
                    processor.ecx = processor.ecx & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 281: {
                    processor.edx = processor.edx & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 282: {
                    processor.ebx = processor.ebx & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 283: {
                    processor.esp = processor.esp & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 284: {
                    processor.ebp = processor.ebp & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 233: {
                    processor.esi = processor.esi & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 172: {
                    processor.edi = processor.edi & 0xFFFF0000 | n3 & 0xFFFF;
                    return;
                }
                case 63: {
                    n3 = processor.eax & 0xFFFF;
                    return;
                }
                case 61: {
                    n3 = processor.ecx & 0xFFFF;
                    return;
                }
                case 108: {
                    n3 = processor.edx & 0xFFFF;
                    return;
                }
                case 189: {
                    n3 = processor.esp & 0xFFFF;
                    return;
                }
                case 129: {
                    n3 = processor.ebp & 0xFFFF;
                    return;
                }
                case 90: {
                    n3 = processor.esi & 0xFFFF;
                    return;
                }
                case 87: {
                    n3 = processor.edi & 0xFFFF;
                    return;
                }
                case 34: {
                    n2 = processor.eax & 0xFF;
                    return;
                }
                case 137: {
                    n2 = processor.ecx & 0xFF;
                    return;
                }
                case 110: {
                    n2 = processor.edx & 0xFF;
                    return;
                }
                case 131: {
                    n2 = processor.ebx & 0xFF;
                    return;
                }
                case 46: {
                    n2 = processor.eax >> 8 & 0xFF;
                    return;
                }
                case 146: {
                    n2 = processor.ecx >> 8 & 0xFF;
                    return;
                }
                case 175: {
                    n2 = processor.edx >> 8 & 0xFF;
                    return;
                }
                case 65: {
                    n2 = processor.ebx >> 8 & 0xFF;
                    return;
                }
                case 24: {
                    processor.eax = processor.eax & 0xFFFFFF00 | n2 & 0xFF;
                    return;
                }
                case 94: {
                    processor.ecx = processor.ecx & 0xFFFFFF00 | n2 & 0xFF;
                    return;
                }
                case 115: {
                    processor.edx = processor.edx & 0xFFFFFF00 | n2 & 0xFF;
                    return;
                }
                case 60: {
                    processor.eax = processor.eax & 0xFFFF00FF | n2 << 8 & 0xFF00;
                    return;
                }
                case 144: {
                    processor.ecx = processor.ecx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                    return;
                }
                case 174: {
                    processor.edx = processor.edx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                    return;
                }
                case 58: {
                    processor.ebx = processor.ebx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                    return;
                }
                case 73: {
                    n3 = processor.eax & 0xFF;
                    return;
                }
                case 92: {
                    n3 = processor.ecx & 0xFF;
                    return;
                }
                case 126: {
                    n3 = processor.edx & 0xFF;
                    return;
                }
                case 154: {
                    n3 = processor.ebx & 0xFF;
                    return;
                }
                case 68: {
                    n3 = processor.eax >> 8 & 0xFF;
                    return;
                }
                case 145: {
                    n3 = processor.ecx >> 8 & 0xFF;
                    return;
                }
                case 176: {
                    n3 = processor.edx >> 8 & 0xFF;
                    return;
                }
                case 64: {
                    n3 = processor.ebx >> 8 & 0xFF;
                    return;
                }
                case 218: {
                    processor.eax = processor.eax & 0xFFFFFF00 | n3 & 0xFF;
                    return;
                }
                case 180: {
                    processor.ecx = processor.ecx & 0xFFFFFF00 | n3 & 0xFF;
                    return;
                }
                case 285: {
                    processor.edx = processor.edx & 0xFFFFFF00 | n3 & 0xFF;
                    return;
                }
                case 286: {
                    processor.ebx = processor.ebx & 0xFFFFFF00 | n3 & 0xFF;
                    return;
                }
                case 287: {
                    processor.eax = processor.eax & 0xFFFF00FF | n3 << 8 & 0xFF00;
                    return;
                }
                case 288: {
                    processor.ecx = processor.ecx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                    return;
                }
                case 289: {
                    processor.edx = processor.edx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                    return;
                }
                case 290: {
                    processor.ebx = processor.ebx & 0xFFFF00FF | n3 << 8 & 0xFF00;
                    return;
                }
                case 224: {
                    n2 = processor.getCR0();
                    return;
                }
                case 244: {
                    n2 = processor.getCR2();
                    return;
                }
                case 245: {
                    n2 = processor.getCR3();
                    return;
                }
                case 246: {
                    n2 = processor.getCR4();
                    return;
                }
                case 225: {
                    processor.setCR0(n2);
                    return;
                }
                case 261: {
                    processor.setCR2(n2);
                    return;
                }
                case 262: {
                    processor.setCR3(n2);
                    return;
                }
                case 263: {
                    processor.setCR4(n2);
                    return;
                }
                case 67: {
                    n2 = 0xFFFF & processor.es.getSelector();
                    return;
                }
                case 171: {
                    n2 = 0xFFFF & processor.cs.getSelector();
                    return;
                }
                case 134: {
                    n2 = 0xFFFF & processor.ss.getSelector();
                    return;
                }
                case 51: {
                    n2 = 0xFFFF & processor.ds.getSelector();
                    return;
                }
                case 242: {
                    n2 = 0xFFFF & processor.fs.getSelector();
                    return;
                }
                case 243: {
                    n2 = 0xFFFF & processor.gs.getSelector();
                    return;
                }
                case 55: {
                    processor.es.setSelector(0xFFFF & n2);
                    return;
                }
                case 258: {
                    processor.cs.setSelector(0xFFFF & n2);
                    return;
                }
                case 141: {
                    processor.ss.setSelector(0xFFFF & n2);
                    return;
                }
                case 37: {
                    processor.ds.setSelector(0xFFFF & n2);
                    return;
                }
                case 259: {
                    processor.fs.setSelector(0xFFFF & n2);
                    return;
                }
                case 260: {
                    processor.gs.setSelector(0xFFFF & n2);
                    return;
                }
                case 291: {
                    processor.cs.setSelector(0xFFFF & n3);
                    return;
                }
                case 292: {
                    processor.ss.setSelector(0xFFFF & n3);
                    return;
                }
                case 91: {
                    processor.ds.setSelector(0xFFFF & n3);
                    return;
                }
                case 293: {
                    processor.fs.setSelector(0xFFFF & n3);
                    return;
                }
                case 294: {
                    processor.gs.setSelector(0xFFFF & n3);
                    return;
                }
                case 118: {
                    processor.setEFlags(processor.getEFlags() & 0xFFFF0000 | n2 & 0xFFFF);
                    return;
                }
                case 119: {
                    processor.setEFlags(n2);
                    return;
                }
                case 120: {
                    n2 = 0xFFFF & processor.getEFlags();
                    return;
                }
                case 121: {
                    n2 = processor.getEFlags();
                    return;
                }
                case 8: {
                    n2 = this.microcodes[n5++] & 0xFF;
                    return;
                }
                case 13: {
                    n2 = this.microcodes[n5++] & 0xFFFF;
                    return;
                }
                case 255: {
                    n2 = this.microcodes[n5++];
                    return;
                }
                case 26: {
                    n3 = this.microcodes[n5++] & 0xFF;
                    return;
                }
                case 27: {
                    n3 = this.microcodes[n5++] & 0xFFFF;
                    return;
                }
                case 168: {
                    n3 = this.microcodes[n5++];
                    return;
                }
                case 296: {
                    n4 = processor.eax;
                    return;
                }
                case 297: {
                    n4 = 0xFFFF & processor.eax;
                    return;
                }
                case 298: {
                    n4 = 0xFF & processor.eax;
                    return;
                }
                case 299: {
                    n4 = 0xFF & processor.ecx;
                    return;
                }
                case 300: {
                    n4 = 0xFF & this.microcodes[n5++];
                    return;
                }
                case 59: {
                    segment = processor.es;
                    return;
                }
                case 76: {
                    segment = processor.cs;
                    return;
                }
                case 5: {
                    segment = processor.ss;
                    return;
                }
                case 14: {
                    segment = processor.ds;
                    return;
                }
                case 301: {
                    segment = processor.fs;
                    return;
                }
                case 302: {
                    segment = processor.gs;
                    return;
                }
                case 307: {
                    n += processor.eax;
                    return;
                }
                case 308: {
                    n += processor.ecx;
                    return;
                }
                case 309: {
                    n += processor.edx;
                    return;
                }
                case 310: {
                    n += processor.ebx;
                    return;
                }
                case 311: {
                    n += processor.esp;
                    return;
                }
                case 312: {
                    n += processor.ebp;
                    return;
                }
                case 313: {
                    n += processor.esi;
                    return;
                }
                case 314: {
                    n += processor.edi;
                    return;
                }
                case 315: {
                    n += (short)processor.eax;
                    return;
                }
                case 316: {
                    n += (short)processor.ecx;
                    return;
                }
                case 317: {
                    n += (short)processor.edx;
                    return;
                }
                case 18: {
                    n += (short)processor.ebx;
                    return;
                }
                case 318: {
                    n += (short)processor.esp;
                    return;
                }
                case 7: {
                    n += (short)processor.ebp;
                    return;
                }
                case 43: {
                    n += (short)processor.esi;
                    return;
                }
                case 95: {
                    n += (short)processor.edi;
                    return;
                }
                case 319: {
                    n += processor.eax << 1;
                    return;
                }
                case 320: {
                    n += processor.ecx << 1;
                    return;
                }
                case 321: {
                    n += processor.edx << 1;
                    return;
                }
                case 322: {
                    n += processor.ebx << 1;
                    return;
                }
                case 323: {
                    n += processor.esp << 1;
                    return;
                }
                case 324: {
                    n += processor.ebp << 1;
                    return;
                }
                case 325: {
                    n += processor.esi << 1;
                    return;
                }
                case 326: {
                    n += processor.edi << 1;
                    return;
                }
                case 327: {
                    n += processor.eax << 2;
                    return;
                }
                case 328: {
                    n += processor.ecx << 2;
                    return;
                }
                case 329: {
                    n += processor.edx << 2;
                    return;
                }
                case 330: {
                    n += processor.ebx << 2;
                    return;
                }
                case 331: {
                    n += processor.esp << 2;
                    return;
                }
                case 332: {
                    n += processor.ebp << 2;
                    return;
                }
                case 333: {
                    n += processor.esi << 2;
                    return;
                }
                case 334: {
                    n += processor.edi << 2;
                    return;
                }
                case 335: {
                    n += processor.eax << 3;
                    return;
                }
                case 336: {
                    n += processor.ecx << 3;
                    return;
                }
                case 337: {
                    n += processor.edx << 3;
                    return;
                }
                case 338: {
                    n += processor.ebx << 3;
                    return;
                }
                case 339: {
                    n += processor.esp << 3;
                    return;
                }
                case 340: {
                    n += processor.ebp << 3;
                    return;
                }
                case 341: {
                    n += processor.esi << 3;
                    return;
                }
                case 342: {
                    n += processor.edi << 3;
                    return;
                }
                case 3: {
                    n += (byte)this.microcodes[n5++];
                    return;
                }
                case 49: {
                    n += (short)this.microcodes[n5++];
                    return;
                }
                case 229: {
                    n += this.microcodes[n5++];
                    return;
                }
                case 1: {
                    n &= 0xFFFF;
                    return;
                }
                case 343: {
                    n += 0xFF & processor.eax;
                    return;
                }
                case 79: {
                    n2 = n;
                    return;
                }
                case 22: {
                    n2 = 0xFF & segment.getByte(n);
                    return;
                }
                case 9: {
                    n2 = 0xFFFF & segment.getWord(n);
                    return;
                }
                case 169: {
                    n2 = segment.getDoubleWord(n);
                    return;
                }
                case 253: {
                    l = segment.getQuadWord(n);
                    return;
                }
                case 88: {
                    n3 = 0xFF & segment.getByte(n);
                    return;
                }
                case 52: {
                    n3 = 0xFFFF & segment.getWord(n);
                    return;
                }
                case 215: {
                    n3 = segment.getDoubleWord(n);
                    return;
                }
                case 66: {
                    segment.setByte(n, (byte)n2);
                    return;
                }
                case 21: {
                    segment.setWord(n, (short)n2);
                    return;
                }
                case 161: {
                    segment.setDoubleWord(n, n2);
                    return;
                }
                case 254: {
                    segment.setQuadWord(n, n2);
                    return;
                }
                case 234: {
                    segment.setByte(n, (byte)n3);
                    return;
                }
                case 190: {
                    segment.setWord(n, (short)n3);
                    return;
                }
                case 295: {
                    segment.setDoubleWord(n, n3);
                    return;
                }
                case 142: {
                    this.jump_far_o16(n2, n3);
                    return;
                }
                case 344: {
                    this.jump_far_o32(n2, n3);
                    return;
                }
                case 93: {
                    processor.eip = n2;
                    return;
                }
                case 139: {
                    this.call_far_o16_a16(n2, n3);
                    return;
                }
                case 347: {
                    this.call_far_o16_a32(n2, n3);
                    return;
                }
                case 346: {
                    this.call_far_o32_a16(n2, n3);
                    return;
                }
                case 348: {
                    this.call_far_o32_a32(n2, n3);
                    return;
                }
                case 177: {
                    this.call_abs_o16_a16(n2);
                    return;
                }
                case 70: {
                    this.jump_o8((byte)n2);
                    return;
                }
                case 75: {
                    this.jump_o16((short)n2);
                    return;
                }
                case 430: {
                    this.jump_o32(n2);
                    return;
                }
                case 100: {
                    this.int_o16_a16(n2);
                    return;
                }
                case 494: {
                    this.int3_o16_a16();
                    return;
                }
                case 106: {
                    n2 = this.iret_o16_a16();
                    return;
                }
                case 116: {
                    n2 = 0xFF & processor.ioports.ioPortReadByte(n2);
                    return;
                }
                case 392: {
                    n2 = 0xFFFF & processor.ioports.ioPortReadWord(n2);
                    return;
                }
                case 393: {
                    n2 = processor.ioports.ioPortReadLong(n2);
                    return;
                }
                case 103: {
                    processor.ioports.ioPortWriteByte(n2, n3);
                    return;
                }
                case 230: {
                    processor.ioports.ioPortWriteWord(n2, n3);
                    return;
                }
                case 391: {
                    processor.ioports.ioPortWriteLong(n2, n3);
                    return;
                }
                case 41: {
                    n2 ^= n3;
                    return;
                }
                case 57: {
                    n2 &= n3;
                    return;
                }
                case 128: {
                    n2 ^= 0xFFFFFFFF;
                    return;
                }
                case 16: {
                    n4 = n2;
                    n2 = n4 - n3;
                    return;
                }
                case 117: {
                    n4 = n2;
                    n2 = n4 - (n3 + (processor.getCarryFlag() ? 1 : 0));
                    return;
                }
                case 20: {
                    n4 = n2;
                    n2 = n4 + n3;
                    return;
                }
                case 69: {
                    n4 = n2;
                    n2 = n4 + n3 + (processor.getCarryFlag() ? 1 : 0);
                    return;
                }
                case 182: {
                    n2 = -n2;
                    return;
                }
                case 187: {
                    this.mul_o8(n2);
                    return;
                }
                case 133: {
                    this.mul_o16(n2);
                    return;
                }
                case 235: {
                    this.mul_o32(n2);
                    return;
                }
                case 354: {
                    this.imula_o8((byte)n2);
                    return;
                }
                case 107: {
                    this.imula_o16((short)n2);
                    return;
                }
                case 355: {
                    this.imula_o32(n2);
                    return;
                }
                case 352: {
                    n2 = this.imul_o16((short)n2, (short)n3);
                    return;
                }
                case 353: {
                    n2 = this.imul_o32(n2, n3);
                    return;
                }
                case 188: {
                    this.div_o8(n2);
                    return;
                }
                case 132: {
                    this.div_o16(n2);
                    return;
                }
                case 356: {
                    this.div_o32(n2);
                    return;
                }
                case 357: {
                    this.idiv_o8((byte)n2);
                    return;
                }
                case 147: {
                    this.idiv_o16((short)n2);
                    return;
                }
                case 358: {
                    this.idiv_o32(n2);
                    return;
                }
                case 387: {
                    n2 = this.bsf(n3, n2);
                    return;
                }
                case 388: {
                    n2 = this.bsr(n3, n2);
                    return;
                }
                case 375: {
                    this.bt_mem(n3, segment, n);
                    return;
                }
                case 378: {
                    this.bts_mem(n3, segment, n);
                    return;
                }
                case 381: {
                    this.btr_mem(n3, segment, n);
                    return;
                }
                case 384: {
                    this.btc_mem(n3, segment, n);
                    return;
                }
                case 377: {
                    processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                    return;
                }
                case 376: {
                    processor.setCarryFlag(n2, n3 &= 0xF, 7);
                    return;
                }
                case 380: {
                    processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                    n2 |= 1 << n3;
                    return;
                }
                case 379: {
                    processor.setCarryFlag(n2, n3 &= 0xF, 7);
                    n2 |= 1 << n3;
                    return;
                }
                case 383: {
                    processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                    n2 &= ~(1 << n3);
                    return;
                }
                case 382: {
                    processor.setCarryFlag(n2, n3 &= 0xF, 7);
                    n2 &= ~(1 << n3);
                    return;
                }
                case 386: {
                    processor.setCarryFlag(n2, n3 &= 0x1F, 7);
                    n2 ^= 1 << n3;
                    return;
                }
                case 385: {
                    processor.setCarryFlag(n2, n3 &= 0xF, 7);
                    n2 ^= 1 << n3;
                    return;
                }
                case 361: {
                    n2 = n2 << (n3 &= 7) | n2 >>> 8 - n3;
                    return;
                }
                case 362: {
                    n2 = n2 << (n3 &= 0xF) | n2 >>> 16 - n3;
                    return;
                }
                case 363: {
                    n2 = n2 << (n3 &= 0x1F) | n2 >>> 32 - n3;
                    return;
                }
                case 163: {
                    n2 = n2 >>> (n3 &= 7) | n2 << 8 - n3;
                    return;
                }
                case 364: {
                    n2 = n2 >>> (n3 &= 0xF) | n2 << 16 - n3;
                    return;
                }
                case 365: {
                    n2 = n2 >>> (n3 &= 0x1F) | n2 << 32 - n3;
                    return;
                }
                case 366: {
                    n3 &= 0x1F;
                    n2 |= processor.getCarryFlag() ? 256 : 0;
                    n2 = n2 << (n3 %= 9) | n2 >>> 9 - n3;
                    return;
                }
                case 213: {
                    n3 &= 0x1F;
                    n2 |= processor.getCarryFlag() ? 65536 : 0;
                    n2 = n2 << (n3 %= 17) | n2 >>> 17 - n3;
                    return;
                }
                case 367: {
                    l = 0xFFFFFFFFL & (long)n2 | (processor.getCarryFlag() ? 0x100000000L : 0L);
                    l = l << (n3 &= 0x1F) | l >>> 33 - n3;
                    n2 = (int)l;
                    return;
                }
                case 368: {
                    n3 &= 0x1F;
                    n2 |= processor.getCarryFlag() ? 256 : 0;
                    n2 = n2 >>> (n3 %= 9) | n2 << 9 - n3;
                    return;
                }
                case 369: {
                    n3 &= 0x1F;
                    n2 |= processor.getCarryFlag() ? 65536 : 0;
                    n2 = n2 >>> (n3 %= 17) | n2 << 17 - n3;
                    return;
                }
                case 370: {
                    l = 0xFFFFFFFFL & (long)n2 | (processor.getCarryFlag() ? 0x100000000L : 0L);
                    l = l >>> (n3 &= 0x1F) | l << 33 - n3;
                    n2 = (int)l;
                    return;
                }
                case 96: {
                    n4 = n2;
                    n2 >>>= (n3 &= 0x1F);
                    return;
                }
                case 359: {
                    n4 = n2;
                    n2 = (byte)n2 >> (n3 &= 0x1F);
                    return;
                }
                case 198: {
                    n4 = n2;
                    n2 = (short)n2 >> (n3 &= 0x1F);
                    return;
                }
                case 360: {
                    n4 = n2;
                    n2 >>= (n3 &= 0x1F);
                    return;
                }
                case 371: {
                    int n6 = n2;
                    n2 = n2 << (n4 &= 0x1F) | n3 >>> 16 - n4;
                    n3 = n4;
                    n4 = n6;
                    return;
                }
                case 372: {
                    int n7 = n2;
                    if ((n4 &= 0x1F) != 0) {
                        n2 = n2 << n4 | n3 >>> 32 - n4;
                    }
                    n3 = n4;
                    n4 = n7;
                    return;
                }
                case 373: {
                    int n8 = n2;
                    n2 = n2 >>> (n4 &= 0x1F) | n3 << 16 - n4;
                    n3 = n4;
                    n4 = n8;
                    return;
                }
                case 374: {
                    int n9 = n2;
                    if ((n4 &= 0x1F) != 0) {
                        n2 = n2 >>> n4 | n3 << 32 - n4;
                    }
                    n3 = n4;
                    n4 = n9;
                    return;
                }
                case 143: {
                    if ((processor.eax & 0x8000) == 0) {
                        processor.edx &= 0xFFFF0000;
                        return;
                    } else {
                        processor.edx |= 0xFFFF;
                        return;
                    }
                }
                case 389: {
                    if ((processor.eax & Integer.MIN_VALUE) == 0) {
                        processor.edx = 0;
                        return;
                    } else {
                        processor.edx = -1;
                        return;
                    }
                }
                case 464: {
                    this.aaa();
                    return;
                }
                case 465: {
                    this.aad(n2);
                    return;
                }
                case 466: {
                    n2 = this.aam(n2);
                    return;
                }
                case 467: {
                    this.aas();
                    return;
                }
                case 468: {
                    this.daa();
                    return;
                }
                case 469: {
                    this.das();
                    return;
                }
                case 507: {
                    short s = (short)n2;
                    short s2 = (short)(n2 >> 16);
                    short s3 = (short)n3;
                    if (s3 >= s && s3 <= s2 + 2) return;
                    throw exceptionBR;
                }
                case 173: {
                    this.lahf();
                    return;
                }
                case 390: {
                    this.sahf();
                    return;
                }
                case 195: {
                    processor.setCarryFlag(false);
                    return;
                }
                case 194: {
                    processor.setCarryFlag(true);
                    return;
                }
                case 135: {
                    processor.eflagsInterruptEnableSoon = false;
                    processor.eflagsInterruptEnable = false;
                    return;
                }
                case 101: {
                    processor.eflagsInterruptEnableSoon = true;
                    processor.eflagsInterruptEnable = true;
                    return;
                }
                case 109: {
                    processor.eflagsDirection = false;
                    return;
                }
                case 462: {
                    processor.eflagsDirection = true;
                    return;
                }
                case 463: {
                    processor.setCarryFlag(processor.getCarryFlag() ^ true);
                    return;
                }
                case 28: {
                    this.call_o16_a16((short)n2);
                    return;
                }
                case 470: {
                    this.call_o32_a16(n2);
                    return;
                }
                case 32: {
                    this.ret_o16_a16();
                    return;
                }
                case 473: {
                    this.ret_o32_a16();
                    return;
                }
                case 114: {
                    this.ret_iw_o16_a16((short)n2);
                    return;
                }
                case 140: {
                    this.ret_far_o16_a16();
                    return;
                }
                case 153: {
                    this.ret_far_iw_o16_a16((short)n2);
                    return;
                }
                case 159: {
                    this.enter_o16_a16(n2, n3);
                    return;
                }
                case 160: {
                    this.leave_o16_a16();
                    return;
                }
                case 4: {
                    this.push_o16_a16((short)n2);
                    return;
                }
                case 165: {
                    this.push_o32_a16(n2);
                    return;
                }
                case 521: {
                    this.push_o16_a16((short)n2);
                    return;
                }
                case 522: {
                    this.push_o32_a16(0xFFFCFFFF & n2);
                    return;
                }
                case 11: {
                    n3 = processor.esp & 0xFFFF0000 | processor.esp + 2 & 0xFFFF;
                    if (this.microcodes[n5] == 141) {
                        processor.eflagsInterruptEnable = false;
                    }
                    n2 = processor.ss.getWord(processor.esp & 0xFFFF);
                    return;
                }
                case 515: {
                    n3 = processor.esp + 2;
                    if (this.microcodes[n5] == 141) {
                        processor.eflagsInterruptEnable = false;
                    }
                    n2 = processor.ss.getWord(processor.esp);
                    return;
                }
                case 164: {
                    n3 = processor.esp & 0xFFFF0000 | processor.esp + 4 & 0xFFFF;
                    if (this.microcodes[n5] == 141) {
                        processor.eflagsInterruptEnable = false;
                    }
                    n2 = processor.ss.getDoubleWord(processor.esp & 0xFFFF);
                    return;
                }
                case 517: {
                    n2 = processor.ss.getWord(processor.esp & 0xFFFF);
                    processor.esp = processor.esp & 0xFFFF0000 | processor.esp + 2 & 0xFFFF;
                    return;
                }
                case 518: {
                    n2 = processor.getEFlags() & 0x20000 | processor.ss.getDoubleWord(processor.esp & 0xFFFF) & 0xFFE5FFFF;
                    processor.esp = processor.esp & 0xFFFF0000 | processor.esp + 4 & 0xFFFF;
                    return;
                }
                case 125: {
                    this.pusha_a16();
                    return;
                }
                case 232: {
                    this.pushad_a16();
                    return;
                }
                case 124: {
                    this.popa_a16();
                    return;
                }
                case 231: {
                    this.popad_a16();
                    return;
                }
                case 111: {
                    n2 = 0xFFFF & (byte)n2;
                    return;
                }
                case 529: {
                    n2 = (byte)n2;
                    return;
                }
                case 530: {
                    n2 = (short)n2;
                    return;
                }
                case 531: {
                    this.cmpsb_a16(segment);
                    return;
                }
                case 533: {
                    this.cmpsw_a16(segment);
                    return;
                }
                case 535: {
                    this.cmpsd_a16(segment);
                    return;
                }
                case 158: {
                    this.repe_cmpsb_a16(segment);
                    return;
                }
                case 538: {
                    this.repe_cmpsw_a16(segment);
                    return;
                }
                case 540: {
                    this.repe_cmpsd_a16(segment);
                    return;
                }
                case 548: {
                    this.insb_a16(n2);
                    return;
                }
                case 550: {
                    this.insw_a16(n2);
                    return;
                }
                case 552: {
                    this.insd_a16(n2);
                    return;
                }
                case 554: {
                    this.rep_insb_a16(n2);
                    return;
                }
                case 556: {
                    this.rep_insw_a16(n2);
                    return;
                }
                case 558: {
                    this.rep_insd_a16(n2);
                    return;
                }
                case 123: {
                    this.lodsb_a16(segment);
                    return;
                }
                case 157: {
                    this.lodsw_a16(segment);
                    return;
                }
                case 562: {
                    this.lodsd_a16(segment);
                    return;
                }
                case 564: {
                    this.rep_lodsb_a16(segment);
                    return;
                }
                case 566: {
                    this.rep_lodsw_a16(segment);
                    return;
                }
                case 568: {
                    this.rep_lodsd_a16(segment);
                    return;
                }
                case 560: {
                    this.lodsb_a32(segment);
                    return;
                }
                case 561: {
                    this.lodsw_a32(segment);
                    return;
                }
                case 563: {
                    this.lodsd_a32(segment);
                    return;
                }
                case 565: {
                    this.rep_lodsb_a32(segment);
                    return;
                }
                case 567: {
                    this.rep_lodsw_a32(segment);
                    return;
                }
                case 569: {
                    this.rep_lodsd_a32(segment);
                    return;
                }
                case 112: {
                    this.movsb_a16(segment);
                    return;
                }
                case 221: {
                    this.movsw_a16(segment);
                    return;
                }
                case 572: {
                    this.movsd_a16(segment);
                    return;
                }
                case 127: {
                    this.rep_movsb_a16(segment);
                    return;
                }
                case 130: {
                    this.rep_movsw_a16(segment);
                    return;
                }
                case 576: {
                    this.rep_movsd_a16(segment);
                    return;
                }
                case 570: {
                    this.movsb_a32(segment);
                    return;
                }
                case 571: {
                    this.movsw_a32(segment);
                    return;
                }
                case 573: {
                    this.movsd_a32(segment);
                    return;
                }
                case 574: {
                    this.rep_movsb_a32(segment);
                    return;
                }
                case 575: {
                    this.rep_movsw_a32(segment);
                    return;
                }
                case 577: {
                    this.rep_movsd_a32(segment);
                    return;
                }
                case 578: {
                    this.outsb_a16(n2, segment);
                    return;
                }
                case 580: {
                    this.outsw_a16(n2, segment);
                    return;
                }
                case 582: {
                    this.outsd_a16(n2, segment);
                    return;
                }
                case 584: {
                    this.rep_outsb_a16(n2, segment);
                    return;
                }
                case 586: {
                    this.rep_outsw_a16(n2, segment);
                    return;
                }
                case 588: {
                    this.rep_outsd_a16(n2, segment);
                    return;
                }
                case 590: {
                    this.scasb_a16(n2);
                    return;
                }
                case 592: {
                    this.scasw_a16(n2);
                    return;
                }
                case 594: {
                    this.scasd_a16(n2);
                    return;
                }
                case 596: {
                    this.repe_scasb_a16(n2);
                    return;
                }
                case 598: {
                    this.repe_scasw_a16(n2);
                    return;
                }
                case 600: {
                    this.repe_scasd_a16(n2);
                    return;
                }
                case 166: {
                    this.repne_scasb_a16(n2);
                    return;
                }
                case 603: {
                    this.repne_scasw_a16(n2);
                    return;
                }
                case 605: {
                    this.repne_scasd_a16(n2);
                    return;
                }
                case 148: {
                    this.stosb_a16(n2);
                    return;
                }
                case 186: {
                    this.stosw_a16(n2);
                    return;
                }
                case 609: {
                    this.stosd_a16(n2);
                    return;
                }
                case 611: {
                    this.rep_stosb_a16(n2);
                    return;
                }
                case 179: {
                    this.rep_stosw_a16(n2);
                    return;
                }
                case 614: {
                    this.rep_stosd_a16(n2);
                    return;
                }
                case 607: {
                    this.stosb_a32(n2);
                    return;
                }
                case 608: {
                    this.stosw_a32(n2);
                    return;
                }
                case 610: {
                    this.stosd_a32(n2);
                    return;
                }
                case 612: {
                    this.rep_stosb_a32(n2);
                    return;
                }
                case 613: {
                    this.rep_stosw_a32(n2);
                    return;
                }
                case 615: {
                    this.rep_stosd_a32(n2);
                    return;
                }
                case 509: {
                    --processor.ecx;
                    if (processor.ecx == 0) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 113: {
                    processor.ecx = processor.ecx & 0xFFFF0000 | processor.ecx - 1 & 0xFFFF;
                    if ((0xFFFF & processor.ecx) == 0) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 510: {
                    --processor.ecx;
                    if (processor.ecx == 0 || !processor.getZeroFlag()) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 196: {
                    processor.ecx = processor.ecx & 0xFFFF0000 | processor.ecx - 1 & 0xFFFF;
                    if ((0xFFFF & processor.ecx) == 0 || !processor.getZeroFlag()) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 511: {
                    --processor.ecx;
                    if (processor.ecx == 0 || processor.getZeroFlag()) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 512: {
                    processor.ecx = processor.ecx & 0xFFFF0000 | processor.ecx - 1 & 0xFFFF;
                    if ((0xFFFF & processor.ecx) == 0 || processor.getZeroFlag()) return;
                    this.jump_o8((byte)n2);
                    return;
                }
                case 397: {
                    this.jo_o8((byte)n2);
                    return;
                }
                case 398: {
                    this.jno_o8((byte)n2);
                    return;
                }
                case 72: {
                    this.jc_o8((byte)n2);
                    return;
                }
                case 71: {
                    this.jnc_o8((byte)n2);
                    return;
                }
                case 45: {
                    this.jz_o8((byte)n2);
                    return;
                }
                case 23: {
                    this.jnz_o8((byte)n2);
                    return;
                }
                case 99: {
                    this.jna_o8((byte)n2);
                    return;
                }
                case 98: {
                    this.ja_o8((byte)n2);
                    return;
                }
                case 399: {
                    this.js_o8((byte)n2);
                    return;
                }
                case 201: {
                    this.jns_o8((byte)n2);
                    return;
                }
                case 400: {
                    this.jp_o8((byte)n2);
                    return;
                }
                case 401: {
                    this.jnp_o8((byte)n2);
                    return;
                }
                case 105: {
                    this.jl_o8((byte)n2);
                    return;
                }
                case 149: {
                    this.jnl_o8((byte)n2);
                    return;
                }
                case 156: {
                    this.jng_o8((byte)n2);
                    return;
                }
                case 138: {
                    this.jg_o8((byte)n2);
                    return;
                }
                case 402: {
                    this.jo_o16((short)n2);
                    return;
                }
                case 403: {
                    this.jno_o16((short)n2);
                    return;
                }
                case 178: {
                    this.jc_o16((short)n2);
                    return;
                }
                case 185: {
                    this.jnc_o16((short)n2);
                    return;
                }
                case 104: {
                    this.jz_o16((short)n2);
                    return;
                }
                case 136: {
                    this.jnz_o16((short)n2);
                    return;
                }
                case 404: {
                    this.jna_o16((short)n2);
                    return;
                }
                case 214: {
                    this.ja_o16((short)n2);
                    return;
                }
                case 405: {
                    this.js_o16((short)n2);
                    return;
                }
                case 406: {
                    this.jns_o16((short)n2);
                    return;
                }
                case 407: {
                    this.jp_o16((short)n2);
                    return;
                }
                case 408: {
                    this.jnp_o16((short)n2);
                    return;
                }
                case 409: {
                    this.jl_o16((short)n2);
                    return;
                }
                case 410: {
                    this.jnl_o16((short)n2);
                    return;
                }
                case 411: {
                    this.jng_o16((short)n2);
                    return;
                }
                case 412: {
                    this.jg_o16((short)n2);
                    return;
                }
                case 413: {
                    this.jo_o32(n2);
                    return;
                }
                case 414: {
                    this.jno_o32(n2);
                    return;
                }
                case 415: {
                    this.jc_o32(n2);
                    return;
                }
                case 416: {
                    this.jnc_o32(n2);
                    return;
                }
                case 417: {
                    this.jz_o32(n2);
                    return;
                }
                case 418: {
                    this.jnz_o32(n2);
                    return;
                }
                case 419: {
                    this.jna_o32(n2);
                    return;
                }
                case 420: {
                    this.ja_o32(n2);
                    return;
                }
                case 421: {
                    this.js_o32(n2);
                    return;
                }
                case 422: {
                    this.jns_o32(n2);
                    return;
                }
                case 423: {
                    this.jp_o32(n2);
                    return;
                }
                case 424: {
                    this.jnp_o32(n2);
                    return;
                }
                case 425: {
                    this.jl_o32(n2);
                    return;
                }
                case 426: {
                    this.jnl_o32(n2);
                    return;
                }
                case 427: {
                    this.jng_o32(n2);
                    return;
                }
                case 428: {
                    this.jg_o32(n2);
                    return;
                }
                case 89: {
                    this.jcxz((byte)n2);
                    return;
                }
                case 429: {
                    this.jecxz((byte)n2);
                    return;
                }
                case 54: {
                    ++n2;
                    return;
                }
                case 77: {
                    --n2;
                    return;
                }
                case 506: {
                    fpuState.checkExceptions();
                    return;
                }
                case 505: {
                    this.halt();
                    return;
                }
                case 619: {
                    long l2 = processor.getClockCount();
                    n2 = (int)l2;
                    n3 = (int)(l2 >>> 32);
                    return;
                }
                case 617: {
                    processor.setMSR(n2, (long)n4 & 0xFFFFFFFFL | ((long)n3 & 0xFFFFFFFFL) << 32);
                    return;
                }
                case 618: {
                    long l3 = processor.getMSR(n2);
                    n2 = (int)l3;
                    n3 = (int)(l3 >>> 32);
                    return;
                }
                case 431: {
                    n2 = processor.getOverflowFlag() ? 1 : 0;
                    return;
                }
                case 432: {
                    n2 = processor.getOverflowFlag() ? 0 : 1;
                    return;
                }
                case 236: {
                    n2 = processor.getCarryFlag() ? 1 : 0;
                    return;
                }
                case 433: {
                    n2 = processor.getCarryFlag() ? 0 : 1;
                    return;
                }
                case 434: {
                    n2 = processor.getZeroFlag() ? 1 : 0;
                    return;
                }
                case 435: {
                    n2 = processor.getZeroFlag() ? 0 : 1;
                    return;
                }
                case 436: {
                    n2 = processor.getCarryFlag() || processor.getZeroFlag() ? 1 : 0;
                    return;
                }
                case 437: {
                    n2 = processor.getCarryFlag() || processor.getZeroFlag() ? 0 : 1;
                    return;
                }
                case 438: {
                    n2 = processor.getSignFlag() ? 1 : 0;
                    return;
                }
                case 439: {
                    n2 = processor.getSignFlag() ? 0 : 1;
                    return;
                }
                case 440: {
                    n2 = processor.getParityFlag() ? 1 : 0;
                    return;
                }
                case 441: {
                    n2 = processor.getParityFlag() ? 0 : 1;
                    return;
                }
                case 442: {
                    n2 = processor.getSignFlag() != processor.getOverflowFlag() ? 1 : 0;
                    return;
                }
                case 443: {
                    n2 = processor.getSignFlag() != processor.getOverflowFlag() ? 0 : 1;
                    return;
                }
                case 444: {
                    n2 = processor.getZeroFlag() || processor.getSignFlag() != processor.getOverflowFlag() ? 1 : 0;
                    return;
                }
                case 445: {
                    n2 = processor.getZeroFlag() || processor.getSignFlag() != processor.getOverflowFlag() ? 0 : 1;
                    return;
                }
                case 228: {
                    n2 = processor.getCR0() & 0xFFFF;
                    return;
                }
                case 634: {
                    processor.setCR0(processor.getCR0() & 0xFFFFFFF0 | n2 & 0xF);
                    return;
                }
                case 227: {
                    processor.gdtr = processor.createDescriptorTableSegment(n3 & 0xFFFFFF, n2);
                    return;
                }
                case 631: {
                    processor.gdtr = processor.createDescriptorTableSegment(n3, n2);
                    return;
                }
                case 633: {
                    processor.idtr = processor.createDescriptorTableSegment(n3 & 0xFFFFFF, n2);
                    return;
                }
                case 632: {
                    processor.idtr = processor.createDescriptorTableSegment(n3, n2);
                    return;
                }
                case 628: {
                    n2 = processor.gdtr.getLimit();
                    n3 = 0xFFFFFF & processor.gdtr.getBase();
                    return;
                }
                case 627: {
                    n2 = processor.gdtr.getLimit();
                    n3 = processor.gdtr.getBase();
                    return;
                }
                case 630: {
                    n2 = processor.idtr.getLimit();
                    n3 = 0xFFFFFF & processor.idtr.getBase();
                    return;
                }
                case 629: {
                    n2 = processor.idtr.getLimit();
                    n3 = processor.idtr.getBase();
                    return;
                }
                case 616: {
                    this.cpuid();
                    return;
                }
                case 622: {
                    processor.setCR3(processor.getCR3() & 0xFFFFFFFB);
                    return;
                }
                case 39: {
                    this.bitwise_flags((byte)n2);
                    return;
                }
                case 50: {
                    this.bitwise_flags((short)n2);
                    return;
                }
                case 191: {
                    this.bitwise_flags(n2);
                    return;
                }
                case 44: {
                    this.sub_o8_flags(n2, n4, n3);
                    return;
                }
                case 36: {
                    this.sub_o16_flags(n2, n4, n3);
                    return;
                }
                case 167: {
                    this.sub_o32_flags(l, n4, n3);
                    return;
                }
                case 237: {
                    this.rep_sub_o8_flags(n2, n4, n3);
                    return;
                }
                case 238: {
                    this.rep_sub_o16_flags(n2, n4, n3);
                    return;
                }
                case 239: {
                    this.rep_sub_o32_flags(n2, n4, n3);
                    return;
                }
                case 62: {
                    this.add_o8_flags(n2, n4, n3);
                    return;
                }
                case 35: {
                    this.add_o16_flags(n2, n4, n3);
                    return;
                }
                case 202: {
                    this.add_o32_flags(l, n4, n3);
                    return;
                }
                case 102: {
                    this.adc_o8_flags(n2, n4, n3);
                    return;
                }
                case 74: {
                    this.adc_o16_flags(n2, n4, n3);
                    return;
                }
                case 643: {
                    this.adc_o32_flags(l, n4, n3);
                    return;
                }
                case 181: {
                    this.sbb_o8_flags(n2, n4, n3);
                    return;
                }
                case 122: {
                    this.sbb_o16_flags(n2, n4, n3);
                    return;
                }
                case 644: {
                    this.sbb_o32_flags(l, n4, n3);
                    return;
                }
                case 151: {
                    this.inc_flags((byte)n2);
                    return;
                }
                case 56: {
                    this.inc_flags((short)n2);
                    return;
                }
                case 170: {
                    this.inc_flags(n2);
                    return;
                }
                case 150: {
                    this.dec_flags((byte)n2);
                    return;
                }
                case 78: {
                    this.dec_flags((short)n2);
                    return;
                }
                case 642: {
                    this.dec_flags(n2);
                    return;
                }
                case 184: {
                    this.shl_flags((byte)n2, (byte)n4, n3);
                    return;
                }
                case 216: {
                    this.shl_flags(n2, n4, n3);
                    return;
                }
                case 211: {
                    this.shr_flags((byte)n2, n4, n3);
                    return;
                }
                case 97: {
                    this.shr_flags((short)n2, n4, n3);
                    return;
                }
                case 210: {
                    this.shr_flags(n2, n4, n3);
                    return;
                }
                case 645: {
                    this.sar_flags((byte)n2, (byte)n4, n3);
                    return;
                }
                case 197: {
                    this.sar_flags((short)n2, (short)n4, n3);
                    return;
                }
                case 646: {
                    this.sar_flags(n2, n4, n3);
                    return;
                }
                case 647: {
                    this.rcl_o8_flags(n2, n3);
                    return;
                }
                case 212: {
                    this.rcl_o16_flags(n2, n3);
                    return;
                }
                case 648: {
                    this.rcl_o32_flags(l, n3);
                    return;
                }
                case 649: {
                    this.rcr_o8_flags(n2, n3);
                    return;
                }
                case 650: {
                    this.rcr_o16_flags(n2, n3);
                    return;
                }
                case 651: {
                    this.rcr_o32_flags(l, n3);
                    return;
                }
                case 652: {
                    this.rol_flags((byte)n2, n3);
                    return;
                }
                case 653: {
                    this.rol_flags((short)n2, n3);
                    return;
                }
                case 654: {
                    this.rol_flags(n2, n3);
                    return;
                }
                case 162: {
                    this.ror_flags((byte)n2, n3);
                    return;
                }
                case 655: {
                    this.ror_flags((short)n2, n3);
                    return;
                }
                case 656: {
                    this.ror_flags(n2, n3);
                    return;
                }
                case 226: {
                    this.neg_flags((byte)n2);
                    return;
                }
                case 183: {
                    this.neg_flags((short)n2);
                    return;
                }
                case 657: {
                    this.neg_flags(n2);
                    return;
                }
                case 662: {
                    d = fpuState.ST(0);
                    this.validateOperand(d);
                    return;
                }
                case 663: {
                    d = fpuState.ST(this.microcodes[n5++]);
                    this.validateOperand(d);
                    return;
                }
                case 664: {
                    int n10 = segment.getDoubleWord(n);
                    d = Float.intBitsToFloat(n10);
                    if (Double.isNaN(d) && (n10 & 0x400000) == 0) {
                        fpuState.setInvalidOperation();
                    }
                    this.validateOperand(d);
                    return;
                }
                case 665: {
                    long l4 = segment.getQuadWord(n);
                    d = Double.longBitsToDouble(l4);
                    if (Double.isNaN(d) && (l4 & 0x8000000000000L) == 0L) {
                        fpuState.setInvalidOperation();
                    }
                    this.validateOperand(d);
                    return;
                }
                case 667: {
                    d = n2;
                    this.validateOperand(d);
                    return;
                }
                case 668: {
                    d = l;
                    this.validateOperand(d);
                    return;
                }
                case 669: {
                    d = 1.0;
                    return;
                }
                case 670: {
                    d = L2TEN;
                    return;
                }
                case 671: {
                    d = L2E;
                    return;
                }
                case 672: {
                    d = Math.PI;
                    return;
                }
                case 673: {
                    d = LOG2;
                    return;
                }
                case 674: {
                    d = LN2;
                    return;
                }
                case 675: {
                    d = POS0;
                    return;
                }
                case 676: {
                    d2 = fpuState.ST(0);
                    this.validateOperand(d2);
                    return;
                }
                case 677: {
                    d2 = fpuState.ST(this.microcodes[n5++]);
                    this.validateOperand(d2);
                    return;
                }
                case 678: {
                    int n11 = segment.getDoubleWord(n);
                    d2 = Float.intBitsToFloat(n11);
                    if (Double.isNaN(d2) && (n11 & 0x400000) == 0) {
                        fpuState.setInvalidOperation();
                    }
                    this.validateOperand(d2);
                    return;
                }
                case 679: {
                    long l5 = segment.getQuadWord(n);
                    d2 = Double.longBitsToDouble(l5);
                    if (Double.isNaN(d2) && (l5 & 0x8000000000000L) == 0L) {
                        fpuState.setInvalidOperation();
                    }
                    this.validateOperand(d2);
                    return;
                }
                case 681: {
                    d2 = n2;
                    this.validateOperand(d2);
                    return;
                }
                case 682: {
                    d2 = l;
                    this.validateOperand(d2);
                    return;
                }
                case 684: {
                    fpuState.setST(0, d);
                    return;
                }
                case 685: {
                    fpuState.setST(this.microcodes[n5++], d);
                    return;
                }
                case 686: {
                    int n12 = Float.floatToRawIntBits((float)d);
                    segment.setDoubleWord(n, n12);
                    return;
                }
                case 687: {
                    long l6 = Double.doubleToRawLongBits(d);
                    segment.setQuadWord(n, l6);
                    return;
                }
                case 689: {
                    n2 = (int)d;
                    return;
                }
                case 690: {
                    fpuState.setST(0, d2);
                    return;
                }
                case 691: {
                    fpuState.setST(this.microcodes[n5++], d2);
                    return;
                }
                case 692: {
                    int n13 = Float.floatToRawIntBits((float)d2);
                    segment.setDoubleWord(n, n13);
                    return;
                }
                case 693: {
                    long l7 = Double.doubleToRawLongBits(d2);
                    segment.setQuadWord(n, l7);
                    return;
                }
                case 695: {
                    n2 = (int)d2;
                    return;
                }
                case 697: {
                    fpuState.setControl(n2);
                    return;
                }
                case 696: {
                    n2 = fpuState.getControl();
                    return;
                }
                case 699: {
                    fpuState.setStatus(n2);
                    return;
                }
                case 698: {
                    n2 = fpuState.getStatus();
                    return;
                }
                case 704: {
                    int n14 = 13;
                    if (Double.isNaN(d) || Double.isNaN(d2)) {
                        fpuState.setInvalidOperation();
                    } else {
                        n14 = d > d2 ? 0 : (d < d2 ? 1 : 8);
                    }
                    fpuState.conditionCode &= 2;
                    fpuState.conditionCode |= n14;
                    return;
                }
                case 705: {
                    int n15 = 13;
                    if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                        n15 = d > d2 ? 0 : (d < d2 ? 1 : 8);
                    }
                    fpuState.conditionCode &= 2;
                    fpuState.conditionCode |= n15;
                    return;
                }
                case 700: {
                    fpuState.pop();
                    return;
                }
                case 701: {
                    fpuState.push(d);
                    return;
                }
                case 710: {
                    d = -d;
                    return;
                }
                case 711: {
                    d = Math.abs(d);
                    return;
                }
                case 702: {
                    if (d == Double.NEGATIVE_INFINITY && d2 == Double.POSITIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) {
                        fpuState.setInvalidOperation();
                    }
                    d += d2;
                    return;
                }
                case 703: {
                    if (Double.isInfinite(d) && d2 == 0.0 || Double.isInfinite(d2) && d == 0.0) {
                        fpuState.setInvalidOperation();
                    }
                    d *= d2;
                    return;
                }
                case 708: {
                    if (d == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
                        fpuState.setInvalidOperation();
                    }
                    d -= d2;
                    return;
                }
                case 709: {
                    if (d == 0.0 && d2 == 0.0 || Double.isInfinite(d) && Double.isInfinite(d2)) {
                        fpuState.setInvalidOperation();
                    }
                    if (d2 == 0.0 && !Double.isNaN(d) && !Double.isInfinite(d)) {
                        fpuState.setZeroDivide();
                    }
                    d /= d2;
                    return;
                }
                case 723: {
                    if (d < 0.0) {
                        fpuState.setInvalidOperation();
                    }
                    d = Math.sqrt(d);
                    return;
                }
                case 727: {
                    if (Double.isInfinite(d)) {
                        fpuState.setInvalidOperation();
                    }
                    if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                        fpuState.conditionCode |= 4;
                        return;
                    } else {
                        d = Math.sin(d);
                        return;
                    }
                }
                case 728: {
                    if (Double.isInfinite(d)) {
                        fpuState.setInvalidOperation();
                    }
                    if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                        fpuState.conditionCode |= 4;
                        return;
                    } else {
                        d = Math.cos(d);
                        return;
                    }
                }
                case 734: {
                    int n16;
                    long l8 = 0L;
                    long l9 = 1L;
                    for (n16 = 0; n16 < 9; ++n16) {
                        byte by = segment.getByte(n + n16);
                        l8 += (long)(by & 0xF) * l9;
                        l8 += (long)(by >> 4 & 0xF) * (l9 *= 10L);
                        l9 *= 10L;
                    }
                    n16 = segment.getByte(n + 9);
                    double d3 = l8;
                    if (n16 < 0) {
                        d3 *= -1.0;
                    }
                    d = d3;
                    return;
                }
                case 735: {
                    long l10 = (long)Math.abs(d);
                    long l11 = 1L;
                    for (int i = 0; i < 9; ++i) {
                        int n17 = (int)(l10 % (l11 * 10L) / l11);
                        byte by = (byte)n17;
                        n17 = (int)(l10 % ((l11 *= 10L) * 10L) / l11);
                        by = (byte)(by | n17 << 4);
                        segment.setByte(n + i, by);
                    }
                    segment.setByte(n + 9, d < 0.0 ? (byte)-128 : 0);
                    return;
                }
                case 716: {
                    d = Math.atan2(d2, d);
                    return;
                }
                case 721: {
                    int n18 = Util.getExponent(d) - Util.getExponent(d2);
                    if (n18 < 64) {
                        fpuState.conditionCode &= 0xFFFFFFFB;
                        long l12 = (long)Math.rint((d %= d2) / d2);
                        fpuState.conditionCode &= 4;
                        if ((l12 & 1L) != 0L) {
                            fpuState.conditionCode |= 2;
                        }
                        if ((l12 & 2L) != 0L) {
                            fpuState.conditionCode |= 8;
                        }
                        if ((l12 & 4L) == 0L) return;
                        fpuState.conditionCode |= 1;
                        return;
                    } else {
                        fpuState.conditionCode |= 4;
                        int n19 = 63;
                        double d4 = Math.pow(2.0, n18 - n19);
                        double d5 = d / d2 / d4;
                        double d6 = d5 < 0.0 ? Math.ceil(d5) : Math.floor(d5);
                        d -= d2 * d6 * d4;
                        return;
                    }
                }
                case 718: {
                    int n20 = Util.getExponent(d) - Util.getExponent(d2);
                    if (n20 < 64) {
                        fpuState.conditionCode &= 0xFFFFFFFB;
                        double d7 = Math.IEEEremainder(d, d2);
                        long l13 = (long)Math.rint(d / d2);
                        fpuState.conditionCode &= 4;
                        if ((l13 & 1L) != 0L) {
                            fpuState.conditionCode |= 2;
                        }
                        if ((l13 & 2L) != 0L) {
                            fpuState.conditionCode |= 8;
                        }
                        if ((l13 & 4L) != 0L) {
                            fpuState.conditionCode |= 1;
                        }
                        fpuState.setST(0, d7);
                        return;
                    } else {
                        fpuState.conditionCode |= 4;
                        int n21 = 63;
                        double d8 = Math.pow(2.0, n20 - n21);
                        double d9 = d / d2 / d8;
                        double d10 = d9 < 0.0 ? Math.ceil(d9) : Math.floor(d9);
                        d -= d2 * d10 * d8;
                        return;
                    }
                }
                case 715: {
                    if (d > Math.pow(2.0, 63.0) || d < -1.0 * Math.pow(2.0, 63.0)) {
                        if (Double.isInfinite(d)) {
                            fpuState.setInvalidOperation();
                        }
                        fpuState.conditionCode |= 4;
                        return;
                    } else {
                        fpuState.conditionCode &= 0xFFFFFFFB;
                        d = Math.tan(d);
                        return;
                    }
                }
                case 726: {
                    d = Util.scalb(d, (int)d2);
                    return;
                }
                case 717: {
                    int n22 = Util.getExponent(d);
                    d2 = n22;
                    d = Util.scalb(d, -n22);
                    return;
                }
                case 725: {
                    if (Double.isInfinite(d)) {
                        return;
                    } else {
                        switch (fpuState.getRoundingControl()) {
                            case 0: {
                                d = Math.rint(d);
                                break;
                            }
                            case 1: {
                                d = Math.floor(d);
                                break;
                            }
                            case 2: {
                                d = Math.ceil(d);
                                break;
                            }
                            case 3: {
                                d = Math.signum(d) * Math.floor(Math.abs(d));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid rounding control value");
                            }
                        }
                        n2 = (int)d;
                        l = (long)d;
                        return;
                    }
                }
                case 751: {
                    this.checkResult(d);
                    return;
                }
                case 752: {
                    this.checkResult(d2);
                    return;
                }
                case 750: {
                    fpuState.init();
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown uCode " + this.microcodes[n5 - 1]);
                }
            }
        }
        catch (ProcessorException processorException) {
            throw processorException;
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
            return;
        }
        finally {
            this.transferSeg0 = segment;
            this.transferAddr0 = n;
            this.transferReg0 = n2;
            this.transferReg1 = n3;
            this.transferReg2 = n4;
            this.transferReg0l = l;
            this.transferFReg0 = d;
            this.transferFReg1 = d2;
            this.transferEipUpdated = bl;
            this.transferPosition = n5;
        }
    }

    @Override
    public int execute(Processor processor) {
        this.fpu = processor.fpu;
        this.cpu = processor;
        Segment segment = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        double d = 0.0;
        double d2 = 0.0;
        this.executeCount = this.getX86Count();
        boolean bl = false;
        int n5 = 0;
        try {
            block109: while (n5 < this.microcodes.length) {
                if (this.uCodeXferLoaded) {
                    this.uCodeXferLoaded = false;
                    n2 = this.uCodeXferReg0;
                    n3 = this.uCodeXferReg1;
                    n4 = this.uCodeXferReg2;
                }
                this.clock.pulse();
                switch (this.microcodes[n5++]) {
                    case 0: {
                        n = 0;
                        segment = null;
                        continue block109;
                    }
                    case 1: {
                        n &= 0xFFFF;
                        continue block109;
                    }
                    case 2: {
                        if (bl) continue block109;
                        bl = true;
                        processor.eip += this.cumulativeX86Length[n5 - 1];
                        continue block109;
                    }
                    case 3: {
                        n += (byte)this.microcodes[n5++];
                        continue block109;
                    }
                    case 4: {
                        this.push_o16_a16((short)n2);
                        continue block109;
                    }
                    case 5: {
                        segment = processor.ss;
                        continue block109;
                    }
                    case 6: {
                        n2 = processor.eax & 0xFFFF;
                        continue block109;
                    }
                    case 7: {
                        n += (short)processor.ebp;
                        continue block109;
                    }
                    case 8: {
                        n2 = this.microcodes[n5++] & 0xFF;
                        continue block109;
                    }
                    case 9: {
                        n2 = 0xFFFF & segment.getWord(n);
                        continue block109;
                    }
                    case 10: {
                        processor.esp = n3;
                        continue block109;
                    }
                    case 11: {
                        n3 = processor.esp & 0xFFFF0000 | processor.esp + 2 & 0xFFFF;
                        if (this.microcodes[n5] == 141) {
                            processor.eflagsInterruptEnable = false;
                        }
                        n2 = processor.ss.getWord(processor.esp & 0xFFFF);
                        continue block109;
                    }
                    case 12: {
                        processor.eax = processor.eax & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 13: {
                        n2 = this.microcodes[n5++] & 0xFFFF;
                        continue block109;
                    }
                    case 14: {
                        segment = processor.ds;
                        continue block109;
                    }
                    case 15: {
                        processor.ebx = processor.ebx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 16: {
                        n4 = n2;
                        n2 = n4 - n3;
                        continue block109;
                    }
                    case 17: {
                        processor.ebp = processor.ebp & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 18: {
                        n += (short)processor.ebx;
                        continue block109;
                    }
                    case 19: {
                        n2 = processor.esp & 0xFFFF;
                        continue block109;
                    }
                    case 20: {
                        n4 = n2;
                        n2 = n4 + n3;
                        continue block109;
                    }
                    case 21: {
                        segment.setWord(n, (short)n2);
                        continue block109;
                    }
                    case 22: {
                        n2 = 0xFF & segment.getByte(n);
                        continue block109;
                    }
                    case 23: {
                        this.jnz_o8((byte)n2);
                        continue block109;
                    }
                    case 24: {
                        processor.eax = processor.eax & 0xFFFFFF00 | n2 & 0xFF;
                        continue block109;
                    }
                    case 25: {
                        n2 = processor.ebx & 0xFFFF;
                        continue block109;
                    }
                    case 26: {
                        n3 = this.microcodes[n5++] & 0xFF;
                        continue block109;
                    }
                    case 27: {
                        n3 = this.microcodes[n5++] & 0xFFFF;
                        continue block109;
                    }
                    case 28: {
                        this.call_o16_a16((short)n2);
                        continue block109;
                    }
                    case 29: {
                        processor.ecx = processor.ecx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 30: {
                        n2 = processor.ecx & 0xFFFF;
                        continue block109;
                    }
                    case 31: {
                        n2 = processor.ebp & 0xFFFF;
                        continue block109;
                    }
                    case 32: {
                        this.ret_o16_a16();
                        continue block109;
                    }
                    case 33: {
                        processor.esp = processor.esp & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 34: {
                        n2 = processor.eax & 0xFF;
                        continue block109;
                    }
                    case 35: {
                        this.add_o16_flags(n2, n4, n3);
                        continue block109;
                    }
                    case 36: {
                        this.sub_o16_flags(n2, n4, n3);
                        continue block109;
                    }
                    case 37: {
                        processor.ds.setSelector(0xFFFF & n2);
                        continue block109;
                    }
                    case 38: {
                        n2 = processor.edx & 0xFFFF;
                        continue block109;
                    }
                    case 39: {
                        this.bitwise_flags((byte)n2);
                        continue block109;
                    }
                    case 40: {
                        processor.esi = processor.esi & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 41: {
                        n2 ^= n3;
                        continue block109;
                    }
                    case 42: {
                        processor.edx = processor.edx & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 43: {
                        n += (short)processor.esi;
                        continue block109;
                    }
                    case 44: {
                        this.sub_o8_flags(n2, n4, n3);
                        continue block109;
                    }
                    case 45: {
                        this.jz_o8((byte)n2);
                        continue block109;
                    }
                    case 46: {
                        n2 = processor.eax >> 8 & 0xFF;
                        continue block109;
                    }
                    case 47: {
                        processor.edi = processor.edi & 0xFFFF0000 | n2 & 0xFFFF;
                        continue block109;
                    }
                    case 48: {
                        n2 = processor.esi & 0xFFFF;
                        continue block109;
                    }
                    case 49: {
                        n += (short)this.microcodes[n5++];
                        continue block109;
                    }
                    case 50: {
                        this.bitwise_flags((short)n2);
                        continue block109;
                    }
                    case 51: {
                        n2 = 0xFFFF & processor.ds.getSelector();
                        continue block109;
                    }
                    case 52: {
                        n3 = 0xFFFF & segment.getWord(n);
                        continue block109;
                    }
                    case 53: {
                        n2 = processor.edi & 0xFFFF;
                        continue block109;
                    }
                    case 54: {
                        ++n2;
                        continue block109;
                    }
                    case 55: {
                        processor.es.setSelector(0xFFFF & n2);
                        continue block109;
                    }
                    case 56: {
                        this.inc_flags((short)n2);
                        continue block109;
                    }
                    case 57: {
                        n2 &= n3;
                        continue block109;
                    }
                    case 58: {
                        processor.ebx = processor.ebx & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block109;
                    }
                    case 59: {
                        segment = processor.es;
                        continue block109;
                    }
                    case 60: {
                        processor.eax = processor.eax & 0xFFFF00FF | n2 << 8 & 0xFF00;
                        continue block109;
                    }
                    case 61: {
                        n3 = processor.ecx & 0xFFFF;
                        continue block109;
                    }
                    case 62: {
                        this.add_o8_flags(n2, n4, n3);
                        continue block109;
                    }
                    case 63: {
                        n3 = processor.eax & 0xFFFF;
                        continue block109;
                    }
                    case 64: {
                        n3 = processor.ebx >> 8 & 0xFF;
                        continue block109;
                    }
                    case 65: {
                        n2 = processor.ebx >> 8 & 0xFF;
                        continue block109;
                    }
                    case 66: {
                        segment.setByte(n, (byte)n2);
                        continue block109;
                    }
                    case 67: {
                        n2 = 0xFFFF & processor.es.getSelector();
                        continue block109;
                    }
                    case 68: {
                        n3 = processor.eax >> 8 & 0xFF;
                        continue block109;
                    }
                    case 69: {
                        n4 = n2;
                        n2 = n4 + n3 + (processor.getCarryFlag() ? 1 : 0);
                        continue block109;
                    }
                    case 70: {
                        this.jump_o8((byte)n2);
                        continue block109;
                    }
                    case 71: {
                        this.jnc_o8((byte)n2);
                        continue block109;
                    }
                    case 72: {
                        this.jc_o8((byte)n2);
                        continue block109;
                    }
                    case 73: {
                        n3 = processor.eax & 0xFF;
                        continue block109;
                    }
                    case 74: {
                        this.adc_o16_flags(n2, n4, n3);
                        continue block109;
                    }
                    case 75: {
                        this.jump_o16((short)n2);
                        continue block109;
                    }
                    case 76: {
                        segment = processor.cs;
                        continue block109;
                    }
                    case 77: {
                        --n2;
                        continue block109;
                    }
                    case 78: {
                        this.dec_flags((short)n2);
                        continue block109;
                    }
                    case 79: {
                        n2 = n;
                        continue block109;
                    }
                    case 80: {
                        n4 = n2;
                        n2 <<= (n3 &= 0x1F);
                        continue block109;
                    }
                    case 81: {
                        processor.ebx = processor.ebx & 0xFFFFFF00 | n2 & 0xFF;
                        continue block109;
                    }
                    case 82: {
                        this.shl_flags((short)n2, (short)n4, n3);
                        continue block109;
                    }
                    case 83: {
                        n3 = processor.ebx & 0xFFFF;
                        continue block109;
                    }
                    case 84: {
                        n2 |= n3;
                        continue block109;
                    }
                    case 85: {
                        processor.es.setSelector(0xFFFF & n3);
                        continue block109;
                    }
                    case 86: {
                        processor.eax = processor.eax & 0xFFFF0000 | n3 & 0xFFFF;
                        continue block109;
                    }
                    case 87: {
                        n3 = processor.edi & 0xFFFF;
                        continue block109;
                    }
                    case 88: {
                        n3 = 0xFF & segment.getByte(n);
                        continue block109;
                    }
                    case 89: {
                        this.jcxz((byte)n2);
                        continue block109;
                    }
                    case 90: {
                        n3 = processor.esi & 0xFFFF;
                        continue block109;
                    }
                    case 91: {
                        processor.ds.setSelector(0xFFFF & n3);
                        continue block109;
                    }
                    case 92: {
                        n3 = processor.ecx & 0xFF;
                        continue block109;
                    }
                    case 93: {
                        processor.eip = n2;
                        continue block109;
                    }
                    case 94: {
                        processor.ecx = processor.ecx & 0xFFFFFF00 | n2 & 0xFF;
                        continue block109;
                    }
                    case 95: {
                        n += (short)processor.edi;
                        continue block109;
                    }
                    case 96: {
                        n4 = n2;
                        n2 >>>= n3;
                        continue block109;
                    }
                    case 97: {
                        this.shr_flags((short)n2, n4, n3);
                        continue block109;
                    }
                    case 98: {
                        this.ja_o8((byte)n2);
                        continue block109;
                    }
                    case 99: {
                        this.jna_o8((byte)n2);
                        continue block109;
                    }
                }
                this.transferSeg0 = segment;
                this.transferAddr0 = n;
                this.transferReg0 = n2;
                this.transferReg1 = n3;
                this.transferReg2 = n4;
                this.transferReg0l = l;
                this.transferEipUpdated = bl;
                this.transferPosition = n5 - 1;
                this.transferFReg0 = d;
                this.transferFReg1 = d2;
                try {
                    this.fullExecute(processor);
                }
                catch (ProcessorException processorException) {
                    throw processorException;
                }
                finally {
                    segment = this.transferSeg0;
                    n = this.transferAddr0;
                    n2 = this.transferReg0;
                    n3 = this.transferReg1;
                    n4 = this.transferReg2;
                    l = this.transferReg0l;
                    d = this.transferFReg0;
                    d2 = this.transferFReg1;
                    bl = this.transferEipUpdated;
                    n5 = this.transferPosition;
                }
            }
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == -1) {
                throw new IllegalStateException("Execute Failed");
            }
            int n6 = n5 - 1;
            if (bl) {
                processor.eip -= this.cumulativeX86Length[n6];
            }
            if (!processorException.pointsToSelf()) {
                processor.eip += this.cumulativeX86Length[n6];
            } else {
                for (int i = n6; i >= 0; --i) {
                    if (this.cumulativeX86Length[i] == this.cumulativeX86Length[n6]) continue;
                    processor.eip += this.cumulativeX86Length[i];
                    break;
                }
            }
            if (processorException.getVector() != 14) {
                System.out.println();
                System.out.println("Location: 0x" + Integer.toHexString(processor.getInstructionPointer()));
                processorException.printStackTrace();
            }
            processor.handleRealModeException(processorException.getVector());
        }
        return Math.max(this.executeCount, 0);
    }

    private final void jo_o8(byte by) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jno_o8(byte by) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jc_o8(byte by) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnc_o8(byte by) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jz_o8(byte by) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnz_o8(byte by) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jna_o8(byte by) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void ja_o8(byte by) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void js_o8(byte by) {
        if (this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jns_o8(byte by) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jp_o8(byte by) {
        if (this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnp_o8(byte by) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jl_o8(byte by) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnl_o8(byte by) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jng_o8(byte by) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jg_o8(byte by) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jo_o16(short s) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jno_o16(short s) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jc_o16(short s) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnc_o16(short s) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jz_o16(short s) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnz_o16(short s) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jna_o16(short s) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void ja_o16(short s) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void js_o16(short s) {
        if (this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jns_o16(short s) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jp_o16(short s) {
        if (this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnp_o16(short s) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jl_o16(short s) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnl_o16(short s) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jng_o16(short s) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jg_o16(short s) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jo_o32(int n) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jno_o32(int n) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jc_o32(int n) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnc_o32(int n) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jz_o32(int n) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnz_o32(int n) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jna_o32(int n) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void ja_o32(int n) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void js_o32(int n) {
        if (this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jns_o32(int n) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jp_o32(int n) {
        if (this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnp_o32(int n) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jl_o32(int n) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnl_o32(int n) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jng_o32(int n) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jg_o32(int n) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jcxz(byte by) {
        if ((this.cpu.ecx & 0xFFFF) == 0) {
            this.jump_o8(by);
        }
    }

    private final void jecxz(byte by) {
        if (this.cpu.ecx == 0) {
            this.jump_o8(by);
        }
    }

    private final void jump_o8(byte by) {
        this.cpu.eip += by;
        if ((this.cpu.eip & 0xFFFF0000) != 0) {
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jump_o16(short s) {
        this.cpu.eip = this.cpu.eip + s & 0xFFFF;
    }

    private final void jump_o32(int n) {
        this.cpu.eip += n;
        if ((this.cpu.eip & 0xFFFF0000) != 0) {
            this.cpu.eip -= n;
            throw exceptionGP;
        }
    }

    private final void call_o16_a16(short s) {
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        int n = this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(n, (short)this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n;
        this.cpu.eip = this.cpu.eip + s & 0xFFFF;
    }

    private final void call_o32_a16(int n) {
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        if (this.cpu.eip + n > 65535) {
            throw exceptionGP;
        }
        int n2 = this.cpu.esp - 4 & 0xFFFF;
        this.cpu.ss.setDoubleWord(n2, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n2;
        this.cpu.eip += n;
    }

    private final void ret_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
    }

    private final void ret_o32_a16() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void ret_iw_o16_a16(short s) {
        this.ret_o16_a16();
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + s & 0xFFFF;
    }

    private final void ret_far_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.cs.setSelector(this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF) & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void ret_far_iw_o16_a16(short s) {
        this.ret_far_o16_a16();
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + s & 0xFFFF;
    }

    private final void enter_o16_a16(int n, int n2) {
        n2 %= 32;
        int n3 = this.cpu.esp;
        int n4 = this.cpu.ebp;
        n3 = n3 & 0xFFFF0000 | n3 - 2 & 0xFFFF;
        this.cpu.ss.setWord(n3 & 0xFFFF, (short)n4);
        int n5 = n3 & 0xFFFF;
        if (n2 != 0) {
            while (--n2 != 0) {
                n4 = n4 & 0xFFFF0000 | n4 - 2 & 0xFFFF;
                n3 = n3 & 0xFFFF0000 | n3 - 2 & 0xFFFF;
                this.cpu.ss.setWord(n3 & 0xFFFF, this.cpu.ss.getWord(n4 & 0xFFFF));
            }
            n3 = n3 & 0xFFFF0000 | n3 - 2 & 0xFFFF;
            this.cpu.ss.setWord(n3 & 0xFFFF, (short)n5);
        }
        this.cpu.ebp = n4 & 0xFFFF0000 | n5 & 0xFFFF;
        this.cpu.esp = n3 & 0xFFFF0000 | n3 - n & 0xFFFF;
    }

    private final void leave_o16_a16() {
        try {
            this.cpu.ss.checkAddress(this.cpu.ebp & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw exceptionSS;
        }
        int n = this.cpu.esp & 0xFFFF0000 | this.cpu.ebp & 0xFFFF;
        int n2 = this.cpu.ebp & 0xFFFF0000 | this.cpu.ss.getWord(n & 0xFFFF) & 0xFFFF;
        if ((n & 0xFFFF) > 65535 | (n & 0xFFFF) < 0) {
            System.out.println("Throwing dodgy leave exception");
            throw exceptionGP;
        }
        this.cpu.esp = n & 0xFFFF0000 | n + 2 & 0xFFFF;
        this.cpu.ebp = n2;
    }

    private final void push_o16_a16(short s) {
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        int n = this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(n, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n;
    }

    private final void push_o32_a16(int n) {
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        int n2 = this.cpu.esp - 4 & 0xFFFF;
        this.cpu.ss.setDoubleWord(n2, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n2;
    }

    private final void pusha_a16() {
        int n = this.cpu.esp & 0xFFFF;
        if (n < 16 && (n & 1) == 1) {
            if (n < 6) {
                System.err.println("Should shutdown machine (PUSHA with small ESP");
            }
            throw exceptionGP;
        }
        int n2 = this.cpu.esp;
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.eax);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.ecx);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.edx);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.ebx);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)n2);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.ebp);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.esi);
        this.cpu.ss.setWord((n -= 2) & 0xFFFF, (short)this.cpu.edi);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void pushad_a16() {
        int n = this.cpu.esp & 0xFFFF;
        int n2 = this.cpu.esp;
        if (n < 32 && n > 0) {
            System.err.println("Throwing dodgy PUSHAD exception, must check!");
            throw exceptionGP;
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n;
    }

    private final void popa_a16() {
        int n = 0xFFFF & this.cpu.esp;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & n);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.ebx = this.cpu.ebx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 4));
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | (n += 2) & 0xFFFF;
    }

    private final void popad_a16() {
        int n = 0xFFFF & this.cpu.esp;
        this.cpu.edi = this.cpu.ss.getDoubleWord(0xFFFF & n);
        this.cpu.esi = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ebp = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ebx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 8));
        this.cpu.edx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ecx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.eax = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | (n += 4) & 0xFFFF;
    }

    private final void jump_far_o16(int n, int n2) {
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void jump_far_o32(int n, int n2) {
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void call_far_o16_a16(int n, int n2) {
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.ss.setWord(this.cpu.esp - 4 & 0xFFFF, (short)this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void call_far_o16_a32(int n, int n2) {
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw exceptionSS;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, (short)this.cpu.cs.getSelector());
        this.cpu.ss.setWord(this.cpu.esp - 4, (short)this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void call_far_o32_a16(int n, int n2) {
        if ((this.cpu.esp & 0xFFFF) < 8 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, 0xFFFF & this.cpu.cs.getSelector());
        this.cpu.ss.setDoubleWord(this.cpu.esp - 8 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 8 & 0xFFFF;
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void call_far_o32_a32(int n, int n2) {
        if (this.cpu.esp < 8 && this.cpu.esp > 0) {
            throw exceptionSS;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, 0xFFFF & this.cpu.cs.getSelector());
        this.cpu.ss.setDoubleWord(this.cpu.esp - 8, this.cpu.eip);
        this.cpu.esp -= 8;
        this.cpu.eip = n;
        this.cpu.cs.setSelector(n2);
    }

    private final void call_abs_o16_a16(int n) {
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void int_o16_a16(int n) {
        if (n == 0) {
            throw new IllegalStateException("INT 0 allowed? 0x" + Integer.toHexString(this.cpu.getInstructionPointer()));
        }
        if ((this.cpu.esp & 0xFFFF) < 6 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        int n2 = this.cpu.getEFlags() & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n2);
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsTrap = false;
        this.cpu.eflagsAlignmentCheck = false;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = 0xFFFF & this.cpu.idtr.getWord(4 * n);
        this.cpu.cs.setSelector(0xFFFF & this.cpu.idtr.getWord(4 * n + 2));
    }

    private final void int3_o16_a16() {
        int n = 3;
        if ((this.cpu.esp & 0xFFFF) < 6 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        int n2 = this.cpu.getEFlags() & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n2);
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsTrap = false;
        this.cpu.eflagsAlignmentCheck = false;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = 0xFFFF & this.cpu.idtr.getWord(4 * n);
        this.cpu.cs.setSelector(0xFFFF & this.cpu.idtr.getWord(4 * n + 2));
    }

    private final int iret_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        this.cpu.cs.setSelector(this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        short s = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        return s;
    }

    private final void cmpsb_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFF & segment.getByte(n);
        int n4 = 0xFF & this.cpu.es.getByte(n2);
        if (this.cpu.eflagsDirection) {
            --n;
            --n2;
        } else {
            ++n;
            ++n2;
        }
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = n3 - n4;
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n3;
        this.uCodeXferLoaded = true;
    }

    private final void cmpsw_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFFFF & segment.getWord(n);
        int n4 = 0xFFFF & this.cpu.es.getWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 2;
            n2 -= 2;
        } else {
            n += 2;
            n2 += 2;
        }
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = n3 - n4;
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n3;
        this.uCodeXferLoaded = true;
    }

    private final void cmpsd_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = segment.getDoubleWord(n);
        int n4 = this.cpu.es.getDoubleWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 4;
            n2 -= 4;
        } else {
            n += 4;
            n2 += 4;
        }
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = (int)((0xFFFFFFFFL & (long)n3) - (0xFFFFFFFFL & (long)n4));
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n3;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsb_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n != 0;
        int n4 = 0;
        int n5 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    --n2;
                    --n3;
                    if (n4 == n5) continue;
                    break;
                }
            } else {
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 == n5) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n5;
            this.uCodeXferReg2 = n4;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n5;
        this.uCodeXferReg2 = n4;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsw_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n != 0;
        int n4 = 0;
        int n5 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 -= 2;
                    n3 -= 2;
                    if (n4 == n5) continue;
                    break;
                }
            } else {
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 == n5) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n5;
            this.uCodeXferReg2 = n4;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n5;
        this.uCodeXferReg2 = n4;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsd_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n != 0;
        int n4 = 0;
        int n5 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 -= 4;
                    n3 -= 4;
                    if (n4 == n5) continue;
                    break;
                }
            } else {
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 == n5) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n5;
            this.uCodeXferReg2 = n4;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n5;
        this.uCodeXferReg2 = n4;
        this.uCodeXferLoaded = true;
    }

    private final void insb_a16(int n) throws ModuleException {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setByte(n2 & 0xFFFF, (byte)this.cpu.ioports.ioPortReadByte(n));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void insw_a16(int n) throws ModuleException {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setWord(n2 & 0xFFFF, (short)this.cpu.ioports.ioPortReadWord(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void insd_a16(int n) throws ModuleException {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setDoubleWord(n2 & 0xFFFF, this.cpu.ioports.ioPortReadLong(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insb_a16(int n) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3 & 0xFFFF, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3 & 0xFFFF, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insw_a16(int n) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3 & 0xFFFF, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3 & 0xFFFF, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insd_a16(int n) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3 & 0xFFFF, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3 & 0xFFFF, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void lodsb_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & segment.getByte(n);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void lodsw_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & segment.getWord(n);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void lodsd_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        this.cpu.eax = segment.getDoubleWord(n);
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsb_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.eax & 0xFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2 & 0xFFFF);
                    --n;
                    --n2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2 & 0xFFFF);
                    --n;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | n3;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsw_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.eax & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2 & 0xFFFF);
                    --n;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2 & 0xFFFF);
                    --n;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n3;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsd_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        int n3 = this.cpu.eax;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2 & 0xFFFF);
                    --n;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2 & 0xFFFF);
                    --n;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.eax = n3;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
        }
    }

    private final void lodsb_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & segment.getByte(n);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi = n;
    }

    private final void lodsw_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & segment.getWord(n);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi = n;
    }

    private final void lodsd_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = segment.getDoubleWord(n);
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.esi = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    --n2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.eax = n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    private final void movsb_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsw_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsd_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void movsb_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsw_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsd_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = n & 0xFFFF;
        this.cpu.esi = n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    private final void outsb_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & segment.getByte(n2));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsw_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsd_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsb_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsw_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsd_a16(int n, Segment segment) throws ModuleException {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void scasb_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFF & this.cpu.es.getByte(n2);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = n - n3;
        this.uCodeXferReg1 = n3;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    private final void scasw_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = 0xFFFF & this.cpu.es.getWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = n - n3;
        this.uCodeXferReg1 = n3;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    private final void scasd_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.es.getDoubleWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
        this.uCodeXferReg0 = (int)((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n3));
        this.uCodeXferReg1 = n3;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasb_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n2 != 0;
        int n4 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    --n3;
                    if (n == n4) continue;
                    break;
                }
            } else {
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n == n4) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n4;
            this.uCodeXferReg2 = n;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasw_a16(int n) {
        block6: {
            int n2 = this.cpu.ecx & 0xFFFF;
            int n3 = this.cpu.edi & 0xFFFF;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n == n4) continue;
                        break block6;
                    }
                    break block6;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                this.uCodeXferReg0 = n - n4;
                this.uCodeXferReg1 = n4;
                this.uCodeXferReg2 = n;
                this.uCodeXferLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasd_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n2 != 0;
        int n4 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 -= 4;
                    if (n == n4) continue;
                    break;
                }
            } else {
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n == n4) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n4;
            this.uCodeXferReg2 = n;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasb_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n2 != 0;
        int n4 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    --n3;
                    if (n != n4) continue;
                    break;
                }
            } else {
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n != n4) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n4;
            this.uCodeXferReg2 = n;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasw_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n2 != 0;
        int n4 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 -= 2;
                    if (n != n4) continue;
                    break;
                }
            } else {
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n != n4) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n4;
            this.uCodeXferReg2 = n;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasd_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        boolean bl = n2 != 0;
        int n4 = 0;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 -= 4;
                    if (n != n4) continue;
                    break;
                }
            } else {
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n != n4) continue;
                }
            }
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
            this.uCodeXferReg0 = bl ? 1 : 0;
            this.uCodeXferReg1 = n4;
            this.uCodeXferReg2 = n;
            this.uCodeXferLoaded = true;
            throw throwable;
        }
        this.uCodeXferReg1 = n4;
        this.uCodeXferReg2 = n;
        this.uCodeXferLoaded = true;
    }

    private final void stosb_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setByte(n2, (byte)n);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void stosw_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setWord(n2, (short)n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void stosd_a16(int n) {
        int n2 = this.cpu.edi & 0xFFFF;
        this.cpu.es.setDoubleWord(n2, n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosb_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3 & 0xFFFF, (byte)n);
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3 & 0xFFFF, (byte)n);
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosw_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3 & 0xFFFF, (short)n);
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3 & 0xFFFF, (short)n);
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosd_a16(int n) {
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.edi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3 & 0xFFFF, n);
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3 & 0xFFFF, n);
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void stosb_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)n);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
    }

    private final void stosw_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setWord(n2, (short)n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
    }

    private final void stosd_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosb_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosw_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosd_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    private final void mul_o8(int n) {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = n2 * n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n3 & 0xFFFF;
        this.cpu.setOverflowFlag(n3, 6);
        this.cpu.setCarryFlag(n3, 6);
    }

    private final void mul_o16(int n) {
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 * n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n3;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & (n3 >>= 16);
        this.cpu.setOverflowFlag(n3, 5);
        this.cpu.setCarryFlag(n3, 5);
    }

    private final void mul_o32(int n) {
        long l = (long)this.cpu.eax & 0xFFFFFFFFL;
        long l2 = 0xFFFFFFFFL & (long)n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>>= 32);
        this.cpu.setOverflowFlag((int)l3, 1);
        this.cpu.setCarryFlag((int)l3, 1);
    }

    private final void imula_o8(byte by) {
        byte by2 = (byte)this.cpu.eax;
        int n = by2 * by;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.setOverflowFlag(n, 2);
        this.cpu.setCarryFlag(n, 2);
    }

    private final void imula_o16(short s) {
        short s2 = (short)this.cpu.eax;
        int n = s2 * s;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | n >>> 16;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
    }

    private final void imula_o32(int n) {
        long l = this.cpu.eax;
        long l2 = n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>> 32);
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
    }

    private final int imul_o16(short s, short s2) {
        int n = s * s2;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
        return n;
    }

    private final int imul_o32(int n, int n2) {
        long l = n;
        long l2 = n2;
        long l3 = l * l2;
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
        return (int)l3;
    }

    private final void div_o8(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 / n;
        if (n3 > 255) {
            throw exceptionDE;
        }
        int n4 = n2 % n << 8;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n3 | 0xFF00 & n4;
    }

    private final void div_o16(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (long)this.cpu.edx & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)this.cpu.eax & 0xFFFFL) / (long)n;
        if (l2 > 65535L) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (int)(l3 & 0xFFFFL);
    }

    private final void div_o32(int n) {
        long l = 0xFFFFFFFFL & (long)n;
        if (l == 0L) {
            throw exceptionDE;
        }
        long l2 = this.cpu.edx;
        l2 <<= 32;
        long l3 = (l2 |= 0xFFFFFFFFL & (long)this.cpu.eax) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 / l;
        long l6 = l4 % l;
        long l7 = l5 << 1;
        long l8 = (l6 << 1) + l3;
        l7 += l8 / l;
        l8 %= l;
        if (l7 > 0xFFFFFFFFL) {
            throw exceptionDE;
        }
        this.cpu.eax = (int)l7;
        this.cpu.edx = (int)l8;
    }

    private final void idiv_o8(byte by) {
        if (by == 0) {
            throw exceptionDE;
        }
        short s = (short)this.cpu.eax;
        int n = s / by;
        int n2 = s % by;
        if (n > 127 || n < -128) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n | (0xFF & n2) << 8;
    }

    private final void idiv_o16(short s) {
        if (s == 0) {
            throw exceptionDE;
        }
        int n = this.cpu.edx << 16 | this.cpu.eax & 0xFFFF;
        int n2 = n / s;
        int n3 = n % s;
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw exceptionDE;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n2;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & n3;
    }

    private final void idiv_o32(int n) {
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (0xFFFFFFFFL & (long)this.cpu.edx) << 32;
        long l2 = (l |= 0xFFFFFFFFL & (long)this.cpu.eax) / (long)n;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw exceptionDE;
        }
        long l3 = l % (long)n;
        this.cpu.eax = (int)l2;
        this.cpu.edx = (int)l3;
    }

    private final void btc_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by ^ 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bts_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by | 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void btr_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by & ~(1 << (n &= 7))));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bt_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        this.cpu.setCarryFlag(segment.getByte(n2), n &= 7, 7);
    }

    private final int bsf(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return RealModeUBlock.numberOfTrailingZeros(n);
    }

    private final int bsr(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return 31 - RealModeUBlock.numberOfLeadingZeros(n);
    }

    private final void aaa() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) > 249 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax + 6 | 0xFF00 & this.cpu.eax + 256 + n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void aad(int n) throws ProcessorException {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = this.cpu.eax >> 8 & 0xFF;
        int n4 = n3 * n;
        int n5 = n4 + n2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n5 & 0xFF;
        this.cpu.setZeroFlag((byte)n5);
        this.cpu.setParityFlag((byte)n5);
        this.cpu.setSignFlag((byte)n5);
        this.cpu.setAuxiliaryCarryFlag(n4, n5, 2);
        this.cpu.setCarryFlag(n5, 8);
        this.cpu.setOverflowFlag(n5, n2, 13);
    }

    private final int aam(int n) throws ProcessorException {
        int n2 = 0xFF & this.cpu.eax;
        if (n == 0) {
            throw exceptionDE;
        }
        int n3 = 0xFF & n2 / n;
        int n4 = 0xFF & n2 % n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n4 | n3 << 8;
        this.cpu.setAuxiliaryCarryFlag(false);
        return (byte)n4;
    }

    private final void aas() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) < 6 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax - 6 | 0xFF00 & this.cpu.eax - 256 - n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void daa() {
        boolean bl;
        int n = this.cpu.eax & 0xFF;
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            n += 6;
            this.cpu.setAuxiliaryCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
        }
        if ((n & 0xFF) > 159 || this.cpu.getCarryFlag()) {
            n += 96;
            bl = true;
        } else {
            bl = false;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & n;
        this.cpu.setOverflowFlag(false);
        this.cpu.setZeroFlag((byte)n);
        this.cpu.setParityFlag((byte)n);
        this.cpu.setSignFlag((byte)n);
        this.cpu.setCarryFlag(bl);
    }

    private final void das() {
        boolean bl = false;
        int n = 0xFF & this.cpu.eax;
        if ((n & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 6 & 0xFF;
            boolean bl2 = bl = n < 6 || this.cpu.getCarryFlag();
        }
        if (n > 153 || this.cpu.getCarryFlag()) {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 96 & 0xFF;
            bl = true;
        }
        this.cpu.setOverflowFlag(false);
        this.cpu.setZeroFlag((byte)this.cpu.eax);
        this.cpu.setParityFlag((byte)this.cpu.eax);
        this.cpu.setSignFlag((byte)this.cpu.eax);
        this.cpu.setCarryFlag(bl);
    }

    private final void lahf() {
        int n = 512;
        if (this.cpu.getSignFlag()) {
            n |= 0x8000;
        }
        if (this.cpu.getZeroFlag()) {
            n |= 0x4000;
        }
        if (this.cpu.getAuxiliaryCarryFlag()) {
            n |= 0x1000;
        }
        if (this.cpu.getParityFlag()) {
            n |= 0x400;
        }
        if (this.cpu.getCarryFlag()) {
            n |= 0x100;
        }
        this.cpu.eax &= 0xFFFF00FF;
        this.cpu.eax |= n;
    }

    private final void sahf() {
        int n = this.cpu.eax & 0xFF00;
        this.cpu.setCarryFlag(0 != (n & 0x100));
        this.cpu.setParityFlag(0 != (n & 0x400));
        this.cpu.setAuxiliaryCarryFlag(0 != (n & 0x1000));
        this.cpu.setZeroFlag(0 != (n & 0x4000));
        this.cpu.setSignFlag(0 != (n & 0x8000));
    }

    private final void halt() {
        while (!this.cpu.waitForInterrupt(50L)) {
            this.cpu.processClock();
        }
        return;
    }

    private final void cpuid() {
        switch (this.cpu.eax) {
            case 0: {
                this.cpu.eax = 2;
                this.cpu.ebx = 1970169159;
                this.cpu.edx = 1231384169;
                this.cpu.ecx = 1818588270;
                return;
            }
            case 1: {
                this.cpu.eax = 1587;
                this.cpu.ebx = 2048;
                this.cpu.ecx = 0;
                int n = 0;
                n |= 1;
                n |= 0x100;
                n |= 0x10;
                n |= 0x20;
                n |= 0x8000;
                n |= 8;
                n |= 0x2000;
                this.cpu.edx = n |= 0x800;
                return;
            }
        }
        this.cpu.eax = 4261377;
        this.cpu.ebx = 0;
        this.cpu.ecx = 0;
        this.cpu.edx = 0;
    }

    private final void bitwise_flags(byte by) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void bitwise_flags(short s) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void bitwise_flags(int n) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private final void arithmetic_flags_o8(int n, int n2, int n3) {
        this.cpu.setZeroFlag((byte)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((byte)n);
        this.cpu.setCarryFlag(n, 9);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o16(int n, int n2, int n3) {
        this.cpu.setZeroFlag((short)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((short)n);
        this.cpu.setCarryFlag(n, 10);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o32(long l, int n, int n2) {
        this.cpu.setZeroFlag((int)l);
        this.cpu.setParityFlag((int)l);
        this.cpu.setSignFlag((int)l);
        this.cpu.setCarryFlag(l, 11);
        this.cpu.setAuxiliaryCarryFlag(n, n2, (int)l, 1);
    }

    private final void add_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag((int)l, n, n2, 24);
    }

    private final void add_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 23);
    }

    private final void add_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 22);
    }

    private final void adc_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2) + (long)n3;
        if (this.cpu.getCarryFlag() && n2 == -1) {
            this.arithmetic_flags_o32(l, n, n2);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag((int)l, n, n2, 24);
            this.arithmetic_flags_o32(l, n, n2);
        }
    }

    private final void adc_o16_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 65535) {
            this.arithmetic_flags_o16(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3, 23);
            this.arithmetic_flags_o16(n, n2, n3);
        }
    }

    private final void adc_o8_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 255) {
            this.arithmetic_flags_o8(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3, 22);
            this.arithmetic_flags_o8(n, n2, n3);
        }
    }

    private final void sub_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag((int)l, n, n2, 27);
    }

    private final void sub_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 26);
    }

    private final void sub_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 25);
    }

    private final void rep_sub_o32_flags(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        long l = (0xFFFFFFFFL & (long)n2) - (0xFFFFFFFFL & (long)n3);
        this.arithmetic_flags_o32(l, n2, n3);
        this.cpu.setOverflowFlag((int)l, n2, n3, 27);
    }

    private final void rep_sub_o16_flags(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        int n4 = n2 - n3;
        this.arithmetic_flags_o16(n4, n2, n3);
        this.cpu.setOverflowFlag(n4, n2, n3, 26);
    }

    private final void rep_sub_o8_flags(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        int n4 = n2 - n3;
        this.arithmetic_flags_o8(n4, n2, n3);
        this.cpu.setOverflowFlag(n4, n2, n3, 25);
    }

    private final void sbb_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) - ((0xFFFFFFFFL & (long)n2) + (long)n3);
        this.cpu.setOverflowFlag((int)l, n, n2, 27);
        this.arithmetic_flags_o32(l, n, n2);
    }

    private final void sbb_o16_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n, n2, n3, 26);
        this.arithmetic_flags_o16(n, n2, n3);
    }

    private final void sbb_o8_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n, n2, n3, 25);
        this.arithmetic_flags_o8(n, n2, n3);
    }

    private final void dec_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 18);
        this.cpu.setAuxiliaryCarryFlag(n, 3);
    }

    private final void dec_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 17);
        this.cpu.setAuxiliaryCarryFlag(s, 3);
    }

    private final void dec_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 16);
        this.cpu.setAuxiliaryCarryFlag(by, 3);
    }

    private final void inc_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 4);
    }

    private final void inc_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 4);
    }

    private final void inc_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 4);
    }

    private final void shl_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 12);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shl_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 13);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shl_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 14);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void shr_flags(byte by, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(by, n, 13);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shr_flags(short s, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(s, n, 14);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shr_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, n2, 15);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void sar_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(by);
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
        }
    }

    private final void sar_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(s);
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
        }
    }

    private final void sar_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(n);
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
        }
    }

    private final void rol_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
        }
    }

    private final void rol_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
        }
    }

    private final void rol_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 16);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
        }
    }

    private final void ror_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 17);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 7);
            }
        }
    }

    private final void ror_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 18);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 9);
            }
        }
    }

    private final void ror_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 19);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 11);
            }
        }
    }

    private final void rcl_o8_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 8);
            }
        }
    }

    private final void rcl_o16_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 10);
            }
        }
    }

    private final void rcl_o32_flags(long l, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag(l, 12);
            }
        }
    }

    private final void rcr_o8_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 8);
            }
        }
    }

    private final void rcr_o16_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 10);
            }
        }
    }

    private final void rcr_o32_flags(long l, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag(l, 12);
            }
        }
    }

    private final void neg_flags(byte by) {
        this.cpu.setCarryFlag(by, 1);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 5);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void neg_flags(short s) {
        this.cpu.setCarryFlag(s, 1);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 5);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void neg_flags(int n) {
        this.cpu.setCarryFlag(n, 1);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 5);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private void checkResult(double d) throws ProcessorException {
        if (Double.isInfinite(d)) {
            this.fpu.setOverflow();
            this.fpu.checkExceptions();
        }
    }

    private void validateOperand(double d) throws ProcessorException {
        long l = Double.doubleToRawLongBits(d);
        if ((l >> 52 & 0x7FFL) == 0L && (l & 0xFFFFFFFFFFFFFL) != 0L) {
            this.fpu.setDenormalizedOperand();
            this.fpu.checkExceptions();
        }
    }

    private static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    private static int numberOfLeadingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8; ++j) {
                if ((1 & i >> j) != 1) continue;
                bl = !bl;
            }
            RealModeUBlock.parityMap[i] = bl;
        }
        L2TEN = Math.log(10.0) / Math.log(2.0);
        L2E = Math.log(10.0) / Math.log(2.0);
        LOG2 = Math.log(10.0) / Math.log(2.0);
        LN2 = Math.log(2.0);
        POS0 = Double.longBitsToDouble(0L);
    }
}

