/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.dma;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleDMA;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.dma.DMA16Handler;
import dioscuri.module.dma.DMA8Handler;
import dioscuri.module.dma.DMAController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMA
extends ModuleDMA {
    boolean busHoldAcknowledged;
    boolean terminalCountReached;
    byte[] ext_page_reg = new byte[16];
    public DMAController[] controller = new DMAController[]{new DMAController(), new DMAController()};
    public DMA8Handler[] dma8Handler = new DMA8Handler[4];
    public DMA16Handler[] dma16Handler = new DMA16Handler[4];
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard", "cpu", "memory"};
    private ModuleMotherboard motherboard;
    private ModuleMemory memory;
    private ModuleCPU cpu;
    private boolean isObserved;
    private boolean debugMode;
    private static final Logger logger = Logger.getLogger(DMA.class.getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "dma";
    public static final String MODULE_NAME = "8237 DMA Controller";
    private static final int MASTER_CTRL = 0;
    private static final int SLAVE_CTRL = 1;
    private static final int PORT_DMA1_CH0_ADDRESS = 0;
    private static final int PORT_DMA1_CH0_COUNT = 1;
    private static final int PORT_DMA1_CH1_ADDRESS = 2;
    private static final int PORT_DMA1_CH1_COUNT = 3;
    private static final int PORT_DMA1_CH2_ADDRESS = 4;
    private static final int PORT_DMA1_CH2_COUNT = 5;
    private static final int PORT_DMA1_CH3_ADDRESS = 6;
    private static final int PORT_DMA1_CH3_COUNT = 7;
    private static final int PORT_DMA1_STATUS_CMD = 8;
    private static final int PORT_DMA1_REQUEST = 9;
    private static final int PORT_DMA1_MASK = 10;
    private static final int PORT_DMA1_MODE = 11;
    private static final int PORT_DMA1_CLEARBYTE = 12;
    private static final int PORT_DMA1_TEMP_MASTER = 13;
    private static final int PORT_DMA1_CLEARMASK = 14;
    private static final int PORT_DMA1_WRITEMASK = 15;
    private static final int PORT_EXTRA_PAGE_0 = 128;
    private static final int PORT_CHAN_2_ADDR_BYTE_2 = 129;
    private static final int PORT_CHAN_3_ADDR_BYTE_2 = 130;
    private static final int PORT_CHAN_1_ADDR_BYTE_2 = 131;
    private static final int PORT_EXTRA_PAGE_4 = 132;
    private static final int PORT_EXTRA_PAGE_5 = 133;
    private static final int PORT_EXTRA_PAGE_6 = 134;
    private static final int PORT_CHAN_0_ADDR_BYTE_2 = 135;
    private static final int PORT_EXTRA_PAGE_8 = 136;
    private static final int PORT_CHAN_6_ADDR_BYTE_2 = 137;
    private static final int PORT_CHAN_7_ADDR_BYTE_2 = 138;
    private static final int PORT_CHAN_5_ADDR_BYTE_2 = 139;
    private static final int PORT_EXTRA_PAGE_C = 140;
    private static final int PORT_EXTRA_PAGE_D = 141;
    private static final int PORT_EXTRA_PAGE_E = 142;
    private static final int PORT_REFRESH_PAGE = 129;
    private static final int PORT_DMA2_CH4_ADDRESS = 192;
    private static final int PORT_DMA2_CH4_COUNT = 194;
    private static final int PORT_DMA2_CH5_ADDRESS = 196;
    private static final int PORT_DMA2_CH5_COUNT = 198;
    private static final int PORT_DMA2_CH6_ADDRESS = 200;
    private static final int PORT_DMA2_CH6_COUNT = 202;
    private static final int PORT_DMA2_CH7_ADDRESS = 204;
    private static final int PORT_DMA2_CH7_COUNT = 206;
    private static final int PORT_DMA2_STATUS_CMD = 208;
    private static final int PORT_DMA2_REQUEST = 210;
    private static final int PORT_DMA2_MASK = 212;
    private static final int PORT_DMA2_MODE = 214;
    private static final int PORT_DMA2_CLEARBYTE = 216;
    private static final int PORT_DMA2_TEMP_MASTER = 218;
    private static final int PORT_DMA2_CLEARMASK = 220;
    private static final int PORT_DMA2_WRITEMASK = 222;
    private static final int FLOPPY_DMA_CHANNEL = 2;
    private static final int CASCADE_DMA_CHANNEL = 4;

    public DMA(Emulator emulator) {
        int n;
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 4; ++i) {
                this.controller[n].DRQ[i] = false;
                this.controller[n].DACK[i] = false;
            }
        }
        this.busHoldAcknowledged = false;
        this.terminalCountReached = false;
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 4; ++i) {
                this.controller[n].channel[i].mode.modeType = 0;
                this.controller[n].channel[i].mode.addressDecrement = false;
                this.controller[n].channel[i].mode.autoInitEnable = false;
                this.controller[n].channel[i].mode.transferType = 0;
                this.controller[n].channel[i].baseAddress = 0;
                this.controller[n].channel[i].currentAddress = 0;
                this.controller[n].channel[i].baseCount = 0;
                this.controller[n].channel[i].currentCount = 0;
                this.controller[n].channel[i].pageRegister = 0;
                this.controller[n].channel[i].channelUsed = false;
            }
        }
        Arrays.fill(this.dma8Handler, null);
        Arrays.fill(this.dma16Handler, null);
        Arrays.fill(this.ext_page_reg, (byte)0);
        this.setCascadeChannel();
        logger.log(Level.INFO, "[dma] Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("memory")) {
            this.memory = (ModuleMemory)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("cpu")) {
            this.cpu = (ModuleCPU)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null && this.cpu != null;
    }

    @Override
    public boolean reset() {
        this.motherboard.setIOPort(0, this);
        this.motherboard.setIOPort(1, this);
        this.motherboard.setIOPort(2, this);
        this.motherboard.setIOPort(3, this);
        this.motherboard.setIOPort(4, this);
        this.motherboard.setIOPort(5, this);
        this.motherboard.setIOPort(6, this);
        this.motherboard.setIOPort(7, this);
        this.motherboard.setIOPort(8, this);
        this.motherboard.setIOPort(9, this);
        this.motherboard.setIOPort(10, this);
        this.motherboard.setIOPort(11, this);
        this.motherboard.setIOPort(12, this);
        this.motherboard.setIOPort(13, this);
        this.motherboard.setIOPort(14, this);
        this.motherboard.setIOPort(15, this);
        this.motherboard.setIOPort(128, this);
        this.motherboard.setIOPort(129, this);
        this.motherboard.setIOPort(130, this);
        this.motherboard.setIOPort(131, this);
        this.motherboard.setIOPort(132, this);
        this.motherboard.setIOPort(133, this);
        this.motherboard.setIOPort(134, this);
        this.motherboard.setIOPort(135, this);
        this.motherboard.setIOPort(136, this);
        this.motherboard.setIOPort(137, this);
        this.motherboard.setIOPort(138, this);
        this.motherboard.setIOPort(139, this);
        this.motherboard.setIOPort(140, this);
        this.motherboard.setIOPort(141, this);
        this.motherboard.setIOPort(142, this);
        this.motherboard.setIOPort(129, this);
        this.motherboard.setIOPort(192, this);
        this.motherboard.setIOPort(194, this);
        this.motherboard.setIOPort(196, this);
        this.motherboard.setIOPort(198, this);
        this.motherboard.setIOPort(200, this);
        this.motherboard.setIOPort(202, this);
        this.motherboard.setIOPort(204, this);
        this.motherboard.setIOPort(206, this);
        this.motherboard.setIOPort(208, this);
        this.motherboard.setIOPort(210, this);
        this.motherboard.setIOPort(212, this);
        this.motherboard.setIOPort(214, this);
        this.motherboard.setIOPort(216, this);
        this.motherboard.setIOPort(218, this);
        this.motherboard.setIOPort(220, this);
        this.motherboard.setIOPort(222, this);
        this.resetController(0);
        this.resetController(1);
        logger.log(Level.INFO, "[dma] Module has been reset");
        return true;
    }

    void resetController(int n) {
        for (int i = 0; i < 4; ++i) {
            this.controller[n].mask[i] = 1;
        }
        this.controller[n].commandRegister = 0;
        this.controller[n].ctrlDisabled = false;
        this.controller[n].statusRegister = 0;
        this.controller[n].flipflop = false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        string = string + "Current registered DMA channels: " + string2;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!this.controller[i].channel[j].channelUsed) continue;
                string = i == 0 ? string + " Channel " + j + ": " + this.dma8Handler[j].owner + "\n" : string + " Channel " + (j + 4) + ": " + this.dma16Handler[j].owner + "\n";
            }
        }
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return -1;
    }

    @Override
    public void setUpdateInterval(int n) {
    }

    @Override
    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleUnknownPort {
        logger.log(Level.CONFIG, "[dma] Read from port 0x" + Integer.toHexString(n).toUpperCase());
        if (this.dma8Handler[2] == null) {
            return -1;
        }
        int n2 = n >= 192 ? 1 : 0;
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 192: 
            case 196: 
            case 200: 
            case 204: {
                int n3 = n >> 1 + n2 & 3;
                if (this.controller[n2].flipflop) {
                    this.controller[n2].flipflop = !this.controller[n2].flipflop;
                    return (byte)(this.controller[n2].channel[n3].currentAddress >> 8);
                }
                this.controller[n2].flipflop = !this.controller[n2].flipflop;
                return (byte)(this.controller[n2].channel[n3].currentAddress & 0xFF);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 194: 
            case 198: 
            case 202: 
            case 206: {
                int n4 = n >> 1 + n2 & 3;
                if (this.controller[n2].flipflop) {
                    this.controller[n2].flipflop = !this.controller[n2].flipflop;
                    return (byte)(this.controller[n2].channel[n4].currentCount >> 8);
                }
                this.controller[n2].flipflop = !this.controller[n2].flipflop;
                return (byte)(this.controller[n2].channel[n4].currentCount & 0xFF);
            }
            case 8: 
            case 208: {
                byte by = this.controller[n2].statusRegister;
                this.controller[n2].statusRegister = (byte)(this.controller[n2].statusRegister & 0xF0);
                return by;
            }
            case 13: 
            case 218: {
                logger.log(Level.CONFIG, "[dma] Controller [" + n2 + "] temporary register (unused) read. Returned 0 (default)");
                return 0;
            }
            case 129: {
                return this.controller[n2].channel[2].pageRegister;
            }
            case 130: {
                return this.controller[n2].channel[3].pageRegister;
            }
            case 131: {
                return this.controller[n2].channel[1].pageRegister;
            }
            case 135: {
                return this.controller[n2].channel[0].pageRegister;
            }
            case 137: {
                return this.controller[n2].channel[2].pageRegister;
            }
            case 138: {
                return this.controller[n2].channel[3].pageRegister;
            }
            case 139: {
                return this.controller[n2].channel[1].pageRegister;
            }
            case 143: {
                return this.controller[n2].channel[0].pageRegister;
            }
            case 128: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 140: 
            case 141: 
            case 142: {
                return this.ext_page_reg[n & 0xF];
            }
            case 15: 
            case 222: {
                byte by = (byte)(this.controller[n2].mask[0] | this.controller[n2].mask[1] << 1 | this.controller[n2].mask[2] << 2 | this.controller[n2].mask[3] << 3);
                return (byte)(0xF0 | by);
            }
        }
        throw new ModuleUnknownPort("[dma] does not recognise port 0x" + Integer.toHexString(n).toUpperCase());
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleUnknownPort {
        logger.log(Level.CONFIG, "[dma] I/O write to port 0x" + Integer.toHexString(n).toUpperCase() + ": 0x" + Integer.toHexString(by));
        if (this.dma8Handler[2] == null) {
            return;
        }
        byte by2 = (byte)(n >= 192 ? 1 : 0);
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 192: 
            case 196: 
            case 200: 
            case 204: {
                int n2 = n >> 1 + by2 & 3;
                logger.log(Level.CONFIG, "[dma]  Controller " + by2 + ",  channel " + n2 + " base and current address set.");
                if (this.controller[by2].flipflop) {
                    this.controller[by2].channel[n2].baseAddress |= (by & 0xFF) << 8;
                    this.controller[by2].channel[n2].currentAddress |= (by & 0xFF) << 8;
                    logger.log(Level.CONFIG, "[dma]    base = 0x" + Integer.toHexString(this.controller[by2].channel[n2].baseAddress).toUpperCase());
                    logger.log(Level.CONFIG, "[dma]    curr = 0x" + Integer.toHexString(this.controller[by2].channel[n2].currentAddress).toUpperCase());
                } else {
                    this.controller[by2].channel[n2].baseAddress = by & 0xFF;
                    this.controller[by2].channel[n2].currentAddress = by & 0xFF;
                }
                this.controller[by2].flipflop = !this.controller[by2].flipflop;
                return;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 194: 
            case 198: 
            case 202: 
            case 206: {
                int n3 = n >> 1 + by2 & 3;
                logger.log(Level.CONFIG, "[dma]  Controller " + by2 + ",  channel " + n3 + " base and current count set.");
                if (this.controller[by2].flipflop) {
                    this.controller[by2].channel[n3].baseCount |= (by & 0xFF) << 8;
                    this.controller[by2].channel[n3].currentCount |= (by & 0xFF) << 8;
                    logger.log(Level.CONFIG, "[dma]    base = 0x" + Integer.toHexString(this.controller[by2].channel[n3].baseCount).toUpperCase());
                    logger.log(Level.CONFIG, "[dma]    curr = 0x" + Integer.toHexString(this.controller[by2].channel[n3].currentCount).toUpperCase());
                } else {
                    this.controller[by2].channel[n3].baseCount = by & 0xFF;
                    this.controller[by2].channel[n3].currentCount = by & 0xFF;
                }
                this.controller[by2].flipflop = !this.controller[by2].flipflop;
                return;
            }
            case 8: 
            case 208: {
                if ((by & 0xFB) != 0) {
                    logger.log(Level.WARNING, "[dma] command register functionality setting not supported");
                }
                this.controller[by2].commandRegister = by;
                this.controller[by2].ctrlDisabled = (by >> 2 & 1) == 1;
                this.controlHoldRequest(by2);
                return;
            }
            case 9: 
            case 210: {
                int n4 = by & 3;
                if ((by & 4) != 0) {
                    this.controller[by2].statusRegister = (byte)(this.controller[by2].statusRegister | 1 << n4 + 4);
                    logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": Set DMA request bit for channel " + n4);
                } else {
                    this.controller[by2].statusRegister = (byte)(this.controller[by2].statusRegister & ~(1 << n4 + 4));
                    logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": Clear DMA request bit for channel " + n4);
                }
                this.controlHoldRequest(by2);
                return;
            }
            case 10: 
            case 212: {
                int n5 = by & 3;
                this.controller[by2].mask[n5] = (byte)((by & 4) > 0 ? 1 : 0);
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ", channel " + n5 + ": set mask as " + ((by & 4) > 0 ? 1 : 0) + "; mask now=0x" + this.controller[by2].mask[n5]);
                this.controlHoldRequest(by2);
                return;
            }
            case 11: 
            case 214: {
                int n6 = by & 3;
                this.controller[by2].channel[n6].mode.modeType = (byte)(by >> 6 & 3);
                this.controller[by2].channel[n6].mode.addressDecrement = (by >> 5 & 1) == 1;
                this.controller[by2].channel[n6].mode.autoInitEnable = (by >> 4 & 1) == 1;
                this.controller[by2].channel[n6].mode.transferType = (byte)(by >> 2 & 3);
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ", channel " + n6 + ": mode register set to 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 12: 
            case 216: {
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": flip-flop cleared");
                this.controller[by2].flipflop = false;
                return;
            }
            case 13: 
            case 218: {
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": master clear (reset)");
                this.resetController(by2);
                return;
            }
            case 14: 
            case 220: {
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": clear mask register");
                this.controller[by2].mask[0] = 0;
                this.controller[by2].mask[1] = 0;
                this.controller[by2].mask[2] = 0;
                this.controller[by2].mask[3] = 0;
                this.controlHoldRequest(by2);
                return;
            }
            case 15: 
            case 222: {
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": write mask register");
                this.controller[by2].mask[0] = (byte)(by & 1);
                by = (byte)(by >> 1);
                this.controller[by2].mask[1] = (byte)(by & 1);
                by = (byte)(by >> 1);
                this.controller[by2].mask[2] = (byte)(by & 1);
                by = (byte)(by >> 1);
                this.controller[by2].mask[3] = (byte)(by & 1);
                this.controlHoldRequest(by2);
                return;
            }
            case 129: {
                this.controller[by2].channel[2].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 2 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 130: {
                this.controller[by2].channel[3].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 3 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 131: {
                this.controller[by2].channel[1].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 1 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 135: {
                this.controller[by2].channel[0].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 0 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 137: {
                this.controller[by2].channel[2].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 2 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 138: {
                this.controller[by2].channel[3].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 3 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 139: {
                this.controller[by2].channel[1].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 1 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 143: {
                this.controller[by2].channel[0].pageRegister = by;
                logger.log(Level.CONFIG, "[dma] Controller " + by2 + ": page register 0 = 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
            case 128: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 140: 
            case 141: 
            case 142: {
                this.ext_page_reg[n & 0xF] = by;
                return;
            }
        }
        throw new ModuleUnknownPort("[dma] does not recognise port 0x" + Integer.toHexString(n).toUpperCase());
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleUnknownPort {
        byte[] byArray = new byte[]{this.getIOPortByte(n), this.getIOPortByte(n)};
        return byArray;
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleUnknownPort {
        this.setIOPortByte(n, byArray[1]);
        this.setIOPortByte(n, byArray[0]);
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[dma] -> IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[dma] -> Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleUnknownPort {
        logger.log(Level.WARNING, "[dma] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public boolean registerDMAChannel(int n, DMA8Handler dMA8Handler) {
        if (n > 3) {
            logger.log(Level.SEVERE, "[dma] registerDMA8Channel: invalid channel number: " + n);
            return false;
        }
        if (this.controller[0].channel[n].channelUsed) {
            logger.log(Level.SEVERE, "[dma] registerDMA8Channel: channel " + n + " already in use.");
            return false;
        }
        logger.log(Level.CONFIG, "[dma] Channel " + n + " (8-bit) used by " + dMA8Handler.owner);
        this.dma8Handler[n] = dMA8Handler;
        this.controller[0].channel[n].channelUsed = true;
        return true;
    }

    @Override
    public boolean registerDMAChannel(int n, DMA16Handler dMA16Handler) {
        if (n < 4 || n > 7) {
            logger.log(Level.SEVERE, "[dma] registerDMA16Channel: invalid channel number: " + n);
            return false;
        }
        if (this.controller[1].channel[n - 4].channelUsed) {
            logger.log(Level.SEVERE, "[dma] registerDMA16Channel: channel " + n + " already in use.");
            return false;
        }
        logger.log(Level.CONFIG, "[dma] Channel " + n + " (16-bit) used by " + dMA16Handler.owner);
        this.dma16Handler[n - 4] = dMA16Handler;
        this.controller[1].channel[n - 4].channelUsed = true;
        return true;
    }

    public boolean unregisterDMAChannel(int n) {
        int n2 = n > 3 ? 1 : 0;
        this.controller[n2].channel[n & 3].channelUsed = false;
        logger.log(Level.INFO, "[dma] Channel " + n + " no longer used");
        return true;
    }

    @Override
    public boolean isTerminalCountReached() {
        return this.terminalCountReached;
    }

    @Override
    public void setDMARequest(int n, boolean bl) {
        int n2;
        int n3;
        if (n > 7) {
            logger.log(Level.SEVERE, "[dma] setDMARequest(): channel " + n + " not connected to any device");
        }
        int n4 = n > 3 ? 1 : 0;
        this.controller[n4].DRQ[n & 3] = bl;
        if (!this.controller[n4].channel[n & 3].channelUsed) {
            logger.log(Level.SEVERE, "[dma] setDMARequest(): channel " + n + " not connected to any device");
        }
        n &= 3;
        if (!bl) {
            logger.log(Level.CONFIG, "[dma] setDMARequest(): val == 0");
            this.controller[n4].statusRegister = (byte)(this.controller[n4].statusRegister & ~(1 << n + 4));
            this.controlHoldRequest(n4);
            return;
        }
        logger.log(Level.CONFIG, "[dma] mask[" + n + "]: 0x" + Integer.toHexString(this.controller[0].mask[n]).toUpperCase());
        logger.log(Level.CONFIG, "[dma] flipflop: " + Boolean.valueOf(this.controller[0].flipflop).toString());
        logger.log(Level.CONFIG, "[dma] statusRegister: 0x" + Integer.toHexString(this.controller[0].statusRegister).toUpperCase());
        logger.log(Level.CONFIG, "[dma] modeType: 0x" + Integer.toHexString(this.controller[0].channel[n].mode.modeType).toUpperCase());
        logger.log(Level.CONFIG, "[dma] addressDecrement: " + Boolean.valueOf(this.controller[0].channel[n].mode.addressDecrement).toString());
        logger.log(Level.CONFIG, "[dma] autoInitEnable: " + Boolean.valueOf(this.controller[0].channel[n].mode.autoInitEnable).toString());
        logger.log(Level.CONFIG, "[dma] transferType: 0x" + Integer.toHexString(this.controller[0].channel[n].mode.transferType).toUpperCase());
        logger.log(Level.CONFIG, "[dma] baseAddress: 0x" + Integer.toHexString(this.controller[0].channel[n].baseAddress).toUpperCase());
        logger.log(Level.CONFIG, "[dma] currentAddress: 0x" + Integer.toHexString(this.controller[0].channel[n].currentAddress).toUpperCase());
        logger.log(Level.CONFIG, "[dma] baseCount: 0x" + Integer.toHexString(this.controller[0].channel[n].baseCount).toUpperCase());
        logger.log(Level.CONFIG, "[dma] currentCount: 0x" + Integer.toHexString(this.controller[0].channel[n].currentCount).toUpperCase());
        logger.log(Level.CONFIG, "[dma] pageReg: 0x" + Integer.toHexString(this.controller[0].channel[n].pageRegister).toUpperCase());
        this.controller[n4].statusRegister = (byte)(this.controller[n4].statusRegister | 1 << n + 4);
        if (this.controller[n4].channel[n].mode.modeType != 1 && this.controller[n4].channel[n].mode.modeType != 0 && this.controller[n4].channel[n].mode.modeType != 3) {
            logger.log(Level.SEVERE, "[dma] setDMARequest(): mode_type(0x" + Integer.toHexString(this.controller[n4].channel[n].mode.modeType).toUpperCase() + " not supported");
        }
        if (((n3 = this.controller[n4].channel[n].pageRegister << 16 | this.controller[n4].channel[n].baseAddress << n4) & 0x7FFF0000 << n4) != ((n2 = this.controller[n4].channel[n].mode.addressDecrement ? n3 - (this.controller[n4].channel[n].baseCount << n4) : n3 + (this.controller[n4].channel[n].baseCount << n4)) & 0x7FFF0000 << n4)) {
            logger.log(Level.CONFIG, "[dma] dmaFloor = 0x" + Integer.toHexString(n3).toUpperCase());
            logger.log(Level.CONFIG, "[dma] dmaBaseCount = 0x" + Integer.toHexString(this.controller[n4].channel[n].baseCount).toUpperCase());
            logger.log(Level.CONFIG, "[dma] dmaCeiling = 0x" + Integer.toHexString(n2).toUpperCase());
            logger.log(Level.SEVERE, "[dma] request outside " + (64 << n4) + "k boundary");
        }
        this.controlHoldRequest(n4);
    }

    private void controlHoldRequest(int n) {
        if (this.controller[n].ctrlDisabled) {
            return;
        }
        if ((this.controller[n].statusRegister & 0xF0) == 0) {
            if (n != 0) {
                this.cpu.setHoldRequest(false, this);
            } else {
                this.setDMARequest(4, false);
            }
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if ((this.controller[n].statusRegister & 1 << i + 4) == 0 || this.controller[n].mask[i] != 0) continue;
            if (n != 0) {
                this.cpu.setHoldRequest(true, this);
                break;
            }
            this.setDMARequest(4, true);
            break;
        }
    }

    @Override
    public void acknowledgeBusHold() {
        int n;
        int n2 = 0;
        boolean bl = false;
        this.busHoldAcknowledged = true;
        for (n = 0; n < 4; ++n) {
            if ((this.controller[1].statusRegister & 1 << n + 4) == 0 || this.controller[1].mask[n] != 0) continue;
            n2 = 1;
            break;
        }
        if (n == 0) {
            this.controller[1].DACK[0] = true;
            for (n = 0; n < 4; ++n) {
                if ((this.controller[0].statusRegister & 1 << n + 4) == 0 || this.controller[0].mask[n] != 0) continue;
                n2 = 0;
                break;
            }
        }
        logger.log(Level.INFO, "[dma] Hold ACK: OK in response to DRQ(" + n + "), address 0x" + Integer.toHexString(this.controller[n2].channel[n].currentAddress & 0xFF).toUpperCase());
        int n3 = this.controller[n2].channel[n].pageRegister << 16 | this.controller[n2].channel[n].currentAddress << n2;
        logger.log(Level.INFO, "BaseAddress=" + this.controller[n2].channel[n].baseAddress + ", currentAddress=" + this.controller[n2].channel[n].currentAddress + ", memoryAddress=" + n3);
        this.controller[n2].DACK[n] = true;
        this.controller[n2].channel[n].currentAddress = this.controller[n2].channel[n].mode.addressDecrement ? --this.controller[n2].channel[n].currentAddress : ++this.controller[n2].channel[n].currentAddress;
        --this.controller[n2].channel[n].currentCount;
        if (this.controller[n2].channel[n].currentCount == -1) {
            this.controller[n2].statusRegister = (byte)(this.controller[n2].statusRegister | 1 << n);
            this.terminalCountReached = true;
            bl = true;
            if (this.controller[n2].channel[n].mode.autoInitEnable) {
                this.controller[n2].channel[n].currentAddress = this.controller[n2].channel[n].baseAddress;
                this.controller[n2].channel[n].currentCount = this.controller[n2].channel[n].baseCount;
            } else {
                this.controller[n2].mask[n] = 1;
            }
        }
        try {
            this.initiateDMATransfer(n2, n, n3);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.SEVERE, "[DMA] Error in DMA transfer: " + moduleException.getMessage());
        }
        if (bl) {
            this.terminalCountReached = false;
            this.busHoldAcknowledged = false;
            this.cpu.setHoldRequest(false, this);
            if (n2 == 0) {
                this.setDMARequest(4, false);
                this.controller[1].DACK[0] = false;
            }
            this.controller[n2].DACK[n] = false;
        }
    }

    private void initiateDMATransfer(int n, int n2, int n3) throws ModuleException {
        byte[] byArray = new byte[2];
        if (this.controller[n].channel[n2].mode.transferType == 1) {
            if (n == 0) {
                if (this.dma8Handler[n2] != null) {
                    byte by = this.dma8Handler[n2].dma8WriteToMem();
                    this.memory.setByte(n3, by);
                } else {
                    logger.log(Level.SEVERE, "[dma] no dma8 write handler for channel " + n2);
                }
            } else if (this.dma16Handler[n2] != null) {
                byArray = this.dma16Handler[n2].dma16WriteToMem();
                this.memory.setWord(n3, byArray);
            } else {
                logger.log(Level.SEVERE, "[dma] no dma16 write handler for channel " + n2);
            }
        } else if (this.controller[n].channel[n2].mode.transferType == 2) {
            if (n == 0) {
                byte by = this.memory.getByte(n3);
                if (this.dma8Handler[n2] != null) {
                    this.dma8Handler[n2].dma8ReadFromMem(by);
                }
            } else {
                byArray = this.memory.getWord(n3);
                if (this.dma16Handler[n2] != null) {
                    this.dma16Handler[n2].dma16ReadFromMem(byArray);
                }
            }
        } else if (this.controller[n].channel[n2].mode.transferType == 0) {
            if (n == 0) {
                if (this.dma8Handler[n2] != null) {
                    byte by = this.dma8Handler[n2].dma8WriteToMem();
                } else {
                    logger.log(Level.SEVERE, "[dma] no dma8 write handler for channel " + n2);
                }
            } else if (this.dma16Handler[n2] != null) {
                byArray = this.dma16Handler[n2].dma16WriteToMem();
            } else {
                logger.log(Level.SEVERE, "[dma] no dma16 write handler for channel " + n2);
            }
        } else {
            logger.log(Level.SEVERE, "[dma] HLDA: memory->memory transfer (type 3) undefined");
        }
    }

    private void setCascadeChannel() {
        class Cascade16Handler
        extends DMA16Handler {
            Cascade16Handler() {
            }

            @Override
            public void dma16ReadFromMem(byte[] byArray) {
            }

            @Override
            public byte[] dma16WriteToMem() {
                return null;
            }
        }
        Cascade16Handler cascade16Handler = new Cascade16Handler();
        cascade16Handler.owner = "Cascade";
        this.registerDMAChannel(4, cascade16Handler);
    }
}

