/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.keyboard;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleKeyboard;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleMouse;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleRTC;
import dioscuri.module.keyboard.ScanCodeSets;
import dioscuri.module.keyboard.TheKeyboard;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Keyboard
extends ModuleKeyboard {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard", "pic", "rtc"};
    private ModuleMotherboard motherboard;
    private ModulePIC pic;
    private ModuleRTC rtc;
    private ModuleMouse mouse;
    private TheKeyboard keyboard;
    private ScanCodeSets scanCodeSet;
    private boolean isObserved;
    private boolean debugMode;
    private int irqNumberKeyboard;
    private int irqNumberMouse;
    private boolean pendingIRQ;
    private int updateInterval;
    private static final Logger logger = Logger.getLogger(Keyboard.class.getName());
    private static final int DATA_PORT = 96;
    private static final int STATUS_PORT = 100;
    static int kbdInitialised = 0;
    private static final int KEYBOARD = 0;
    private static final int MOUSE = 1;
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "keyboard";
    public static final String MODULE_NAME = "101-key PS/2 QWERTY keyboard";

    public Keyboard(Emulator emulator) {
        this.emu = emulator;
        this.keyboard = new TheKeyboard();
        this.scanCodeSet = new ScanCodeSets();
        this.isObserved = false;
        this.debugMode = false;
        this.updateInterval = -1;
        this.irqNumberKeyboard = -1;
        this.irqNumberMouse = -1;
        this.pendingIRQ = false;
        this.keyboard.internalBuffer.ledStatus = 0;
        this.keyboard.internalBuffer.scanningEnabled = 1;
        this.keyboard.controller.parityError = 0;
        this.keyboard.controller.timeOut = 0;
        this.keyboard.controller.auxBuffer = 0;
        this.keyboard.controller.keyboardLock = 1;
        this.keyboard.controller.commandData = 1;
        this.keyboard.controller.systemFlag = 0;
        this.keyboard.controller.inputBuffer = 0;
        this.keyboard.controller.outputBuffer = 0;
        this.keyboard.controller.kbdClockEnabled = 1;
        this.keyboard.controller.auxClockEnabled = 0;
        this.keyboard.controller.allowIRQ1 = 1;
        this.keyboard.controller.allowIRQ12 = 1;
        this.keyboard.controller.kbdOutputBuffer = 0;
        this.keyboard.controller.auxOutputBuffer = 0;
        this.keyboard.controller.lastCommand = 0;
        this.keyboard.controller.expectingPort60h = 0;
        this.keyboard.controller.irq1Requested = 0;
        this.keyboard.controller.irq12Requested = 0;
        this.keyboard.controller.batInProgress = 0;
        this.keyboard.controller.timerPending = 0;
        logger.log(Level.INFO, "[keyboard] Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("pic")) {
            this.pic = (ModulePIC)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("rtc")) {
            this.rtc = (ModuleRTC)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("mouse")) {
            this.mouse = (ModuleMouse)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null && this.pic != null && this.rtc != null;
    }

    @Override
    public boolean reset() {
        this.motherboard.setIOPort(96, this);
        this.motherboard.setIOPort(100, this);
        this.irqNumberKeyboard = this.pic.requestIRQNumber(this);
        if (this.irqNumberKeyboard > -1) {
            logger.log(Level.CONFIG, "[keyboard] Keyboard IRQ number set to: " + this.irqNumberKeyboard);
        } else {
            logger.log(Level.WARNING, "[keyboard] Request of IRQ number failed.");
        }
        if (this.mouse != null) {
            this.irqNumberMouse = this.pic.requestIRQNumber(this.mouse);
            if (this.irqNumberMouse > -1) {
                logger.log(Level.CONFIG, "[keyboard] Mouse IRQ number set to: " + this.irqNumberMouse);
            } else {
                logger.log(Level.WARNING, "[keyboard] Request of IRQ number failed.");
            }
        } else {
            logger.log(Level.CONFIG, "[keyboard] No mouse available (or not connected to keyboard controller)");
        }
        if (!this.motherboard.requestTimer(this, this.updateInterval, true)) {
            return false;
        }
        this.motherboard.setTimerActiveState(this, true);
        this.rtc.setCMOSRegister(20, (byte)(this.rtc.getCMOSRegister(20) | 4));
        return this.resetKeyboardBuffer(1);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "Keyboard status:\n";
        string = string + "Internal buffer contents:";
        string = string + this.keyboard.internalBuffer.buffer.toString() + "\n";
        string = string + "Controller queue contents:";
        string = string + this.keyboard.controllerQueue + "\n";
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 200;
        this.motherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        int n = this.poll();
        if ((n & 1) == 1) {
            this.setInterrupt(this.irqNumberKeyboard);
            logger.log(Level.CONFIG, "[keyboard] timer raises IRQ1");
        }
        if ((n & 2) == 2) {
            this.setInterrupt(this.irqNumberMouse);
            logger.log(Level.CONFIG, "[keyboard] timer raises IRQ12");
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleUnknownPort, ModuleWriteOnlyPortException {
        switch (n) {
            case 96: {
                if (this.keyboard.controller.auxBuffer != 0) {
                    byte by = this.keyboard.controller.auxOutputBuffer;
                    this.keyboard.controller.auxOutputBuffer = 0;
                    this.keyboard.controller.outputBuffer = 0;
                    this.keyboard.controller.auxBuffer = 0;
                    this.keyboard.controller.irq12Requested = 0;
                    if (!this.keyboard.controllerQueue.isEmpty()) {
                        this.keyboard.controller.auxOutputBuffer = this.keyboard.controllerQueue.remove(0);
                        this.keyboard.controller.outputBuffer = 1;
                        this.keyboard.controller.auxBuffer = 1;
                        if (this.keyboard.controller.allowIRQ12 != 0) {
                            this.keyboard.controller.irq12Requested = 1;
                        }
                        logger.log(Level.CONFIG, "controller_Qsize: " + this.keyboard.controllerQueue.size() + 1);
                    }
                    this.clearInterrupt(this.irqNumberMouse);
                    this.activateTimer();
                    logger.log(Level.CONFIG, "[keyboard] (mouse) Port 0x" + Integer.toHexString(n).toUpperCase() + " read: " + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase() + "h");
                    return by;
                }
                if (this.keyboard.controller.outputBuffer != 0) {
                    byte by = this.keyboard.controller.kbdOutputBuffer;
                    this.keyboard.controller.outputBuffer = 0;
                    this.keyboard.controller.auxBuffer = 0;
                    this.keyboard.controller.irq1Requested = 0;
                    this.keyboard.controller.batInProgress = 0;
                    if (!this.keyboard.controllerQueue.isEmpty()) {
                        this.keyboard.controller.auxOutputBuffer = this.keyboard.controllerQueue.remove(0);
                        this.keyboard.controller.outputBuffer = 1;
                        this.keyboard.controller.auxBuffer = 1;
                        if (this.keyboard.controller.allowIRQ1 != 0) {
                            this.keyboard.controller.irq1Requested = 1;
                        }
                    }
                    this.clearInterrupt(this.irqNumberKeyboard);
                    this.activateTimer();
                    logger.log(Level.CONFIG, "[keyboard] (keyboard) Port 0x" + Integer.toHexString(n).toUpperCase() + " read: " + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase() + "h");
                    return by;
                }
                logger.log(Level.INFO, "[keyboard] Internal buffer elements no.: " + this.keyboard.internalBuffer.buffer.size());
                logger.log(Level.WARNING, "[keyboard] Port 0x60 read but output buffer empty!");
                return this.keyboard.controller.kbdOutputBuffer;
            }
            case 100: {
                byte by = (byte)(this.keyboard.controller.parityError << 7 | this.keyboard.controller.timeOut << 6 | this.keyboard.controller.auxBuffer << 5 | this.keyboard.controller.keyboardLock << 4 | this.keyboard.controller.commandData << 3 | this.keyboard.controller.systemFlag << 2 | this.keyboard.controller.inputBuffer << 1 | this.keyboard.controller.outputBuffer);
                this.keyboard.controller.timeOut = 0;
                return by;
            }
        }
        throw new ModuleUnknownPort("keyboard does not recognise port 0x" + Integer.toHexString(n).toUpperCase());
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleUnknownPort {
        logger.log(Level.CONFIG, "[keyboard] Port 0x" + Integer.toHexString(n).toUpperCase() + " received write of 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
        switch (n) {
            case 96: {
                if (this.keyboard.controller.expectingPort60h != 0) {
                    this.keyboard.controller.expectingPort60h = 0;
                    this.keyboard.controller.commandData = 0;
                    if (this.keyboard.controller.inputBuffer != 0) {
                        logger.log(Level.WARNING, "[keyboard] Port 0x60 write but input buffer is not ready");
                    }
                    switch (this.keyboard.controller.lastCommand) {
                        case 96: {
                            this.keyboard.controller.translateScancode = (byte)(by >> 6 & 1);
                            byte by2 = (byte)(by >> 5 & 1);
                            byte by3 = (byte)(by >> 4 & 1);
                            this.keyboard.controller.systemFlag = (byte)(by >> 2 & 1);
                            this.keyboard.controller.allowIRQ12 = (byte)(by >> 1 & 1);
                            this.keyboard.controller.allowIRQ1 = (byte)(by >> 0 & 1);
                            this.setKeyboardClock(by3 == 0);
                            this.setAuxClock(by2 == 0);
                            if (this.keyboard.controller.allowIRQ12 != 0 && this.keyboard.controller.auxBuffer != 0) {
                                this.keyboard.controller.irq12Requested = 1;
                                logger.log(Level.INFO, "[keyboard] IRQ12 (mouse) allowance set to " + this.keyboard.controller.allowIRQ12);
                            } else if (this.keyboard.controller.allowIRQ1 != 0 && this.keyboard.controller.outputBuffer != 0) {
                                this.keyboard.controller.irq1Requested = 1;
                                logger.log(Level.INFO, "[keyboard] IRQ1 (keyboard) allowance set to " + this.keyboard.controller.allowIRQ1);
                            }
                            if (this.keyboard.controller.translateScancode == 0) {
                                logger.log(Level.WARNING, "[keyboard] Scancode translation turned off");
                            }
                            return;
                        }
                        case -47: {
                            logger.log(Level.INFO, "[keyboard] Writing value 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase() + " to output port P2");
                            this.motherboard.setA20((by & 2) != 0);
                            logger.log(Level.INFO, "[keyboard]" + ((by & 2) == 2 ? "En" : "Dis") + "abled A20 gate");
                            if ((by & 1) == 0) {
                                logger.log(Level.WARNING, "[keyboard] System reset requested (is not implemented yet)");
                            }
                            return;
                        }
                        case -46: {
                            this.enqueueControllerBuffer(by, 0);
                            return;
                        }
                        case -45: {
                            this.enqueueControllerBuffer(by, 1);
                            return;
                        }
                        case -44: {
                            this.mouse.controlMouse(by);
                            return;
                        }
                    }
                    logger.log(Level.WARNING, "[keyboard] does not recognise command [" + Integer.toHexString(this.keyboard.controller.lastCommand).toUpperCase() + "] writing value " + Integer.toHexString(by).toUpperCase() + " to port " + Integer.toHexString(n).toUpperCase());
                    throw new ModuleUnknownPort("keyboard -> does not recognise command " + this.keyboard.controller.lastCommand + " writing value " + Integer.toHexString(by).toUpperCase() + " to port " + Integer.toHexString(n).toUpperCase());
                }
                this.keyboard.controller.commandData = 0;
                this.keyboard.controller.expectingPort60h = 0;
                if (this.keyboard.controller.kbdClockEnabled == 0) {
                    this.setKeyboardClock(true);
                }
                this.dataPortToInternalKB(by);
                return;
            }
            case 100: {
                this.keyboard.controller.commandData = 1;
                this.keyboard.controller.lastCommand = by;
                this.keyboard.controller.expectingPort60h = 0;
                switch (by) {
                    case 32: {
                        logger.log(Level.INFO, "[keyboard]Read keyboard controller command byte");
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        byte by4 = (byte)(this.keyboard.controller.translateScancode << 6 | (this.keyboard.controller.auxClockEnabled == 0 ? 1 : 0) << 5 | (this.keyboard.controller.kbdClockEnabled == 0 ? 1 : 0) << 4 | 0 | this.keyboard.controller.systemFlag << 2 | this.keyboard.controller.allowIRQ12 << 1 | this.keyboard.controller.allowIRQ1 << 0);
                        this.enqueueControllerBuffer(by4, 0);
                        return;
                    }
                    case 96: {
                        logger.log(Level.INFO, "[keyboard] Write keyboard controller command byte");
                        this.keyboard.controller.expectingPort60h = 1;
                        return;
                    }
                    case -96: {
                        logger.log(Level.INFO, "[keyboard]Unsupported command on port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                        return;
                    }
                    case -95: {
                        logger.log(Level.INFO, "[keyboard] Controller firmware version request: ignored");
                        return;
                    }
                    case -89: {
                        this.setAuxClock(false);
                        logger.log(Level.INFO, "[keyboard] Aux device (mouse) disabled");
                        return;
                    }
                    case -88: {
                        this.setAuxClock(true);
                        logger.log(Level.INFO, "[keyboard] Aux device (mouse) enabled");
                        return;
                    }
                    case -87: {
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        this.enqueueControllerBuffer((byte)-1, 0);
                        return;
                    }
                    case -86: {
                        logger.log(Level.INFO, "[keyboard] Controller self test");
                        if (kbdInitialised == 0) {
                            this.keyboard.controllerQueue.clear();
                            this.keyboard.controller.outputBuffer = 0;
                            ++kbdInitialised;
                        }
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        this.keyboard.controller.systemFlag = 1;
                        this.enqueueControllerBuffer((byte)85, 0);
                        return;
                    }
                    case -85: {
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        this.enqueueControllerBuffer((byte)0, 0);
                        return;
                    }
                    case -83: {
                        logger.log(Level.INFO, "[keyboard] Keyboard disabled");
                        this.setKeyboardClock(false);
                        return;
                    }
                    case -82: {
                        logger.log(Level.INFO, "[keyboard] Keyboard enabled");
                        this.setKeyboardClock(true);
                        return;
                    }
                    case -81: {
                        logger.log(Level.WARNING, "[keyboard]Unsupported command on port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                        return;
                    }
                    case -64: {
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        this.enqueueControllerBuffer((byte)-128, 0);
                        return;
                    }
                    case -63: 
                    case -62: {
                        logger.log(Level.WARNING, "[keyboard]Unsupported command on port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                        return;
                    }
                    case -48: {
                        logger.log(Level.INFO, "[keyboard]Partially supported command on port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                        if (this.keyboard.controller.outputBuffer != 0) {
                            logger.log(Level.WARNING, "[keyboard] command 0x" + Integer.toHexString(by).toUpperCase() + " encountered but output buffer not empty!");
                            return;
                        }
                        byte by5 = (byte)(this.keyboard.controller.irq12Requested << 5 | this.keyboard.controller.irq1Requested << 4 | (this.motherboard.getA20() ? 1 : 0) | 1);
                        this.enqueueControllerBuffer(by5, 0);
                        return;
                    }
                    case -47: {
                        logger.log(Level.INFO, "[keyboard] Port 0x64: write output port P2");
                        this.keyboard.controller.expectingPort60h = 1;
                        return;
                    }
                    case -46: {
                        logger.log(Level.INFO, "[keyboard] Port 0x64: write keyboard output buffer");
                        this.keyboard.controller.expectingPort60h = 1;
                        return;
                    }
                    case -45: {
                        logger.log(Level.INFO, "[keyboard] Port 0x64: write mouse output buffer");
                        this.keyboard.controller.expectingPort60h = 1;
                        return;
                    }
                    case -44: {
                        logger.log(Level.INFO, "[keyboard] Port 0x64: write to mouse");
                        this.keyboard.controller.expectingPort60h = 1;
                        return;
                    }
                    case -35: {
                        logger.log(Level.INFO, "[keyboard] Port 0xDD: A20 address line disabled");
                        this.motherboard.setA20(false);
                        return;
                    }
                    case -33: {
                        logger.log(Level.INFO, "[keyboard] Port 0xDF: A20 address line enabled");
                        this.motherboard.setA20(true);
                        return;
                    }
                    case -32: {
                        logger.log(Level.WARNING, "[keyboard] Unsupported command to port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                        return;
                    }
                    case -2: {
                        logger.log(Level.WARNING, "[keyboard] Port 0x64: system reset (not implemented yet)");
                        return;
                    }
                }
                if (by >= 240 && by <= 253 || by == 255) {
                    logger.log(Level.INFO, "[keyboard] Port 0x64: pulse output bits");
                    return;
                }
                logger.log(Level.WARNING, "[keyboard] Unsupported command to port 0x64: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
                return;
            }
        }
        throw new ModuleUnknownPort("[keyboard] does not recognise OUT port 0x" + Integer.toHexString(n).toUpperCase());
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[keyboard] IN command (word) to port 0x" + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[keyboard] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[keyboard] OUT command (word) to port 0x" + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[keyboard] IN command (double word) to port 0x" + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[keyboard] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[keyboard] OUT command (double word) to port 0x" + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    protected void setInterrupt(int n) {
        this.pic.setIRQ(n);
        this.pendingIRQ = true;
    }

    protected void clearInterrupt(int n) {
        this.pic.clearIRQ(n);
        if (this.pendingIRQ) {
            this.pendingIRQ = false;
        }
    }

    @Override
    public void generateScancode(KeyEvent keyEvent, int n) {
        logger.log(Level.INFO, "[keyboard] generateScancode(): " + keyEvent.getKeyCode() + (n == 1 ? " pressed" : " released"));
        if (this.keyboard.controller.kbdClockEnabled == 0 || this.keyboard.internalBuffer.scanningEnabled == 0) {
            return;
        }
        if (!this.scanCodeSet.keyIsPresent(this.keyboard.controller.currentScancodeSet, keyEvent.getKeyCode(), n)) {
            logger.log(Level.INFO, "[keyboard] ignoring illegal keystroke.");
            return;
        }
        String[] stringArray = this.scanCodeSet.scancodes[this.keyboard.controller.currentScancodeSet][keyEvent.getKeyCode()][n].split(" ");
        if (!stringArray[0].equalsIgnoreCase("")) {
            if ((keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 16) && keyEvent.getKeyLocation() == 2) {
                this.scanCodeSet.scancodes[this.keyboard.controller.currentScancodeSet][keyEvent.getKeyCode() - 3][n].split(" ");
            }
            if (keyEvent.getKeyCode() == 10 && keyEvent.getKeyLocation() == 4) {
                this.scanCodeSet.scancodes[this.keyboard.controller.currentScancodeSet][keyEvent.getKeyCode() + 1][n].split(" ");
            }
            if (this.keyboard.controller.translateScancode != 0) {
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n3 = Integer.parseInt(stringArray[i], 16);
                    if (n3 == 240) {
                        n2 = 128;
                        continue;
                    }
                    logger.log(Level.INFO, "[keyboard] generateScancode(): Translated scancode to " + (this.scanCodeSet.translate8042[n3] | n2));
                    this.enqueueInternalBuffer((byte)(this.scanCodeSet.translate8042[n3] | n2));
                    n2 = 0;
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    logger.log(Level.INFO, "[keyboard] generateScancode(): Writing raw " + stringArray[i]);
                    this.enqueueInternalBuffer((byte)Integer.parseInt(stringArray[i], 16));
                }
            }
        } else {
            logger.log(Level.WARNING, "[keyboard] Key not recognised (scancode not found).");
        }
    }

    private boolean resetKeyboardBuffer(int n) {
        this.keyboard.internalBuffer.buffer.clear();
        this.keyboard.internalBuffer.expectingTypematic = 0;
        this.keyboard.internalBuffer.expectingScancodeSet = 0;
        this.keyboard.controller.currentScancodeSet = 1;
        this.keyboard.controller.translateScancode = 1;
        if (n != 0) {
            this.keyboard.internalBuffer.expectingLEDWrite = 0;
            this.keyboard.internalBuffer.keyPressDelay = 1;
            this.keyboard.internalBuffer.keyRepeatRate = (byte)11;
        }
        logger.log(Level.INFO, "[keyboard] Module has been reset.");
        return true;
    }

    private void setKeyboardClock(boolean bl) {
        if (!bl) {
            this.keyboard.controller.kbdClockEnabled = 0;
        } else {
            byte by = this.keyboard.controller.kbdClockEnabled;
            this.keyboard.controller.kbdClockEnabled = 1;
            if (by != 0 || this.keyboard.controller.outputBuffer == 0) {
                // empty if block
            }
            this.activateTimer();
        }
        logger.log(Level.CONFIG, "[keyboard] Keyboard clock " + (bl ? "enabled" : "disabled"));
    }

    private void setAuxClock(boolean bl) {
        if (!bl) {
            this.keyboard.controller.auxClockEnabled = 0;
        } else {
            byte by = this.keyboard.controller.auxClockEnabled;
            this.keyboard.controller.auxClockEnabled = 1;
            if (by != 0 || this.keyboard.controller.outputBuffer == 0) {
                // empty if block
            }
            this.activateTimer();
        }
        logger.log(Level.CONFIG, "[keyboard] Aux clock " + (bl ? "enabled" : "disabled"));
    }

    @Override
    public void setTimeOut(byte by) {
        this.keyboard.controller.timeOut = by;
    }

    @Override
    public void enqueueControllerBuffer(byte by, int n) {
        logger.log(Level.INFO, "[keyboard] Queueing 0x" + Integer.toHexString(by).toUpperCase() + " in keyboard controller buffer");
        if (this.keyboard.controller.outputBuffer != 0) {
            if (this.keyboard.controllerQueue.size() >= 5) {
                logger.log(Level.WARNING, "[keyboard] queueKBControllerBuffer(): Keyboard controller is full!");
            }
            this.keyboard.controllerQueue.add(by);
            return;
        }
        if (n == 0) {
            this.keyboard.controller.kbdOutputBuffer = by;
            this.keyboard.controller.outputBuffer = 1;
            this.keyboard.controller.auxBuffer = 0;
            this.keyboard.controller.inputBuffer = 0;
            if (this.keyboard.controller.allowIRQ1 != 0) {
                this.keyboard.controller.irq1Requested = 1;
            }
        } else {
            this.keyboard.controller.auxOutputBuffer = by;
            this.keyboard.controller.outputBuffer = 1;
            this.keyboard.controller.auxBuffer = 1;
            this.keyboard.controller.inputBuffer = 0;
            if (this.keyboard.controller.allowIRQ12 != 0) {
                this.keyboard.controller.irq12Requested = 1;
            }
        }
    }

    private void enqueueInternalBuffer(byte by) {
        logger.log(Level.INFO, "[keyboard] enqueueInternalBuffer: 0x" + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase());
        if (this.keyboard.internalBuffer.buffer.size() >= 16) {
            logger.log(Level.WARNING, "[keyboard]internal keyboard buffer full, ignoring scancode " + by);
        } else {
            logger.log(Level.INFO, "[keyboard] enqueueInternalBuffer: adding scancode " + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase() + "h to internal buffer");
            this.keyboard.internalBuffer.buffer.add(by);
            if (this.keyboard.controller.outputBuffer == 0 && this.keyboard.controller.kbdClockEnabled != 0) {
                this.activateTimer();
                logger.log(Level.INFO, "[keyboard] Timer activated");
                return;
            }
        }
    }

    private void activateTimer() {
        if (this.keyboard.controller.timerPending == 0) {
            this.keyboard.controller.timerPending = 1;
        }
    }

    private int poll() {
        int n = this.keyboard.controller.irq1Requested | this.keyboard.controller.irq12Requested << 1;
        this.keyboard.controller.irq1Requested = 0;
        this.keyboard.controller.irq12Requested = 0;
        if (this.keyboard.controller.timerPending == 0) {
            logger.log(Level.INFO, "[keyboard] no timer raised, do nothing");
            return n;
        }
        this.keyboard.controller.timerPending = 0;
        if (this.keyboard.controller.outputBuffer != 0) {
            logger.log(Level.WARNING, "[keyboard] poll(): output buffer is not empty");
            return n;
        }
        if (!(this.keyboard.internalBuffer.buffer.isEmpty() || this.keyboard.controller.kbdClockEnabled == 0 && this.keyboard.controller.batInProgress == 0)) {
            logger.log(Level.WARNING, "[keyboard] poll(): key in internal buffer waiting" + this.getDump());
            this.keyboard.controller.kbdOutputBuffer = this.keyboard.internalBuffer.buffer.remove(0);
            this.keyboard.controller.outputBuffer = 1;
            if (this.keyboard.controller.allowIRQ1 != 0) {
                this.keyboard.controller.irq1Requested = 1;
            }
        } else if (this.mouse != null) {
            if (this.keyboard.controller.auxClockEnabled == 1 && !this.mouse.isBufferEmpty()) {
                logger.log(Level.WARNING, "[keyboard] poll(): mouse event waiting");
                this.keyboard.controller.auxOutputBuffer = this.mouse.getDataFromBuffer();
                this.keyboard.controller.outputBuffer = 1;
                this.keyboard.controller.auxBuffer = 1;
                if (this.keyboard.controller.allowIRQ12 == 1) {
                    this.keyboard.controller.irq12Requested = 1;
                }
            }
        } else {
            logger.log(Level.WARNING, "[keyboard] poll(): no keys or mouse events waiting");
        }
        return n;
    }

    private void dataPortToInternalKB(byte by) {
        logger.log(Level.CONFIG, "[keyboard] Controller passing byte " + Integer.toHexString(0x100 | by & 0xFF).substring(1).toUpperCase() + "h directly to keyboard");
        if (this.keyboard.internalBuffer.expectingTypematic != 0) {
            this.keyboard.internalBuffer.expectingTypematic = 0;
            this.keyboard.internalBuffer.keyPressDelay = (byte)(by >> 5 & 3);
            switch (this.keyboard.internalBuffer.keyPressDelay) {
                case 0: {
                    logger.log(Level.INFO, "[keyboard] typematic delay (unused) set to 250 ms");
                    break;
                }
                case 1: {
                    logger.log(Level.INFO, "[keyboard] typematic delay (unused) set to 500 ms");
                    break;
                }
                case 2: {
                    logger.log(Level.INFO, "[keyboard] typematic delay (unused) set to 750 ms");
                    break;
                }
                case 3: {
                    logger.log(Level.INFO, "[keyboard] typematic delay (unused) set to 1000 ms");
                }
            }
            this.keyboard.internalBuffer.keyRepeatRate = (byte)(by & 0x1F);
            double d = 1000.0 / ((double)(8 + (by & 7)) * Math.pow(2.0, by >> 3 & 3) * 4.17);
            DecimalFormat decimalFormat = new DecimalFormat("##.#");
            logger.log(Level.INFO, "[keyboard] Repeat rate (unused) set to " + decimalFormat.format(d) + "char. per second");
            this.enqueueInternalBuffer((byte)-6);
            return;
        }
        if (this.keyboard.internalBuffer.expectingLEDWrite != 0) {
            this.keyboard.internalBuffer.expectingLEDWrite = 0;
            this.keyboard.internalBuffer.ledStatus = by;
            logger.log(Level.CONFIG, "[keyboard] Status of LEDs set to " + Integer.toHexString(this.keyboard.internalBuffer.ledStatus));
            switch (by) {
                case 0: {
                    this.emu.statusChanged(5);
                    this.emu.statusChanged(7);
                    this.emu.statusChanged(9);
                    break;
                }
                case 1: {
                    this.emu.statusChanged(5);
                    this.emu.statusChanged(7);
                    this.emu.statusChanged(8);
                    break;
                }
                case 2: {
                    this.emu.statusChanged(4);
                    this.emu.statusChanged(7);
                    this.emu.statusChanged(9);
                    break;
                }
                case 3: {
                    this.emu.statusChanged(4);
                    this.emu.statusChanged(7);
                    this.emu.statusChanged(8);
                    break;
                }
                case 4: {
                    this.emu.statusChanged(5);
                    this.emu.statusChanged(6);
                    this.emu.statusChanged(9);
                    break;
                }
                case 5: {
                    this.emu.statusChanged(5);
                    this.emu.statusChanged(6);
                    this.emu.statusChanged(8);
                    break;
                }
                case 6: {
                    this.emu.statusChanged(4);
                    this.emu.statusChanged(6);
                    this.emu.statusChanged(9);
                    break;
                }
                case 7: {
                    this.emu.statusChanged(4);
                    this.emu.statusChanged(6);
                    this.emu.statusChanged(8);
                    break;
                }
            }
            this.enqueueInternalBuffer((byte)-6);
            return;
        }
        if (this.keyboard.internalBuffer.expectingScancodeSet != 0) {
            this.keyboard.internalBuffer.expectingScancodeSet = 0;
            if (by != 0) {
                if (by < 4) {
                    this.keyboard.controller.currentScancodeSet = (byte)(by - 1);
                    logger.log(Level.INFO, "[keyboard] Switching to scancode set " + Integer.toHexString(this.keyboard.controller.currentScancodeSet + 1));
                    this.enqueueInternalBuffer((byte)-6);
                } else {
                    logger.log(Level.WARNING, "[keyboard] Scancode set number out of range: " + Integer.toHexString(by).toUpperCase());
                    this.enqueueInternalBuffer((byte)-1);
                }
            } else {
                this.enqueueInternalBuffer((byte)-6);
                this.enqueueInternalBuffer((byte)(1 + this.keyboard.controller.currentScancodeSet));
            }
            return;
        }
        switch (by) {
            case 0: {
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case 5: {
                this.keyboard.controller.systemFlag = 1;
                this.enqueueInternalBuffer((byte)-2);
                break;
            }
            case -45: {
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case -19: {
                this.keyboard.internalBuffer.expectingLEDWrite = 1;
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case -18: {
                this.enqueueInternalBuffer((byte)-18);
                break;
            }
            case -16: {
                this.keyboard.internalBuffer.expectingScancodeSet = 1;
                logger.log(Level.INFO, "[keyboard] Expecting scancode set information");
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case -14: {
                logger.log(Level.INFO, "[keyboard] Read Keyboard ID command received");
                this.enqueueInternalBuffer((byte)-6);
                this.enqueueInternalBuffer((byte)-85);
                if (this.keyboard.controller.translateScancode != 0) {
                    this.enqueueInternalBuffer((byte)65);
                    break;
                }
                this.enqueueInternalBuffer((byte)-125);
                break;
            }
            case -13: {
                this.keyboard.internalBuffer.expectingTypematic = 1;
                logger.log(Level.INFO, "[keyboard] Expecting Typematic Rate/Delay information");
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case -12: {
                this.keyboard.internalBuffer.scanningEnabled = 1;
                this.enqueueInternalBuffer((byte)-6);
                break;
            }
            case -11: {
                this.resetKeyboardBuffer(1);
                this.enqueueInternalBuffer((byte)-6);
                this.keyboard.internalBuffer.scanningEnabled = 0;
                logger.log(Level.CONFIG, "[keyboard] Reset w/ Disable command received");
                break;
            }
            case -10: {
                this.resetKeyboardBuffer(1);
                this.enqueueInternalBuffer((byte)-6);
                this.keyboard.internalBuffer.scanningEnabled = 1;
                logger.log(Level.CONFIG, "[keyboard] Reset w Enable command received");
                break;
            }
            case -2: {
                logger.log(Level.WARNING, "[keyboard] Requesting resend: transmission error!!");
                break;
            }
            case -1: {
                logger.log(Level.INFO, "[keyboard] Reset w/ BAT command received");
                this.resetKeyboardBuffer(1);
                this.enqueueInternalBuffer((byte)-6);
                this.keyboard.controller.batInProgress = 1;
                this.enqueueInternalBuffer((byte)-86);
                break;
            }
            default: {
                logger.log(Level.INFO, "[keyboard] dataPortToInternalKB(): got value of " + by);
                this.enqueueInternalBuffer((byte)-2);
            }
        }
    }
}

