/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.motherboard;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleMotherboard;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceDummy
extends ModuleDevice {
    private boolean isObserved;
    private boolean debugMode;
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard"};
    private ModuleMotherboard motherboard;
    private static final Logger logger = Logger.getLogger(DeviceDummy.class.getName());
    public static final int MODULE_ID = 5000;
    public static final String MODULE_TYPE = "dummy device";
    public static final String MODULE_NAME = "Dummy Device";

    public DeviceDummy(Emulator emulator) {
        this.emu = emulator;
    }

    @Override
    public int getID() {
        return 5000;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null;
    }

    @Override
    public boolean reset() {
        for (int i = 0; i < this.motherboard.ioSpaceSize; ++i) {
            this.motherboard.setIOPort(i, this);
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        return null;
    }

    @Override
    public int getUpdateInterval() {
        return -1;
    }

    @Override
    public void setUpdateInterval(int n) {
    }

    @Override
    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        if (n == 146) {
            logger.log(Level.CONFIG, "[dummy device] IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[dummy device] Returned A20 value: " + Boolean.toString(this.motherboard.getA20()));
            return (byte)(this.motherboard.getA20() ? 2 : 0);
        }
        logger.log(Level.CONFIG, "[dummy device] IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.INFO, "[dummy device] Returned default value 0xFF to AL");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        if (n == 146) {
            logger.log(Level.CONFIG, "[dummy device] OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[dummy device] Set A20 value: " + by);
            this.motherboard.setA20((by & 2) == 2);
            return;
        }
        logger.log(Level.WARNING, "[dummy device] OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        if (n == 146) {
            byte[] byArray;
            logger.log(Level.CONFIG, "[dummy device] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[dummy device] Returned A20 value");
            if (this.motherboard.getA20()) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 0;
                byArray = byArray2;
                byArray2[1] = 2;
            } else {
                byte[] byArray3 = new byte[2];
                byArray3[0] = 0;
                byArray = byArray3;
                byArray3[1] = 0;
            }
            return byArray;
        }
        logger.log(Level.WARNING, "[dummy device] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[dummy device] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        if (n == 146) {
            logger.log(Level.CONFIG, "[dummy device] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
            logger.log(Level.INFO, "[dummy device] Set A20 value");
            this.motherboard.setA20((byArray[1] & 2) == 2);
            return;
        }
        logger.log(Level.WARNING, "[dummy device] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[dummy device] IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[dummy device] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[dummy device] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }
}

