/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.motherboard;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleClock;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.motherboard.Devices;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Motherboard
extends ModuleMotherboard {
    private Emulator emu;
    private String[] moduleConnections;
    private ModuleCPU cpu;
    private ModuleMemory memory;
    private Devices devices;
    private ModuleClock clock;
    private boolean isObserved;
    private boolean debugMode;
    private boolean A20Enabled;
    protected int ioSpaceSize;
    public ModuleDevice[] ioAddressSpace;
    private static final Logger logger = Logger.getLogger(Motherboard.class.getPackage().getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "motherboard";
    public static final String MODULE_NAME = "General x86 motherboard";
    public static final int IOSPACE_ISA_SIZE = 1024;
    public static final int IOSPACE_EISA_SIZE = 65536;
    public static final int SYSTEM_CONTROL_PORT_A = 146;

    public Motherboard(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        this.ioSpaceSize = 65536;
        this.devices = new Devices(20);
        this.clock = null;
        this.ioAddressSpace = new ModuleDevice[this.ioSpaceSize];
        this.moduleConnections = !this.emu.isCpu32bit() ? new String[]{"cpu", "memory"} : new String[0];
        logger.log(Level.INFO, "[motherboard]General x86 motherboard -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (!this.emu.isCpu32bit()) {
            if (module.getType().equalsIgnoreCase("memory")) {
                this.memory = (ModuleMemory)module;
                return true;
            }
            if (module.getType().equalsIgnoreCase("cpu")) {
                this.cpu = (ModuleCPU)module;
                return true;
            }
        }
        try {
            this.devices.addDevice((ModuleDevice)module);
            return true;
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.WARNING, "[motherboard] Failed to establish connection.");
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        if (!this.emu.isCpu32bit()) {
            return this.memory != null && this.cpu != null;
        }
        return true;
    }

    @Override
    public boolean reset() {
        this.A20Enabled = true;
        logger.log(Level.INFO, "[motherboard]  Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "Dump of I/O address space:" + string2;
        for (int i = 0; i < 1024; ++i) {
            if (this.ioAddressSpace[i] == null || this.ioAddressSpace[i].getType().equalsIgnoreCase("dummy")) continue;
            string = string + "0x" + Integer.toHexString(0x10000 | i & 0xFFFF).substring(1).toUpperCase() + string3 + ": " + this.ioAddressSpace[i].getName() + " (" + this.ioAddressSpace[i].getType() + ")" + string2;
        }
        return string;
    }

    @Override
    public boolean registerClock(ModuleClock moduleClock) {
        this.clock = moduleClock;
        return true;
    }

    @Override
    public boolean requestTimer(ModuleDevice moduleDevice, int n, boolean bl) {
        if (this.clock != null) {
            return this.clock.registerDevice(moduleDevice, n, bl);
        }
        return false;
    }

    @Override
    public boolean setTimerActiveState(ModuleDevice moduleDevice, boolean bl) {
        if (this.clock != null) {
            return this.clock.setTimerActiveState(moduleDevice, bl);
        }
        return false;
    }

    @Override
    public boolean resetTimer(ModuleDevice moduleDevice, int n) {
        if (this.clock != null) {
            return this.clock.resetTimer(moduleDevice, n);
        }
        return false;
    }

    @Override
    public boolean setIOPort(int n, ModuleDevice moduleDevice) {
        if (this.ioAddressSpace[n] == null) {
            this.ioAddressSpace[n] = moduleDevice;
            return true;
        }
        logger.log(Level.WARNING, "[motherboard]  I/O address space: Registration for " + moduleDevice.getType() + " failed. I/O port address already registered by " + this.ioAddressSpace[n].getType());
        return false;
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortByte(n);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.WARNING, "[motherboard] Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (ModuleWriteOnlyPortException moduleWriteOnlyPortException) {
                logger.log(Level.WARNING, "[motherboard] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.INFO, "[motherboard] Requested I/O port 0x" + Integer.toHexString(n) + " (getByte) is not in use.");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        if (n == 1024 || n == 1025) {
            logger.log(Level.SEVERE, "[motherboard] Problem occurred in ROM BIOS at line: " + by);
            return;
        }
        if (n == 1026 || n == 1027) {
            try {
                logger.log(Level.WARNING, "[motherboard] I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): " + new String(new byte[]{by}, "US-ASCII"));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "[motherboard] I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): " + new String(new byte[]{by}));
            }
            return;
        }
        if (n == 35072) {
            logger.log(Level.WARNING, "[motherboard] I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): attempting to shutdown.");
            return;
        }
        if (this.ioAddressSpace[n] != null) {
            try {
                this.ioAddressSpace[n].setIOPortByte(n, by);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.INFO, "[motherboard]  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        } else {
            logger.log(Level.INFO, "[motherboard]  Requested I/O port (0x" + Integer.toHexString(n).toUpperCase() + ", setByte) is not available/registered.");
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortWord(n);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.WARNING, "[motherboard] Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (ModuleWriteOnlyPortException moduleWriteOnlyPortException) {
                logger.log(Level.WARNING, "[motherboard] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.WARNING, "[motherboard] Requested I/O port 0x" + Integer.toHexString(n) + " (getWord) is not in use.");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null) {
            try {
                this.ioAddressSpace[n].setIOPortWord(n, byArray);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.WARNING, "[motherboard]  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        }
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null && this.ioAddressSpace[n + 2] != null && this.ioAddressSpace[n + 3] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortDoubleWord(n);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.WARNING, "[motherboard]  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (ModuleWriteOnlyPortException moduleWriteOnlyPortException) {
                logger.log(Level.WARNING, "[motherboard] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.WARNING, "[motherboard] Requested I/O port 0x" + Integer.toHexString(n) + " (getDoubleWord) is not in use.");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null && this.ioAddressSpace[n + 2] != null && this.ioAddressSpace[n + 3] != null) {
            try {
                this.ioAddressSpace[n].setIOPortDoubleWord(n, byArray);
            }
            catch (ModuleUnknownPort moduleUnknownPort) {
                logger.log(Level.WARNING, "[motherboard]  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        }
    }

    @Override
    public boolean getA20() {
        return this.A20Enabled;
    }

    @Override
    public void setA20(boolean bl) {
        this.A20Enabled = bl;
        if (this.emu.isCpu32bit()) {
            logger.log(Level.WARNING, "[motherboard] Attempting to set memory A20 line in 32-bit mode (unsupported)");
        } else {
            this.memory.setA20AddressLine(bl);
        }
    }

    @Override
    public long getCurrentInstructionNumber() {
        if (this.emu.isCpu32bit()) {
            logger.log(Level.WARNING, "[motherboard]Attempting to get CPU instruction number in 32-bit mode (unsupported)");
            return 1L;
        }
        return this.cpu.getCurrentInstructionNumber();
    }
}

