/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.mouse;

import dioscuri.Emulator;
import dioscuri.interfaces.UART;
import dioscuri.module.Module;
import dioscuri.module.ModuleKeyboard;
import dioscuri.module.ModuleMouse;
import dioscuri.module.ModuleSerialPort;
import dioscuri.module.mouse.MouseBuffer;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mouse
extends ModuleMouse
implements UART {
    private static final Logger logger = Logger.getLogger(Mouse.class.getName());
    private Emulator emu;
    private String[] moduleConnections = new String[]{"keyboard", "serialport"};
    private ModuleKeyboard keyboard;
    private ModuleSerialPort serialPort;
    private MouseBuffer buffer;
    private boolean isObserved;
    private boolean debugMode;
    private boolean mouseEnabled;
    private int mouseType;
    private int mouseMode;
    private int mousePreviousMode;
    private byte lastMouseCommand;
    private boolean expectingMouseParameter;
    private int imRequest;
    private boolean imMode;
    private byte sampleRate;
    private int resolutionCpmm;
    private int scaling;
    private int previousX;
    private int previousY;
    private int delayed_dx = 0;
    private int delayed_dy = 0;
    private int delayed_dz = 0;
    private byte buttonStatus;
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "mouse";
    public static final String MODULE_NAME = "Serial mouse";
    private static final int MOUSE_TYPE_PS2 = 1;
    private static final int MOUSE_TYPE_IMPS2 = 2;
    private static final int MOUSE_TYPE_SERIAL = 3;
    private static final int MOUSE_TYPE_SERIAL_WHEEL = 4;
    private static final int MOUSE_MODE_WRAP = 1;
    private static final int MOUSE_MODE_STREAM = 2;
    private static final int MOUSE_MODE_REMOTE = 3;
    private static final int MOUSE_MODE_RESET = 4;
    private static final byte MOUSE_CMD_ACK = -6;
    private static final byte MOUSE_CMD_COMPLETION = -86;
    private static final byte MOUSE_CMD_ID = 0;
    private static final byte MOUSE_CMD_RESEND = -2;
    private static final int MOUSE_BUFFER_SIZE = 16;

    public Mouse(Emulator emulator) {
        this.emu = emulator;
        this.buffer = new MouseBuffer(16);
        this.isObserved = false;
        this.debugMode = false;
        logger.log(Level.INFO, "[mouse] Serial mouse -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("keyboard")) {
            this.keyboard = (ModuleKeyboard)module;
            this.keyboard.setConnection(this);
            return true;
        }
        if (module.getType().equalsIgnoreCase("serialport")) {
            this.serialPort = (ModuleSerialPort)module;
            this.serialPort.setConnection(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.keyboard != null && this.serialPort != null;
    }

    @Override
    public boolean reset() {
        this.lastMouseCommand = 0;
        this.previousX = -1;
        this.previousY = -1;
        logger.log(Level.INFO, "[mouse] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "Mouse status:\n";
        return string;
    }

    @Override
    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    @Override
    public void setMouseType(String string) {
        logger.log(Level.INFO, "[mouse] Trying to setting mouse type to '" + string + "'");
        if (string.equalsIgnoreCase("serial")) {
            this.mouseType = 3;
            logger.log(Level.INFO, "[mouse] Mouse type set to serial");
            if (this.serialPort.setUARTDevice(this, 0)) {
                logger.log(Level.INFO, "[mouse] Mouse connected to COM port 1");
            } else {
                logger.log(Level.SEVERE, "[mouse] Could not connect mouse to COM port 1");
            }
        } else if (string.equalsIgnoreCase("ps/2")) {
            this.mouseType = 1;
            logger.log(Level.INFO, "[mouse] Mouse type set to PS/2");
        } else {
            logger.log(Level.WARNING, "[mouse] Mouse type not recognised: set to default (serial)");
            this.mouseType = 3;
        }
    }

    @Override
    public boolean isBufferEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public synchronized void storeBufferData(boolean bl) {
        byte by;
        byte by2;
        int n = this.delayed_dx;
        int n2 = this.delayed_dy;
        if (!bl && n == 0 && n2 == 0) {
            return;
        }
        if (n > 254) {
            n = 254;
        }
        if (n < -254) {
            n = -254;
        }
        if (n2 > 254) {
            n2 = 254;
        }
        if (n2 < -254) {
            n2 = -254;
        }
        byte by3 = (byte)(this.buttonStatus & 0xF | 8);
        if (n >= 0 && n <= 255) {
            by2 = (byte)n;
            this.delayed_dx -= n;
        } else if (n > 255) {
            by2 = -1;
            this.delayed_dx -= 255;
        } else if (n >= -256) {
            by2 = (byte)n;
            by3 = (byte)(by3 | 0x10);
            this.delayed_dx -= n;
        } else {
            by2 = 0;
            by3 = (byte)(by3 | 0x10);
            this.delayed_dx += 256;
        }
        if (n2 >= 0 && n2 <= 255) {
            by = (byte)n2;
            this.delayed_dy -= n2;
        } else if (n2 > 255) {
            by = -1;
            this.delayed_dy -= 255;
        } else if (n2 >= -256) {
            by = (byte)n2;
            by3 = (byte)(by3 | 0x20);
            this.delayed_dy -= n2;
        } else {
            by = 0;
            by3 = (byte)(by3 | 0x20);
            this.delayed_dy += 256;
        }
        byte by4 = (byte)(-this.delayed_dz);
        this.enqueueData(by3, by2, by, by4);
        logger.log(Level.CONFIG, "[mouse] Mouse (PS/2) data stored in mouse buffer. Total bytes in buffer: " + this.buffer.size());
    }

    @Override
    public synchronized byte getDataFromBuffer() {
        if (!this.buffer.isEmpty()) {
            return this.buffer.getByte();
        }
        return -1;
    }

    @Override
    public void controlMouse(byte by) {
        boolean bl = false;
        if (this.mouseType == 1 || this.mouseType == 2) {
            bl = true;
        }
        logger.log(Level.CONFIG, "[mouse] kbd_ctrl_to_mouse " + by);
        if (this.expectingMouseParameter) {
            this.expectingMouseParameter = false;
            switch (this.lastMouseCommand) {
                case -13: {
                    this.sampleRate = by;
                    logger.log(Level.CONFIG, "[mouse] Sampling rate set to " + by);
                    if (by == 200 && this.imRequest == 0) {
                        this.imRequest = 1;
                    } else if (by == 100 && this.imRequest == 1) {
                        this.imRequest = 2;
                    } else if (by == 80 && this.imRequest == 2) {
                        if (this.mouseType == 2) {
                            logger.log(Level.INFO, "[mouse] Wheel mouse mode enabled");
                            this.imMode = true;
                        } else {
                            logger.log(Level.INFO, "[mouse] Wheel mouse mode request rejected");
                        }
                        this.imRequest = 0;
                    } else {
                        this.imRequest = 0;
                    }
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    break;
                }
                case -24: {
                    switch (by) {
                        case 0: {
                            this.resolutionCpmm = 1;
                            break;
                        }
                        case 1: {
                            this.resolutionCpmm = 2;
                            break;
                        }
                        case 2: {
                            this.resolutionCpmm = 4;
                            break;
                        }
                        case 3: {
                            this.resolutionCpmm = 8;
                            break;
                        }
                        default: {
                            logger.log(Level.WARNING, "[mouse] Unknown resolution");
                        }
                    }
                    logger.log(Level.CONFIG, "[mouse] Resolution set to " + this.resolutionCpmm + " counts per mm");
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "[mouse] unknown last command " + this.lastMouseCommand);
                    break;
                }
            }
        } else {
            this.expectingMouseParameter = false;
            this.lastMouseCommand = by;
            if (this.mouseMode == 1 && by != 255 && by != 236) {
                logger.log(Level.CONFIG, "[mouse] Wrap mode: ignoring command " + by);
                this.keyboard.enqueueControllerBuffer(by, 1);
                return;
            }
            switch (by) {
                case -69: {
                    logger.log(Level.WARNING, "[mouse] Ignoring command 0xBB");
                    break;
                }
                case -26: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.scaling = 2;
                    logger.log(Level.CONFIG, "[mouse] Scaling set to 1:1");
                    break;
                }
                case -25: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.scaling = 2;
                    logger.log(Level.CONFIG, "[mouse] Scaling set to 2:1");
                    break;
                }
                case -24: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.expectingMouseParameter = true;
                    break;
                }
                case -23: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.keyboard.enqueueControllerBuffer(this.getStatusByte(), 1);
                    this.keyboard.enqueueControllerBuffer(this.getResolutionByte(), 1);
                    this.keyboard.enqueueControllerBuffer(this.sampleRate, 1);
                    logger.log(Level.CONFIG, "[mouse] Mouse information returned");
                    break;
                }
                case -22: {
                    this.mouseMode = 2;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Stream mode on");
                    break;
                }
                case -21: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.enqueueData((byte)(this.buttonStatus & 0xF | 8), (byte)0, (byte)0, (byte)0);
                    logger.log(Level.WARNING, "[mouse] Read Data command partially supported");
                    break;
                }
                case -20: {
                    if (this.mouseMode != 1) break;
                    this.mouseMode = this.mousePreviousMode;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Wrap mode off. Set to previous mode");
                    break;
                }
                case -18: {
                    this.mousePreviousMode = this.mouseMode;
                    this.mouseMode = 1;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Wrap mode on");
                    break;
                }
                case -16: {
                    this.mouseMode = 3;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Remote mode on");
                    break;
                }
                case -14: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    if (this.imMode) {
                        this.keyboard.enqueueControllerBuffer((byte)3, 1);
                    } else {
                        this.keyboard.enqueueControllerBuffer((byte)0, 1);
                    }
                    logger.log(Level.CONFIG, "[mouse] Read mouse ID");
                    break;
                }
                case -13: {
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.expectingMouseParameter = true;
                    break;
                }
                case -12: {
                    if (bl) {
                        this.mouseEnabled = true;
                        this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                        logger.log(Level.CONFIG, "[mouse] Mouse enabled (stream mode)");
                        break;
                    }
                    this.keyboard.enqueueControllerBuffer((byte)-2, 1);
                    this.keyboard.setTimeOut((byte)1);
                    break;
                }
                case -11: {
                    this.mouseEnabled = false;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Mouse disabled (stream mode)");
                    break;
                }
                case -10: {
                    this.sampleRate = (byte)100;
                    this.resolutionCpmm = 4;
                    this.scaling = 1;
                    this.mouseEnabled = false;
                    this.mouseMode = 2;
                    this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[mouse] Mouse set to default settings");
                    break;
                }
                case -1: {
                    if (bl) {
                        this.sampleRate = (byte)100;
                        this.resolutionCpmm = 4;
                        this.scaling = 1;
                        this.mouseEnabled = false;
                        this.mouseMode = 4;
                        if (this.imMode) {
                            logger.log(Level.CONFIG, "[mouse] Wheel mouse mode disabled");
                        }
                        this.imMode = false;
                        this.keyboard.enqueueControllerBuffer((byte)-6, 1);
                        this.keyboard.enqueueControllerBuffer((byte)-86, 1);
                        this.keyboard.enqueueControllerBuffer((byte)0, 1);
                        logger.log(Level.CONFIG, "[mouse] Mouse has been reset");
                        break;
                    }
                    this.keyboard.enqueueControllerBuffer((byte)-2, 1);
                    this.keyboard.setTimeOut((byte)1);
                    break;
                }
                default: {
                    if (!bl) break;
                    logger.log(Level.WARNING, "[mouse] kbd_ctrl_to_mouse(): no command match");
                    this.keyboard.enqueueControllerBuffer((byte)-2, 1);
                }
            }
        }
    }

    @Override
    public void mouseMotion(MouseEvent mouseEvent) {
        if (this.previousX == -1) {
            this.previousX = mouseEvent.getX();
            this.previousY = mouseEvent.getY();
            return;
        }
        int n = mouseEvent.getX() - this.previousX;
        int n2 = mouseEvent.getY() - this.previousY;
        int n3 = 0;
        int n4 = mouseEvent.getButton() == 3 ? 1 : 0;
        int n5 = mouseEvent.getButton() == 1 ? 1 : 0;
        this.previousX = mouseEvent.getX();
        this.previousY = mouseEvent.getY();
        if (this.mouseType == 3 || this.mouseType == 4) {
            if (n < -1 || n > 1) {
                n /= 2;
            }
            if (n2 < -1 || n2 > 1) {
                n2 /= 2;
            }
            if (n > 127) {
                n = 127;
            }
            if (n2 > 127) {
                n2 = 127;
            }
            if (n < -128) {
                n = -128;
            }
            if (n2 < -128) {
                n2 = -128;
            }
            byte by = (byte)(0x40 | (((byte)n & 0xC0) >> 6 | ((byte)n2 & 0xC0) >> 4) | (n5 & 1) << 5 | (n4 & 1) << 4);
            byte by2 = (byte)(n & 0x3F);
            byte by3 = (byte)(n2 & 0x3F);
            boolean bl = false;
            this.buffer.setByte(by);
            this.buffer.setByte(by2);
            this.buffer.setByte(by3);
            logger.log(Level.INFO, "[mouse] Mouse movement! dX=" + n + ", dY=" + n2 + ", dZ=" + n3 + ", buttonLeft=" + n5);
            logger.log(Level.INFO, "[mouse] Mouse (serial) data stored in mouse buffer. Total bytes in buffer: " + this.buffer.size());
        }
    }

    private byte getStatusByte() {
        byte by = (byte)(this.mouseMode == 3 ? 64 : 0);
        by = (byte)(by | (this.mouseEnabled ? 1 : 0) << 5);
        by = (byte)(by | (this.scaling == 1 ? 0 : 16));
        by = (byte)(by | (this.buttonStatus & 1) << 2);
        by = (byte)(by | (this.buttonStatus & 2) << 0);
        return by;
    }

    private byte getResolutionByte() {
        byte by = 0;
        switch (this.resolutionCpmm) {
            case 1: {
                by = 0;
                break;
            }
            case 2: {
                by = 1;
                break;
            }
            case 4: {
                by = 2;
                break;
            }
            case 8: {
                by = 3;
                break;
            }
            default: {
                logger.log(Level.WARNING, "[mouse] Invalid resolution cpmm");
            }
        }
        return by;
    }

    private void enqueueData(byte by, byte by2, byte by3, byte by4) {
        if (this.imMode) {
            this.buffer.setByte(by);
            this.buffer.setByte(by2);
            this.buffer.setByte(by3);
            this.buffer.setByte(by4);
        } else {
            this.buffer.setByte(by);
            this.buffer.setByte(by2);
            this.buffer.setByte(by3);
        }
    }

    @Override
    public synchronized boolean isDataAvailable() {
        return !this.buffer.isEmpty();
    }

    @Override
    public synchronized byte getSerialData() {
        if (!this.buffer.isEmpty()) {
            return this.buffer.getByte();
        }
        return -1;
    }

    @Override
    public synchronized void setSerialData(byte by) {
        this.buffer.setByte(by);
    }
}

