/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.parallelport;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleParallelPort;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelPort
extends ModuleParallelPort {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard"};
    private ModuleMotherboard motherboard;
    private boolean isObserved;
    private boolean debugMode;
    private static final Logger logger = Logger.getLogger(ParallelPort.class.getName());
    private static final int DATA_PORT = 888;
    private static final int STATUS_PORT = 889;
    private static final int CONTROL_PORT = 890;
    private static final int DATA_PORT2 = 632;
    private static final int STATUS_PORT2 = 633;
    private static final int CONTROL_PORT2 = 634;
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "parallelport";
    public static final String MODULE_NAME = "25-pin IEEE 1284 parallel port";

    public ParallelPort(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        logger.log(Level.INFO, "[parallelport] 25-pin IEEE 1284 parallel port -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null;
    }

    @Override
    public boolean reset() {
        this.motherboard.setIOPort(888, this);
        this.motherboard.setIOPort(889, this);
        this.motherboard.setIOPort(890, this);
        this.motherboard.setIOPort(632, this);
        this.motherboard.setIOPort(633, this);
        this.motherboard.setIOPort(634, this);
        logger.log(Level.INFO, "[parallelport] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "Parallel port status:\n";
        string = string + "This module is only a stub, no contents available\n";
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return -1;
    }

    @Override
    public void setUpdateInterval(int n) {
    }

    @Override
    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleUnknownPort, ModuleWriteOnlyPortException {
        logger.log(Level.CONFIG, "[parallelport] IO read from " + n);
        switch (n) {
            case 888: {
                logger.log(Level.INFO, "[parallelport] returning default value 'available'");
                return -86;
            }
            case 632: {
                logger.log(Level.INFO, "[parallelport] returning default value 'not available'");
                return -1;
            }
            case 633: 
            case 889: {
                logger.log(Level.INFO, "[parallelport] returning default value 0x58");
                return 88;
            }
            case 890: {
                logger.log(Level.INFO, "[parallelport] returning default value 'available'");
                return 12;
            }
            case 634: {
                logger.log(Level.INFO, "[parallelport] returning default value 'not available'");
                return -1;
            }
        }
        throw new ModuleUnknownPort("[parallelport] Unknown I/O port requested");
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleUnknownPort {
        logger.log(Level.CONFIG, "[parallelport] IO write to " + n + " = " + by);
        switch (n) {
            case 888: {
                logger.log(Level.INFO, "[parallelport] OUT on port " + Integer.toHexString(888).toUpperCase() + " received, not handled");
                return;
            }
            case 632: {
                logger.log(Level.INFO, "[parallelport] OUT on port " + Integer.toHexString(n).toUpperCase() + " received, not handled");
                return;
            }
            case 633: 
            case 889: {
                logger.log(Level.INFO, "[parallelport] OUT on port " + Integer.toHexString(n).toUpperCase() + " received, not handled");
                return;
            }
            case 890: {
                logger.log(Level.INFO, "[parallelport] OUT on port " + Integer.toHexString(890).toUpperCase() + " received, not handled");
                return;
            }
            case 634: {
                logger.log(Level.INFO, "[parallelport] OUT on port " + Integer.toHexString(634).toUpperCase() + " received, not handled");
                return;
            }
        }
        throw new ModuleUnknownPort("[parallelport] Unknown I/O port requested");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleUnknownPort, ModuleWriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException, ModuleUnknownPort {
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleUnknownPort, ModuleWriteOnlyPortException {
        return null;
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException, ModuleUnknownPort {
    }
}

