/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pci;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleDevice;
import dioscuri.module.ModuleMotherboard;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PCI
extends ModuleDevice {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard"};
    private ModuleMotherboard motherboard;
    private boolean isObserved;
    private boolean debugMode;
    private static final Logger logger = Logger.getLogger(PCI.class.getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "pci";
    public static final String MODULE_NAME = "Peripheral Component Interconnect";
    private static final int PORT_PCI1_ADDRESS = 3320;
    private static final int PORT_PCI1_DATA = 3324;

    public PCI(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        logger.log(Level.INFO, "[pci] Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null;
    }

    @Override
    public boolean reset() {
        this.motherboard.setIOPort(3320, this);
        this.motherboard.setIOPort(3321, this);
        this.motherboard.setIOPort(3322, this);
        this.motherboard.setIOPort(3323, this);
        this.motherboard.setIOPort(3324, this);
        this.motherboard.setIOPort(3325, this);
        this.motherboard.setIOPort(3326, this);
        this.motherboard.setIOPort(3327, this);
        logger.log(Level.CONFIG, "[pci] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        return null;
    }

    @Override
    public int getUpdateInterval() {
        return -1;
    }

    @Override
    public void setUpdateInterval(int n) {
    }

    @Override
    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        logger.log(Level.WARNING, "[pci] IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[pci] Returned default value 0xFF");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        logger.log(Level.WARNING, "[pci] OUT command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[pci] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[pci] Returned default value 0xFFFF");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[pci] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[pci] IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[pci] Returned default value 0xFFFFFFFF");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[pci] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }
}

