/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pit;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModulePIT;
import dioscuri.module.pit.Counter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PIT
extends ModulePIT {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard", "pic"};
    protected ModuleMotherboard motherboard;
    protected ModulePIC pic;
    private Counter[] counters;
    private boolean isObserved;
    private boolean debugMode;
    protected int irqNumber;
    private int updateInterval;
    private static final Logger logger = Logger.getLogger(PIT.class.getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "pit";
    public static final String MODULE_NAME = "Intel 8254 Programmable Interval Timer (PIT)";
    private static final int PORT_PIT_COUNTER0 = 64;
    private static final int PORT_PIT_COUNTER1 = 65;
    private static final int PORT_PIT_COUNTER2 = 66;
    private static final int PORT_PIT_CONTROLWORD1 = 67;
    private static final int PORT_PIT_COUNTER3 = 68;
    private static final int PORT_PIT_CONTROLWORD2 = 71;
    private static final int PORT_PIT_EISA = 72;
    private static final int PORT_PIT_TIMER2 = 73;
    private static final int PORT_PIT_EISA_PIT2A = 74;
    private static final int PORT_PIT_EISA_PIT2B = 75;
    private static final int PORT_KB_CTRL_B = 97;

    public PIT(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        this.updateInterval = -1;
        this.counters = new Counter[3];
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new Counter(this, i);
        }
        logger.log(Level.INFO, "[pit] Intel 8254 Programmable Interval Timer (PIT) -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("pic")) {
            this.pic = (ModulePIC)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null && this.pic != null;
    }

    @Override
    public boolean reset() {
        this.motherboard.setIOPort(64, this);
        this.motherboard.setIOPort(65, this);
        this.motherboard.setIOPort(66, this);
        this.motherboard.setIOPort(67, this);
        this.motherboard.setIOPort(68, this);
        this.motherboard.setIOPort(71, this);
        this.motherboard.setIOPort(72, this);
        this.motherboard.setIOPort(73, this);
        this.motherboard.setIOPort(74, this);
        this.motherboard.setIOPort(75, this);
        this.irqNumber = this.pic.requestIRQNumber(this);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, "[pit] IRQ number set to: " + this.irqNumber);
        } else {
            logger.log(Level.WARNING, "[pit] Request of IRQ number failed.");
        }
        if (this.motherboard.requestTimer(this, this.updateInterval, true)) {
            logger.log(Level.CONFIG, "[pit] Timer requested successfully.");
        } else {
            logger.log(Level.WARNING, "[pit] Failed to request a timer.");
        }
        this.motherboard.setTimerActiveState(this, true);
        logger.log(Level.INFO, "[pit] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "PIT dump:" + string2;
        string = string + "Update interval is " + this.updateInterval + " instructions/update." + string2;
        string = string + "In total " + this.counters.length + " counters exist:" + string2;
        for (int i = 0; i < this.counters.length; ++i) {
            if (this.counters[i].isEnabled()) {
                string = string + "Counter " + i + string3 + ": mode " + this.counters[i].counterMode;
                string = string + ", count: start=" + (((this.counters[i].cr[0] & 0xFF) << 8) + (this.counters[i].cr[1] & 0xFF));
                string = string + ", current=" + (((this.counters[i].ce[0] & 0xFF) << 8) + (this.counters[i].ce[1] & 0xFF));
                string = string + ", R/W-mode=" + this.counters[i].rwMode;
                string = string + ", signals: OUT=" + this.counters[i].getGateSignal() + " GATE=" + this.counters[i].getOutSignal();
                string = string + ", parity: " + (this.counters[i].getParity() ? "EVEN" : "ODD");
                string = string + ", bcd: " + (this.counters[i].getBCD() ? "BCD mode" : "Decimal mode") + string2;
                continue;
            }
            string = string + "Counter " + i + string3 + ": mode " + this.counters[i].counterMode + ", not used" + string2;
        }
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 1000;
        this.motherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].clockPulse();
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, ModuleUnknownPort {
        logger.log(Level.INFO, "[pit] I/O read from address 0x" + Integer.toHexString(n));
        byte by = 0;
        switch (n) {
            case 64: {
                by = this.counters[0].getCounterValue();
                break;
            }
            case 65: {
                logger.log(Level.WARNING, "[pit] Attempted read of Counter 1 [0x41]");
                by = this.counters[1].getCounterValue();
                break;
            }
            case 66: {
                by = this.counters[2].getCounterValue();
                break;
            }
            case 67: {
                logger.log(Level.WARNING, "[pit] Attempted read of control word port [0x43]");
                break;
            }
            case 97: {
                logger.log(Level.WARNING, "[pit] Attempted read of KB_CTRL_B [0x61]");
                break;
            }
            default: {
                throw new ModuleUnknownPort("[pit] Unknown I/O port requested");
            }
        }
        return by;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, ModuleUnknownPort {
        logger.log(Level.INFO, "[pit] I/O write to 0x" + Integer.toHexString(n) + " = 0x" + Integer.toHexString(by));
        block0 : switch (n) {
            case 64: {
                logger.log(Level.CONFIG, "[pit] Counter 0: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[0].setCounterValue(by);
                break;
            }
            case 65: {
                logger.log(Level.CONFIG, "[pit] Counter 1: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[1].setCounterValue(by);
                break;
            }
            case 66: {
                logger.log(Level.CONFIG, "[pit] Counter 2: value set to 0x" + Integer.toHexString(by & 0xFF));
                this.counters[2].setCounterValue(by);
                break;
            }
            case 67: {
                int n2 = by & 0xFF;
                int n3 = n2 >> 6;
                int n4 = n2 >> 4 & 3;
                int n5 = n2 >> 1 & 7;
                int n6 = n2 & 1;
                if (n5 > 6 || n4 > 4) {
                    logger.log(Level.SEVERE, "[pit] ControlWord counterMode (" + n5 + ") / rwMode (" + n4 + ") out of range");
                    break;
                }
                if (n3 == 3) {
                    logger.log(Level.WARNING, "[pit] Read-Back Command is not implemented");
                    break;
                }
                switch (n4) {
                    case 0: {
                        logger.log(Level.CONFIG, "[pit] Counter " + n3 + " in latch mode.");
                        this.counters[n3].latchCounter();
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        logger.log(Level.WARNING, "[pit] LSB/MSB command not implemented");
                        break block0;
                    }
                    case 3: {
                        logger.log(Level.CONFIG, "[pit] Counter " + n3 + " in 16-bit mode.");
                        this.counters[n3].setCounterMode(n5);
                        this.counters[n3].rwMode = n4;
                        break block0;
                    }
                }
                logger.log(Level.WARNING, "[pit] rwMode [" + n4 + "] not recognised");
                break;
            }
            default: {
                throw new ModuleUnknownPort("[pit] Unknown I/O port requested");
            }
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[pit] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[pit] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[pit] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[pit] IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[pit] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[pit] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    protected void raiseIRQ(Counter counter) {
        this.pic.setIRQ(this.irqNumber);
    }

    protected void lowerIRQ(Counter counter) {
        this.pic.clearIRQ(this.irqNumber);
    }
}

