/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.screen;

import dioscuri.Emulator;
import dioscuri.module.Module;
import dioscuri.module.ModuleScreen;
import dioscuri.module.ModuleVideo;
import dioscuri.module.screen.CodePage437;
import dioscuri.module.screen.ScreenPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class Screen
extends ModuleScreen {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"video"};
    private ScreenPanel screenPanel;
    protected ModuleVideo video;
    private boolean isObserved;
    private boolean debugMode;
    protected byte[] pixels = null;
    protected DataBuffer dataBuffer = null;
    protected SampleModel sampleModel = null;
    protected WritableRaster raster = null;
    protected byte[][] palette = new byte[3][256];
    protected ColorModel colourModel = null;
    protected BufferedImage image = null;
    protected int imageType;
    protected BufferedImage[] fontImages = new BufferedImage[256];
    protected BufferedImage graphicTile;
    byte[] codePage = new byte[8192];
    boolean codePageReqsUpdate;
    boolean[] codePageUpdateIndex = new boolean[256];
    private int textRows = 25;
    private int textColumns = 90;
    private int fontWidth = 8;
    private int fontHeight = 16;
    private int screenWidth = this.textColumns * this.fontWidth;
    private int screenHeight = this.textRows * this.fontHeight;
    private byte horizPanning = 0;
    private byte vertPanning = 0;
    private short lineCompare = (short)1023;
    private int cursorPosPrevX = 0;
    private int cursorPosPrevY = 0;
    private int xTileSize = 16;
    private int yTileSize = 24;
    private static final Logger logger = Logger.getLogger(Screen.class.getName());
    private static final int MODULE_ID = 1;
    private static final String MODULE_TYPE = "screen";
    private static final String MODULE_NAME = "Compatible CRT/LCD computer screen";
    protected static final int RED = 0;
    protected static final int GREEN = 1;
    protected static final int BLUE = 2;

    public Screen(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        Arrays.fill(this.palette[0], (byte)0);
        Arrays.fill(this.palette[1], (byte)0);
        Arrays.fill(this.palette[2], (byte)0);
        this.colourModel = new IndexColorModel(8, 256, this.palette[0], this.palette[1], this.palette[2]);
        this.createCodePage437Images();
        int[] nArray = new int[this.xTileSize * this.yTileSize * 8];
        this.graphicTile = new BufferedImage(this.xTileSize, this.yTileSize, 13, (IndexColorModel)this.colourModel);
        WritableRaster writableRaster = this.graphicTile.getRaster();
        for (int i = 0; i < this.yTileSize; ++i) {
            for (int j = this.xTileSize - 1; j >= 0; --j) {
                nArray[i * this.xTileSize + Math.abs((int)(j - 7))] = 0;
            }
        }
        writableRaster.setPixels(0, 0, this.fontWidth, this.fontHeight, nArray);
        this.screenPanel = new ScreenPanel();
        logger.log(Level.INFO, "[screen] Compatible CRT/LCD computer screen . Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("video")) {
            this.video = (ModuleVideo)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.video != null;
    }

    @Override
    public boolean reset() {
        this.setScreenSize(this.screenWidth, this.screenHeight);
        logger.log(Level.INFO, "[screen] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        string = "Screen status:" + string2;
        string = string + "Rows: " + this.textRows + "; Columns: " + this.textColumns + string2;
        string = string + "Font width: " + this.fontWidth + "; font height: " + this.fontHeight + string2;
        string = string + "Screen width: " + this.screenWidth + "; screen height: " + this.screenHeight + string2;
        return string;
    }

    @Override
    public JPanel getScreen() {
        return this.screenPanel;
    }

    @Override
    public int getScreenRows() {
        return this.textRows;
    }

    @Override
    public int getScreenColumns() {
        return this.textColumns;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public void setScreenSize(int n, int n2) {
        this.setImage(n, n2);
        this.screenWidth = n;
        this.screenHeight = n2;
        this.screenPanel.setSize(n, n2);
        this.screenPanel.setBackground(Color.black);
        logger.log(Level.INFO, "[screen] Size of screen has been set.");
    }

    @Override
    public void updateScreenSize(int n, int n2, int n3, int n4) {
        logger.log(Level.INFO, "[screen] call to updateScreenSize() w/ fonts");
        if (n4 > 0) {
            this.fontHeight = n4;
            this.fontWidth = n3;
            this.textColumns = n / this.fontWidth;
            this.textRows = n2 / this.fontHeight;
        }
        if (n != this.screenWidth || n2 != this.screenHeight) {
            this.setScreenSize(n, n2);
        }
    }

    @Override
    public void clearScreen() {
        byte[] byArray = new byte[this.image.getWidth() * this.image.getHeight()];
        Arrays.fill(byArray, (byte)0);
        this.dataBuffer = new DataBufferByte(byArray, byArray.length);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, this.image.getWidth(), this.image.getHeight(), 8);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, this.dataBuffer, null);
        this.image.setData(writableRaster);
    }

    @Override
    public boolean setPaletteColour(byte by, int n, int n2, int n3) {
        int n4 = by & 0xFF;
        this.palette[0][n4] = (byte)n;
        this.palette[1][n4] = (byte)n2;
        this.palette[2][n4] = (byte)n3;
        this.updatePalette();
        logger.log(Level.INFO, "[screen] Palette[" + n4 + "] changed to: {" + (byte)n + "," + (byte)n2 + "," + (byte)n3 + "}");
        return true;
    }

    @Override
    public void setByteInCodePage(int n, byte by) {
        this.codePage[n] = by;
        this.codePageUpdateIndex[n >> 5] = true;
        this.codePageReqsUpdate = true;
        logger.log(Level.INFO, "[screen] codePage[" + n + "] = " + by);
    }

    @Override
    public void updateCodePage(int n) {
        System.arraycopy(this.codePage, 0, this.video.getVideoBuffer(), n, 8192);
        Arrays.fill(this.codePageUpdateIndex, true);
        this.codePageReqsUpdate = true;
    }

    @Override
    public void updateText(int n, int n2, long l, long l2, short[] sArray, int n3) {
        logger.log(Level.INFO, String.format("call :: updateText(oldText=%d, newText=%d, cursorXPos=%d, cursorYPos=%d, textModeAttribs=%s, numberRows=%d)", n, n2, l, l2, Arrays.toString(sArray), n3));
        try {
            int n4;
            int n5;
            boolean bl = false;
            short s = sArray[0];
            byte by = (byte)sArray[1];
            byte by2 = (byte)sArray[2];
            short s2 = sArray[3];
            short s3 = sArray[4];
            byte by3 = (byte)sArray[5];
            byte by4 = (byte)sArray[6];
            byte by5 = (byte)sArray[7];
            byte by6 = (byte)sArray[8];
            if (this.codePageReqsUpdate) {
                logger.log(Level.INFO, "[" + this.getType() + "] Character map update. New font height: " + this.fontHeight + "; width: " + this.fontWidth);
                for (int i = 0; i < 256; ++i) {
                    if (!this.codePageUpdateIndex[i]) continue;
                    int[] nArray = new int[16];
                    for (n5 = 0; n5 < 16; ++n5) {
                        nArray[n5] = this.codePage[(i << 5) + n5];
                    }
                    this.updateFontImage(i, nArray, this.fontWidth, this.fontHeight);
                    if (this.fontImages[i] == null) {
                        logger.log(Level.SEVERE, "[" + this.getType() + "] Can't create vga font " + i + " while updating codepage.");
                    }
                    this.codePageUpdateIndex[i] = false;
                }
                bl = true;
                this.codePageReqsUpdate = false;
            }
            if (by3 != this.horizPanning || by4 != this.vertPanning) {
                bl = true;
                this.horizPanning = by3;
                this.vertPanning = by4;
            }
            if (s3 != this.lineCompare) {
                bl = true;
                this.lineCompare = s3;
            }
            if (this.cursorPosPrevY < this.textRows && this.cursorPosPrevX < this.textColumns) {
                n4 = this.cursorPosPrevY * s2 + this.cursorPosPrevX * 2;
                this.video.setTextSnapshot(n + n4, ~this.video.getVideoBufferByte(n2 + n4));
            }
            if (by <= by2 && by < this.fontHeight && l2 < (long)this.textRows && l < (long)this.textColumns) {
                n4 = (int)(l2 * (long)s2 + l * 2L);
                this.video.setTextSnapshot(n + n4, ~this.video.getVideoBufferByte(n2 + n4));
            } else {
                n4 = 65535;
            }
            int n6 = this.textRows;
            if (this.vertPanning != 0) {
                ++n6;
            }
            int n7 = 0;
            int n8 = 0;
            byte by7 = (byte)(n2 - s);
            int n9 = (this.lineCompare + this.vertPanning) / this.fontHeight;
            byte by8 = (byte)((this.lineCompare + this.vertPanning) % this.fontHeight + 1);
            boolean bl2 = false;
            do {
                byte by9;
                byte by10;
                int n10;
                int n11 = this.textColumns;
                if (this.horizPanning != 0) {
                    ++n11;
                }
                if (bl2) {
                    n10 = this.lineCompare + n8 * this.fontHeight + 1;
                    by10 = 0;
                    if (n6 == 1) {
                        by9 = (byte)((this.screenHeight - this.lineCompare - 1) % this.fontHeight);
                        if (by9 == 0) {
                            by9 = (byte)this.fontHeight;
                        }
                    } else {
                        by9 = (byte)this.fontHeight;
                    }
                } else if (this.vertPanning != 0) {
                    if (n7 == 0) {
                        n10 = 0;
                        by10 = this.vertPanning;
                        by9 = (byte)(this.fontHeight - this.vertPanning);
                    } else {
                        n10 = n7 * this.fontHeight - this.vertPanning;
                        by10 = 0;
                        by9 = n6 == 1 ? this.vertPanning : (byte)this.fontHeight;
                    }
                } else {
                    n10 = n7 * this.fontHeight;
                    by10 = 0;
                    by9 = (byte)this.fontHeight;
                }
                if (!bl2 && n7 == n9 && by8 < by9) {
                    by9 = by8;
                }
                int n12 = n2;
                int n13 = n;
                int n14 = 0;
                int n15 = n8 * s2;
                do {
                    byte by11;
                    byte by12;
                    int n16;
                    if (this.horizPanning != 0) {
                        if (n11 > this.textColumns) {
                            n16 = 0;
                            by12 = this.horizPanning;
                            by11 = (byte)(this.fontWidth - this.horizPanning);
                        } else {
                            n16 = n14 * this.fontWidth - this.horizPanning;
                            by12 = 0;
                            by11 = n11 == 1 ? this.horizPanning : (byte)this.fontWidth;
                        }
                    } else {
                        n16 = n14 * this.fontWidth;
                        by12 = 0;
                        by11 = (byte)this.fontWidth;
                    }
                    if (bl || this.video.getTextSnapshot(n) != this.video.getVideoBufferByte(n2) || this.video.getTextSnapshot(n + 1) != this.video.getVideoBufferByte(n2 + 1)) {
                        int n17 = this.video.getVideoBufferByte(n2);
                        byte by13 = this.video.getAttributePaletteRegister(this.video.getVideoBufferByte(n2 + 1) & 0xF);
                        byte by14 = this.video.getAttributePaletteRegister((this.video.getVideoBufferByte(n2 + 1) & 0xF0) >> 4);
                        WritableRaster writableRaster = this.fontImages[n17 &= 0xFF].getData().createCompatibleWritableRaster();
                        for (int i = writableRaster.getMinX(); i < writableRaster.getWidth(); ++i) {
                            block11: for (n5 = writableRaster.getMinY(); n5 < writableRaster.getHeight(); ++n5) {
                                switch (this.fontImages[n17].getData().getSample(i, n5, 0)) {
                                    case 0: {
                                        writableRaster.setSample(i, n5, 0, by14);
                                        continue block11;
                                    }
                                    case 1: {
                                        writableRaster.setSample(i, n5, 0, by13);
                                        continue block11;
                                    }
                                }
                            }
                        }
                        this.image.setData(writableRaster.createTranslatedChild(n16, n10));
                        if (n15 == n4) {
                            byte by15;
                            byte by16;
                            int n18;
                            if (by10 == 0) {
                                n18 = n10 + by;
                                by16 = by;
                                by15 = (byte)(by2 - by + 1);
                                if (n18 + by15 > this.screenHeight) {
                                    by15 = (byte)(this.screenHeight - n18);
                                }
                            } else if (this.vertPanning > by) {
                                n18 = n10;
                                by16 = by10;
                                by15 = (byte)(by2 - this.vertPanning + 1);
                            } else {
                                n18 = n10 + by - this.vertPanning;
                                by16 = by;
                                by15 = (byte)(by2 - by + 1);
                            }
                            if (n18 < this.screenHeight) {
                                WritableRaster writableRaster2 = this.fontImages[n17].getData().createChild(this.image.getMinX(), this.image.getMinY(), by11, by15, n16, n18, null).createCompatibleWritableRaster();
                                for (n5 = writableRaster2.getMinX(); n5 < writableRaster2.getWidth(); ++n5) {
                                    for (int i = writableRaster2.getMinY(); i < writableRaster2.getHeight(); ++i) {
                                        writableRaster2.setSample(n5, i, 0, by13);
                                    }
                                }
                                this.image.setData(writableRaster2.createTranslatedChild(n16, n18));
                            }
                        }
                    }
                    ++n14;
                    n2 += 2;
                    n += 2;
                    n15 += 2;
                } while (--n11 != 0);
                if (!bl2 && n7 == n9) {
                    n2 = by7;
                    bl = true;
                    n8 = 0;
                    if (by6 != 0) {
                        this.horizPanning = 0;
                    }
                    n6 = (this.screenHeight - this.lineCompare + this.fontHeight - 2) / this.fontHeight + 1;
                    bl2 = true;
                    continue;
                }
                ++n7;
                ++n8;
                n2 = n12 + s2;
                n = n13 + s2;
            } while (--n6 != 0);
            this.horizPanning = by3;
            this.cursorPosPrevX = (int)l;
            this.cursorPosPrevY = (int)l2;
            this.screenPanel.repaint();
        }
        catch (RasterFormatException rasterFormatException) {
            logger.log(Level.SEVERE, "RasterFormatException details: " + rasterFormatException.getMessage());
        }
    }

    @Override
    public void updateGraphicsTile(byte[] byArray, int n, int n2) {
        int n3 = n2 + this.yTileSize > this.screenHeight ? this.screenHeight - n2 : this.yTileSize;
        WritableRaster writableRaster = this.graphicTile.getRaster();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.xTileSize; ++j) {
                writableRaster.setSample(j, i, 0, byArray[i * this.xTileSize + j]);
            }
        }
        this.image.setData(writableRaster.createTranslatedChild(n, n2));
        this.screenPanel.repaint();
    }

    private void setImage(int n, int n2) {
        this.pixels = new byte[n * n2];
        Arrays.fill(this.pixels, (byte)0);
        this.dataBuffer = new DataBufferByte(this.pixels, this.pixels.length);
        this.sampleModel = new MultiPixelPackedSampleModel(0, n, n2, 8);
        this.raster = Raster.createWritableRaster(this.sampleModel, this.dataBuffer, null);
        this.image = new BufferedImage(this.colourModel, this.raster, false, null);
        this.screenPanel.setImage(this.image);
    }

    private void updateImage() {
        this.image = new BufferedImage(this.colourModel, this.raster, false, null);
        this.screenPanel.setImage(this.image);
    }

    private void updatePalette() {
        this.colourModel = new IndexColorModel(8, 256, this.palette[0], this.palette[1], this.palette[2]);
        this.updateImage();
    }

    private void createCodePage437Images() {
        int n = 8;
        int n2 = 16;
        for (int i = 0; i < CodePage437.codePageArray.length; ++i) {
            int[] nArray = new int[n * n2];
            this.fontImages[i] = new BufferedImage(n, n2, 12);
            WritableRaster writableRaster = this.fontImages[i].getRaster();
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    nArray[j * n + k] = CodePage437.codePageArray[i][j] >>> k & 1;
                }
            }
            writableRaster.setPixels(0, 0, n, n2, nArray);
            if (this.fontImages[i] != null) continue;
            logger.log(Level.SEVERE, "[screen] Can't create  font [" + i + "]");
        }
    }

    private void updateFontImage(int n, int[] nArray, int n2, int n3) {
        int n4 = 8;
        int[] nArray2 = new int[n2 * n3 * n4];
        this.fontImages[n] = new BufferedImage(n2, n3, 13, (IndexColorModel)this.colourModel);
        WritableRaster writableRaster = this.fontImages[n].getRaster();
        for (int i = 0; i < n3; ++i) {
            for (int j = n4 - 1; j >= 0; --j) {
                nArray2[i * n2 + Math.abs((int)(j - (n4 - 1)))] = nArray[i] >>> j & 1;
            }
        }
        writableRaster.setPixels(0, 0, n2, n3, nArray2);
    }
}

