/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import dioscuri.util.Utilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AtaConfigDialog
extends ConfigurationDialog {
    private JCheckBox enabledCheckBox;
    private JFormattedTextField channelIndexFTextField;
    private JCheckBox masterCheckBox;
    private JCheckBox autodetectCheckBox;
    private JFormattedTextField cylindersFTextField;
    private JFormattedTextField headsFTextField;
    private JFormattedTextField sectorsFTextField;
    private JFormattedTextField updateIntField;
    private JButton imageBrowseButton;
    Emulator emuConfig;

    public AtaConfigDialog(GUI gUI) {
        super(gUI, "ATA Configuration", false, ModuleType.ATA);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Ata.Harddiskdrive harddiskdrive = this.emuConfig.getArchitecture().getModules().getAta().getHarddiskdrive().get(0);
        Integer n = this.emuConfig.getArchitecture().getModules().getAta().getUpdateintervalmicrosecs().intValue();
        boolean bl = harddiskdrive.isEnabled();
        int n2 = harddiskdrive.getChannelindex().intValue();
        boolean bl2 = harddiskdrive.isMaster();
        boolean bl3 = harddiskdrive.isAutodetectcylinders();
        int n3 = harddiskdrive.getCylinders().intValue();
        int n4 = harddiskdrive.getHeads().intValue();
        int n5 = harddiskdrive.getSectorspertrack().intValue();
        String string = Utilities.resolvePathAsString(harddiskdrive.getImagefilepath());
        this.updateIntField.setValue(n);
        this.enabledCheckBox.setSelected(bl);
        this.channelIndexFTextField.setValue(new Integer(n2));
        this.masterCheckBox.setSelected(bl2);
        this.autodetectCheckBox.setSelected(bl3);
        this.cylindersFTextField.setValue(new Integer(n3));
        this.headsFTextField.setValue(new Integer(n4));
        this.sectorsFTextField.setValue(new Integer(n5));
        if (string.length() > 30) {
            this.imageFilePathLabel.setText("..." + string.substring(string.length() - 30));
        } else {
            this.imageFilePathLabel.setText(string);
        }
        this.selectedfile = new File(string);
    }

    @Override
    protected void initMainEntryPanel() {
        JLabel jLabel = new JLabel("Update Interval");
        JLabel jLabel2 = new JLabel("microseconds");
        JLabel jLabel3 = new JLabel("Enabled");
        JLabel jLabel4 = new JLabel("Channel Index");
        JLabel jLabel5 = new JLabel("Master");
        JLabel jLabel6 = new JLabel("Auto Detect");
        JLabel jLabel7 = new JLabel("Cylinders");
        JLabel jLabel8 = new JLabel("Heads");
        JLabel jLabel9 = new JLabel("Sectors");
        JLabel jLabel10 = new JLabel("Image File");
        this.populateControls();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainEntryPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mainEntryPanel.add(jLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.updateIntField, gridBagConstraints);
        this.mainEntryPanel.add(this.updateIntField);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.mainEntryPanel.add(jLabel2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.mainEntryPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.enabledCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.enabledCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.mainEntryPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.channelIndexFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.channelIndexFTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this.mainEntryPanel.add(jLabel5);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.masterCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.masterCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        this.mainEntryPanel.add(jLabel6);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.autodetectCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.autodetectCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        this.mainEntryPanel.add(jLabel7);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cylindersFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.cylindersFTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel8, gridBagConstraints);
        this.mainEntryPanel.add(jLabel8);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.headsFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.headsFTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel9, gridBagConstraints);
        this.mainEntryPanel.add(jLabel9);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.sectorsFTextField, gridBagConstraints);
        this.mainEntryPanel.add(this.sectorsFTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel10, gridBagConstraints);
        this.mainEntryPanel.add(jLabel10);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.imageFilePathLabel, gridBagConstraints);
        this.mainEntryPanel.add(this.imageFilePathLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.imageBrowseButton, gridBagConstraints);
        this.mainEntryPanel.add(this.imageBrowseButton);
    }

    private void populateControls() {
        this.imageFilePathLabel = new JLabel("");
        this.updateIntField = new JFormattedTextField();
        this.updateIntField.setValue(new Integer(0));
        this.updateIntField.setColumns(10);
        this.enabledCheckBox = new JCheckBox();
        this.enabledCheckBox.setSelected(true);
        this.channelIndexFTextField = new JFormattedTextField();
        this.channelIndexFTextField.setValue(new Integer(0));
        this.channelIndexFTextField.setColumns(10);
        this.cylindersFTextField = new JFormattedTextField();
        this.cylindersFTextField.setValue(new Integer(0));
        this.cylindersFTextField.setColumns(10);
        this.headsFTextField = new JFormattedTextField();
        this.headsFTextField.setValue(new Integer(0));
        this.headsFTextField.setColumns(10);
        this.sectorsFTextField = new JFormattedTextField();
        this.sectorsFTextField.setValue(new Integer(0));
        this.sectorsFTextField.setColumns(10);
        this.masterCheckBox = new JCheckBox();
        this.masterCheckBox.setSelected(true);
        this.autodetectCheckBox = new JCheckBox();
        this.imageBrowseButton = new JButton("Browse");
        this.imageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AtaConfigDialog.this.launchFileChooser();
            }
        });
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Ata.Harddiskdrive harddiskdrive = this.emuConfig.getArchitecture().getModules().getAta().getHarddiskdrive().get(0);
        this.emuConfig.getArchitecture().getModules().getAta().setUpdateintervalmicrosecs(BigInteger.valueOf(((Integer)this.updateIntField.getValue()).intValue()));
        harddiskdrive.setEnabled(this.enabledCheckBox.isSelected());
        harddiskdrive.setChannelindex(BigInteger.valueOf(((Integer)this.channelIndexFTextField.getValue()).intValue()));
        harddiskdrive.setMaster(this.masterCheckBox.isSelected());
        harddiskdrive.setAutodetectcylinders(this.autodetectCheckBox.isSelected());
        harddiskdrive.setCylinders(BigInteger.valueOf(((Integer)this.cylindersFTextField.getValue()).intValue()));
        harddiskdrive.setHeads(BigInteger.valueOf(((Integer)this.headsFTextField.getValue()).intValue()));
        harddiskdrive.setSectorspertrack(BigInteger.valueOf(((Integer)this.sectorsFTextField.getValue()).intValue()));
        harddiskdrive.setImagefilepath(this.selectedfile.getAbsoluteFile().toString());
        return this.emuConfig;
    }
}

