/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BootConfigDialog
extends ConfigurationDialog {
    private JComboBox bootDrive1ComboxBox;
    private JComboBox bootDrive2ComboxBox;
    private JComboBox bootDrive3ComboxBox;
    private JCheckBox floppyCheckDisabledCheckBox;
    Emulator emuConfig;

    public BootConfigDialog(GUI gUI) {
        super(gUI, "Boot Configuration", false, ModuleType.BOOT);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Bios.Bootdrives bootdrives = this.emuConfig.getArchitecture().getModules().getBios().get(0).getBootdrives();
        String string = bootdrives.getBootdrive0();
        String string2 = bootdrives.getBootdrive1();
        String string3 = bootdrives.getBootdrive2();
        boolean bl = this.emuConfig.getArchitecture().getModules().getBios().get(0).isFloppycheckdisabled();
        this.bootDrive1ComboxBox.setSelectedItem(string);
        this.bootDrive2ComboxBox.setSelectedItem(string2);
        this.bootDrive3ComboxBox.setSelectedItem(string3);
        this.floppyCheckDisabledCheckBox.setSelected(bl);
    }

    @Override
    protected void initMainEntryPanel() {
        int n;
        JLabel jLabel = new JLabel("  Select Boot Drive 1");
        JLabel jLabel2 = new JLabel("  Select Boot Drive 2");
        JLabel jLabel3 = new JLabel("  Select Boot Drive 3");
        JLabel jLabel4 = new JLabel("  Floppy Check Disabled");
        this.populateControls();
        this.mainEntryPanel = new JPanel(new GridLayout(10, 3));
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        for (n = 0; n < 3; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
        this.mainEntryPanel.add(jLabel);
        this.mainEntryPanel.add(this.bootDrive1ComboxBox);
        this.mainEntryPanel.add(new JLabel(""));
        this.mainEntryPanel.add(jLabel2);
        this.mainEntryPanel.add(this.bootDrive2ComboxBox);
        this.mainEntryPanel.add(new JLabel(""));
        this.mainEntryPanel.add(jLabel3);
        this.mainEntryPanel.add(this.bootDrive3ComboxBox);
        this.mainEntryPanel.add(new JLabel(""));
        this.mainEntryPanel.add(jLabel4);
        this.mainEntryPanel.add(this.floppyCheckDisabledCheckBox);
        this.mainEntryPanel.add(new JLabel(""));
        for (n = 0; n < 15; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
    }

    private void populateControls() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Floppy Drive");
        defaultComboBoxModel.addElement("Hard Drive");
        defaultComboBoxModel.addElement("None");
        this.bootDrive1ComboxBox = new JComboBox(defaultComboBoxModel);
        this.bootDrive1ComboxBox.setSelectedIndex(0);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("Floppy Drive");
        defaultComboBoxModel2.addElement("Hard Drive");
        defaultComboBoxModel2.addElement("None");
        this.bootDrive2ComboxBox = new JComboBox(defaultComboBoxModel2);
        this.bootDrive2ComboxBox.setSelectedIndex(2);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("Floppy Drive");
        defaultComboBoxModel3.addElement("Hard Drive");
        defaultComboBoxModel3.addElement("None");
        this.bootDrive3ComboxBox = new JComboBox(defaultComboBoxModel3);
        this.bootDrive3ComboxBox.setSelectedIndex(2);
        this.floppyCheckDisabledCheckBox = new JCheckBox();
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Bios.Bootdrives bootdrives = this.emuConfig.getArchitecture().getModules().getBios().get(0).getBootdrives();
        bootdrives.setBootdrive0((String)this.bootDrive1ComboxBox.getSelectedItem());
        bootdrives.setBootdrive1((String)this.bootDrive2ComboxBox.getSelectedItem());
        bootdrives.setBootdrive2((String)this.bootDrive3ComboxBox.getSelectedItem());
        this.emuConfig.getArchitecture().getModules().getBios().get(0).setFloppycheckdisabled(this.floppyCheckDisabledCheckBox.isSelected());
        return this.emuConfig;
    }
}

