/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class CpuConfigDialog
extends ConfigurationDialog {
    private JFormattedTextField speedField;
    private JRadioButton cpu32Button;
    private JRadioButton cpu16Button;
    Emulator emuConfig;

    public CpuConfigDialog(GUI gUI) {
        super(gUI, "CPU Configuration", false, ModuleType.CPU);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Cpu cpu = this.emuConfig.getArchitecture().getModules().getCpu();
        Integer n = cpu.getSpeedmhz().intValue();
        this.speedField.setValue(n);
        Boolean bl = cpu.isCpu32Bit();
        if (bl.booleanValue()) {
            this.cpu32Button.setSelected(true);
        } else {
            this.cpu16Button.setSelected(true);
        }
    }

    @Override
    protected void initDoButton() {
        this.doButton = new JButton("Save");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CpuConfigDialog.this.saveParams();
            }
        });
    }

    @Override
    protected void initMainEntryPanel() {
        int n;
        JLabel jLabel = new JLabel("  CPU bits:");
        JLabel jLabel2 = new JLabel("  Speed (MHz)");
        String string = "32-bit";
        String string2 = "16-bit";
        this.cpu32Button = new JRadioButton(string);
        this.cpu16Button = new JRadioButton(string2);
        this.cpu32Button.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.cpu32Button);
        buttonGroup.add(this.cpu16Button);
        this.speedField = new JFormattedTextField();
        this.speedField.setValue(new Integer(0));
        this.speedField.setColumns(10);
        this.mainEntryPanel = new JPanel(new GridLayout(10, 3));
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        this.mainEntryPanel.add(jLabel);
        this.mainEntryPanel.add(this.cpu32Button);
        this.mainEntryPanel.add(this.cpu16Button);
        for (n = 0; n < 3; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
        this.mainEntryPanel.add(jLabel2);
        this.mainEntryPanel.add(this.speedField);
        this.mainEntryPanel.add(new JLabel(""));
        for (n = 0; n < 21; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Cpu cpu = this.emuConfig.getArchitecture().getModules().getCpu();
        cpu.setSpeedmhz(BigDecimal.valueOf(((Number)this.speedField.getValue()).intValue()));
        cpu.setCpu32Bit(this.cpu32Button.isSelected());
        return this.emuConfig;
    }
}

