/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import dioscuri.util.Utilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigInteger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FdcConfigDialog
extends ConfigurationDialog {
    private JCheckBox enabledCheckBox;
    private JCheckBox insertedCheckBox;
    private JComboBox driveLetterComboxBox;
    private JComboBox diskFormatComboBox;
    private JCheckBox writeProtectedCheckBox;
    private JButton imageBrowseButton;
    private JFormattedTextField updateIntField;
    Emulator emuConfig;

    public FdcConfigDialog(GUI gUI) {
        super(gUI, "FDC Configuration", false, ModuleType.FDC);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Fdc.Floppy floppy = this.emuConfig.getArchitecture().getModules().getFdc().getFloppy().get(0);
        Integer n = this.emuConfig.getArchitecture().getModules().getFdc().getUpdateintervalmicrosecs().intValue();
        boolean bl = floppy.isEnabled();
        boolean bl2 = floppy.isInserted();
        String string = floppy.getDriveletter();
        String string2 = floppy.getDiskformat();
        boolean bl3 = floppy.isWriteprotected();
        String string3 = Utilities.resolvePathAsString(floppy.getImagefilepath());
        this.updateIntField.setValue(n);
        this.enabledCheckBox.setSelected(bl);
        this.insertedCheckBox.setSelected(bl2);
        this.driveLetterComboxBox.setSelectedItem(string);
        this.diskFormatComboBox.setSelectedItem(string2);
        this.writeProtectedCheckBox.setSelected(bl3);
        if (string3.length() > 30) {
            this.imageFilePathLabel.setText("..." + string3.substring(string3.length() - 30));
        } else {
            this.imageFilePathLabel.setText(string3);
        }
        this.selectedfile = new File(string3);
    }

    @Override
    protected void initMainEntryPanel() {
        JLabel jLabel = new JLabel("Update Interval");
        JLabel jLabel2 = new JLabel("microseconds");
        JLabel jLabel3 = new JLabel("Enabled");
        JLabel jLabel4 = new JLabel("Inserted");
        JLabel jLabel5 = new JLabel("Drive Letter");
        JLabel jLabel6 = new JLabel("Disk Format");
        JLabel jLabel7 = new JLabel("Write Protected");
        JLabel jLabel8 = new JLabel("Image File");
        this.populateControls();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainEntryPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mainEntryPanel.add(jLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.updateIntField, gridBagConstraints);
        this.mainEntryPanel.add(this.updateIntField);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.mainEntryPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.mainEntryPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.enabledCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.enabledCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.mainEntryPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.insertedCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.insertedCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this.mainEntryPanel.add(jLabel5);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.driveLetterComboxBox, gridBagConstraints);
        this.mainEntryPanel.add(this.driveLetterComboxBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        this.mainEntryPanel.add(jLabel6);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.diskFormatComboBox, gridBagConstraints);
        this.mainEntryPanel.add(this.diskFormatComboBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        this.mainEntryPanel.add(jLabel7);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.writeProtectedCheckBox, gridBagConstraints);
        this.mainEntryPanel.add(this.writeProtectedCheckBox);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel8, gridBagConstraints);
        this.mainEntryPanel.add(jLabel8);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.imageFilePathLabel, gridBagConstraints);
        this.mainEntryPanel.add(this.imageFilePathLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.imageBrowseButton, gridBagConstraints);
        this.mainEntryPanel.add(this.imageBrowseButton);
    }

    private void populateControls() {
        this.imageFilePathLabel = new JLabel("");
        this.updateIntField = new JFormattedTextField();
        this.updateIntField.setValue(new Integer(0));
        this.updateIntField.setColumns(10);
        this.enabledCheckBox = new JCheckBox();
        this.enabledCheckBox.setSelected(true);
        this.insertedCheckBox = new JCheckBox();
        this.insertedCheckBox.setSelected(true);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("A");
        defaultComboBoxModel.addElement("B");
        this.driveLetterComboxBox = new JComboBox(defaultComboBoxModel);
        this.driveLetterComboxBox.setSelectedIndex(0);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("1.2M");
        defaultComboBoxModel2.addElement("1.44M");
        defaultComboBoxModel2.addElement("2.88M");
        defaultComboBoxModel2.addElement("160K");
        defaultComboBoxModel2.addElement("180K");
        defaultComboBoxModel2.addElement("320K");
        defaultComboBoxModel2.addElement("360K");
        defaultComboBoxModel2.addElement("720K");
        this.diskFormatComboBox = new JComboBox(defaultComboBoxModel2);
        this.diskFormatComboBox.setSelectedIndex(1);
        this.writeProtectedCheckBox = new JCheckBox();
        this.imageBrowseButton = new JButton("Browse");
        this.imageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FdcConfigDialog.this.launchFileChooser();
            }
        });
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Fdc.Floppy floppy = this.emuConfig.getArchitecture().getModules().getFdc().getFloppy().get(0);
        this.emuConfig.getArchitecture().getModules().getFdc().setUpdateintervalmicrosecs(BigInteger.valueOf(((Number)this.updateIntField.getValue()).intValue()));
        floppy.setEnabled(this.enabledCheckBox.isSelected());
        floppy.setInserted(this.insertedCheckBox.isSelected());
        floppy.setDriveletter(this.driveLetterComboxBox.getSelectedItem().toString());
        floppy.setDiskformat(this.diskFormatComboBox.getSelectedItem().toString());
        floppy.setWriteprotected(this.writeProtectedCheckBox.isSelected());
        floppy.setImagefilepath(this.selectedfile.getAbsoluteFile().toString());
        return this.emuConfig;
    }
}

