/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MouseConfigDialog
extends ConfigurationDialog {
    private JLabel enabledLabel;
    private JLabel sizeLabel;
    private JCheckBox enabledCheckBox;
    private JComboBox mouseTypeComboxBox;
    Emulator emuConfig;

    public MouseConfigDialog(GUI gUI) {
        super(gUI, "Mouse Configuration", false, ModuleType.MOUSE);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Mouse mouse = this.emuConfig.getArchitecture().getModules().getMouse();
        boolean bl = mouse.isEnabled();
        String string = mouse.getMousetype();
        this.enabledCheckBox.setSelected(bl);
        this.mouseTypeComboxBox.setSelectedItem(string);
    }

    @Override
    protected void initDoButton() {
        this.doButton = new JButton("Save");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MouseConfigDialog.this.saveParams();
            }
        });
    }

    @Override
    protected void initMainEntryPanel() {
        int n;
        this.enabledLabel = new JLabel("Enabled");
        this.sizeLabel = new JLabel("  Type");
        this.enabledCheckBox = new JCheckBox();
        this.enabledCheckBox.setSelected(true);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("ps/2");
        defaultComboBoxModel.addElement("serial");
        this.mouseTypeComboxBox = new JComboBox(defaultComboBoxModel);
        this.mouseTypeComboxBox.setSelectedIndex(0);
        this.mainEntryPanel = new JPanel(new GridLayout(10, 3));
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        this.mainEntryPanel.add(this.enabledLabel);
        this.mainEntryPanel.add(this.enabledCheckBox);
        for (n = 0; n < 1; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
        this.mainEntryPanel.add(this.sizeLabel);
        this.mainEntryPanel.add(this.mouseTypeComboxBox);
        this.mainEntryPanel.add(new JLabel(""));
        for (n = 0; n < 24; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Mouse mouse = this.emuConfig.getArchitecture().getModules().getMouse();
        mouse.setEnabled(this.enabledCheckBox.isSelected());
        mouse.setMousetype((String)this.mouseTypeComboxBox.getSelectedItem());
        return this.emuConfig;
    }
}

