/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.ConfigurationDialog;
import dioscuri.config.Emulator;
import dioscuri.config.ModuleType;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class RamConfigDialog
extends ConfigurationDialog {
    private JFormattedTextField sizeField;
    Emulator emuConfig;

    public RamConfigDialog(GUI gUI) {
        super(gUI, "RAM Configuration", false, ModuleType.MEMORY);
    }

    @Override
    protected void readInParams() {
        this.emuConfig = this.parent.getEmuConfig();
        Emulator.Architecture.Modules.Memory memory = this.emuConfig.getArchitecture().getModules().getMemory();
        Integer n = memory.getSizemb().intValue();
        this.sizeField.setValue(n);
    }

    @Override
    protected void initDoButton() {
        this.doButton = new JButton("Save");
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RamConfigDialog.this.saveParams();
            }
        });
    }

    @Override
    protected void initMainEntryPanel() {
        int n;
        JLabel jLabel = new JLabel("  Size (MB)");
        this.sizeField = new JFormattedTextField();
        this.sizeField.setValue(new Integer(0));
        this.sizeField.setColumns(10);
        this.mainEntryPanel = new JPanel(new GridLayout(10, 3));
        Border border = BorderFactory.createLineBorder(Color.black);
        this.mainEntryPanel.setBorder(border);
        for (n = 0; n < 3; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
        this.mainEntryPanel.add(jLabel);
        this.mainEntryPanel.add(this.sizeField);
        this.mainEntryPanel.add(new JLabel(""));
        for (n = 0; n < 24; ++n) {
            this.mainEntryPanel.add(new JLabel(""));
        }
    }

    @Override
    protected Emulator getParamsFromGui() {
        Emulator.Architecture.Modules.Memory memory = this.emuConfig.getArchitecture().getModules().getMemory();
        memory.setSizemb(BigDecimal.valueOf(((Number)this.sizeField.getValue()).intValue()));
        return this.emuConfig;
    }
}

