/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.bios;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.module.Module;
import dioscuri.module.ModuleBIOS;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BIOS
extends ModuleBIOS {
    private Emulator emu;
    private String[] moduleConnections = new String[0];
    private boolean isObserved;
    private boolean debugMode;
    private byte[] systemROM;
    private byte[] videoROM;
    private byte[] optionalROM;
    private static final Logger logger = Logger.getLogger(BIOS.class.getName());
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "bios";
    public static final String MODULE_NAME = "BIOS ROM";
    private static final int SYSTEMBIOS_ROM_SIZE = 65536;
    private static final int VIDEOBIOS_ROM_SIZE = 32768;

    public BIOS(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        this.systemROM = new byte[65536];
        this.videoROM = new byte[32768];
        Arrays.fill(this.systemROM, (byte)0);
        Arrays.fill(this.videoROM, (byte)0);
        logger.log(Level.INFO, "[bios] BIOS ROM -> Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        return false;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean reset() {
        logger.log(Level.CONFIG, "[bios] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        int n;
        int n2;
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        String string4 = " ";
        string = "System BIOS dump of first 800 bytes as stored in ROM:" + string2;
        for (n2 = 0; n2 < 50; ++n2) {
            string = string + n2 + string3 + ": ";
            for (n = 0; n < 16; ++n) {
                string = string + Integer.toHexString(0x100 | this.systemROM[n2 * 16 + n] & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        string = string + string2;
        string = string + "Video BIOS dump of first 800 bytes as stored in ROM:" + string2;
        for (n2 = 0; n2 < 50; ++n2) {
            string = string + n2 + string3 + ": ";
            for (n = 0; n < 16; ++n) {
                string = string + Integer.toHexString(0x100 | this.videoROM[n2 * 16 + n] & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public byte[] getSystemBIOS() {
        byte[] byArray = new byte[65536];
        for (int i = 0; i < 65536; ++i) {
            byArray[i] = this.systemROM[i];
        }
        return byArray;
    }

    @Override
    public boolean setSystemBIOS(byte[] byArray) throws ModuleException {
        if (byArray.length == 65536) {
            try {
                for (int i = 0; i < 65536; ++i) {
                    this.systemROM[i] = byArray[i];
                }
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(Level.SEVERE, "[bios] System BIOS is larger than 65536 bytes");
                throw new ModuleException("[bios] System BIOS is larger than 65536 bytes");
            }
        }
        throw new ModuleException("[bios] System BIOS is not 65536 bytes");
    }

    @Override
    public byte[] getVideoBIOS() {
        byte[] byArray = new byte[32768];
        for (int i = 0; i < 32768; ++i) {
            byArray[i] = this.videoROM[i];
        }
        return byArray;
    }

    @Override
    public boolean setVideoBIOS(byte[] byArray) throws ModuleException {
        if (byArray.length == 32768) {
            try {
                for (int i = 0; i < 32768; ++i) {
                    this.videoROM[i] = byArray[i];
                }
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(Level.SEVERE, "[bios Video BIOS is larger than 65536 bytes");
                throw new ModuleException("[bios Video BIOS is larger than 65536 bytes");
            }
        }
        throw new ModuleException("[bios Video BIOS is not 65536 bytes");
    }
}

