/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_ESC_FPU
implements Instruction {
    private CPU cpu;
    int opCode = 0;
    int addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    private static final Logger logger = Logger.getLogger(Instruction_ESC_FPU.class.getName());

    public Instruction_ESC_FPU() {
    }

    public Instruction_ESC_FPU(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.opCode = this.cpu.codeByte;
        block0 : switch (this.opCode) {
            case 216: {
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                break;
            }
            case 217: {
                this.addressByte = this.cpu.getByteFromCode() & 0xFF;
                if (this.addressByte < 191) {
                    switch ((this.addressByte & 0x38) >> 3) {
                        case 7: {
                            this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
                            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest((byte)this.addressByte, this.memoryReferenceDisplacement);
                            this.sourceValue = this.cpu.getWordFromMemorySegment((byte)this.addressByte, this.memoryReferenceLocation);
                            break block0;
                        }
                    }
                    logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implemented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                    break;
                }
                switch (this.addressByte) {
                    default: 
                }
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implemented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                break;
            }
            case 218: {
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                break;
            }
            case 219: {
                this.addressByte = this.cpu.getByteFromCode() & 0xFF;
                if (this.addressByte < 191) {
                    switch ((this.addressByte & 0x38) >> 3) {
                        default: 
                    }
                    logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implemented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                    break;
                }
                switch (this.addressByte) {
                    case 227: {
                        break block0;
                    }
                }
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implemented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not properly implented (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
                break;
            }
            default: {
                logger.log(Level.SEVERE, "[" + this.cpu.getType() + "]" + " FPU instruction 0x" + Integer.toHexString(this.opCode) + " not recognised (" + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + ")");
            }
        }
    }
}

