/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_GRP7
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue1 = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] oldValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    int intermediateResult = 0;
    byte[] word0x0001 = new byte[]{0, 1};
    int iCarryFlag = 0;
    byte[] tempResult = new byte[2];
    byte[] temp = new byte[2];
    private static final Logger logger = Logger.getLogger(Instruction_GRP7.class.getName());

    public Instruction_GRP7() {
    }

    public Instruction_GRP7(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[5]);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[4]);
                if (this.cpu.doubleWord) {
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[3]);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[2]);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[1]);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[0]);
                    break;
                }
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[3]);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[2]);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.cpu.gdtr[1]);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, (byte)0);
                break;
            }
            case 1: {
                throw new CPUInstructionException("Group 7 (0x0F01) instruction SIDT not implemented.");
            }
            case 2: {
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.gdtr[5] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.gdtr[4] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                if (this.cpu.doubleWord) {
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.gdtr[3] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.gdtr[2] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.gdtr[1] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                    this.cpu.gdtr[0] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    break;
                }
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.gdtr[3] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.gdtr[2] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                this.cpu.gdtr[1] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                Util.addWords(this.memoryReferenceLocation, this.word0x0001, 0);
                byte by = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.cpu.gdtr[0] = 0;
                break;
            }
            case 3: {
                throw new CPUInstructionException("Group 7 (0x0F01) instruction LIDT not implemented.");
            }
            case 4: {
                byte[] byArray = Util.booleansToBytes(this.cpu.cr0);
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.sourceValue1[0] = byArray[2];
                    this.sourceValue1[1] = byArray[3];
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, byArray[3]);
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, byArray[2]);
                break;
            }
            case 5: {
                throw new CPUInstructionException("Group 7 (0x0701/5) illegal reg bits");
            }
            case 6: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue1 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.cr0[0] = (this.sourceValue1[1] & 1) == 1;
                this.cpu.cr0[1] = (this.sourceValue1[1] & 2) == 2;
                this.cpu.cr0[2] = (this.sourceValue1[1] & 4) == 4;
                boolean bl = this.cpu.cr0[3] = (this.sourceValue1[1] & 6) == 6;
                if (this.cpu.cr0[2]) break;
                logger.log(Level.WARNING, "[" + this.cpu.getType() + "] FPU emulation is turned off.");
                break;
            }
            case 7: {
                throw new CPUInstructionException("Group 7 (0x0F01) instruction INVLPG not implemented.");
            }
            default: {
                throw new CPUInstructionException("Group 7 (0x0F01) instruction no case match.");
            }
        }
    }
}

