/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_INSB_YbDX
implements Instruction {
    private CPU cpu;
    int portAddress;
    byte portByte = 0;
    byte[] transition;
    private static final Logger logger = Logger.getLogger(Instruction_INSB_YbDX.class.getName());

    public Instruction_INSB_YbDX() {
    }

    public Instruction_INSB_YbDX(CPU cPU) {
        this();
        this.cpu = cPU;
        this.transition = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
        try {
            this.portByte = this.cpu.getIOPortByte(this.portAddress);
            this.cpu.setByteToExtra(this.cpu.di, this.portByte);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[" + this.cpu.getType() + "] " + moduleException.getMessage());
        }
        this.cpu.di = this.cpu.flags[10] ? Util.subtractWords(this.cpu.di, this.transition, 0) : Util.addWords(this.cpu.di, this.transition, 0);
    }
}

