/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_INSW_YvDX
implements Instruction {
    private CPU cpu;
    int portAddress;
    byte[] portValue = new byte[2];
    byte[] ePortValue = new byte[4];
    byte[] transition;
    private static final Logger logger = Logger.getLogger(Instruction_INSW_YvDX.class.getName());

    public Instruction_INSW_YvDX() {
    }

    public Instruction_INSW_YvDX(CPU cPU) {
        this();
        this.cpu = cPU;
        this.transition = new byte[]{0, 2};
    }

    @Override
    public void execute() {
        this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
        try {
            if (this.cpu.doubleWord) {
                this.ePortValue = this.cpu.getIOPortDoubleWord(this.portAddress);
                this.cpu.setWordToExtra(this.cpu.di, new byte[]{this.ePortValue[1], this.ePortValue[0]});
                this.cpu.di = this.cpu.flags[10] ? Util.subtractWords(this.cpu.di, this.transition, 0) : Util.addWords(this.cpu.di, this.transition, 0);
                this.cpu.setWordToExtra(this.cpu.di, new byte[]{this.ePortValue[3], this.ePortValue[2]});
            } else {
                this.portValue = this.cpu.getIOPortWord(this.portAddress);
                this.cpu.setWordToExtra(this.cpu.di, this.portValue);
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[" + this.cpu.getType() + "] " + moduleException.getMessage());
        }
        this.cpu.di = this.cpu.flags[10] ? Util.subtractWords(this.cpu.di, this.transition, 0) : Util.addWords(this.cpu.di, this.transition, 0);
    }
}

