/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_OUTSW_DXXv
implements Instruction {
    private CPU cpu;
    int portAddress;
    byte defaultAddressByte = 0;
    byte[] memoryValue = new byte[2];
    byte[] eMemoryValue = new byte[2];
    byte[] transition;
    private static final Logger logger = Logger.getLogger(Instruction_OUTSW_DXXv.class.getName());

    public Instruction_OUTSW_DXXv() {
    }

    public Instruction_OUTSW_DXXv(CPU cPU) {
        this();
        this.cpu = cPU;
        this.transition = new byte[]{0, 2};
    }

    @Override
    public void execute() {
        this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
        try {
            if (this.cpu.doubleWord) {
                this.eMemoryValue = this.cpu.getWordFromMemorySegment(this.defaultAddressByte, this.cpu.si);
                this.memoryValue = this.cpu.getWordFromMemorySegment(this.defaultAddressByte, Util.addWords(this.cpu.si, new byte[]{0, 2}, 0));
                this.cpu.setIOPortDoubleWord(this.portAddress, new byte[]{this.eMemoryValue[1], this.eMemoryValue[0], this.memoryValue[1], this.memoryValue[0]});
                this.cpu.si = this.cpu.flags[10] ? Util.subtractWords(this.cpu.si, this.transition, 0) : Util.addWords(this.cpu.si, this.transition, 0);
            } else {
                this.memoryValue = this.cpu.getWordFromMemorySegment(this.defaultAddressByte, this.cpu.si);
                this.cpu.setIOPortWord(this.portAddress, this.memoryValue);
            }
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[" + this.cpu.getType() + "] " + moduleException.getMessage());
        }
        this.cpu.si = this.cpu.flags[10] ? Util.subtractWords(this.cpu.si, this.transition, 0) : Util.addWords(this.cpu.si, this.transition, 0);
    }
}

