/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_OUTS_DXXb
implements Instruction {
    private CPU cpu;
    int portAddress;
    byte defaultAddressByte = 0;
    byte memoryValue = 0;
    byte[] transition;
    private static final Logger logger = Logger.getLogger(Instruction_OUTS_DXXb.class.getName());

    public Instruction_OUTS_DXXb() {
    }

    public Instruction_OUTS_DXXb(CPU cPU) {
        this();
        this.cpu = cPU;
        this.transition = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
        try {
            this.memoryValue = this.cpu.getByteFromMemorySegment(this.defaultAddressByte, this.cpu.si);
            this.cpu.setIOPortByte(this.portAddress, this.memoryValue);
        }
        catch (ModuleException moduleException) {
            logger.log(Level.WARNING, "[" + this.cpu.getType() + "] " + moduleException.getMessage());
        }
        this.cpu.si = this.cpu.flags[10] ? Util.subtractWords(this.cpu.si, this.transition, 0) : Util.addWords(this.cpu.si, this.transition, 0);
    }
}

