/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_POP_Ev
implements Instruction {
    private CPU cpu;
    private byte addressByte;
    private boolean operandWordSize;
    private byte[] memoryReferenceDisplacement;
    private byte[] offset;

    public Instruction_POP_Ev() {
    }

    public Instruction_POP_Ev(CPU cPU) {
        this();
        this.cpu = cPU;
        this.addressByte = 0;
        this.operandWordSize = true;
        this.memoryReferenceDisplacement = new byte[2];
        this.offset = new byte[2];
    }

    @Override
    public void execute() {
        if (this.cpu.doubleWord) {
            this.addressByte = this.cpu.getByteFromCode();
            System.out.println("POP_Ev: 32-bits not supported");
        } else {
            this.addressByte = this.cpu.getByteFromCode();
            this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
            this.offset = (this.addressByte >> 6 & 3) == 3 ? this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7) : this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.cpu.setWordInMemorySegment(this.addressByte, this.offset, this.cpu.getWordFromStack());
        }
    }
}

