/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.InstructionSource;

public class ArrayBackedInstructionSource
implements InstructionSource {
    private int[] microcodes;
    private int[] positions;
    private int readOffset;
    private int operationLength;
    private int operationEnd;
    private int operationStart;
    private int x86Start;
    private int x86End;

    public ArrayBackedInstructionSource(int[] nArray, int[] nArray2) {
        this.microcodes = nArray;
        this.positions = nArray2;
        this.x86Start = 0;
        this.x86End = 0;
    }

    @Override
    public boolean getNext() {
        if (this.operationEnd >= this.microcodes.length) {
            return false;
        }
        this.readOffset = this.operationEnd++;
        this.operationStart = this.readOffset;
        this.x86Start = this.x86End;
        while (this.operationEnd < this.microcodes.length && this.positions[this.operationEnd] == this.positions[this.operationEnd - 1]) {
            ++this.operationEnd;
        }
        this.x86End = this.positions[this.operationEnd - 1];
        return true;
    }

    @Override
    public int getMicrocode() {
        if (this.readOffset < this.operationEnd) {
            return this.microcodes[this.readOffset++];
        }
        throw new IllegalStateException();
    }

    @Override
    public int getLength() {
        return this.operationEnd - this.operationStart;
    }

    @Override
    public int getX86Length() {
        return this.x86End - this.x86Start;
    }
}

