/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ConstantPoolSymbol;
import dioscuri.module.cpu32.MicrocodeSet;
import dioscuri.module.cpu32.Processor;

public class BytecodeFragments
implements MicrocodeSet {
    public static final Object IMMEDIATE = new Object();
    public static final Object X86LENGTH = new Object();
    private static Object[][] pushCodeArray = new Object[46][];
    private static Object[][] popCodeArray = new Object[39][];

    protected BytecodeFragments() {
    }

    public static Object[] pushCode(int n) {
        Object[] objectArray = pushCodeArray[n];
        if (objectArray == null) {
            throw new IllegalStateException("Non existant CPU Element: " + n);
        }
        return objectArray;
    }

    public static Object[] popCode(int n) {
        Object[] objectArray = popCodeArray[n];
        if (objectArray == null) {
            throw new IllegalStateException("Non existant CPU Element: " + n);
        }
        return objectArray;
    }

    public static Object field(String string) {
        try {
            return new ConstantPoolSymbol(Processor.class.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
    }

    public static Object field(Class clazz, String string) {
        try {
            return new ConstantPoolSymbol(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
    }

    public static Object method(String string) {
        return BytecodeFragments.method(string, new Class[0]);
    }

    public static Object method(String string, Class clazz) {
        return BytecodeFragments.method(string, new Class[]{clazz});
    }

    public static Object method(String string, Class clazz, Class clazz2) {
        return BytecodeFragments.method(string, new Class[]{clazz, clazz2});
    }

    public static Object method(String string, Class[] classArray) {
        try {
            return new ConstantPoolSymbol(Processor.class.getDeclaredMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
    }

    public static Object method(Class clazz, String string) {
        return BytecodeFragments.method(clazz, string, new Class[0]);
    }

    public static Object method(Class clazz, String string, Class clazz2) {
        return BytecodeFragments.method(clazz, string, new Class[]{clazz2});
    }

    public static Object method(Class clazz, String string, Class clazz2, Class clazz3) {
        return BytecodeFragments.method(clazz, string, new Class[]{clazz2, clazz3});
    }

    public static Object method(Class clazz, String string, Class clazz2, Class clazz3, Class clazz4) {
        return BytecodeFragments.method(clazz, string, new Class[]{clazz2, clazz3, clazz4});
    }

    public static Object method(Class clazz, String string, Class[] classArray) {
        try {
            return new ConstantPoolSymbol(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
    }

    public static Object integer(int n) {
        return new ConstantPoolSymbol(new Integer(n));
    }

    public static Object longint(long l) {
        return new ConstantPoolSymbol(new Long(l));
    }

    static {
        BytecodeFragments.pushCodeArray[0] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eax")};
        BytecodeFragments.pushCodeArray[1] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ecx")};
        BytecodeFragments.pushCodeArray[2] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("edx")};
        BytecodeFragments.pushCodeArray[3] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ebx")};
        BytecodeFragments.pushCodeArray[4] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("esp")};
        BytecodeFragments.pushCodeArray[5] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ebp")};
        BytecodeFragments.pushCodeArray[6] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("esi")};
        BytecodeFragments.pushCodeArray[7] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("edi")};
        BytecodeFragments.pushCodeArray[8] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eip")};
        BytecodeFragments.pushCodeArray[9] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getCarryFlag")};
        BytecodeFragments.pushCodeArray[10] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getParityFlag")};
        BytecodeFragments.pushCodeArray[11] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getAuxiliaryCarryFlag")};
        BytecodeFragments.pushCodeArray[12] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getZeroFlag")};
        BytecodeFragments.pushCodeArray[13] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getSignFlag")};
        BytecodeFragments.pushCodeArray[14] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsTrap")};
        BytecodeFragments.pushCodeArray[15] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsInterruptEnable")};
        BytecodeFragments.pushCodeArray[16] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsDirection")};
        BytecodeFragments.pushCodeArray[17] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getOverflowFlag")};
        BytecodeFragments.pushCodeArray[18] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsIOPrivilegeLevel")};
        BytecodeFragments.pushCodeArray[19] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsNestedTask")};
        BytecodeFragments.pushCodeArray[20] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsResume")};
        BytecodeFragments.pushCodeArray[21] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsVirtual8086Mode")};
        BytecodeFragments.pushCodeArray[22] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsAlignmentCheck")};
        BytecodeFragments.pushCodeArray[23] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsVirtualInterrupt")};
        BytecodeFragments.pushCodeArray[24] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsVirtualInterruptPending")};
        BytecodeFragments.pushCodeArray[25] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("eflagsID")};
        BytecodeFragments.pushCodeArray[26] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("es")};
        BytecodeFragments.pushCodeArray[27] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("cs")};
        BytecodeFragments.pushCodeArray[28] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ss")};
        BytecodeFragments.pushCodeArray[29] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ds")};
        BytecodeFragments.pushCodeArray[30] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("fs")};
        BytecodeFragments.pushCodeArray[31] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("gs")};
        BytecodeFragments.pushCodeArray[32] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("idtr")};
        BytecodeFragments.pushCodeArray[33] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("gdtr")};
        BytecodeFragments.pushCodeArray[34] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ldtr")};
        BytecodeFragments.pushCodeArray[35] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("tss")};
        BytecodeFragments.pushCodeArray[36] = new Object[]{new Integer(43), new Integer(182), BytecodeFragments.method("getCPL")};
        BytecodeFragments.pushCodeArray[37] = new Object[]{new Integer(43), new Integer(180), BytecodeFragments.field("ioports")};
        BytecodeFragments.pushCodeArray[38] = new Object[]{new Integer(3)};
        BytecodeFragments.popCodeArray[0] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eax")};
        BytecodeFragments.popCodeArray[1] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ecx")};
        BytecodeFragments.popCodeArray[2] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("edx")};
        BytecodeFragments.popCodeArray[3] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ebx")};
        BytecodeFragments.popCodeArray[4] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("esp")};
        BytecodeFragments.popCodeArray[5] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ebp")};
        BytecodeFragments.popCodeArray[6] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("esi")};
        BytecodeFragments.popCodeArray[7] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("edi")};
        BytecodeFragments.popCodeArray[8] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eip")};
        BytecodeFragments.popCodeArray[9] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setCarryFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[10] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setParityFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[11] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setAuxiliaryCarryFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[12] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setZeroFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[13] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setSignFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[14] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsTrap")};
        BytecodeFragments.popCodeArray[15] = new Object[]{new Integer(89), new Integer(43), new Integer(91), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsInterruptEnable"), new Integer(181), BytecodeFragments.field("eflagsInterruptEnableSoon")};
        BytecodeFragments.popCodeArray[16] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsDirection")};
        BytecodeFragments.popCodeArray[17] = new Object[]{new Integer(43), new Integer(95), new Integer(182), BytecodeFragments.method("setOverflowFlag", Boolean.TYPE)};
        BytecodeFragments.popCodeArray[18] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsIOPrivilegeLevel")};
        BytecodeFragments.popCodeArray[19] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsNestedTask")};
        BytecodeFragments.popCodeArray[20] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsResume")};
        BytecodeFragments.popCodeArray[21] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsVirtual8086Mode")};
        BytecodeFragments.popCodeArray[22] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsAlignmentCheck")};
        BytecodeFragments.popCodeArray[23] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsVirtualInterrupt")};
        BytecodeFragments.popCodeArray[24] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsVirtualInterruptPending")};
        BytecodeFragments.popCodeArray[25] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("eflagsID")};
        BytecodeFragments.popCodeArray[26] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("es")};
        BytecodeFragments.popCodeArray[27] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("cs")};
        BytecodeFragments.popCodeArray[28] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ss")};
        BytecodeFragments.popCodeArray[29] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ds")};
        BytecodeFragments.popCodeArray[30] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("fs")};
        BytecodeFragments.popCodeArray[31] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("gs")};
        BytecodeFragments.popCodeArray[32] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("idtr")};
        BytecodeFragments.popCodeArray[33] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("gdtr")};
        BytecodeFragments.popCodeArray[34] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("ldtr")};
        BytecodeFragments.popCodeArray[35] = new Object[]{new Integer(43), new Integer(95), new Integer(181), BytecodeFragments.field("tss")};
        BytecodeFragments.popCodeArray[38] = new Object[]{new Integer(87)};
    }
}

