/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSourceWrappedMemory;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockFactory;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.SpanningCodeBlock;

public class SpanningProtectedModeCodeBlock
extends SpanningCodeBlock
implements ProtectedModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningProtectedModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        ProtectedModeCodeBlock protectedModeCodeBlock = null;
        LinearAddressSpace linearAddressSpace = processor.linearMemory;
        int n = processor.getInstructionPointer();
        boolean bl = processor.cs.getDefaultSizeFlag();
        for (int i = 0; i < this.factories.length && protectedModeCodeBlock == null; ++i) {
            try {
                this.byteSource.set(linearAddressSpace, n);
                protectedModeCodeBlock = this.factories[i].getProtectedModeCodeBlock(this.byteSource, bl);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return protectedModeCodeBlock;
    }

    @Override
    public String getDisplayString() {
        return "Spanning Protected Mode CodeBlock";
    }
}

