/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.memory;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.module.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleVideo;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Memory
extends ModuleMemory {
    private Emulator emu;
    private String[] moduleConnections = new String[]{"video", "cpu", "motherboard"};
    private ModuleVideo video;
    private ModuleCPU cpu;
    private ModuleMotherboard motherboard;
    private boolean isObserved;
    private boolean debugMode;
    public byte[] ram;
    protected static long A20mask;
    private static final Logger logger;
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "memory";
    public static final String MODULE_NAME = "RAM";
    private static final int BYTES_IN_MB = 0x100000;
    private int ramSize = 0x100000;
    private boolean watchValue;
    private int watchAddress;

    public Memory(Emulator emulator) {
        this.emu = emulator;
        this.isObserved = false;
        this.debugMode = false;
        this.ram = new byte[this.ramSize];
        this.watchValue = false;
        this.watchAddress = -1;
        logger.log(Level.INFO, "[memory] RAM Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("video")) {
            this.video = (ModuleVideo)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("cpu")) {
            this.cpu = (ModuleCPU)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.video != null && this.cpu != null && this.motherboard != null;
    }

    @Override
    public boolean reset() {
        Arrays.fill(this.ram, (byte)0);
        Arrays.fill(this.ram, 786432, this.ram.length, (byte)-1);
        this.setA20AddressLine(true);
        logger.log(Level.INFO, "[memory] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        if (stringArray.length > 1) {
            int n = Integer.parseInt(stringArray[0]);
            byte[] byArray = new byte[stringArray.length - 1];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)this.convertStringToByte(stringArray[i + 1]);
            }
            try {
                this.setBytes(n, byArray);
            }
            catch (ModuleException moduleException) {
                logger.log(Level.SEVERE, "[memory] setData: data not set. " + moduleException.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        String string4 = " ";
        string = "Memory dump of first 3200 bytes as stored in RAM:" + string2;
        for (int i = 0; i < 200; ++i) {
            string = string + i + string3 + ": ";
            for (int j = 0; j < 16; ++j) {
                string = string + Integer.toHexString(0x100 | this.ram[i * 16 + j] & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public byte getByte(int n) {
        n = (int)((long)n & A20mask);
        try {
            if (this.watchValue && n == this.watchAddress) {
                logger.log(Level.CONFIG, "[memory] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched BYTE at address " + this.watchAddress + " is read: [" + Integer.toHexString(this.ram[n]).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                return this.video.readMode(n);
            }
            return this.ram[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[memory] Access outside memory bounds; returning 0xFF");
            return -1;
        }
    }

    @Override
    public void setByte(int n, byte by) {
        n = (int)((long)n & A20mask);
        try {
            if (this.watchValue && n == this.watchAddress) {
                logger.log(Level.CONFIG, "[memory] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched BYTE at address " + this.watchAddress + " is written: [" + Integer.toHexString(by).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                this.video.writeMode(n, by);
            } else {
                if (n >= 786432 && n <= 1048575) {
                    return;
                }
                this.ram[n] = by;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[memory] Out of memory during write byte");
        }
    }

    @Override
    public byte[] getWord(int n) {
        n = (int)((long)n & A20mask);
        try {
            if (this.watchValue && (n == this.watchAddress || n + 1 == this.watchAddress)) {
                logger.log(Level.CONFIG, "[memory] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched WORD at address " + this.watchAddress + " is read: [" + Integer.toHexString(this.ram[n + 1]).toUpperCase() + "] [" + Integer.toHexString(this.ram[n]).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                return new byte[]{this.video.readMode(n + 1), this.video.readMode(n)};
            }
            return new byte[]{this.ram[n + 1], this.ram[n]};
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[memory] Access outside memory bounds; returning 0xFFFF");
            return new byte[]{-1, -1};
        }
    }

    @Override
    public void setWord(int n, byte[] byArray) {
        n = (int)((long)n & A20mask);
        try {
            if (this.watchValue && (n == this.watchAddress || n + 1 == this.watchAddress)) {
                logger.log(Level.CONFIG, "[memory] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched WORD at address " + this.watchAddress + " is written: [" + Integer.toHexString(byArray[0]).toUpperCase() + "][" + Integer.toHexString(byArray[1]).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                this.video.writeMode(n, byArray[1]);
                this.video.writeMode(n + 1, byArray[0]);
            } else {
                if (n >= 786432 && n <= 1048575) {
                    return;
                }
                this.ram[n] = byArray[1];
                this.ram[n + 1] = byArray[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[memory] Out of memory during write word");
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws ModuleException {
        int n2 = byArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                this.ram[n + i] = byArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[memory] Out of memory during write stream of bytes");
            throw new ModuleException("[memory] setBytes: Out of memory at byte " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public void setA20AddressLine(boolean bl) {
        A20mask = bl ? -1L : -1048577L;
        logger.log(Level.CONFIG, "[memory] A20 address line status: " + bl + " A20mask: [0x" + Long.toHexString(A20mask) + "]");
    }

    @Override
    public void setWatchValueAndAddress(boolean bl, int n) {
        this.watchValue = bl;
        this.watchAddress = n;
    }

    @Override
    public void setRamSizeInMB(int n) {
        this.ramSize = n * 0x100000;
        this.ram = new byte[this.ramSize];
        A20mask = -1048577L;
    }

    private int convertStringToByte(String string) {
        try {
            int n = 0;
            for (int i = string.length(); i > 0; --i) {
                n += (int)Math.pow(16.0, string.length() - i) * Integer.parseInt(string.substring(i - 1, i), 16);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.SEVERE, "[memory] Error while parsing input");
            return -1;
        }
    }

    static {
        logger = Logger.getLogger(Memory.class.getName());
    }
}

