/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.rtc;

import java.util.Arrays;
import java.util.Calendar;

public class CMOS {
    protected byte[] ram = new byte[128];
    Calendar calendar;
    private static final int CMOS_SIZE = 128;
    protected static final int RTC_SECONDS = 0;
    protected static final int RTC_SECOND_ALARM = 1;
    protected static final int RTC_MINUTES = 2;
    protected static final int RTC_MINUTE_ALARM = 3;
    protected static final int RTC_HOURS = 4;
    protected static final int RTC_HOUR_ALARM = 5;
    protected static final int RTC_DAYOFWEEK = 6;
    protected static final int RTC_DATEOFMONTH = 7;
    protected static final int RTC_MONTH = 8;
    protected static final int RTC_YEAR = 9;
    protected static final int STATUS_REGISTER_A = 10;
    protected static final int STATUS_REGISTER_B = 11;
    protected static final int STATUS_REGISTER_C = 12;
    protected static final int STATUS_REGISTER_D = 13;
    protected static final int SHUTDOWN_STATUS = 15;
    protected static final int FLOPPYDRIVE_TYPE = 16;
    protected static final int IBM_PS2_HD1_DATA = 17;
    protected static final int IBM_HD_DATA = 18;
    protected static final int IBM_PS2_HD2_DATA = 19;
    protected static final int IBM_EQUIPMENT = 20;
    protected static final int IBM_BASE_MEM_LOW = 21;
    protected static final int IBM_BASE_MEM_HIGH = 22;
    protected static final int IBM_EXTEND_MEM_LOW = 23;
    protected static final int IBM_EXTEND_MEM_HIGH = 24;
    protected static final int IBM_EXTEND_HD1 = 25;
    protected static final int IBM_EXTEND_HD2 = 26;
    protected static final int AWARD_HD1_USERDEF = 45;
    protected static final int CHECKSUM_HIGH_BYTE = 46;
    protected static final int CHECKSUM_LOW_BYTE = 47;
    protected static final int IBM_EXTEND_MEM2_LOW = 48;
    protected static final int IBM_EXTEND_MEM2_HIGH = 49;
    protected static final int IBM_RTC_CENTURY = 50;
    protected static final int AMI_EXTEND_MEM_LOW = 52;
    protected static final int AMI_EXTEND_MEM_HIGH = 53;
    protected static final int IBM_PS2_RTC_CENTURY = 55;
    protected static final int ELTORITO_BOOT = 56;
    protected static final int ATA_POLICY_0_1 = 57;
    protected static final int ATA_POLICY_2_3 = 58;
    protected static final int ELTORITO_BOOT2 = 61;

    public CMOS() {
        Arrays.fill(this.ram, (byte)0);
        this.ram[10] = 38;
        this.ram[11] = 2;
        this.ram[12] = 0;
        this.ram[13] = -128;
        this.calendar = Calendar.getInstance();
    }

    protected void reset(boolean bl) {
        if (!bl) {
            this.calendar.set(1995, 4, 5, 11, 59, 59);
        }
        this.ram[0] = this.decToBcd(this.calendar.get(13));
        this.ram[2] = this.decToBcd(this.calendar.get(12));
        this.ram[4] = this.decToBcd(this.calendar.get(11));
        this.ram[6] = (byte)this.calendar.get(7);
        this.ram[7] = this.decToBcd(this.calendar.get(5));
        this.ram[8] = (byte)(this.decToBcd(this.calendar.get(2)) + 1);
        this.ram[9] = this.decToBcd(this.calendar.get(1));
        this.ram[50] = this.decToBcd(this.calendar.get(1) / 100);
        this.ram[55] = this.ram[50];
        this.ram[11] = (byte)(this.ram[11] & 0x8F);
        this.ram[12] = (byte)(this.ram[12] & 0xF);
        this.checksum();
    }

    private void checksum() {
        int n = 0;
        for (int i = 16; i <= 45; ++i) {
            n += this.ram[i];
        }
        this.ram[47] = (byte)(n & 0xFF);
        this.ram[46] = (byte)(n >> 8 & 0xFF);
    }

    protected byte decToBcd(int n) {
        return (byte)(16 * (n / 10 % 10) + n % 10);
    }

    protected int bcdToDec(byte by) {
        return (by >> 4 & 0xF) * 10 + (by & 0xF);
    }

    protected String getClockValue() {
        return "" + this.bcdToDec(this.ram[4]) + ":" + this.bcdToDec(this.ram[2]) + ":" + this.bcdToDec(this.ram[0]) + " " + this.bcdToDec(this.ram[7]) + "-" + this.bcdToDec(this.ram[8]) + "-" + this.bcdToDec(this.ram[9]);
    }

    protected void setClockValue(int n) {
        this.calendar.add(13, n);
        this.ram[0] = this.decToBcd(this.calendar.get(13));
        this.ram[2] = this.decToBcd(this.calendar.get(12));
        this.ram[4] = this.decToBcd(this.calendar.get(11));
        this.ram[6] = (byte)this.calendar.get(7);
        this.ram[7] = this.decToBcd(this.calendar.get(5));
        this.ram[8] = (byte)(this.decToBcd(this.calendar.get(2)) + 1);
        this.ram[9] = this.decToBcd(this.calendar.get(1));
        this.ram[50] = this.decToBcd(this.calendar.get(1) / 100);
        this.ram[55] = this.ram[50];
    }
}

