/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.rtc;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.ModuleUnknownPort;
import dioscuri.exception.ModuleWriteOnlyPortException;
import dioscuri.module.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleRTC;
import dioscuri.module.rtc.CMOS;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTC
extends ModuleRTC {
    CMOS cmos;
    private Emulator emu;
    private String[] moduleConnections = new String[]{"motherboard", "pic"};
    private ModuleMotherboard motherboard;
    private ModulePIC pic;
    private boolean isObserved;
    private boolean debugMode;
    private boolean systemTime;
    private static final Logger logger = Logger.getLogger(RTC.class.getName());
    private boolean disableNMI;
    private int irqNumber;
    protected int lookupRegister;
    private static final int OUT_PORT = 112;
    private static final int IN_PORT = 113;
    public static final int MODULE_ID = 1;
    public static final String MODULE_TYPE = "rtc";
    public static final String MODULE_NAME = "Real Time Clock (RTC)";

    public RTC(Emulator emulator) {
        this.emu = emulator;
        this.cmos = new CMOS();
        this.isObserved = false;
        this.debugMode = false;
        this.irqNumber = -1;
        this.systemTime = false;
        logger.log(Level.INFO, "[rtc]  Module created successfully.");
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public String getType() {
        return MODULE_TYPE;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String[] getConnection() {
        return this.moduleConnections;
    }

    @Override
    public boolean setConnection(Module module) {
        if (module.getType().equalsIgnoreCase("motherboard")) {
            this.motherboard = (ModuleMotherboard)module;
            return true;
        }
        if (module.getType().equalsIgnoreCase("pic")) {
            this.pic = (ModulePIC)module;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.motherboard != null && this.pic != null;
    }

    @Override
    public boolean reset() {
        this.cmos.reset(this.systemTime);
        if (this.systemTime) {
            logger.log(Level.INFO, "[rtc] CMOS clock set to host machine's values: " + this.cmos.getClockValue());
        } else {
            logger.log(Level.INFO, "[rtc] CMOS clock set to user-defined values: " + this.cmos.getClockValue());
        }
        this.motherboard.setIOPort(112, this);
        this.motherboard.setIOPort(113, this);
        this.lookupRegister = 0;
        this.irqNumber = this.pic.requestIRQNumber(this);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, "[rtc] IRQ number set to: " + this.irqNumber);
        } else {
            logger.log(Level.WARNING, "[rtc] Request of IRQ number failed.");
        }
        logger.log(Level.INFO, "[rtc] Module has been reset.");
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isObserved() {
        return this.isObserved;
    }

    @Override
    public void setObserved(boolean bl) {
        this.isObserved = bl;
    }

    @Override
    public boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public byte[] getData(Module module) {
        return null;
    }

    @Override
    public boolean setData(byte[] byArray, Module module) {
        if (module.getType().equalsIgnoreCase("pit")) {
            logger.log(Level.INFO, "[rtc] Received out signal from PIT.");
        }
        return false;
    }

    @Override
    public boolean setData(String[] stringArray, Module module) {
        return false;
    }

    @Override
    public String getDump() {
        String string = "Dump of RTC/CMOS registers 0x00 - 0x2F and checksum regs:\n";
        string = string + "Reg\tVal(hex)\tVal(BCD)\n";
        DecimalFormat decimalFormat = new DecimalFormat("00");
        for (int i = 0; i <= 47; ++i) {
            string = string + "0x" + Integer.toHexString(0x100 | i & 0xFF).substring(1).toUpperCase();
            string = string + "\t";
            string = string + "[" + Integer.toHexString(0x100 | this.cmos.ram[i] & 0xFF).substring(1).toUpperCase() + "]";
            string = string + "\t";
            string = string + "[" + decimalFormat.format(this.cmos.ram[i]) + "]";
            string = string + "\n";
        }
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return -1;
    }

    @Override
    public void setUpdateInterval(int n) {
    }

    @Override
    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleUnknownPort, ModuleWriteOnlyPortException {
        logger.log(Level.CONFIG, "[rtc] IO read from " + n);
        switch (n) {
            case 112: {
                logger.log(Level.INFO, "[rtc] IN command (byte) from port 0x" + Integer.toHexString(n).toUpperCase() + "; Returned 0xFF");
                return -1;
            }
            case 113: {
                logger.log(Level.INFO, "[rtc] IN command (byte) from register 0x" + Integer.toHexString(this.lookupRegister).toUpperCase() + ": 0x" + Integer.toHexString(this.cmos.ram[this.lookupRegister]).toUpperCase());
                if (this.lookupRegister == 12) {
                    this.cmos.ram[12] = 0;
                    this.pic.clearIRQ(this.irqNumber);
                }
                return this.cmos.ram[this.lookupRegister];
            }
        }
        throw new ModuleUnknownPort("[rtc] Unknown I/O port requested");
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleUnknownPort {
        logger.log(Level.CONFIG, "[rtc] IO write to " + n + " = " + by);
        this.disableNMI = (by & 0x80) == 1;
        switch (n) {
            case 112: {
                this.lookupRegister = by & 0x7F;
                logger.log(Level.INFO, "[rtc] OUT command (byte) to port 0x" + Integer.toHexString(n).toUpperCase() + ": lookup byte set to 0x" + Integer.toHexString(this.lookupRegister).toUpperCase());
                return;
            }
            case 113: {
                if (this.lookupRegister != 12 && this.lookupRegister != 13) {
                    this.cmos.ram[this.lookupRegister] = by;
                }
                logger.log(Level.INFO, "[rtc] OUT command (byte) to port 0x" + Integer.toHexString(n).toUpperCase() + " [0x" + Integer.toHexString(this.lookupRegister).toUpperCase() + "] set to: 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
        }
        throw new ModuleUnknownPort("[rtc] Unknown I/O port requested");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[rtc] IN command (word) from port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[rtc] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[rtc] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, ModuleWriteOnlyPortException {
        logger.log(Level.WARNING, "[rtc] IN command (double word) from port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[rtc] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[rtc] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte getCMOSRegister(int n) {
        logger.log(Level.CONFIG, "[rtc] Returned CMOS register " + n + ": 0x" + Integer.toHexString(this.cmos.ram[n]).toUpperCase());
        return this.cmos.ram[n];
    }

    @Override
    public void setCMOSRegister(int n, byte by) {
        logger.log(Level.CONFIG, "[rtc] Set CMOS register " + n + ": 0x" + Integer.toHexString(by).toUpperCase());
        this.cmos.ram[n] = by;
    }

    @Override
    public void updateClock() {
        this.cmos.setClockValue(1);
        logger.log(Level.INFO, "[rtc] CMOS clock updated: " + this.cmos.getClockValue());
    }
}

